/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.swt.utils;

import org.eclipse.equinox.log.Logger;
import org.eclipse.riena.core.IRienaActivator;
import org.eclipse.riena.core.Log4r;
import org.eclipse.riena.core.util.Trace;
import org.eclipse.riena.internal.ui.swt.Activator;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public final class WidgetIdentificationSupport {
    public static final String RIENA_ID = "rienaid";
    private static final Logger LOGGER = Log4r.getLogger((IRienaActivator)Activator.getDefault(), WidgetIdentificationSupport.class);
    private static boolean debugOutput = Trace.isOn(WidgetIdentificationSupport.class, (String)"debug");

    private WidgetIdentificationSupport() {
    }

    public static void setIdentification(Shell aShell) {
        aShell.setData(RIENA_ID, (Object)System.getProperty("riena.testing.widgetid.mainshell", "default"));
    }

    public static void setIdentification(Widget aWidget, String ... aParts) {
        StringBuilder fullId = new StringBuilder();
        String[] stringArray = aParts;
        int n = aParts.length;
        int n2 = 0;
        while (n2 < n) {
            String part = stringArray[n2];
            if (fullId.length() != 0) {
                fullId.append('.');
            }
            fullId.append(part);
            ++n2;
        }
        if (debugOutput) {
            LOGGER.log(4, String.format("registering widget %s, (class: %s)", fullId, aWidget.getClass()));
        }
        aWidget.setData(RIENA_ID, (Object)fullId.toString());
    }

    public static void setDefaultIdentification(Widget aWidget) {
        WidgetIdentificationSupport.setIdentification(aWidget, aWidget.getClass().getName());
    }

    public static String getIdentification(Widget aWidget) {
        return (String)aWidget.getData(RIENA_ID);
    }
}

