/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.swt.gef.presentation;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.FreeformLayer;
import org.eclipse.draw2d.FreeformLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.ui.SapphirePart;
import org.eclipse.sapphire.ui.diagram.ConnectionAddEvent;
import org.eclipse.sapphire.ui.diagram.ConnectionDeleteEvent;
import org.eclipse.sapphire.ui.diagram.ConnectionEndpointsEvent;
import org.eclipse.sapphire.ui.diagram.ConnectionEvent;
import org.eclipse.sapphire.ui.diagram.editor.DiagramNodeAddEvent;
import org.eclipse.sapphire.ui.diagram.editor.DiagramNodeDeleteEvent;
import org.eclipse.sapphire.ui.diagram.editor.DiagramNodeEvent;
import org.eclipse.sapphire.ui.diagram.editor.DiagramNodeMoveEvent;
import org.eclipse.sapphire.ui.diagram.editor.DiagramNodePart;
import org.eclipse.sapphire.ui.diagram.editor.DiagramNodeTemplate;
import org.eclipse.sapphire.ui.diagram.editor.SapphireDiagramEditorPagePart;
import org.eclipse.sapphire.ui.swt.gef.DiagramConfigurationManager;
import org.eclipse.sapphire.ui.swt.gef.model.DiagramModel;
import org.eclipse.sapphire.ui.swt.gef.model.DiagramResourceCache;
import org.eclipse.sapphire.ui.swt.gef.presentation.DiagramNodePresentation;
import org.eclipse.sapphire.ui.swt.gef.presentation.DiagramPresentation;
import org.eclipse.swt.widgets.Shell;

public class DiagramPagePresentation
extends DiagramPresentation {
    private DiagramResourceCache resourceCache;
    private List<DiagramNodePresentation> nodes = new ArrayList<DiagramNodePresentation>();
    private Listener diagramNodeListener;
    private Listener connectionListener;

    public DiagramPagePresentation(SapphirePart part, DiagramConfigurationManager configManager, Shell shell) {
        super(part, null, configManager, shell);
        this.resourceCache = new DiagramResourceCache();
        this.constructNodes();
    }

    public void init(final DiagramModel diagramModel) {
        this.diagramNodeListener = new FilteredListener<DiagramNodeEvent>(){

            protected void handleTypedEvent(DiagramNodeEvent event) {
                DiagramNodePart nodePart = event.part();
                if (event instanceof DiagramNodeAddEvent) {
                    diagramModel.handleAddNode(nodePart);
                } else if (event instanceof DiagramNodeDeleteEvent) {
                    diagramModel.handleRemoveNode(nodePart);
                } else if (event instanceof DiagramNodeMoveEvent) {
                    diagramModel.handleMoveNode(nodePart);
                }
            }
        };
        this.part().attach(this.diagramNodeListener);
        this.connectionListener = new FilteredListener<ConnectionEvent>(){

            protected void handleTypedEvent(ConnectionEvent event) {
                if (event instanceof ConnectionEndpointsEvent) {
                    diagramModel.updateConnectionEndpoint(event.part());
                } else if (event instanceof ConnectionAddEvent) {
                    diagramModel.addConnection(event.part());
                } else if (event instanceof ConnectionDeleteEvent) {
                    diagramModel.removeConnection(event.part());
                }
            }
        };
        this.part().attach(this.connectionListener);
    }

    @Override
    public void render() {
        FreeformLayer f = new FreeformLayer();
        f.setBorder((Border)new MarginBorder(3));
        f.setLayoutManager((LayoutManager)new FreeformLayout());
        this.setFigure((IFigure)f);
    }

    public SapphireDiagramEditorPagePart part() {
        return (SapphireDiagramEditorPagePart)super.part();
    }

    public List<DiagramNodePresentation> getNodes() {
        return this.nodes;
    }

    public DiagramResourceCache getResourceCache() {
        return this.resourceCache;
    }

    public void dispose() {
        this.resourceCache.dispose();
        this.part().detach(this.diagramNodeListener);
        this.part().detach(this.connectionListener);
        super.dispose();
    }

    public DiagramNodePresentation addNode(DiagramNodePart nodePart) {
        DiagramNodePresentation nodePresentation = new DiagramNodePresentation(nodePart, this, this.shell(), this.getConfigurationManager(), this.getResourceCache());
        this.nodes.add(nodePresentation);
        return nodePresentation;
    }

    private void constructNodes() {
        for (DiagramNodeTemplate nodeTemplate : this.part().getNodeTemplates()) {
            if (!nodeTemplate.visible()) continue;
            for (DiagramNodePart nodePart : nodeTemplate.getDiagramNodes()) {
                if (!nodePart.visible() || !nodePart.getShapePart().visible()) continue;
                this.nodes.add(new DiagramNodePresentation(nodePart, this, this.shell(), this.getConfigurationManager(), this.getResourceCache()));
            }
        }
    }
}

