/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.search.internal.core.text;

import java.io.CharConversionException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobGroup;
import org.eclipse.jface.text.IDocument;
import org.eclipse.search.core.text.TextSearchMatchAccess;
import org.eclipse.search.core.text.TextSearchRequestor;
import org.eclipse.search.core.text.TextSearchScope;
import org.eclipse.search.internal.core.text.FileCharSequenceProvider;
import org.eclipse.search.internal.ui.Messages;
import org.eclipse.search.internal.ui.SearchMessages;
import org.eclipse.search.internal.ui.SearchPlugin;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.ITextEditor;

public class TextSearchVisitor {
    public static final boolean TRACING = "true".equalsIgnoreCase(Platform.getDebugOption((String)"org.eclipse.search/perf"));
    private static final int NUMBER_OF_LOGICAL_THREADS = Runtime.getRuntime().availableProcessors();
    private static final int FILES_PER_JOB = 50;
    private final TextSearchRequestor fCollector;
    private final Pattern fSearchPattern;
    private IProgressMonitor fProgressMonitor;
    private int fNumberOfFilesToScan;
    private int fNumberOfScannedFiles;
    private IFile fCurrentFile;
    private Object fLock = new Object();
    private final MultiStatus fStatus;
    private volatile boolean fFatalError;
    private boolean fIsLightweightAutoRefresh;

    public TextSearchVisitor(TextSearchRequestor collector, Pattern searchPattern) {
        this.fCollector = collector;
        this.fStatus = new MultiStatus("org.eclipse.search", 0, SearchMessages.TextSearchEngine_statusMessage, null);
        this.fSearchPattern = searchPattern;
        this.fIsLightweightAutoRefresh = Platform.getPreferencesService().getBoolean("org.eclipse.core.resources", "refresh.lightweight.enabled", false, null);
    }

    /*
     * Loose catch block
     */
    public IStatus search(IFile[] files, IProgressMonitor monitor) {
        if (files.length == 0) {
            return this.fStatus;
        }
        this.fProgressMonitor = monitor == null ? new NullProgressMonitor() : monitor;
        this.fNumberOfScannedFiles = 0;
        this.fNumberOfFilesToScan = files.length;
        this.fCurrentFile = null;
        int maxThreads = this.fCollector.canRunInParallel() ? NUMBER_OF_LOGICAL_THREADS : 1;
        int jobCount = 1;
        if (maxThreads > 1) {
            jobCount = (files.length + 50 - 1) / 50;
        }
        final TextSearchJobGroup jobGroup = new TextSearchJobGroup("Text Search", maxThreads, jobCount);
        long startTime = TRACING ? System.currentTimeMillis() : 0L;
        Job monitorUpdateJob = new Job(SearchMessages.TextSearchVisitor_progress_updating_job){
            private int fLastNumberOfScannedFiles;
            {
                super($anonymous0);
                this.fLastNumberOfScannedFiles = 0;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public IStatus run(IProgressMonitor inner) {
                while (!inner.isCanceled()) {
                    int numberOfScannedFiles;
                    IFile file;
                    if (TextSearchVisitor.this.fProgressMonitor.isCanceled()) {
                        jobGroup.cancel();
                        break;
                    }
                    Object object = TextSearchVisitor.this.fLock;
                    synchronized (object) {
                        file = TextSearchVisitor.this.fCurrentFile;
                        numberOfScannedFiles = TextSearchVisitor.this.fNumberOfScannedFiles;
                    }
                    if (file != null) {
                        String fileName = file.getName();
                        Object[] args = new Object[]{fileName, new Integer(numberOfScannedFiles), new Integer(TextSearchVisitor.this.fNumberOfFilesToScan)};
                        TextSearchVisitor.this.fProgressMonitor.subTask(Messages.format(SearchMessages.TextSearchVisitor_scanning, args));
                        int steps = numberOfScannedFiles - this.fLastNumberOfScannedFiles;
                        TextSearchVisitor.this.fProgressMonitor.worked(steps);
                        this.fLastNumberOfScannedFiles += steps;
                    }
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {
                        return Status.OK_STATUS;
                    }
                }
                return Status.OK_STATUS;
            }
        };
        String taskName = this.fSearchPattern.pattern().length() == 0 ? SearchMessages.TextSearchVisitor_filesearch_task_label : Messages.format(SearchMessages.TextSearchVisitor_textsearch_task_label, this.fSearchPattern.pattern());
        this.fProgressMonitor.beginTask(taskName, this.fNumberOfFilesToScan);
        monitorUpdateJob.setSystem(true);
        monitorUpdateJob.schedule();
        try {
            this.fCollector.beginReporting();
            Map<IFile, IDocument> documentsInEditors = PlatformUI.isWorkbenchRunning() ? this.evalNonFileBufferDocuments() : Collections.emptyMap();
            int filesPerJob = (files.length + jobCount - 1) / jobCount;
            IFile[] filesByLocation = new IFile[files.length];
            System.arraycopy(files, 0, filesByLocation, 0, files.length);
            Arrays.sort(filesByLocation, new Comparator<IFile>(){

                @Override
                public int compare(IFile o1, IFile o2) {
                    if (o1 == o2) {
                        return 0;
                    }
                    if (o1.getLocation() == o2.getLocation()) {
                        return 0;
                    }
                    if (o1.getLocation() == null) {
                        return 1;
                    }
                    if (o2.getLocation() == null) {
                        return -1;
                    }
                    return o1.getLocation().toString().compareTo(o2.getLocation().toString());
                }
            });
            int first = 0;
            while (first < filesByLocation.length) {
                int end = Math.min(filesByLocation.length, first + filesPerJob);
                TextSearchJob job = new TextSearchJob(filesByLocation, first, end, documentsInEditors);
                job.setJobGroup(jobGroup);
                job.schedule();
                first += filesPerJob;
            }
            jobGroup.join(0L, null);
            if (this.fProgressMonitor.isCanceled()) {
                throw new OperationCanceledException(SearchMessages.TextSearchVisitor_canceled);
            }
            this.fStatus.addAll((IStatus)jobGroup.getResult());
            MultiStatus multiStatus = this.fStatus;
            return multiStatus;
        }
        catch (InterruptedException interruptedException) {
            throw new OperationCanceledException(SearchMessages.TextSearchVisitor_canceled);
        }
        finally {
            monitorUpdateJob.cancel();
        }
        {
            catch (Throwable throwable) {
                this.fProgressMonitor.done();
                this.fCollector.endReporting();
                if (TRACING) {
                    Object[] args = new Object[]{new Integer(this.fNumberOfScannedFiles), new Integer(jobCount), new Integer(NUMBER_OF_LOGICAL_THREADS), new Long(System.currentTimeMillis() - startTime)};
                    System.out.println(Messages.format("[TextSearch] Search duration for {0} files in {1} jobs using {2} threads: {3}ms", args));
                }
                throw throwable;
            }
        }
    }

    public IStatus search(TextSearchScope scope, IProgressMonitor monitor) {
        return this.search(scope.evaluateFilesInScope(this.fStatus), monitor);
    }

    private Map<IFile, IDocument> evalNonFileBufferDocuments() {
        HashMap<IFile, IDocument> result = new HashMap<IFile, IDocument>();
        IWorkbench workbench = SearchPlugin.getDefault().getWorkbench();
        IWorkbenchWindow[] windows = workbench.getWorkbenchWindows();
        int i = 0;
        while (i < windows.length) {
            IWorkbenchPage[] pages = windows[i].getPages();
            int x = 0;
            while (x < pages.length) {
                IEditorReference[] editorRefs = pages[x].getEditorReferences();
                int z = 0;
                while (z < editorRefs.length) {
                    IEditorPart ep = editorRefs[z].getEditor(false);
                    if (ep instanceof ITextEditor && ep.isDirty()) {
                        this.evaluateTextEditor(result, ep);
                    }
                    ++z;
                }
                ++x;
            }
            ++i;
        }
        return result;
    }

    private void evaluateTextEditor(Map<IFile, IDocument> result, IEditorPart ep) {
        IFile file;
        IEditorInput input = ep.getEditorInput();
        if (input instanceof IFileEditorInput && !result.containsKey(file = ((IFileEditorInput)input).getFile())) {
            ITextFileBufferManager bufferManager = FileBuffers.getTextFileBufferManager();
            ITextFileBuffer textFileBuffer = bufferManager.getTextFileBuffer(file.getFullPath(), LocationKind.IFILE);
            if (textFileBuffer != null) {
                result.put(file, textFileBuffer.getDocument());
            } else {
                IDocument document = ((ITextEditor)ep).getDocumentProvider().getDocument((Object)input);
                if (document != null) {
                    result.put(file, document);
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean hasBinaryContent(CharSequence seq, IFile file) throws CoreException {
        IContentType contentType;
        IContentDescription desc = file.getContentDescription();
        if (desc != null && (contentType = desc.getContentType()) != null && contentType.isKindOf(Platform.getContentTypeManager().getContentType("org.eclipse.core.runtime.text"))) {
            return false;
        }
        try {
            int limit = FileCharSequenceProvider.BUFFER_SIZE;
            int i = 0;
            while (true) {
                if (i >= limit) {
                    return false;
                }
                if (seq.charAt(i) == '\u0000') {
                    return true;
                }
                ++i;
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return false;
        }
        catch (FileCharSequenceProvider.FileCharSequenceException ex) {
            if (!(ex.getCause() instanceof CharConversionException)) throw ex;
            return true;
        }
    }

    private List<TextSearchMatchAccess> locateMatches(IFile file, CharSequence searchInput, Matcher matcher, IProgressMonitor monitor) throws CoreException {
        List<TextSearchMatchAccess> occurences = null;
        matcher.reset(searchInput);
        int k = 0;
        while (matcher.find()) {
            if (occurences == null) {
                occurences = new ArrayList<TextSearchMatchAccess>();
            }
            int start = matcher.start();
            int end = matcher.end();
            if (end != start) {
                ReusableMatchAccess access = new ReusableMatchAccess();
                access.initialize(file, start, end - start, searchInput);
                occurences.add(access);
                boolean res = this.fCollector.acceptPatternMatch(access);
                if (!res) {
                    return occurences;
                }
            }
            if (++k % 20 == 0 && monitor.isCanceled()) break;
        }
        if (occurences == null) {
            occurences = Collections.emptyList();
        }
        return occurences;
    }

    private String getExceptionMessage(Exception e) {
        String message = e.getLocalizedMessage();
        if (message == null) {
            return e.getClass().getName();
        }
        return message;
    }

    private IDocument getOpenDocument(IFile file, Map<IFile, IDocument> documentsInEditors) {
        ITextFileBufferManager bufferManager;
        ITextFileBuffer textFileBuffer;
        IDocument document = documentsInEditors.get(file);
        if (document == null && (textFileBuffer = (bufferManager = FileBuffers.getTextFileBufferManager()).getTextFileBuffer(file.getFullPath(), LocationKind.IFILE)) != null) {
            document = textFileBuffer.getDocument();
        }
        return document;
    }

    private String getCharSetName(IFile file) {
        try {
            return file.getCharset();
        }
        catch (CoreException coreException) {
            return "unknown";
        }
    }

    static /* synthetic */ Pattern access$1(TextSearchVisitor textSearchVisitor) {
        return textSearchVisitor.fSearchPattern;
    }

    static /* synthetic */ void access$3(TextSearchVisitor textSearchVisitor, IFile iFile) {
        textSearchVisitor.fCurrentFile = iFile;
    }

    static /* synthetic */ void access$5(TextSearchVisitor textSearchVisitor, int n) {
        textSearchVisitor.fNumberOfScannedFiles = n;
    }

    static /* synthetic */ TextSearchRequestor access$6(TextSearchVisitor textSearchVisitor) {
        return textSearchVisitor.fCollector;
    }

    static /* synthetic */ IDocument access$7(TextSearchVisitor textSearchVisitor, IFile iFile, Map map) {
        return textSearchVisitor.getOpenDocument(iFile, map);
    }

    static /* synthetic */ List access$8(TextSearchVisitor textSearchVisitor, IFile iFile, CharSequence charSequence, Matcher matcher, IProgressMonitor iProgressMonitor) throws CoreException {
        return textSearchVisitor.locateMatches(iFile, charSequence, matcher, iProgressMonitor);
    }

    static /* synthetic */ boolean access$9(TextSearchVisitor textSearchVisitor, CharSequence charSequence, IFile iFile) throws CoreException {
        return textSearchVisitor.hasBinaryContent(charSequence, iFile);
    }

    static /* synthetic */ String access$10(TextSearchVisitor textSearchVisitor, IFile iFile) {
        return textSearchVisitor.getCharSetName(iFile);
    }

    static /* synthetic */ String access$11(TextSearchVisitor textSearchVisitor, Exception exception) {
        return textSearchVisitor.getExceptionMessage(exception);
    }

    static /* synthetic */ boolean access$12(TextSearchVisitor textSearchVisitor) {
        return textSearchVisitor.fIsLightweightAutoRefresh;
    }

    static /* synthetic */ void access$13(TextSearchVisitor textSearchVisitor, boolean bl) {
        textSearchVisitor.fFatalError = bl;
    }

    public static class ReusableMatchAccess
    extends TextSearchMatchAccess {
        private int fOffset;
        private int fLength;
        private IFile fFile;
        private CharSequence fContent;

        public void initialize(IFile file, int offset, int length, CharSequence content) {
            this.fFile = file;
            this.fOffset = offset;
            this.fLength = length;
            this.fContent = content;
        }

        @Override
        public IFile getFile() {
            return this.fFile;
        }

        @Override
        public int getMatchOffset() {
            return this.fOffset;
        }

        @Override
        public int getMatchLength() {
            return this.fLength;
        }

        @Override
        public int getFileContentLength() {
            return this.fContent.length();
        }

        @Override
        public char getFileContentChar(int offset) {
            return this.fContent.charAt(offset);
        }

        @Override
        public String getFileContent(int offset, int length) {
            return this.fContent.subSequence(offset, offset + length).toString();
        }
    }

    private class TextSearchJob
    extends Job {
        private final IFile[] fFiles;
        private final int fBegin;
        private final int fEnd;
        private final Map<IFile, IDocument> fDocumentsInEditors;
        private FileCharSequenceProvider fileCharSequenceProvider;
        private IPath previousLocationFromFile;
        private List<TextSearchMatchAccess> occurencesForPreviousLocation;
        private CharSequence charsequenceForPreviousLocation;

        public TextSearchJob(IFile[] files, int begin, int end, Map<IFile, IDocument> documentsInEditors) {
            super(files[begin].getName());
            this.setSystem(true);
            this.fFiles = files;
            this.fBegin = begin;
            this.fEnd = end;
            this.fDocumentsInEditors = documentsInEditors;
        }

        protected IStatus run(IProgressMonitor inner) {
            MultiStatus multiStatus = new MultiStatus("org.eclipse.search", 0, SearchMessages.TextSearchEngine_statusMessage, null);
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)inner, (int)(this.fEnd - this.fBegin));
            this.fileCharSequenceProvider = new FileCharSequenceProvider();
            int i = this.fBegin;
            while (i < this.fEnd && !TextSearchVisitor.this.fFatalError) {
                IStatus status = this.processFile(this.fFiles[i], (IProgressMonitor)subMonitor.split(1));
                if (!status.isOK()) {
                    multiStatus.add(status);
                }
                ++i;
            }
            if (this.charsequenceForPreviousLocation != null) {
                try {
                    this.fileCharSequenceProvider.releaseCharSequence(this.charsequenceForPreviousLocation);
                }
                catch (IOException e) {
                    SearchPlugin.log(e);
                }
            }
            return multiStatus;
        }

        /*
         * Exception decompiling
         */
        public IStatus processFile(IFile file, IProgressMonitor monitor) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        public Map<IFile, IDocument> getDocumentsInEditors() {
            return this.fDocumentsInEditors;
        }
    }

    private static class TextSearchJobGroup
    extends JobGroup {
        public TextSearchJobGroup(String name, int maxThreads, int initialJobCount) {
            super(name, maxThreads, initialJobCount);
        }

        protected boolean shouldCancel(IStatus lastCompletedJobResult, int numberOfFailedJobs, int numberOfCancelledJobs) {
            return false;
        }
    }
}

