/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.analysis.xml.core.model;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.Activator;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.model.ITmfXmlModelFactory;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.model.ITmfXmlStateAttribute;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.model.TmfXmlScenarioInfo;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.module.IXmlStateSystemContainer;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.module.XmlUtils;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.statesystem.core.exceptions.AttributeNotFoundException;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateValueTypeException;
import org.eclipse.tracecompass.statesystem.core.statevalue.ITmfStateValue;
import org.eclipse.tracecompass.statesystem.core.statevalue.TmfStateValue;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.event.aspect.ITmfEventAspect;
import org.eclipse.tracecompass.tmf.core.event.aspect.TmfCpuAspect;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceUtils;
import org.w3c.dom.Element;

public abstract class TmfXmlStateAttribute
implements ITmfXmlStateAttribute {
    private final String CURRENT_STATE = "#currentState";
    private final String CURRENT_SCENARIO = "#CurrentScenario";
    private final StateAttributeType fType;
    private final @Nullable String fName;
    private final List<ITmfXmlStateAttribute> fQueryList = new LinkedList<ITmfXmlStateAttribute>();
    private final IXmlStateSystemContainer fContainer;
    private static /* synthetic */ int[] $SWITCH_TABLE$org$eclipse$tracecompass$statesystem$core$statevalue$ITmfStateValue$Type;
    private static /* synthetic */ int[] $SWITCH_TABLE$org$eclipse$tracecompass$internal$tmf$analysis$xml$core$model$TmfXmlStateAttribute$StateAttributeType;

    protected TmfXmlStateAttribute(ITmfXmlModelFactory modelFactory, Element attribute, IXmlStateSystemContainer container) {
        this.fContainer = container;
        switch (attribute.getAttribute("type")) {
            case "constant": {
                this.fType = StateAttributeType.CONSTANT;
                this.fName = this.getAttributeName(attribute);
                break;
            }
            case "eventField": {
                this.fType = StateAttributeType.EVENTFIELD;
                this.fName = this.getAttributeName(attribute);
                break;
            }
            case "location": {
                this.fType = StateAttributeType.LOCATION;
                this.fName = this.getAttributeName(attribute);
                break;
            }
            case "query": {
                List<@Nullable Element> childElements = XmlUtils.getChildElements(attribute);
                for (Element subAttributeNode : childElements) {
                    if (subAttributeNode == null) continue;
                    ITmfXmlStateAttribute subAttribute = modelFactory.createStateAttribute(subAttributeNode, this.fContainer);
                    this.fQueryList.add(subAttribute);
                }
                this.fType = StateAttributeType.QUERY;
                this.fName = null;
                break;
            }
            case "eventName": {
                this.fType = StateAttributeType.EVENTNAME;
                this.fName = this.getAttributeName(attribute);
                break;
            }
            case "": {
                this.fType = StateAttributeType.NONE;
                this.fName = null;
                break;
            }
            case "self": {
                this.fType = StateAttributeType.SELF;
                this.fName = null;
                break;
            }
            default: {
                throw new IllegalArgumentException("TmfXmlStateAttribute constructor: The XML element is not of the right type");
            }
        }
    }

    private String getAttributeName(Element attribute) {
        return this.fContainer.getAttributeValue(attribute.getAttribute("value")).intern();
    }

    @Override
    public int getAttributeQuark(int startQuark, @Nullable TmfXmlScenarioInfo scenarioInfo) {
        return this.getAttributeQuark(null, startQuark, scenarioInfo);
    }

    protected abstract int getQuarkAbsoluteAndAdd(String ... var1) throws AttributeNotFoundException;

    protected abstract int getQuarkRelativeAndAdd(int var1, String ... var2) throws AttributeNotFoundException;

    protected @Nullable ITmfStateSystem getStateSystem() {
        return this.fContainer.getStateSystem();
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int getAttributeQuark(@Nullable ITmfEvent event, int startQuark, @Nullable TmfXmlScenarioInfo scenarioInfo) {
        ss = this.getStateSystem();
        if (ss == null) {
            throw new IllegalStateException("The state system hasn't been initialized yet");
        }
        name = NonNullUtils.nullToEmptyString((Object)this.fName);
        if (name.length() > 0 && name.charAt(0) == '#' && scenarioInfo == null) {
            throw new IllegalStateException("XML Attribute needs " + this.fName + " but the data is not available.");
        }
        name = name.equals("#currentState") != false ? ((TmfXmlScenarioInfo)NonNullUtils.checkNotNull((Object)scenarioInfo)).getActiveState() : this.fName;
        try {
            switch (TmfXmlStateAttribute.$SWITCH_TABLE$org$eclipse$tracecompass$internal$tmf$analysis$xml$core$model$TmfXmlStateAttribute$StateAttributeType()[this.fType.ordinal()]) {
                case 2: {
                    if (name == null) {
                        throw new IllegalStateException("Invalid attribute name");
                    }
                    if (name.equals("#CurrentScenario")) {
                        return ((TmfXmlScenarioInfo)NonNullUtils.checkNotNull((Object)scenarioInfo)).getQuark();
                    }
                    if (startQuark == -1) {
                        return this.getQuarkAbsoluteAndAdd(new String[]{name});
                    }
                    return this.getQuarkRelativeAndAdd(startQuark, new String[]{name});
                }
                case 3: {
                    quark = -1;
                    if (event == null) {
                        Activator.logWarning("XML State attribute: looking for an event field, but event is null");
                        return quark;
                    }
                    if (name == null) {
                        throw new IllegalStateException("Invalid attribute name");
                    }
                    fieldValue = null;
                    field = event.getContent().getField(new String[]{name});
                    if (field != null) ** GOTO lbl34
                    if (name.equalsIgnoreCase("cpu")) {
                        cpu = TmfTraceUtils.resolveIntEventAspectOfClassForEvent((ITmfTrace)event.getTrace(), TmfCpuAspect.class, (ITmfEvent)event);
                        if (cpu == null) return -1;
                        return this.getQuarkRelativeAndAdd(startQuark, new String[]{cpu.toString()});
                    }
                    var10_25 = event.getTrace().getEventAspects().iterator();
                    ** GOTO lbl83
lbl34:
                    // 1 sources

                    fieldValue = field.getValue();
lbl35:
                    // 3 sources

                    while (true) {
                        if (fieldValue instanceof String) {
                            fieldString = (String)fieldValue;
                            return this.getQuarkRelativeAndAdd(startQuark, new String[]{fieldString});
                        }
                        if (fieldValue instanceof Long) {
                            fieldLong = (Long)fieldValue;
                            return this.getQuarkRelativeAndAdd(startQuark, new String[]{fieldLong.toString()});
                        }
                        if (fieldValue instanceof Integer == false) return quark;
                        fieldInterger = (Integer)fieldValue;
                        return this.getQuarkRelativeAndAdd(startQuark, new String[]{fieldInterger.toString()});
                    }
                }
                case 4: {
                    value = TmfStateValue.nullValue();
                    quarkQuery = -1;
                    var10_26 = this.fQueryList.iterator();
                    while (var10_26.hasNext() && (quarkQuery = (attrib = var10_26.next()).getAttributeQuark(event, quarkQuery, scenarioInfo)) != -1) {
                    }
                    if (quarkQuery != -1) {
                        value = ss.queryOngoingState(quarkQuery);
                    }
                    switch (TmfXmlStateAttribute.$SWITCH_TABLE$org$eclipse$tracecompass$statesystem$core$statevalue$ITmfStateValue$Type()[value.getType().ordinal()]) {
                        case 2: {
                            result = value.unboxInt();
                            return this.getQuarkRelativeAndAdd(startQuark, new String[]{String.valueOf(result)});
                        }
                        case 3: {
                            result = value.unboxLong();
                            return this.getQuarkRelativeAndAdd(startQuark, new String[]{String.valueOf(result)});
                        }
                        case 5: {
                            result = value.unboxStr();
                            return this.getQuarkRelativeAndAdd(startQuark, new String[]{result});
                        }
                    }
                    return -1;
                }
                case 5: {
                    quark = startQuark;
                    idLocation = name;
                    var9_24 = this.fContainer.getLocations().iterator();
                    do {
                        if (var9_24.hasNext()) continue;
                        return quark;
                    } while (!(location = var9_24.next()).getId().equals(idLocation) || (quark = location.getLocationQuark(event, quark, scenarioInfo)) != -1);
                    return quark;
                }
                case 7: {
                    quark = -1;
                    if (event == null) {
                        Activator.logWarning("XML State attribute: looking for an eventname, but event is null");
                        return quark;
                    }
                    return this.getQuarkRelativeAndAdd(startQuark, new String[]{event.getName()});
                }
                case 6: {
                    return startQuark;
                }
                default: {
                    return startQuark;
lbl83:
                    // 1 sources

                    if (true) ** GOTO lbl93
                }
            }
        }
        catch (AttributeNotFoundException ae) {
            return -1;
        }
        catch (StateValueTypeException e) {
            Activator.logError("StateValueTypeException", e);
            return -1;
        }
        do {
            if (!(aspect = (ITmfEventAspect)var10_25.next()).getName().equals(this.fName)) continue;
            fieldValue = aspect.resolve(event);
            ** GOTO lbl35
lbl93:
            // 2 sources

        } while (var10_25.hasNext());
        ** while (true)
    }

    public String toString() {
        return "TmfXmlStateAttribute " + (Object)((Object)this.fType) + ": " + this.fName;
    }

    static /* synthetic */ int[] $SWITCH_TABLE$org$eclipse$tracecompass$statesystem$core$statevalue$ITmfStateValue$Type() {
        if ($SWITCH_TABLE$org$eclipse$tracecompass$statesystem$core$statevalue$ITmfStateValue$Type != null) {
            return $SWITCH_TABLE$org$eclipse$tracecompass$statesystem$core$statevalue$ITmfStateValue$Type;
        }
        int[] nArray = new int[ITmfStateValue.Type.values().length];
        try {
            nArray[ITmfStateValue.Type.CUSTOM.ordinal()] = 6;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ITmfStateValue.Type.DOUBLE.ordinal()] = 4;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ITmfStateValue.Type.INTEGER.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ITmfStateValue.Type.LONG.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ITmfStateValue.Type.NULL.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ITmfStateValue.Type.STRING.ordinal()] = 5;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        $SWITCH_TABLE$org$eclipse$tracecompass$statesystem$core$statevalue$ITmfStateValue$Type = nArray;
        return nArray;
    }

    static /* synthetic */ int[] $SWITCH_TABLE$org$eclipse$tracecompass$internal$tmf$analysis$xml$core$model$TmfXmlStateAttribute$StateAttributeType() {
        if ($SWITCH_TABLE$org$eclipse$tracecompass$internal$tmf$analysis$xml$core$model$TmfXmlStateAttribute$StateAttributeType != null) {
            return $SWITCH_TABLE$org$eclipse$tracecompass$internal$tmf$analysis$xml$core$model$TmfXmlStateAttribute$StateAttributeType;
        }
        int[] nArray = new int[StateAttributeType.values().length];
        try {
            nArray[StateAttributeType.CONSTANT.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[StateAttributeType.EVENTFIELD.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[StateAttributeType.EVENTNAME.ordinal()] = 7;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[StateAttributeType.LOCATION.ordinal()] = 5;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[StateAttributeType.NONE.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[StateAttributeType.QUERY.ordinal()] = 4;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[StateAttributeType.SELF.ordinal()] = 6;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        $SWITCH_TABLE$org$eclipse$tracecompass$internal$tmf$analysis$xml$core$model$TmfXmlStateAttribute$StateAttributeType = nArray;
        return nArray;
    }

    private static enum StateAttributeType {
        NONE,
        CONSTANT,
        EVENTFIELD,
        QUERY,
        LOCATION,
        SELF,
        EVENTNAME;

    }
}

