/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.analysis.xml.core.model;

import java.util.List;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.Activator;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.model.ITmfXmlModelFactory;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.model.ITmfXmlStateAttribute;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.model.ITmfXmlStateValue;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.model.TmfXmlMapEntry;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.model.TmfXmlScenarioInfo;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.module.IXmlStateSystemContainer;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.pattern.stateprovider.XmlPatternStateProvider;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.stateprovider.XmlStateProvider;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.statesystem.core.exceptions.AttributeNotFoundException;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateValueTypeException;
import org.eclipse.tracecompass.statesystem.core.exceptions.TimeRangeException;
import org.eclipse.tracecompass.statesystem.core.statevalue.ITmfStateValue;
import org.eclipse.tracecompass.statesystem.core.statevalue.TmfStateValue;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.event.ITmfEventField;
import org.eclipse.tracecompass.tmf.core.event.aspect.ITmfEventAspect;
import org.eclipse.tracecompass.tmf.core.event.aspect.TmfCpuAspect;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceUtils;
import org.w3c.dom.Element;

public abstract class TmfXmlStateValue
implements ITmfXmlStateValue {
    private final TmfXmlStateValueBase fStateValue;
    private final List<ITmfXmlStateAttribute> fPath;
    private final @Nullable String fEventField;
    private final boolean fIncrement;
    private final boolean fUpdate;
    private final ValueTypeStack fStackType;
    private final ITmfStateValue.Type fForcedType;
    private final IXmlStateSystemContainer fContainer;
    private final String fMappingGroup;

    protected TmfXmlStateValue(ITmfXmlModelFactory modelFactory, Element node, IXmlStateSystemContainer container, List<ITmfXmlStateAttribute> attributes, @Nullable String eventField) {
        this.fPath = attributes;
        this.fContainer = container;
        this.fEventField = eventField;
        if (!node.getNodeName().equals("stateValue")) {
            throw new IllegalArgumentException("TmfXmlStateValue constructor: Element is not a stateValue");
        }
        this.fIncrement = Boolean.parseBoolean(node.getAttribute("increment"));
        this.fUpdate = Boolean.parseBoolean(node.getAttribute("update"));
        this.fStateValue = this.initializeStateValue(modelFactory, node);
        switch (node.getAttribute("forcedType")) {
            case "string": {
                this.fForcedType = ITmfStateValue.Type.STRING;
                break;
            }
            case "int": {
                this.fForcedType = ITmfStateValue.Type.INTEGER;
                break;
            }
            case "long": {
                this.fForcedType = ITmfStateValue.Type.LONG;
                break;
            }
            case "double": {
                this.fForcedType = ITmfStateValue.Type.DOUBLE;
                break;
            }
            default: {
                this.fForcedType = ITmfStateValue.Type.NULL;
            }
        }
        String stack = node.getAttribute("stack");
        this.fStackType = ValueTypeStack.getTypeFromString(stack);
        this.fMappingGroup = node.getAttribute("mappingGroup");
    }

    protected TmfXmlStateValueBase initializeStateValue(ITmfXmlModelFactory modelFactory, Element node) {
        return new TmfXmlStateValueNull();
    }

    protected IXmlStateSystemContainer getSsContainer() {
        return this.fContainer;
    }

    protected @Nullable ITmfStateSystem getStateSystem() {
        return this.fContainer.getStateSystem();
    }

    protected boolean isIncrement() {
        return this.fIncrement;
    }

    protected boolean isUpdate() {
        return this.fUpdate;
    }

    protected ValueTypeStack getStackType() {
        return this.fStackType;
    }

    protected ITmfStateValue.Type getForcedType() {
        return this.fForcedType;
    }

    @Override
    public ITmfStateValue getValue(@Nullable ITmfEvent event, @Nullable TmfXmlScenarioInfo scenarioInfo) throws AttributeNotFoundException {
        return this.getMappedValue(event, scenarioInfo, this.fStateValue.getValue(event, scenarioInfo));
    }

    private ITmfStateValue getMappedValue(@Nullable ITmfEvent event, @Nullable TmfXmlScenarioInfo scenarioInfo, ITmfStateValue value) {
        try {
            Set<TmfXmlMapEntry> group = null;
            if (this.fContainer instanceof XmlPatternStateProvider) {
                group = ((XmlPatternStateProvider)this.fContainer).getMappingGroup(this.fMappingGroup);
            } else if (this.fContainer instanceof XmlStateProvider) {
                group = ((XmlStateProvider)this.fContainer).getMappingGroup(this.fMappingGroup);
            }
            if (group != null) {
                for (TmfXmlMapEntry entry : group) {
                    if (!entry.getKey().getValue(event, scenarioInfo).equals(value)) continue;
                    return entry.getValue().getValue(event, scenarioInfo);
                }
            }
            return value;
        }
        catch (AttributeNotFoundException e) {
            Activator.logError("Unable to map the state value");
            return TmfStateValue.nullValue();
        }
    }

    @Override
    public ITmfStateValue getEventFieldValue(@NonNull ITmfEvent event) {
        String eventField = this.fEventField;
        if (eventField == null) {
            throw new IllegalStateException();
        }
        return this.getEventFieldValue(event, eventField);
    }

    protected ITmfStateValue getEventFieldValue(ITmfEvent event, String fieldName) {
        TmfStateValue value = TmfStateValue.nullValue();
        ITmfEventField field = event.getContent().getField(new String[]{fieldName});
        Object fieldValue = null;
        if (field == null) {
            if (fieldName.equalsIgnoreCase("cpu")) {
                Integer cpu = TmfTraceUtils.resolveIntEventAspectOfClassForEvent((ITmfTrace)event.getTrace(), TmfCpuAspect.class, (ITmfEvent)event);
                if (cpu != null) {
                    return TmfStateValue.newValueInt((int)cpu);
                }
            } else if (fieldName.equalsIgnoreCase("timestamp")) {
                return TmfStateValue.newValueLong((long)event.getTimestamp().getValue());
            }
            for (ITmfEventAspect aspect : event.getTrace().getEventAspects()) {
                if (!aspect.getName().equals(fieldName)) continue;
                fieldValue = aspect.resolve(event);
                break;
            }
            if (fieldValue == null) {
                return value;
            }
        } else {
            fieldValue = field.getValue();
        }
        if (fieldValue instanceof String) {
            String fieldString = (String)fieldValue;
            switch (this.fForcedType) {
                case INTEGER: {
                    value = TmfStateValue.newValueInt((int)Integer.parseInt(fieldString));
                    break;
                }
                case LONG: {
                    value = TmfStateValue.newValueLong((long)Long.parseLong(fieldString));
                    break;
                }
                case DOUBLE: {
                    value = TmfStateValue.newValueDouble((double)Double.parseDouble(fieldString));
                    break;
                }
                case CUSTOM: {
                    throw new IllegalStateException("Custom type cannot be forced");
                }
                default: {
                    value = TmfStateValue.newValueString((String)fieldString);
                    break;
                }
            }
        } else if (fieldValue instanceof Long) {
            Long fieldLong = (Long)fieldValue;
            switch (this.fForcedType) {
                case INTEGER: {
                    value = TmfStateValue.newValueInt((int)fieldLong.intValue());
                    break;
                }
                case STRING: {
                    value = TmfStateValue.newValueString((String)fieldLong.toString());
                    break;
                }
                case DOUBLE: {
                    value = TmfStateValue.newValueDouble((double)fieldLong.doubleValue());
                    break;
                }
                case CUSTOM: {
                    throw new IllegalStateException("Custom type cannot be forced");
                }
                default: {
                    value = TmfStateValue.newValueLong((long)fieldLong);
                    break;
                }
            }
        } else if (fieldValue instanceof Integer) {
            Integer fieldInteger = (Integer)fieldValue;
            switch (this.fForcedType) {
                case LONG: {
                    value = TmfStateValue.newValueLong((long)fieldInteger.longValue());
                    break;
                }
                case STRING: {
                    value = TmfStateValue.newValueString((String)fieldInteger.toString());
                    break;
                }
                case DOUBLE: {
                    value = TmfStateValue.newValueDouble((double)fieldInteger.doubleValue());
                    break;
                }
                case CUSTOM: {
                    throw new IllegalStateException("Custom type cannot be forced");
                }
                default: {
                    value = TmfStateValue.newValueInt((int)fieldInteger);
                    break;
                }
            }
        } else if (fieldValue instanceof Double) {
            Double fieldDouble = (Double)fieldValue;
            switch (this.fForcedType) {
                case LONG: {
                    value = TmfStateValue.newValueLong((long)fieldDouble.longValue());
                    break;
                }
                case STRING: {
                    value = TmfStateValue.newValueString((String)fieldDouble.toString());
                    break;
                }
                case INTEGER: {
                    value = TmfStateValue.newValueInt((int)fieldDouble.intValue());
                    break;
                }
                case CUSTOM: {
                    throw new IllegalStateException("Custom type cannot be forced");
                }
                default: {
                    value = TmfStateValue.newValueDouble((double)fieldDouble);
                }
            }
        }
        return value;
    }

    @Override
    public List<ITmfXmlStateAttribute> getAttributes() {
        return this.fPath;
    }

    @Override
    public void handleEvent(@NonNull ITmfEvent event, @Nullable TmfXmlScenarioInfo scenarioInfo) throws AttributeNotFoundException, StateValueTypeException, TimeRangeException {
        int quark = -1;
        for (ITmfXmlStateAttribute attribute : this.fPath) {
            quark = attribute.getAttributeQuark(event, quark, scenarioInfo);
            if (quark != -1) continue;
            Activator.logError("Not found XML attribute " + attribute);
            return;
        }
        long ts = event.getTimestamp().getValue();
        this.fStateValue.handleEvent(event, quark, ts, scenarioInfo);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("TmfXmlStateValue: ");
        if (this.fEventField != null) {
            builder.append("Field=").append(this.fEventField).append("; ");
        } else if (!this.fPath.isEmpty()) {
            builder.append("Path=").append(this.fPath).append("; ");
        }
        builder.append(this.fStateValue);
        return builder.toString();
    }

    protected abstract class TmfXmlStateValueBase {
        protected TmfXmlStateValueBase() {
        }

        public abstract ITmfStateValue getValue(@Nullable ITmfEvent var1, @Nullable TmfXmlScenarioInfo var2) throws AttributeNotFoundException;

        public void handleEvent(ITmfEvent event, int quark, long timestamp, @Nullable TmfXmlScenarioInfo scenarioInfo) throws StateValueTypeException, TimeRangeException, AttributeNotFoundException {
            if (TmfXmlStateValue.this.fIncrement) {
                this.incrementValue(event, quark, timestamp, scenarioInfo);
            } else {
                ITmfStateValue value = this.getValue(event, scenarioInfo);
                this.processValue(quark, timestamp, value);
            }
        }

        protected void processValue(int quark, long timestamp, ITmfStateValue value) throws TimeRangeException, StateValueTypeException, AttributeNotFoundException {
        }

        protected void incrementValue(ITmfEvent event, int quark, long timestamp, @Nullable TmfXmlScenarioInfo scenarioInfo) throws StateValueTypeException, TimeRangeException, AttributeNotFoundException {
        }
    }

    private class TmfXmlStateValueNull
    extends TmfXmlStateValueBase {
        private TmfXmlStateValueNull() {
        }

        @Override
        public ITmfStateValue getValue(@Nullable ITmfEvent event, @Nullable TmfXmlScenarioInfo scenarioInfo) throws AttributeNotFoundException {
            return TmfStateValue.nullValue();
        }

        public String toString() {
            return "NULL";
        }
    }

    protected static enum ValueTypeStack {
        NULL,
        PEEK,
        POP,
        PUSH;


        public static ValueTypeStack getTypeFromString(String input) {
            switch (input) {
                case "push": {
                    return PUSH;
                }
                case "pop": {
                    return POP;
                }
                case "peek": {
                    return PEEK;
                }
            }
            return NULL;
        }
    }
}

