/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.analysis.xml.core.stateprovider;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.model.ITmfXmlModelFactory;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.model.TmfXmlEventHandler;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.model.TmfXmlLocation;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.model.TmfXmlMapEntry;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.model.readwrite.TmfXmlReadWriteModelFactory;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.module.IXmlStateSystemContainer;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.module.XmlUtils;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.statesystem.AbstractTmfStateProvider;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class XmlStateProvider
extends AbstractTmfStateProvider
implements IXmlStateSystemContainer {
    private final IPath fFilePath;
    private final @NonNull String fStateId;
    private final List<TmfXmlEventHandler> fEventHandlers = new ArrayList<TmfXmlEventHandler>();
    private final @NonNull Set<@NonNull TmfXmlLocation> fLocations;
    private final Map<String, String> fDefinedValues = new HashMap<String, String>();
    private final @NonNull Map<@NonNull String, @NonNull Set<@NonNull TmfXmlMapEntry>> fMappingGroups;

    public XmlStateProvider(@NonNull ITmfTrace trace, @NonNull String stateid, IPath file) {
        super(trace, stateid);
        this.fStateId = stateid;
        this.fFilePath = file;
        Element doc = XmlUtils.getElementInFile(this.fFilePath.makeAbsolute().toOSString(), "stateProvider", this.fStateId);
        if (doc == null) {
            throw new IllegalArgumentException("XmlStateProvider: Cannot find state provider element in file " + file);
        }
        ITmfXmlModelFactory modelFactory = TmfXmlReadWriteModelFactory.getInstance();
        NodeList definedStateNodes = doc.getElementsByTagName("definedValue");
        int i = 0;
        while (i < definedStateNodes.getLength()) {
            Element element = (Element)definedStateNodes.item(i);
            this.fDefinedValues.put(element.getAttribute("name"), element.getAttribute("value"));
            ++i;
        }
        List<Element> childElements = XmlUtils.getChildElements(doc, "location");
        HashSet<@NonNull TmfXmlLocation> locations = new HashSet<TmfXmlLocation>();
        for (Element element : childElements) {
            if (element == null) continue;
            TmfXmlLocation location = modelFactory.createLocation(element, this);
            locations.add(location);
        }
        this.fLocations = Collections.unmodifiableSet(locations);
        @NonNull HashMap<@NonNull String, @NonNull HashSet<@NonNull E>> mapGroups = new HashMap();
        NodeList mapNodes = doc.getElementsByTagName("mappingGroup");
        int i2 = 0;
        while (i2 < mapNodes.getLength()) {
            Element map = (Element)mapNodes.item(i2);
            String id = map.getAttribute("id");
            HashSet<@NonNull TmfXmlMapEntry> entrySet = (HashSet<TmfXmlMapEntry>)mapGroups.get(id);
            if (entrySet == null) {
                entrySet = new HashSet<TmfXmlMapEntry>();
                mapGroups.put(id, entrySet);
            }
            NodeList entryNodes = map.getElementsByTagName("entry");
            int j = 0;
            while (j < entryNodes.getLength()) {
                Element entryElement = (Element)entryNodes.item(j);
                if (entryElement != null) {
                    TmfXmlMapEntry entry = modelFactory.createMapEntry(entryElement, this);
                    entrySet.add(entry);
                }
                ++j;
            }
            ++i2;
        }
        this.fMappingGroups = Collections.unmodifiableMap(mapGroups);
        childElements = XmlUtils.getChildElements(doc, "eventHandler");
        for (Element element : childElements) {
            if (element == null) continue;
            TmfXmlEventHandler handler = modelFactory.createEventHandler(element, this);
            this.fEventHandlers.add(handler);
        }
    }

    public @NonNull String getStateId() {
        return this.fStateId;
    }

    public int getVersion() {
        Element ssNode = XmlUtils.getElementInFile(this.fFilePath.makeAbsolute().toOSString(), "stateProvider", this.fStateId);
        if (ssNode != null) {
            return Integer.parseInt(ssNode.getAttribute("version"));
        }
        throw new IllegalStateException("The state provider XML node should have a version attribute");
    }

    public XmlStateProvider getNewInstance() {
        return new XmlStateProvider(this.getTrace(), this.getStateId(), this.fFilePath);
    }

    protected void eventHandle(ITmfEvent event) {
        for (TmfXmlEventHandler eventHandler : this.fEventHandlers) {
            eventHandler.handleEvent(event);
        }
    }

    @Override
    public ITmfStateSystem getStateSystem() {
        return this.getStateSystemBuilder();
    }

    @Override
    public Iterable<TmfXmlLocation> getLocations() {
        return this.fLocations;
    }

    public String getDefinedValue(String constant) {
        return this.fDefinedValues.get(constant);
    }

    @Override
    public String getAttributeValue(String name) {
        String attribute = name;
        if (attribute.startsWith("$")) {
            attribute = this.getDefinedValue(attribute.substring(1));
        }
        return attribute;
    }

    public @Nullable Set<@NonNull TmfXmlMapEntry> getMappingGroup(@NonNull String id) {
        return this.fMappingGroups.get(id);
    }
}

