/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.parsers.custom;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.tmf.core.event.ITmfEventField;
import org.eclipse.tracecompass.tmf.core.event.TmfEvent;
import org.eclipse.tracecompass.tmf.core.event.TmfEventType;
import org.eclipse.tracecompass.tmf.core.parsers.custom.CustomEvent;
import org.eclipse.tracecompass.tmf.core.parsers.custom.CustomTraceDefinition;
import org.eclipse.tracecompass.tmf.core.parsers.custom.CustomXmlTraceDefinition;
import org.eclipse.tracecompass.tmf.core.timestamp.ITmfTimestamp;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;

public class CustomXmlEvent
extends CustomEvent {
    private String fLastExtraFieldName = null;

    public CustomXmlEvent(CustomXmlTraceDefinition definition) {
        super(definition);
    }

    public CustomXmlEvent(CustomXmlTraceDefinition definition, @NonNull TmfEvent other) {
        super(definition, other);
    }

    public CustomXmlEvent(CustomXmlTraceDefinition definition, ITmfTrace parentTrace, ITmfTimestamp timestamp, TmfEventType type) {
        super(definition, parentTrace, timestamp, type);
    }

    @Override
    public void setContent(ITmfEventField content) {
        super.setContent(content);
    }

    @Deprecated
    public void parseInput(String value, String name, int inputAction, String inputFormat) {
    }

    public void parseInput(String value, CustomTraceDefinition.Tag inputTag, String inputName, int inputAction, String inputFormat) {
        Object key;
        if (value.length() == 0) {
            return;
        }
        Object object = key = inputTag.equals((Object)CustomTraceDefinition.Tag.OTHER) ? inputName : inputTag;
        if (key.equals((Object)CustomTraceDefinition.Tag.EXTRA_FIELD_NAME)) {
            this.fLastExtraFieldName = value;
            if (!this.fData.containsKey(value)) {
                this.fData.put(value, null);
            }
            return;
        }
        if (key.equals((Object)CustomTraceDefinition.Tag.EXTRA_FIELD_VALUE)) {
            if (this.fLastExtraFieldName == null) {
                return;
            }
            key = this.fLastExtraFieldName;
        }
        if (inputAction == 0) {
            this.fData.put(key, value);
            if (key.equals((Object)CustomTraceDefinition.Tag.TIMESTAMP)) {
                this.fData.put(CustomEvent.Key.TIMESTAMP_INPUT_FORMAT, inputFormat);
            }
        } else if (inputAction == 1) {
            String s = (String)this.fData.get(key);
            if (s != null) {
                this.fData.put(key, String.valueOf(s) + value);
            } else {
                this.fData.put(key, value);
            }
            if (key.equals((Object)CustomTraceDefinition.Tag.TIMESTAMP)) {
                String timeStampInputFormat = (String)this.fData.get((Object)CustomEvent.Key.TIMESTAMP_INPUT_FORMAT);
                if (timeStampInputFormat != null) {
                    this.fData.put(CustomEvent.Key.TIMESTAMP_INPUT_FORMAT, String.valueOf(timeStampInputFormat) + inputFormat);
                } else {
                    this.fData.put(CustomEvent.Key.TIMESTAMP_INPUT_FORMAT, inputFormat);
                }
            }
        } else if (inputAction == 2) {
            String s = (String)this.fData.get(key);
            if (s != null) {
                this.fData.put(key, String.valueOf(s) + " | " + value);
            } else {
                this.fData.put(key, value);
            }
            if (key.equals((Object)CustomTraceDefinition.Tag.TIMESTAMP)) {
                String timeStampInputFormat = (String)this.fData.get((Object)CustomEvent.Key.TIMESTAMP_INPUT_FORMAT);
                if (timeStampInputFormat != null) {
                    this.fData.put(CustomEvent.Key.TIMESTAMP_INPUT_FORMAT, String.valueOf(timeStampInputFormat) + " | " + inputFormat);
                } else {
                    this.fData.put(CustomEvent.Key.TIMESTAMP_INPUT_FORMAT, inputFormat);
                }
            }
        }
    }
}

