/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.ui.project.model;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.tracecompass.internal.tmf.ui.editors.ITmfEventsEditorConstants;
import org.eclipse.tracecompass.tmf.core.TmfCommonConstants;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfExperimentElement;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfExperimentFolder;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfProjectElement;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfProjectRegistry;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfTraceElement;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfTraceFolder;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.ResourceUtil;
import org.eclipse.ui.navigator.ILinkHelper;
import org.eclipse.ui.part.FileEditorInput;

public class TmfEditorLinkHelper
implements ILinkHelper {
    public IStructuredSelection findSelection(IEditorInput anInput) {
        IFile file = ResourceUtil.getFile((IEditorInput)anInput);
        if (file != null) {
            try {
                String traceTypeId = file.getPersistentProperty(TmfCommonConstants.TRACETYPE);
                if (traceTypeId == null) {
                    return StructuredSelection.EMPTY;
                }
                TmfProjectElement project = TmfProjectRegistry.getProject(file.getProject(), true);
                TmfTraceFolder tracesFolder = project.getTracesFolder();
                if (ITmfEventsEditorConstants.EXPERIMENT_INPUT_TYPE_CONSTANTS.contains((Object)traceTypeId)) {
                    TmfExperimentFolder experimentFolder = project.getExperimentsFolder();
                    if (experimentFolder != null) {
                        for (TmfExperimentElement experimentElement : experimentFolder.getExperiments()) {
                            if (!experimentElement.getResource().equals((Object)file.getParent())) continue;
                            return new StructuredSelection((Object)experimentElement);
                        }
                    }
                } else if (ITmfEventsEditorConstants.TRACE_INPUT_TYPE_CONSTANTS.contains((Object)traceTypeId)) {
                    if (tracesFolder != null) {
                        for (TmfTraceElement traceElement : tracesFolder.getTraces()) {
                            if (!traceElement.getResource().equals((Object)file.getParent())) continue;
                            return new StructuredSelection((Object)traceElement);
                        }
                    }
                } else if (tracesFolder != null) {
                    for (TmfTraceElement traceElement : tracesFolder.getTraces()) {
                        if (!traceElement.getResource().equals((Object)file)) continue;
                        return new StructuredSelection((Object)traceElement);
                    }
                }
            }
            catch (CoreException e) {
                return StructuredSelection.EMPTY;
            }
        }
        return StructuredSelection.EMPTY;
    }

    public void activateEditor(IWorkbenchPage aPage, IStructuredSelection aSelection) {
        if (aSelection == null || aSelection.isEmpty()) {
            return;
        }
        IFile file = null;
        if (aSelection.getFirstElement() instanceof TmfTraceElement) {
            TmfTraceElement traceElement = (TmfTraceElement)aSelection.getFirstElement();
            traceElement = traceElement.getElementUnderTraceFolder();
            file = traceElement.getBookmarksFile();
        } else if (aSelection.getFirstElement() instanceof TmfExperimentElement) {
            TmfExperimentElement experimentElement = (TmfExperimentElement)aSelection.getFirstElement();
            file = experimentElement.getBookmarksFile();
        }
        if (file != null) {
            FileEditorInput tmpInput = new FileEditorInput(file);
            IEditorPart localEditor = aPage.findEditor((IEditorInput)tmpInput);
            if (localEditor != null) {
                aPage.bringToTop((IWorkbenchPart)localEditor);
            } else {
                IEditorReference[] refs;
                IEditorReference[] iEditorReferenceArray = refs = aPage.getEditorReferences();
                int n = refs.length;
                int n2 = 0;
                while (n2 < n) {
                    IEditorReference editorReference = iEditorReferenceArray[n2];
                    try {
                        if (editorReference.getEditorInput().equals(tmpInput) && (localEditor = editorReference.getEditor(true)) != null) {
                            aPage.bringToTop((IWorkbenchPart)localEditor);
                        }
                    }
                    catch (PartInitException partInitException) {
                        // empty catch block
                    }
                    ++n2;
                }
            }
        }
    }
}

