/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.ui.symbols;

import java.io.File;
import java.util.Collections;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.internal.tmf.core.callstack.FunctionNameMapper;
import org.eclipse.tracecompass.internal.tmf.ui.symbols.BasicSymbolProviderPreferencePage;
import org.eclipse.tracecompass.tmf.core.event.lookup.ITmfCallsite;
import org.eclipse.tracecompass.tmf.core.event.lookup.TmfCallsite;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.ui.symbols.ISymbolProvider;
import org.eclipse.tracecompass.tmf.ui.symbols.ISymbolProviderPreferencePage;

public class BasicSymbolProvider
implements ISymbolProvider {
    private final @NonNull ITmfTrace fTrace;
    private @NonNull Map<String, String> fMapping = Collections.emptyMap();
    private String fSource;
    private @NonNull SourceKind fKind = SourceKind.BINARY;
    private boolean fConfigured;

    public BasicSymbolProvider(@NonNull ITmfTrace trace) {
        this.fTrace = trace;
    }

    public String getConfiguredSource() {
        return this.fSource;
    }

    public @NonNull SourceKind getConfiguredSourceKind() {
        return this.fKind;
    }

    public void setConfiguredSource(String fileSource, @NonNull SourceKind kind) {
        this.fSource = fileSource;
        this.fKind = kind;
        this.fConfigured = false;
    }

    @Override
    public @NonNull ITmfTrace getTrace() {
        return this.fTrace;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadConfiguration(IProgressMonitor monitor) {
        if (!this.fConfigured) {
            BasicSymbolProvider basicSymbolProvider = this;
            synchronized (basicSymbolProvider) {
                if (!this.fConfigured) {
                    try {
                        Map result;
                        File file;
                        this.fMapping = Collections.emptyMap();
                        if (this.fSource != null && (file = new File(this.fSource)).isFile() && (result = this.fKind == SourceKind.BINARY ? FunctionNameMapper.mapFromBinaryFile((File)file) : FunctionNameMapper.mapFromNmTextFile((File)file)) != null) {
                            this.fMapping = result;
                        }
                    }
                    finally {
                        this.fConfigured = true;
                    }
                }
            }
        }
    }

    @Override
    public @Nullable String getSymbolText(long address) {
        this.loadConfiguration(null);
        return this.fMapping.get(Long.toHexString(address));
    }

    @Override
    @Deprecated
    public @Nullable ITmfCallsite getSymbolInfo(long address) {
        this.loadConfiguration(null);
        String symbolText = this.getSymbolText(address);
        if (symbolText != null) {
            return new TmfCallsite(null, symbolText, -1L);
        }
        return null;
    }

    @Override
    public ISymbolProviderPreferencePage createPreferencePage() {
        return new BasicSymbolProviderPreferencePage(this);
    }

    public static enum SourceKind {
        BINARY,
        MAPPING;

    }
}

