/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.markers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.math.Fraction;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.swt.graphics.RGBA;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.IMarkerEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.IMarkerEventSource;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.MarkerEvent;

@NonNullByDefault
public class PeriodicMarkerEventSource
implements IMarkerEventSource {
    private final String fCategory;
    private final Reference fReference;
    private final double fPeriod;
    private final long fPeriodInteger;
    private @Nullable Fraction fPeriodFraction;
    private final long fRollover;
    private final RGBA fColor;
    private final @Nullable RGBA fOddColor;
    private final boolean fForeground;

    public PeriodicMarkerEventSource(String category, Reference reference, double period, long rollover, RGBA color, boolean foreground) {
        this(category, reference, period, rollover, foreground, color, null);
    }

    public PeriodicMarkerEventSource(String category, Reference reference, double period, long rollover, RGBA evenColor, RGBA oddColor, boolean foreground) {
        this(category, reference, period, rollover, foreground, evenColor, oddColor);
    }

    private PeriodicMarkerEventSource(String category, Reference reference, double period, long rollover, boolean foreground, RGBA evenColor, @Nullable RGBA oddColor) {
        if (period <= 0.0) {
            throw new IllegalArgumentException("period cannot be less than or equal to zero");
        }
        if (rollover < 0L) {
            throw new IllegalArgumentException("rollover cannot be less than zero");
        }
        this.fCategory = category;
        this.fReference = reference;
        this.fPeriod = period;
        this.fPeriodInteger = (long)period;
        try {
            this.fPeriodFraction = Fraction.getFraction((double)(this.fPeriod - (double)this.fPeriodInteger));
        }
        catch (ArithmeticException e) {
            this.fPeriodFraction = null;
        }
        this.fRollover = rollover;
        this.fColor = evenColor;
        this.fOddColor = oddColor;
        this.fForeground = foreground;
    }

    @Override
    public List<String> getMarkerCategories() {
        return Arrays.asList(this.fCategory);
    }

    @Override
    public List<IMarkerEvent> getMarkerList(String category, long startTime, long endTime, long resolution, IProgressMonitor monitor) {
        if (startTime > endTime) {
            return Collections.emptyList();
        }
        ArrayList<IMarkerEvent> markers = new ArrayList<IMarkerEvent>();
        long time = startTime - Math.max(Math.round(1.5 * this.fPeriod), resolution);
        Reference reference = this.adjustReference(this.fReference, time);
        MarkerEvent markerEvent = null;
        while (true) {
            long index = Math.round((double)(time - reference.time) / this.fPeriod) + reference.index;
            time = Math.round((double)(index - reference.index) * this.fPeriod) + reference.time;
            long duration = this.fOddColor == null ? 0L : Math.round((double)(index + 1L - reference.index) * this.fPeriod) + reference.time - time;
            long labelIndex = index;
            if (this.fRollover != 0L && (labelIndex %= this.fRollover) < 0L) {
                labelIndex += this.fRollover;
            }
            if ((time >= startTime || time + duration > startTime) && markerEvent != null) {
                markers.add(markerEvent);
            }
            RGBA color = this.fOddColor == null ? this.fColor : (index % 2L == 0L ? this.fColor : this.fOddColor);
            markerEvent = new MarkerEvent(null, time, duration, this.fCategory, color, this.getMarkerLabel(labelIndex), this.fForeground);
            if (time > endTime) break;
            time += Math.max(Math.round(this.fPeriod), resolution);
        }
        markers.add(markerEvent);
        return markers;
    }

    private Reference adjustReference(Reference baseReference, long time) {
        long offsetIndex = (long)((double)(time - baseReference.time) / this.fPeriod);
        long offsetTime = 0L;
        Fraction fraction = this.fPeriodFraction;
        if (fraction != null) {
            offsetIndex -= offsetIndex % (long)fraction.getDenominator();
            offsetTime = offsetIndex * this.fPeriodInteger + offsetIndex / (long)fraction.getDenominator() * (long)fraction.getNumerator();
        } else {
            offsetTime = Math.round((double)offsetIndex * this.fPeriod);
        }
        Reference reference = new Reference(baseReference.time + offsetTime, baseReference.index + offsetIndex);
        return reference;
    }

    public String getMarkerLabel(long index) {
        return (String)NonNullUtils.checkNotNull((Object)Long.toString(index));
    }

    public static class Reference {
        public static final Reference ZERO = new Reference(0L, 0);
        private final long time;
        private final long index;

        public Reference(long time, int index) {
            this.time = time;
            this.index = index;
        }

        public Reference(long time, long index) {
            this.time = time;
            this.index = index;
        }

        public String toString() {
            return String.format("[%d, %d]", this.time, this.index);
        }
    }
}

