/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.project.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.tracecompass.tmf.core.analysis.IAnalysisModule;
import org.eclipse.tracecompass.tmf.core.analysis.IAnalysisModuleHelper;
import org.eclipse.tracecompass.tmf.core.analysis.IAnalysisOutput;
import org.eclipse.tracecompass.tmf.core.project.model.ITmfPropertiesProvider;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.ui.project.model.ITmfProjectModelElement;
import org.eclipse.tracecompass.tmf.ui.project.model.ITmfStyledProjectModelElement;
import org.eclipse.tracecompass.tmf.ui.project.model.Messages;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfAnalysisOutputElement;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfCommonProjectElement;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfOpenTraceHelper;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfProjectModelElement;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfProjectModelIcons;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfTraceElement;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfTraceFolder;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfViewsElement;
import org.eclipse.tracecompass.tmf.ui.properties.ReadOnlyTextPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource2;
import org.osgi.framework.Bundle;

public class TmfAnalysisElement
extends TmfProjectModelElement
implements ITmfStyledProjectModelElement,
IPropertySource2 {
    private static final StyledString.Styler ANALYSIS_CANT_EXECUTE_STYLER = new StyledString.Styler(){

        public void applyStyles(TextStyle textStyle) {
            textStyle.strikeout = true;
        }
    };
    private final @NonNull IAnalysisModuleHelper fAnalysisHelper;
    private boolean fCanExecute = true;
    private static final String ANALYSIS_PROPERTIES_CATEGORY = Messages.TmfAnalysisElement_AnalysisProperties;
    private static final String HELPER_PROPERTIES_CATEGORY = Messages.TmfAnalysisElement_HelperProperties;

    protected TmfAnalysisElement(String name, IResource resource, TmfViewsElement parent, @NonNull IAnalysisModuleHelper module) {
        super(name, resource, parent);
        this.fAnalysisHelper = module;
    }

    @Override
    public TmfViewsElement getParent() {
        return (TmfViewsElement)super.getParent();
    }

    @Override
    protected void refreshChildren() {
        TmfCommonProjectElement parentTraceElement;
        ITmfTrace trace;
        this.fCanExecute = true;
        HashMap<String, TmfAnalysisOutputElement> childrenMap = new HashMap<String, TmfAnalysisOutputElement>();
        for (TmfAnalysisOutputElement output : this.getAvailableOutputs()) {
            childrenMap.put(output.getName(), output);
        }
        TmfTraceFolder tracesFolder = this.getProject().getTracesFolder();
        if (tracesFolder == null) {
            return;
        }
        IPath path = tracesFolder.getPath();
        IResource resource = this.getResource();
        if (resource instanceof IFolder) {
            path = ((IFolder)resource).getFullPath();
        }
        if ((trace = (parentTraceElement = this.getParent().getParent()).getTrace()) == null) {
            this.deleteOutputs();
            return;
        }
        IAnalysisModule module = trace.getAnalysisModule(this.fAnalysisHelper.getId());
        if (module == null) {
            this.deleteOutputs();
            this.fCanExecute = false;
            return;
        }
        for (Object output : module.getOutputs()) {
            TmfAnalysisOutputElement outputElement = (TmfAnalysisOutputElement)childrenMap.remove(output.getName());
            if (outputElement == null) {
                IFolder newresource = ResourcesPlugin.getWorkspace().getRoot().getFolder(path.append(output.getName()));
                outputElement = new TmfAnalysisOutputElement(output.getName(), (IResource)newresource, this, (IAnalysisOutput)output);
                this.addChild(outputElement);
            }
            outputElement.refreshChildren();
        }
        for (Object output : childrenMap.values()) {
            this.removeChild((ITmfProjectModelElement)output);
        }
    }

    @Override
    public Image getIcon() {
        Image icon;
        Bundle bundle;
        String iconFile = this.getIconFile();
        if (iconFile != null && (bundle = this.getBundle()) != null && (icon = TmfProjectModelIcons.loadIcon(bundle, iconFile)) != null) {
            return icon;
        }
        return TmfProjectModelIcons.DEFAULT_ANALYSIS_ICON;
    }

    @Override
    public StyledString.Styler getStyler() {
        if (!this.fCanExecute) {
            return ANALYSIS_CANT_EXECUTE_STYLER;
        }
        return null;
    }

    public List<TmfAnalysisOutputElement> getAvailableOutputs() {
        List<ITmfProjectModelElement> children = this.getChildren();
        ArrayList<TmfAnalysisOutputElement> outputs = new ArrayList<TmfAnalysisOutputElement>();
        for (ITmfProjectModelElement child : children) {
            if (!(child instanceof TmfAnalysisOutputElement)) continue;
            outputs.add((TmfAnalysisOutputElement)child);
        }
        return outputs;
    }

    public String getAnalysisId() {
        return this.fAnalysisHelper.getId();
    }

    public String getHelpMessage() {
        IAnalysisModule module;
        TmfTraceElement traceElement;
        TmfCommonProjectElement parentTrace = this.getParent().getParent();
        ITmfTrace trace = null;
        if (parentTrace instanceof TmfTraceElement && (trace = (traceElement = (TmfTraceElement)parentTrace).getTrace()) != null && (module = trace.getAnalysisModule(this.fAnalysisHelper.getId())) != null) {
            return module.getHelpText(trace);
        }
        if (trace != null) {
            return this.fAnalysisHelper.getHelpText(trace);
        }
        return this.fAnalysisHelper.getHelpText();
    }

    public String getIconFile() {
        return this.fAnalysisHelper.getIcon();
    }

    public Bundle getBundle() {
        return this.fAnalysisHelper.getBundle();
    }

    private void deleteOutputs() {
        for (TmfAnalysisOutputElement output : this.getAvailableOutputs()) {
            this.removeChild(output);
        }
    }

    public void activateParentTrace() {
        TmfCommonProjectElement parentTrace = this.getParent().getParent();
        if (parentTrace instanceof TmfTraceElement) {
            TmfTraceElement traceElement = (TmfTraceElement)parentTrace;
            TmfOpenTraceHelper.openTraceFromElement(traceElement);
        }
    }

    public Object getEditableValue() {
        return null;
    }

    private Map<String, String> getAnalysisProperties() {
        ITmfProjectModelElement parent = this.getParent();
        if (!(parent instanceof TmfViewsElement)) {
            return Collections.EMPTY_MAP;
        }
        if ((parent = parent.getParent()) instanceof TmfCommonProjectElement) {
            ITmfTrace trace = ((TmfCommonProjectElement)parent).getTrace();
            if (trace == null) {
                return Collections.EMPTY_MAP;
            }
            IAnalysisModule module = trace.getAnalysisModule(this.fAnalysisHelper.getId());
            if (module instanceof ITmfPropertiesProvider) {
                return ((ITmfPropertiesProvider)module).getProperties();
            }
        }
        return Collections.EMPTY_MAP;
    }

    private Map<String, String> getAnalysisHelperProperties() {
        if (this.fAnalysisHelper instanceof ITmfPropertiesProvider) {
            ITmfPropertiesProvider analysisProperties = (ITmfPropertiesProvider)this.fAnalysisHelper;
            return analysisProperties.getProperties();
        }
        return Collections.EMPTY_MAP;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        Map<String, String> helperProperties = this.getAnalysisHelperProperties();
        Map<String, String> analysisProperties = this.getAnalysisProperties();
        if (!analysisProperties.isEmpty() || !helperProperties.isEmpty()) {
            ReadOnlyTextPropertyDescriptor descriptor;
            ArrayList<ReadOnlyTextPropertyDescriptor> propertyDescriptorArray = new ArrayList<ReadOnlyTextPropertyDescriptor>(analysisProperties.size() + helperProperties.size());
            for (Map.Entry<String, String> varName : helperProperties.entrySet()) {
                descriptor = new ReadOnlyTextPropertyDescriptor(String.valueOf(this.getName()) + '_' + varName.getKey(), varName.getKey());
                descriptor.setCategory(HELPER_PROPERTIES_CATEGORY);
                propertyDescriptorArray.add(descriptor);
            }
            for (Map.Entry<String, String> varName : analysisProperties.entrySet()) {
                descriptor = new ReadOnlyTextPropertyDescriptor(String.valueOf(this.getName()) + '_' + varName.getKey(), varName.getKey());
                descriptor.setCategory(ANALYSIS_PROPERTIES_CATEGORY);
                propertyDescriptorArray.add(descriptor);
            }
            return propertyDescriptorArray.toArray(new IPropertyDescriptor[analysisProperties.size() + helperProperties.size()]);
        }
        return new IPropertyDescriptor[0];
    }

    public Object getPropertyValue(Object id) {
        if (id == null) {
            return null;
        }
        Map<String, String> properties = this.getAnalysisHelperProperties();
        String key = (String)id;
        if (properties.containsKey(key = key.substring(this.getName().length() + 1))) {
            String value = properties.get(key);
            return value;
        }
        properties = this.getAnalysisProperties();
        if (properties.containsKey(key)) {
            String value = properties.get(key);
            return value;
        }
        return null;
    }

    public final void resetPropertyValue(Object id) {
    }

    public final void setPropertyValue(Object id, Object value) {
    }

    public final boolean isPropertyResettable(Object id) {
        return false;
    }

    public final boolean isPropertySet(Object id) {
        return false;
    }
}

