/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.viewers.xycharts;

import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimestamp;
import org.eclipse.tracecompass.tmf.ui.viewers.xycharts.ITmfChartTimeProvider;
import org.eclipse.tracecompass.tmf.ui.viewers.xycharts.TmfBaseProvider;
import org.swtchart.IAxis;

public class TmfSimpleTooltipProvider
extends TmfBaseProvider
implements MouseTrackListener {
    public TmfSimpleTooltipProvider(ITmfChartTimeProvider tmfChartViewer) {
        super(tmfChartViewer);
        this.register();
    }

    @Override
    public void register() {
        this.getChart().getPlotArea().addMouseTrackListener((MouseTrackListener)this);
    }

    @Override
    public void deregister() {
        if (this.getChartViewer().getControl() != null && !this.getChartViewer().getControl().isDisposed()) {
            this.getChart().getPlotArea().removeMouseTrackListener((MouseTrackListener)this);
        }
    }

    @Override
    public void refresh() {
    }

    public void mouseEnter(MouseEvent e) {
    }

    public void mouseExit(MouseEvent e) {
    }

    public void mouseHover(MouseEvent e) {
        if (this.getChartViewer().getWindowDuration() == 0L) {
            return;
        }
        IAxis xAxis = this.getChart().getAxisSet().getXAxis(0);
        IAxis yAxis = this.getChart().getAxisSet().getYAxis(0);
        double xCoordinate = xAxis.getDataCoordinate(e.x);
        double yCoordinate = yAxis.getDataCoordinate(e.y);
        ITmfChartTimeProvider viewer = this.getChartViewer();
        StringBuffer buffer = new StringBuffer();
        buffer.append("x=");
        buffer.append(TmfTimestamp.fromNanos((long)((long)xCoordinate + viewer.getTimeOffset())).toString());
        buffer.append("\n");
        buffer.append("y=");
        buffer.append((long)yCoordinate);
        this.getChart().getPlotArea().setToolTipText(buffer.toString());
    }
}

