/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.navigator.dnd;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.ui.internal.navigator.dnd.CommonDropAdapterDescriptor;
import org.eclipse.ui.internal.navigator.extensions.ExtensionSequenceNumberComparator;
import org.eclipse.ui.internal.navigator.extensions.INavigatorContentExtPtConstants;
import org.eclipse.ui.internal.navigator.extensions.NavigatorContentDescriptor;
import org.eclipse.ui.internal.navigator.extensions.NavigatorContentRegistryReader;
import org.eclipse.ui.navigator.INavigatorContentDescriptor;
import org.eclipse.ui.navigator.INavigatorContentService;

public class CommonDropDescriptorManager {
    private static final CommonDropDescriptorManager INSTANCE = new CommonDropDescriptorManager();
    private static final CommonDropAdapterDescriptor[] NO_DESCRIPTORS = new CommonDropAdapterDescriptor[0];
    private final Map<INavigatorContentDescriptor, List> dropDescriptors = new TreeMap<INavigatorContentDescriptor, List>(ExtensionSequenceNumberComparator.INSTANCE);

    public static CommonDropDescriptorManager getInstance() {
        return INSTANCE;
    }

    private CommonDropDescriptorManager() {
        new CommonDropAdapterRegistry().readRegistry();
    }

    public CommonDropAdapterDescriptor[] findCommonDropAdapterAssistants(Object aDropTarget, INavigatorContentService aContentService) {
        LinkedHashSet<CommonDropAdapterDescriptor> foundDescriptors = new LinkedHashSet<CommonDropAdapterDescriptor>();
        for (INavigatorContentDescriptor contentDescriptor : this.dropDescriptors.keySet()) {
            if (!aContentService.isVisible(contentDescriptor.getId()) || !aContentService.isActive(contentDescriptor.getId())) continue;
            List<CommonDropAdapterDescriptor> dropDescriptors = this.getDropDescriptors(contentDescriptor);
            for (CommonDropAdapterDescriptor dropDescriptor : dropDescriptors) {
                if (!dropDescriptor.isDropElementSupported(aDropTarget)) continue;
                foundDescriptors.add(dropDescriptor);
            }
        }
        if (foundDescriptors.isEmpty()) {
            return NO_DESCRIPTORS;
        }
        return foundDescriptors.toArray(new CommonDropAdapterDescriptor[foundDescriptors.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<CommonDropAdapterDescriptor> getDropDescriptors(INavigatorContentDescriptor aContentDescriptor) {
        ArrayList descriptors = this.dropDescriptors.get(aContentDescriptor);
        if (descriptors != null) {
            return descriptors;
        }
        Map<INavigatorContentDescriptor, List> map = this.dropDescriptors;
        synchronized (map) {
            descriptors = this.dropDescriptors.get(aContentDescriptor);
            if (descriptors == null) {
                descriptors = new ArrayList();
                this.dropDescriptors.put(aContentDescriptor, descriptors);
            }
        }
        return descriptors;
    }

    private void addCommonDropAdapter(INavigatorContentDescriptor aContentDescriptor, CommonDropAdapterDescriptor aDropDescriptor) {
        this.getDropDescriptors(aContentDescriptor).add(aDropDescriptor);
    }

    private class CommonDropAdapterRegistry
    extends NavigatorContentRegistryReader
    implements INavigatorContentExtPtConstants {
        private CommonDropAdapterRegistry() {
        }

        @Override
        protected boolean readElement(IConfigurationElement element) {
            NavigatorContentDescriptor contentDescriptor;
            String id;
            if ("navigatorContent".equals(element.getName()) && (id = element.getAttribute("id")) != null && (contentDescriptor = this.CONTENT_DESCRIPTOR_MANAGER.getContentDescriptor(id)) != null) {
                IConfigurationElement[] commonDropAdapters = element.getChildren("dropAssistant");
                int i = 0;
                while (i < commonDropAdapters.length) {
                    CommonDropDescriptorManager.this.addCommonDropAdapter(contentDescriptor, new CommonDropAdapterDescriptor(commonDropAdapters[i], contentDescriptor));
                    ++i;
                }
            }
            return super.readElement(element);
        }
    }
}

