/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.consumer.converters;

import java.io.Serializable;
import org.gradle.api.Action;
import org.gradle.tooling.internal.adapter.SourceObjectMapping;
import org.gradle.tooling.internal.consumer.converters.IdeaModuleDependencyTargetMixin;
import org.gradle.tooling.internal.consumer.converters.IdeaModuleIdentifierMixin;
import org.gradle.tooling.internal.consumer.converters.IdeaProjectJavaLanguageSettingsMixin;
import org.gradle.tooling.internal.consumer.versioning.VersionDetails;
import org.gradle.tooling.model.idea.IdeaDependency;
import org.gradle.tooling.model.idea.IdeaModule;
import org.gradle.tooling.model.idea.IdeaProject;
import org.gradle.util.GradleVersion;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IdeaModelCompatibilityMapping
implements Action<SourceObjectMapping>,
Serializable {
    private final boolean versionSupportsIdeaJavaSourceSettings;
    private final boolean versionSupportsIdeaModuleIdentifier;

    public IdeaModelCompatibilityMapping(VersionDetails versionDetails) {
        GradleVersion targetGradleVersion = GradleVersion.version(versionDetails.getVersion());
        this.versionSupportsIdeaJavaSourceSettings = this.supportsIdeaJavaSourceSettings(targetGradleVersion);
        this.versionSupportsIdeaModuleIdentifier = this.supportsIdeaModuleIdentifier(targetGradleVersion);
    }

    @Override
    public void execute(SourceObjectMapping mapping) {
        Class<?> targetType = mapping.getTargetType();
        if (IdeaProject.class.isAssignableFrom(targetType) && !this.versionSupportsIdeaJavaSourceSettings) {
            mapping.mixIn(IdeaProjectJavaLanguageSettingsMixin.class);
        }
        if (!this.versionSupportsIdeaModuleIdentifier) {
            if (IdeaDependency.class.isAssignableFrom(targetType)) {
                mapping.mixIn(IdeaModuleDependencyTargetMixin.class);
            } else if (IdeaModule.class.isAssignableFrom(targetType)) {
                mapping.mixIn(IdeaModuleIdentifierMixin.class);
            }
        }
    }

    private boolean supportsIdeaJavaSourceSettings(GradleVersion targetGradleVersion) {
        return targetGradleVersion.getBaseVersion().compareTo(GradleVersion.version("2.11")) >= 0;
    }

    private boolean supportsIdeaModuleIdentifier(GradleVersion targetGradleVersion) {
        return targetGradleVersion.getBaseVersion().compareTo(GradleVersion.version("2.14")) >= 0;
    }
}

