/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.model.internal.flash.proxy.logs;

import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ProxyLogRecord {
    private long millis;
    private Level level;
    private String message;
    private String loggerName;
    private String id;
    private static final Pattern pattern = Pattern.compile("\\[id:(\\d+)\\] (.*)");

    public ProxyLogRecord(LogRecord logRecord) {
        this.millis = logRecord.getMillis();
        this.level = logRecord.getLevel();
        this.loggerName = logRecord.getLoggerName();
        this.message = logRecord.getMessage();
        this.id = "";
        if (this.message != null) {
            Matcher matcher = pattern.matcher(this.message);
            if (matcher.find()) {
                this.id = matcher.group(1);
                this.message = matcher.group(2);
            }
            if (this.message.length() > 256) {
                this.message = String.valueOf(this.message.substring(0, 256)) + "...";
            }
        }
    }

    public long getMillis() {
        return this.millis;
    }

    public Level getLevel() {
        return this.level;
    }

    public String getMessage() {
        return this.message;
    }

    public String getID() {
        return this.id;
    }

    public String getLoggerName() {
        return this.loggerName;
    }
}

