/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.lib.explorer;

import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.part.Page;

public abstract class LibraryExplorerViewPage
extends Page
implements ISelectionProvider {
    private TreeViewer treeViewer;
    private ListenerList selectionChangedListeners = new ListenerList(1);
    private ISelection currentSelection = StructuredSelection.EMPTY;

    public void createControl(Composite parent) {
        this.treeViewer = this.createTreeViewer(parent);
        if (this.treeViewer == null) {
            return;
        }
        this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                LibraryExplorerViewPage.this.currentSelection = event.getSelection();
                LibraryExplorerViewPage.this.fireSelectionChanged(LibraryExplorerViewPage.this.currentSelection);
            }
        });
    }

    public void init(IPageSite pageSite) {
        super.init(pageSite);
        pageSite.setSelectionProvider((ISelectionProvider)this);
    }

    public Control getControl() {
        if (this.treeViewer == null) {
            return null;
        }
        return this.treeViewer.getControl();
    }

    public void setFocus() {
        if (this.treeViewer != null) {
            this.treeViewer.getControl().setFocus();
        }
    }

    protected abstract TreeViewer createTreeViewer(Composite var1);

    public TreeViewer getTreeViewer() {
        return this.treeViewer;
    }

    private void fireSelectionChanged(ISelection selection) {
        final SelectionChangedEvent event = new SelectionChangedEvent((ISelectionProvider)this, selection);
        Object[] listeners = this.selectionChangedListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            final ISelectionChangedListener l = (ISelectionChangedListener)listeners[i];
            SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    l.selectionChanged(event);
                }
            });
            ++i;
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.setSelection(event.getSelection());
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangedListeners.add((Object)listener);
    }

    public ISelection getSelection() {
        return this.currentSelection;
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangedListeners.remove((Object)listener);
    }

    public void setSelection(ISelection selection) {
        if (this.getTreeViewer() != null) {
            this.getTreeViewer().setSelection(selection);
        }
    }

    public void dispose() {
        this.selectionChangedListeners.clear();
        this.treeViewer = null;
        super.dispose();
    }
}

