/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.internal.ui.preferences;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.make.internal.ui.MakeUIPlugin;
import org.eclipse.cdt.make.internal.ui.preferences.AbstractMakefileEditorPreferencePage;
import org.eclipse.cdt.make.internal.ui.preferences.MakefilePreferencesMessages;
import org.eclipse.cdt.make.internal.ui.preferences.OverlayPreferenceStore;
import org.eclipse.cdt.make.internal.ui.preferences.TabFolderLayout;
import org.eclipse.cdt.make.internal.ui.text.ColorManager;
import org.eclipse.cdt.make.ui.IMakeHelpContextIds;
import org.eclipse.jface.preference.ColorSelector;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.ui.model.WorkbenchViewerComparator;

public class MakefileEditorPreferencePage
extends AbstractMakefileEditorPreferencePage {
    private String[][] fSyntaxColorListModel;
    private TableViewer fHighlightingColorListViewer;
    private final List<HighlightingColorListItem> fHighlightingColorList = new ArrayList<HighlightingColorListItem>(7);
    Button fAppearanceColorDefault;
    ColorSelector fSyntaxForegroundColorEditor;
    Button fBoldCheckBox;
    Button fItalicCheckBox;
    protected Button fFoldingCheckbox;

    @Override
    protected OverlayPreferenceStore createOverlayStore() {
        String[][] stringArrayArray = new String[7][];
        String[] stringArray = new String[3];
        stringArray[0] = MakefilePreferencesMessages.getString("MakefileEditorPreferencePage.makefile_editor_comment");
        stringArray[1] = "org.eclipse.cdt.make.ui.editor.comment";
        stringArrayArray[0] = stringArray;
        String[] stringArray2 = new String[3];
        stringArray2[0] = MakefilePreferencesMessages.getString("MakefileEditorPreferencePage.makefile_editor_macro_ref");
        stringArray2[1] = "org.eclipse.cdt.make.ui.editor.macro_ref";
        stringArrayArray[1] = stringArray2;
        String[] stringArray3 = new String[3];
        stringArray3[0] = MakefilePreferencesMessages.getString("MakefileEditorPreferencePage.makefile_editor_macro_def");
        stringArray3[1] = "org.eclipse.cdt.make.ui.editor.macro_def";
        stringArrayArray[2] = stringArray3;
        String[] stringArray4 = new String[3];
        stringArray4[0] = MakefilePreferencesMessages.getString("MakefileEditorPreferencePage.makefile_editor_function");
        stringArray4[1] = "org.eclipse.cdt.make.ui.editor.function";
        stringArrayArray[3] = stringArray4;
        String[] stringArray5 = new String[3];
        stringArray5[0] = MakefilePreferencesMessages.getString("MakefileEditorPreferencePage.makefile_editor_keyword");
        stringArray5[1] = "org.eclipse.cdt.make.ui.editor.keyword";
        stringArrayArray[4] = stringArray5;
        String[] stringArray6 = new String[3];
        stringArray6[0] = MakefilePreferencesMessages.getString("MakefileEditorPreferencePage.makefile_editor_matching_bracket");
        stringArray6[1] = "org.eclipse.cdt.make.ui.editor.matching.brackets.color";
        stringArrayArray[5] = stringArray6;
        String[] stringArray7 = new String[3];
        stringArray7[0] = MakefilePreferencesMessages.getString("MakefileEditorPreferencePage.makefile_editor_default");
        stringArray7[1] = "org.eclipse.cdt.make.ui.editor.default";
        stringArrayArray[6] = stringArray7;
        this.fSyntaxColorListModel = stringArrayArray;
        ArrayList<OverlayPreferenceStore.OverlayKey> overlayKeys = new ArrayList<OverlayPreferenceStore.OverlayKey>();
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "editor_folding_enabled"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "editor_folding_default_conditional"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "editor_folding_default_macrodef"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "editor_folding_default_rule"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "editor_matching_brackets"));
        int i = 0;
        while (i < this.fSyntaxColorListModel.length) {
            String colorKey = this.fSyntaxColorListModel[i][1];
            this.addTextKeyToCover(overlayKeys, colorKey);
            ++i;
        }
        OverlayPreferenceStore.OverlayKey[] keys = new OverlayPreferenceStore.OverlayKey[overlayKeys.size()];
        overlayKeys.toArray(keys);
        return new OverlayPreferenceStore(this.getPreferenceStore(), keys);
    }

    private void addTextKeyToCover(ArrayList<OverlayPreferenceStore.OverlayKey> overlayKeys, String mainKey) {
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, mainKey));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, String.valueOf(mainKey) + "_bold"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, String.valueOf(mainKey) + "_italic"));
    }

    protected Control createContents(Composite parent) {
        MakeUIPlugin.getDefault().getWorkbench().getHelpSystem().setHelp(this.getControl(), IMakeHelpContextIds.MAKE_EDITOR_PREFERENCE_PAGE);
        this.getOverlayStore().load();
        this.getOverlayStore().start();
        TabFolder folder = new TabFolder(parent, 0);
        folder.setLayout((Layout)new TabFolderLayout());
        folder.setLayoutData((Object)new GridData(1808));
        TabItem item = new TabItem(folder, 0);
        item.setText(MakefilePreferencesMessages.getString("MakefileEditorPreferencePage.syntax"));
        item.setControl(this.createSyntaxPage((Composite)folder));
        item = new TabItem(folder, 0);
        item.setText(MakefilePreferencesMessages.getString("MakefileEditorPreferencePage.folding"));
        item.setControl((Control)this.createFoldingTabContent(folder));
        this.initialize();
        this.applyDialogFont((Composite)folder);
        return folder;
    }

    private void initialize() {
        this.initializeFields();
        int i = 0;
        int n = this.fSyntaxColorListModel.length;
        while (i < n) {
            this.fHighlightingColorList.add(new HighlightingColorListItem(this.fSyntaxColorListModel[i][0], this.fSyntaxColorListModel[i][1], String.valueOf(this.fSyntaxColorListModel[i][1]) + "_bold", String.valueOf(this.fSyntaxColorListModel[i][1]) + "_italic", null));
            ++i;
        }
        this.fHighlightingColorListViewer.setInput(this.fHighlightingColorList);
        this.fHighlightingColorListViewer.setSelection((ISelection)new StructuredSelection(this.fHighlightingColorListViewer.getElementAt(0)));
        this.initializeFolding();
    }

    void initializeFolding() {
        boolean enabled = this.getOverlayStore().getBoolean("editor_folding_enabled");
        this.fFoldingCheckbox.setSelection(enabled);
    }

    void initializeDefaultFolding() {
        boolean enabled = this.getOverlayStore().getDefaultBoolean("editor_folding_enabled");
        this.fFoldingCheckbox.setSelection(enabled);
    }

    @Override
    protected void handleDefaults() {
        this.handleSyntaxColorListSelection();
        this.initializeDefaultFolding();
    }

    private Control createSyntaxPage(Composite parent) {
        Composite colorComposite = new Composite(parent, 0);
        colorComposite.setLayout((Layout)new GridLayout());
        Label label = new Label(colorComposite, 16384);
        label.setText(MakefilePreferencesMessages.getString("MakefileEditorPreferencePage.Foreground"));
        label.setLayoutData((Object)new GridData(768));
        Composite editorComposite = new Composite(colorComposite, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        editorComposite.setLayout((Layout)layout);
        GridData gd = new GridData(1808);
        editorComposite.setLayoutData((Object)gd);
        this.fHighlightingColorListViewer = new TableViewer(editorComposite, 68100);
        this.fHighlightingColorListViewer.setLabelProvider((IBaseLabelProvider)new ColorListLabelProvider());
        this.fHighlightingColorListViewer.setContentProvider((IContentProvider)new ColorListContentProvider());
        this.fHighlightingColorListViewer.setComparator((ViewerComparator)new WorkbenchViewerComparator());
        gd = new GridData(1808);
        gd.heightHint = this.convertHeightInCharsToPixels(5);
        this.fHighlightingColorListViewer.getControl().setLayoutData((Object)gd);
        Composite stylesComposite = new Composite(editorComposite, 0);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 2;
        stylesComposite.setLayout((Layout)layout);
        stylesComposite.setLayoutData((Object)new GridData(1808));
        label = new Label(stylesComposite, 16384);
        label.setText(MakefilePreferencesMessages.getString("MakefileEditorPreferencePage.color"));
        gd = new GridData();
        gd.horizontalAlignment = 1;
        label.setLayoutData((Object)gd);
        this.fSyntaxForegroundColorEditor = new ColorSelector(stylesComposite);
        Button foregroundColorButton = this.fSyntaxForegroundColorEditor.getButton();
        gd = new GridData(768);
        gd.horizontalAlignment = 1;
        foregroundColorButton.setLayoutData((Object)gd);
        this.fBoldCheckBox = new Button(stylesComposite, 32);
        this.fBoldCheckBox.setText(MakefilePreferencesMessages.getString("MakefileEditorPreferencePage.bold"));
        gd = new GridData(768);
        gd.horizontalAlignment = 1;
        gd.horizontalSpan = 2;
        this.fBoldCheckBox.setLayoutData((Object)gd);
        this.fItalicCheckBox = new Button(stylesComposite, 32);
        this.fItalicCheckBox.setText(MakefilePreferencesMessages.getString("MakefileEditorPreferencePage.italic"));
        gd = new GridData(768);
        gd.horizontalAlignment = 1;
        gd.horizontalSpan = 2;
        this.fItalicCheckBox.setLayoutData((Object)gd);
        this.fHighlightingColorListViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                MakefileEditorPreferencePage.this.handleSyntaxColorListSelection();
            }
        });
        foregroundColorButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                HighlightingColorListItem item = MakefileEditorPreferencePage.this.getHighlightingColorListItem();
                PreferenceConverter.setValue((IPreferenceStore)MakefileEditorPreferencePage.this.getOverlayStore(), (String)item.getColorKey(), (RGB)MakefileEditorPreferencePage.this.fSyntaxForegroundColorEditor.getColorValue());
            }
        });
        this.fBoldCheckBox.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                HighlightingColorListItem item = MakefileEditorPreferencePage.this.getHighlightingColorListItem();
                MakefileEditorPreferencePage.this.getOverlayStore().setValue(item.getBoldKey(), MakefileEditorPreferencePage.this.fBoldCheckBox.getSelection());
            }
        });
        this.fItalicCheckBox.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                HighlightingColorListItem item = MakefileEditorPreferencePage.this.getHighlightingColorListItem();
                MakefileEditorPreferencePage.this.getOverlayStore().setValue(item.getItalicKey(), MakefileEditorPreferencePage.this.fItalicCheckBox.getSelection());
            }
        });
        return colorComposite;
    }

    private Composite createFoldingTabContent(TabFolder folder) {
        Composite composite = new Composite((Composite)folder, 0);
        GridData gd = new GridData(80);
        composite.setLayoutData((Object)gd);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        this.fFoldingCheckbox = new Button(composite, 32);
        this.fFoldingCheckbox.setText(MakefilePreferencesMessages.getString("MakefileEditorPreferencePage.foldingenable"));
        gd = new GridData(34);
        this.fFoldingCheckbox.setLayoutData((Object)gd);
        this.fFoldingCheckbox.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                boolean enabled = MakefileEditorPreferencePage.this.fFoldingCheckbox.getSelection();
                MakefileEditorPreferencePage.this.getOverlayStore().setValue("editor_folding_enabled", enabled);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        return composite;
    }

    void handleSyntaxColorListSelection() {
        HighlightingColorListItem item = this.getHighlightingColorListItem();
        RGB rgb = PreferenceConverter.getColor((IPreferenceStore)this.getOverlayStore(), (String)item.getColorKey());
        this.fSyntaxForegroundColorEditor.setColorValue(rgb);
        boolean isTextType = !MakefilePreferencesMessages.getString("MakefileEditorPreferencePage.makefile_editor_matching_bracket").equals(item.getDisplayName());
        this.fBoldCheckBox.setVisible(isTextType);
        this.fItalicCheckBox.setVisible(isTextType);
        if (isTextType) {
            this.fBoldCheckBox.setSelection(this.getOverlayStore().getBoolean(item.getBoldKey()));
            this.fItalicCheckBox.setSelection(this.getOverlayStore().getBoolean(item.getItalicKey()));
        }
    }

    HighlightingColorListItem getHighlightingColorListItem() {
        IStructuredSelection selection = (IStructuredSelection)this.fHighlightingColorListViewer.getSelection();
        return (HighlightingColorListItem)selection.getFirstElement();
    }

    @Override
    public boolean performOk() {
        return super.performOk();
    }

    public static void initDefaults(IPreferenceStore prefs) {
        PreferenceConverter.setDefault((IPreferenceStore)prefs, (String)"org.eclipse.cdt.make.ui.editor.comment", (RGB)ColorManager.MAKE_COMMENT_RGB);
        PreferenceConverter.setDefault((IPreferenceStore)prefs, (String)"org.eclipse.cdt.make.ui.editor.default", (RGB)ColorManager.MAKE_DEFAULT_RGB);
        PreferenceConverter.setDefault((IPreferenceStore)prefs, (String)"org.eclipse.cdt.make.ui.editor.function", (RGB)ColorManager.MAKE_FUNCTION_RGB);
        PreferenceConverter.setDefault((IPreferenceStore)prefs, (String)"org.eclipse.cdt.make.ui.editor.keyword", (RGB)ColorManager.MAKE_KEYWORD_RGB);
        PreferenceConverter.setDefault((IPreferenceStore)prefs, (String)"org.eclipse.cdt.make.ui.editor.macro_def", (RGB)ColorManager.MAKE_MACRO_DEF_RGB);
        PreferenceConverter.setDefault((IPreferenceStore)prefs, (String)"org.eclipse.cdt.make.ui.editor.macro_ref", (RGB)ColorManager.MAKE_MACRO_REF_RGB);
        PreferenceConverter.setDefault((IPreferenceStore)prefs, (String)"org.eclipse.cdt.make.ui.editor.matching.brackets.color", (RGB)ColorManager.MAKE_MATCHING_BRACKETS_RGB);
        prefs.setDefault("org.eclipse.cdt.make.ui.editor.keyword_bold", true);
        prefs.setDefault("org.eclipse.cdt.make.ui.editor.function_bold", true);
        prefs.setDefault("org.eclipse.cdt.make.ui.editor.macro_def_bold", true);
    }

    private class ColorListContentProvider
    implements IStructuredContentProvider {
        private ColorListContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return ((List)inputElement).toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private class ColorListLabelProvider
    extends LabelProvider
    implements IColorProvider {
        private ColorListLabelProvider() {
        }

        public String getText(Object element) {
            return ((HighlightingColorListItem)element).getDisplayName();
        }

        public Color getForeground(Object element) {
            return ((HighlightingColorListItem)element).getItemColor();
        }

        public Color getBackground(Object element) {
            return null;
        }
    }

    private class HighlightingColorListItem {
        private String fDisplayName;
        private String fColorKey;
        private String fBoldKey;
        private String fItalicKey;
        private Color fItemColor;

        public HighlightingColorListItem(String displayName, String colorKey, String boldKey, String italicKey, Color itemColor) {
            this.fDisplayName = displayName;
            this.fColorKey = colorKey;
            this.fBoldKey = boldKey;
            this.fItalicKey = italicKey;
            this.fItemColor = itemColor;
        }

        public String getBoldKey() {
            return this.fBoldKey;
        }

        public String getItalicKey() {
            return this.fItalicKey;
        }

        public String getColorKey() {
            return this.fColorKey;
        }

        public String getDisplayName() {
            return this.fDisplayName;
        }

        public Color getItemColor() {
            return this.fItemColor;
        }
    }
}

