/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.core.internal;

import java.util.HashMap;
import java.util.Map;

public class DeployedResourceCache {
    private final Map<CachedDeployedApplication, Map<String, DeployedResourceEntry>> cacheMap = new HashMap<CachedDeployedApplication, Map<String, DeployedResourceEntry>>();

    public synchronized void add(CachedDeployedApplication applicationID, DeployedResourceEntry entry) {
        Map<String, DeployedResourceEntry> appEntries = this.cacheMap.get(applicationID);
        if (appEntries == null) {
            appEntries = new HashMap<String, DeployedResourceEntry>();
            this.cacheMap.put(applicationID, appEntries);
        }
        appEntries.put(entry.getZipRelativeFileName(), entry);
    }

    public synchronized DeployedResourceEntry getEntry(CachedDeployedApplication applicationID, String zipRelativeFileName) {
        Map<String, DeployedResourceEntry> appEntries = this.cacheMap.get(applicationID);
        return appEntries != null ? appEntries.get(zipRelativeFileName) : null;
    }

    public static class CachedDeployedApplication {
        private final String appName;

        public CachedDeployedApplication(String appName) {
            this.appName = appName;
        }

        public String getAppName() {
            return this.appName;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.appName == null ? 0 : this.appName.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CachedDeployedApplication other = (CachedDeployedApplication)obj;
            return !(this.appName == null ? other.appName != null : !this.appName.equals(other.appName));
        }

        public String toString() {
            return this.appName.toString();
        }
    }

    public static class DeployedResourceEntry {
        private final byte[] sha1;
        private final long fileSize;
        private final String zipRelativeFileName;

        public DeployedResourceEntry(byte[] sha1, long fileSize, String zipRelativeFileName) {
            this.sha1 = sha1;
            this.fileSize = fileSize;
            this.zipRelativeFileName = zipRelativeFileName;
        }

        public String getZipRelativeFileName() {
            return this.zipRelativeFileName;
        }

        public byte[] getSha1() {
            return this.sha1;
        }

        public long getFileSize() {
            return this.fileSize;
        }
    }
}

