/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.compare.contentmergeviewer;

import com.ibm.icu.text.MessageFormat;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareNavigator;
import org.eclipse.compare.CompareUI;
import org.eclipse.compare.ICompareNavigator;
import org.eclipse.compare.IEditableContentExtension;
import org.eclipse.compare.IEncodedStreamContentAccessor;
import org.eclipse.compare.INavigatable;
import org.eclipse.compare.ISharedDocumentAdapter;
import org.eclipse.compare.IStreamContentAccessor;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.SharedDocumentAdapter;
import org.eclipse.compare.contentmergeviewer.ContentMergeViewer;
import org.eclipse.compare.contentmergeviewer.IDocumentRange;
import org.eclipse.compare.contentmergeviewer.IMergeViewerContentProvider;
import org.eclipse.compare.contentmergeviewer.ITokenComparator;
import org.eclipse.compare.contentmergeviewer.TokenComparator;
import org.eclipse.compare.internal.BufferedCanvas;
import org.eclipse.compare.internal.ChangeCompareFilterPropertyAction;
import org.eclipse.compare.internal.ChangePropertyAction;
import org.eclipse.compare.internal.CompareEditor;
import org.eclipse.compare.internal.CompareEditorSelectionProvider;
import org.eclipse.compare.internal.CompareFilterDescriptor;
import org.eclipse.compare.internal.CompareHandlerService;
import org.eclipse.compare.internal.CompareMessages;
import org.eclipse.compare.internal.CompareUIPlugin;
import org.eclipse.compare.internal.DocumentManager;
import org.eclipse.compare.internal.ICompareUIConstants;
import org.eclipse.compare.internal.IMergeViewerTestAdapter;
import org.eclipse.compare.internal.MergeSourceViewer;
import org.eclipse.compare.internal.MergeViewerContentProvider;
import org.eclipse.compare.internal.NavigationEndDialog;
import org.eclipse.compare.internal.OutlineViewerCreator;
import org.eclipse.compare.internal.ShowWhitespaceAction;
import org.eclipse.compare.internal.TextEditorPropertyAction;
import org.eclipse.compare.internal.Utilities;
import org.eclipse.compare.internal.merge.DocumentMerger;
import org.eclipse.compare.patch.IHunk;
import org.eclipse.compare.structuremergeviewer.DiffNode;
import org.eclipse.compare.structuremergeviewer.DocumentRangeNode;
import org.eclipse.compare.structuremergeviewer.ICompareInput;
import org.eclipse.compare.structuremergeviewer.IDiffContainer;
import org.eclipse.compare.structuremergeviewer.IDiffElement;
import org.eclipse.core.commands.operations.IOperationHistoryListener;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.commands.operations.OperationHistoryEvent;
import org.eclipse.core.commands.operations.OperationHistoryFactory;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.CursorLinePainter;
import org.eclipse.jface.text.DefaultPositionUpdater;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension3;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.IFindReplaceTarget;
import org.eclipse.jface.text.IFindReplaceTargetExtension;
import org.eclipse.jface.text.IFindReplaceTargetExtension3;
import org.eclipse.jface.text.IPositionUpdater;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.IRewriteTarget;
import org.eclipse.jface.text.ITextPresentationListener;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.IViewportListener;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.text.source.CompositeRuler;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.util.Util;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.custom.LineBackgroundEvent;
import org.eclipse.swt.custom.LineBackgroundListener;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IKeyBindingService;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.editors.text.IEncodingSupport;
import org.eclipse.ui.editors.text.IStorageDocumentProvider;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.ui.texteditor.ChainedPreferenceStore;
import org.eclipse.ui.texteditor.ChangeEncodingAction;
import org.eclipse.ui.texteditor.FindReplaceAction;
import org.eclipse.ui.texteditor.GotoLineAction;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.IDocumentProviderExtension;
import org.eclipse.ui.texteditor.IElementStateListener;
import org.eclipse.ui.texteditor.IFindReplaceTargetExtension2;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.SourceViewerDecorationSupport;

public class TextMergeViewer
extends ContentMergeViewer
implements IAdaptable {
    private static final String COPY_LEFT_TO_RIGHT_INDICATOR = ">";
    private static final String COPY_RIGHT_TO_LEFT_INDICATOR = "<";
    private static final char ANCESTOR_CONTRIBUTOR = 'A';
    private static final char RIGHT_CONTRIBUTOR = 'R';
    private static final char LEFT_CONTRIBUTOR = 'L';
    private static final String DIFF_RANGE_CATEGORY = "org.eclipse.compare.DIFF_RANGE_CATEGORY";
    static final boolean DEBUG = false;
    private static final boolean FIX_47640 = true;
    private static final String[] GLOBAL_ACTIONS = new String[]{ActionFactory.UNDO.getId(), ActionFactory.REDO.getId(), ActionFactory.CUT.getId(), ActionFactory.COPY.getId(), ActionFactory.PASTE.getId(), ActionFactory.DELETE.getId(), ActionFactory.SELECT_ALL.getId(), ActionFactory.FIND.getId(), "org.eclipse.ui.edit.text.goto.line"};
    private static final String[] TEXT_ACTIONS = new String[]{"undo", "redo", "cut", "copy", "paste", "delete", "selectAll", "find", "gotoLine"};
    private static final String BUNDLE_NAME = "org.eclipse.compare.contentmergeviewer.TextMergeViewerResources";
    private static final String INCOMING_COLOR = "INCOMING_COLOR";
    private static final String OUTGOING_COLOR = "OUTGOING_COLOR";
    private static final String CONFLICTING_COLOR = "CONFLICTING_COLOR";
    private static final String RESOLVED_COLOR = "RESOLVED_COLOR";
    private static final int MARGIN_WIDTH = 6;
    private static final int CENTER_WIDTH = 34;
    private static final int BIRDS_EYE_VIEW_WIDTH = 12;
    private static final int BIRDS_EYE_VIEW_INSET = 2;
    private static final int RESOLVE_SIZE = 5;
    private static final int LW = 1;
    private boolean fShowCurrentOnly = false;
    private boolean fShowCurrentOnly2 = false;
    private int fMarginWidth = 6;
    private int fTopInset;
    private RGB fBackground;
    private RGB fForeground;
    private boolean fIsUsingSystemForeground = true;
    private boolean fIsUsingSystemBackground = true;
    private RGB SELECTED_INCOMING;
    private RGB INCOMING;
    private RGB INCOMING_FILL;
    private RGB INCOMING_TEXT_FILL;
    private RGB SELECTED_CONFLICT;
    private RGB CONFLICT;
    private RGB CONFLICT_FILL;
    private RGB CONFLICT_TEXT_FILL;
    private RGB SELECTED_OUTGOING;
    private RGB OUTGOING;
    private RGB OUTGOING_FILL;
    private RGB OUTGOING_TEXT_FILL;
    private RGB RESOLVED;
    private IPreferenceStore fPreferenceStore;
    private IPropertyChangeListener fPreferenceChangeListener;
    private HashMap<Object, Position> fNewAncestorRanges = new HashMap();
    private HashMap<Object, Position> fNewLeftRanges = new HashMap();
    private HashMap<Object, Position> fNewRightRanges = new HashMap();
    private MergeSourceViewer fAncestor;
    private MergeSourceViewer fLeft;
    private MergeSourceViewer fRight;
    private int fLeftLineCount;
    private int fRightLineCount;
    private boolean fInScrolling;
    private int[] fPts = new int[8];
    private int fInheritedDirection;
    private int fTextDirection;
    private ActionContributionItem fIgnoreAncestorItem;
    private boolean fHighlightRanges;
    private boolean fShowPseudoConflicts = false;
    private boolean fUseSplines = true;
    private boolean fUseSingleLine = true;
    private boolean fHighlightTokenChanges = false;
    private String fSymbolicFontName;
    private ActionContributionItem fNextDiff;
    private ActionContributionItem fPreviousDiff;
    private ActionContributionItem fCopyDiffLeftToRightItem;
    private ActionContributionItem fCopyDiffRightToLeftItem;
    private CompareHandlerService fHandlerService;
    private boolean fSynchronizedScrolling = true;
    private MergeSourceViewer fFocusPart;
    private boolean fSubDoc = true;
    private IPositionUpdater fPositionUpdater;
    private boolean fIsMotif;
    private boolean fIsCarbon;
    private boolean fIsMac;
    private boolean fHasErrors;
    private BufferedCanvas fAncestorCanvas;
    private BufferedCanvas fLeftCanvas;
    private BufferedCanvas fRightCanvas;
    private Canvas fScrollCanvas;
    private ScrollBar fVScrollBar;
    private Canvas fBirdsEyeCanvas;
    private Canvas fSummaryHeader;
    private HeaderPainter fHeaderPainter;
    private Map<RGB, Color> fColors;
    private Cursor fBirdsEyeCursor;
    private double[] fBasicCenterCurve;
    private Button fLeftToRightButton;
    private Button fRightToLeftButton;
    private DocumentMerger.Diff fButtonDiff;
    private ContributorInfo fLeftContributor;
    private ContributorInfo fRightContributor;
    private ContributorInfo fAncestorContributor;
    private int isRefreshing = 0;
    private int fSynchronziedScrollPosition;
    private ActionContributionItem fNextChange;
    private ActionContributionItem fPreviousChange;
    private ShowWhitespaceAction showWhitespaceAction;
    private InternalOutlineViewerCreator fOutlineViewerCreator;
    private TextEditorPropertyAction toggleLineNumbersAction;
    private IFindReplaceTarget fFindReplaceTarget;
    private ChangePropertyAction fIgnoreWhitespace;
    private List<ChangeCompareFilterPropertyAction> fCompareFilterActions = new ArrayList<ChangeCompareFilterPropertyAction>();
    private DocumentMerger fMerger;
    private DocumentMerger.Diff fCurrentDiff;
    private DocumentMerger.Diff fSavedDiff;
    private boolean copyOperationInProgress = false;
    private IUndoableOperation copyUndoable = null;
    private IOperationHistoryListener operationHistoryListener;
    private static final String CURRENT_LINE = "currentLine";
    private static final String CURRENT_LINE_COLOR = "currentLineColor";
    private List<SourceViewerDecorationSupport> fSourceViewerDecorationSupport = new ArrayList<SourceViewerDecorationSupport>(3);
    private boolean isConfigured = false;
    private boolean fRedoDiff = false;

    public TextMergeViewer(Composite parent, CompareConfiguration configuration) {
        this(parent, 0, configuration);
    }

    public TextMergeViewer(Composite parent, int style, CompareConfiguration configuration) {
        super(style, ResourceBundle.getBundle(BUNDLE_NAME), configuration);
        this.operationHistoryListener = new IOperationHistoryListener(){

            public void historyNotification(OperationHistoryEvent event) {
                TextMergeViewer.this.historyNotification(event);
            }
        };
        OperationHistoryFactory.getOperationHistory().addOperationHistoryListener(this.operationHistoryListener);
        this.fMerger = new DocumentMerger(new DocumentMerger.IDocumentMergerInput(){

            @Override
            public ITokenComparator createTokenComparator(String line) {
                return TextMergeViewer.this.createTokenComparator(line);
            }

            @Override
            public CompareConfiguration getCompareConfiguration() {
                return TextMergeViewer.this.getCompareConfiguration();
            }

            @Override
            public IDocument getDocument(char contributor) {
                switch (contributor) {
                    case 'L': {
                        return TextMergeViewer.this.fLeft.getSourceViewer().getDocument();
                    }
                    case 'R': {
                        return TextMergeViewer.this.fRight.getSourceViewer().getDocument();
                    }
                    case 'A': {
                        return TextMergeViewer.this.fAncestor.getSourceViewer().getDocument();
                    }
                }
                return null;
            }

            @Override
            public int getHunkStart() {
                return TextMergeViewer.this.getHunkStart();
            }

            @Override
            public Position getRegion(char contributor) {
                switch (contributor) {
                    case 'L': {
                        return TextMergeViewer.this.fLeft.getRegion();
                    }
                    case 'R': {
                        return TextMergeViewer.this.fRight.getRegion();
                    }
                    case 'A': {
                        return TextMergeViewer.this.fAncestor.getRegion();
                    }
                }
                return null;
            }

            @Override
            public boolean isHunkOnLeft() {
                ITypedElement left = ((ICompareInput)TextMergeViewer.this.getInput()).getRight();
                return left != null && Adapters.adapt((Object)left, IHunk.class) != null;
            }

            @Override
            public boolean isIgnoreAncestor() {
                return TextMergeViewer.this.isIgnoreAncestor();
            }

            @Override
            public boolean isPatchHunk() {
                return TextMergeViewer.this.isPatchHunk();
            }

            @Override
            public boolean isShowPseudoConflicts() {
                return TextMergeViewer.this.fShowPseudoConflicts;
            }

            @Override
            public boolean isThreeWay() {
                return TextMergeViewer.this.isThreeWay();
            }

            @Override
            public boolean isPatchHunkOk() {
                return TextMergeViewer.this.isPatchHunkOk();
            }
        });
        int inheritedStyle = parent.getStyle();
        this.fInheritedDirection = (inheritedStyle & 0x2000000) != 0 ? 0x2000000 : ((inheritedStyle & 0x4000000) != 0 ? 0x4000000 : 0);
        this.fTextDirection = (style & 0x2000000) != 0 ? 0x2000000 : ((style & 0x4000000) != 0 ? 0x4000000 : 0);
        this.fSymbolicFontName = this.getSymbolicFontName();
        this.fIsMotif = Util.isMotif();
        this.fIsCarbon = Util.isCarbon();
        this.fIsMac = Util.isMac();
        if (this.fIsMotif) {
            this.fMarginWidth = 0;
        }
        this.fPreferenceChangeListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                TextMergeViewer.this.handlePropertyChangeEvent(event);
            }
        };
        this.fPreferenceStore = this.createChainedPreferenceStore();
        if (this.fPreferenceStore != null) {
            this.fPreferenceStore.addPropertyChangeListener(this.fPreferenceChangeListener);
            this.fSynchronizedScrolling = this.fPreferenceStore.getBoolean("org.eclipse.compare.SynchronizeScrolling");
            this.fShowPseudoConflicts = this.fPreferenceStore.getBoolean("org.eclipse.compare.ShowPseudoConflicts");
            this.fUseSingleLine = this.fPreferenceStore.getBoolean("org.eclipse.compare.UseSingleLine");
            this.fHighlightTokenChanges = this.fPreferenceStore.getBoolean("org.eclipse.compare.HighlightTokenChanges");
        }
        this.buildControl(parent);
        this.setColors();
        INavigatable nav = new INavigatable(){

            @Override
            public boolean selectChange(int flag) {
                if (flag == 3 || flag == 4) {
                    TextMergeViewer.this.selectFirstDiff(flag == 3);
                    return false;
                }
                return TextMergeViewer.this.navigate(flag == 1, false, false);
            }

            @Override
            public Object getInput() {
                return TextMergeViewer.this.getInput();
            }

            @Override
            public boolean openSelectedChange() {
                return false;
            }

            @Override
            public boolean hasChange(int flag) {
                return TextMergeViewer.this.getNextVisibleDiff(flag == 1, false) != null;
            }
        };
        this.fComposite.setData("org.eclipse.compare.internal.Navigator", (Object)nav);
        this.fBirdsEyeCursor = new Cursor((Device)parent.getDisplay(), 21);
        JFaceResources.getFontRegistry().addListener(this.fPreferenceChangeListener);
        JFaceResources.getColorRegistry().addListener(this.fPreferenceChangeListener);
        this.updateFont();
    }

    private ChainedPreferenceStore createChainedPreferenceStore() {
        ArrayList<IPreferenceStore> stores = new ArrayList<IPreferenceStore>(2);
        stores.add(this.getCompareConfiguration().getPreferenceStore());
        stores.add(EditorsUI.getPreferenceStore());
        return new ChainedPreferenceStore(stores.toArray(new IPreferenceStore[stores.size()]));
    }

    private static RGB createColor(IPreferenceStore store, String key) {
        if (!store.contains(key)) {
            return null;
        }
        if (store.isDefault(key)) {
            return PreferenceConverter.getDefaultColor((IPreferenceStore)store, (String)key);
        }
        return PreferenceConverter.getColor((IPreferenceStore)store, (String)key);
    }

    private void setColors() {
        this.fIsUsingSystemBackground = this.fPreferenceStore.getBoolean("AbstractTextEditor.Color.Background.SystemDefault");
        if (!this.fIsUsingSystemBackground) {
            this.fBackground = TextMergeViewer.createColor(this.fPreferenceStore, "AbstractTextEditor.Color.Background");
        }
        this.fIsUsingSystemForeground = this.fPreferenceStore.getBoolean("AbstractTextEditor.Color.Foreground.SystemDefault");
        if (!this.fIsUsingSystemForeground) {
            this.fForeground = TextMergeViewer.createColor(this.fPreferenceStore, "AbstractTextEditor.Color.Foreground");
        }
        this.updateColors(null);
    }

    private String getSymbolicFontName() {
        Class<?> clazz = this.getClass();
        do {
            String fontName = clazz.getName();
            if (!JFaceResources.getFontRegistry().hasValueFor(fontName)) continue;
            return fontName;
        } while ((clazz = clazz.getSuperclass()) != null);
        return this.getClass().getName();
    }

    private void updateFont() {
        Font f = JFaceResources.getFont((String)this.fSymbolicFontName);
        if (f != null) {
            if (this.fAncestor != null) {
                this.fAncestor.setFont(f);
            }
            if (this.fLeft != null) {
                this.fLeft.setFont(f);
            }
            if (this.fRight != null) {
                this.fRight.setFont(f);
            }
        }
    }

    private void checkForColorUpdate(Display display) {
        RGB bg;
        if (this.fIsUsingSystemBackground && !(bg = display.getSystemColor(25).getRGB()).equals((Object)this.getBackground(display))) {
            this.updateColors(display);
        }
    }

    public void setBackgroundColor(RGB background) {
        this.fIsUsingSystemBackground = background == null;
        this.fBackground = background;
        this.updateColors(null);
    }

    private RGB getBackground(Display display) {
        if (this.fBackground != null) {
            return this.fBackground;
        }
        if (display == null) {
            display = this.fComposite.getDisplay();
        }
        return display.getSystemColor(25).getRGB();
    }

    public void setForegroundColor(RGB foreground) {
        this.fIsUsingSystemForeground = foreground == null;
        this.fForeground = foreground;
        this.updateColors(null);
    }

    private void updateColors(Display display) {
        if (display == null) {
            display = this.fComposite.getDisplay();
        }
        Color bgColor = null;
        if (this.fBackground != null) {
            bgColor = this.getColor(display, this.fBackground);
        }
        if (this.fAncestor != null) {
            this.fAncestor.setBackgroundColor(bgColor);
        }
        if (this.fLeft != null) {
            this.fLeft.setBackgroundColor(bgColor);
        }
        if (this.fRight != null) {
            this.fRight.setBackgroundColor(bgColor);
        }
        Color fgColor = null;
        if (this.fForeground != null) {
            fgColor = this.getColor(display, this.fForeground);
        }
        if (this.fAncestor != null) {
            this.fAncestor.setForegroundColor(fgColor);
        }
        if (this.fLeft != null) {
            this.fLeft.setForegroundColor(fgColor);
        }
        if (this.fRight != null) {
            this.fRight.setForegroundColor(fgColor);
        }
        ColorRegistry registry = JFaceResources.getColorRegistry();
        RGB bg = this.getBackground(display);
        this.SELECTED_INCOMING = registry.getRGB(INCOMING_COLOR);
        if (this.SELECTED_INCOMING == null) {
            this.SELECTED_INCOMING = new RGB(0, 0, 255);
        }
        this.INCOMING = TextMergeViewer.interpolate(this.SELECTED_INCOMING, bg, 0.6);
        this.INCOMING_FILL = TextMergeViewer.interpolate(this.SELECTED_INCOMING, bg, 0.97);
        this.INCOMING_TEXT_FILL = TextMergeViewer.interpolate(this.SELECTED_INCOMING, bg, 0.85);
        this.SELECTED_OUTGOING = registry.getRGB(OUTGOING_COLOR);
        if (this.SELECTED_OUTGOING == null) {
            this.SELECTED_OUTGOING = new RGB(0, 0, 0);
        }
        this.OUTGOING = TextMergeViewer.interpolate(this.SELECTED_OUTGOING, bg, 0.6);
        this.OUTGOING_FILL = TextMergeViewer.interpolate(this.SELECTED_OUTGOING, bg, 0.97);
        this.OUTGOING_TEXT_FILL = TextMergeViewer.interpolate(this.SELECTED_OUTGOING, bg, 0.85);
        this.SELECTED_CONFLICT = registry.getRGB(CONFLICTING_COLOR);
        if (this.SELECTED_CONFLICT == null) {
            this.SELECTED_CONFLICT = new RGB(255, 0, 0);
        }
        this.CONFLICT = TextMergeViewer.interpolate(this.SELECTED_CONFLICT, bg, 0.6);
        this.CONFLICT_FILL = TextMergeViewer.interpolate(this.SELECTED_CONFLICT, bg, 0.97);
        this.CONFLICT_TEXT_FILL = TextMergeViewer.interpolate(this.SELECTED_CONFLICT, bg, 0.85);
        this.RESOLVED = registry.getRGB(RESOLVED_COLOR);
        if (this.RESOLVED == null) {
            this.RESOLVED = new RGB(0, 255, 0);
        }
        this.updatePresentation();
    }

    private void updatePresentation() {
        this.refreshBirdsEyeView();
        this.invalidateLines();
        this.invalidateTextPresentation();
    }

    public void invalidateTextPresentation() {
        if (this.fAncestor != null) {
            this.fAncestor.getSourceViewer().invalidateTextPresentation();
        }
        if (this.fLeft != null) {
            this.fLeft.getSourceViewer().invalidateTextPresentation();
        }
        if (this.fRight != null) {
            this.fRight.getSourceViewer().invalidateTextPresentation();
        }
    }

    protected void configureTextViewer(TextViewer textViewer) {
        if (textViewer instanceof ISourceViewer) {
            SourceViewerConfiguration configuration = new SourceViewerConfiguration();
            ((ISourceViewer)textViewer).configure(configuration);
        }
    }

    protected ITokenComparator createTokenComparator(String line) {
        return new TokenComparator(line);
    }

    protected void setupDocument(IDocument document) {
        String partitioning = this.getDocumentPartitioning();
        if (partitioning == null || !(document instanceof IDocumentExtension3)) {
            IDocumentPartitioner partitioner;
            if (document.getDocumentPartitioner() == null && (partitioner = this.getDocumentPartitioner()) != null) {
                document.setDocumentPartitioner(partitioner);
                partitioner.connect(document);
            }
        } else {
            IDocumentPartitioner partitioner;
            IDocumentExtension3 ex3 = (IDocumentExtension3)document;
            if (ex3.getDocumentPartitioner(partitioning) == null && (partitioner = this.getDocumentPartitioner()) != null) {
                ex3.setDocumentPartitioner(partitioning, partitioner);
                partitioner.connect(document);
            }
        }
    }

    protected IDocumentPartitioner getDocumentPartitioner() {
        return null;
    }

    protected String getDocumentPartitioning() {
        return null;
    }

    @Override
    protected void handleDispose(DisposeEvent event) {
        OperationHistoryFactory.getOperationHistory().removeOperationHistoryListener(this.operationHistoryListener);
        if (this.fHandlerService != null) {
            this.fHandlerService.dispose();
        }
        Object input = this.getInput();
        this.removeFromDocumentManager('A', input);
        this.removeFromDocumentManager('L', input);
        this.removeFromDocumentManager('R', input);
        if (this.fPreferenceChangeListener != null) {
            JFaceResources.getFontRegistry().removeListener(this.fPreferenceChangeListener);
            JFaceResources.getColorRegistry().removeListener(this.fPreferenceChangeListener);
            if (this.fPreferenceStore != null) {
                this.fPreferenceStore.removePropertyChangeListener(this.fPreferenceChangeListener);
            }
            this.fPreferenceChangeListener = null;
        }
        this.fLeftCanvas = null;
        this.fRightCanvas = null;
        this.fVScrollBar = null;
        this.fBirdsEyeCanvas = null;
        this.fSummaryHeader = null;
        this.fAncestorContributor.unsetDocument(this.fAncestor);
        this.fLeftContributor.unsetDocument(this.fLeft);
        this.fRightContributor.unsetDocument(this.fRight);
        this.disconnect(this.fLeftContributor);
        this.disconnect(this.fRightContributor);
        this.disconnect(this.fAncestorContributor);
        if (this.fBirdsEyeCursor != null) {
            this.fBirdsEyeCursor.dispose();
            this.fBirdsEyeCursor = null;
        }
        if (this.showWhitespaceAction != null) {
            this.showWhitespaceAction.dispose();
        }
        if (this.toggleLineNumbersAction != null) {
            this.toggleLineNumbersAction.dispose();
        }
        if (this.fIgnoreWhitespace != null) {
            this.fIgnoreWhitespace.dispose();
        }
        this.getCompareConfiguration().setProperty("COMPARE_FILTERS_INITIALIZING", Boolean.TRUE);
        this.disposeCompareFilterActions(false);
        if (this.fSourceViewerDecorationSupport != null) {
            Iterator<SourceViewerDecorationSupport> iterator = this.fSourceViewerDecorationSupport.iterator();
            while (iterator.hasNext()) {
                iterator.next().dispose();
            }
            this.fSourceViewerDecorationSupport = null;
        }
        if (this.fAncestor != null) {
            this.fAncestor.dispose();
        }
        this.fAncestor = null;
        if (this.fLeft != null) {
            this.fLeft.dispose();
        }
        this.fLeft = null;
        if (this.fRight != null) {
            this.fRight.dispose();
        }
        this.fRight = null;
        if (this.fColors != null) {
            for (Color color : this.fColors.values()) {
                if (color.isDisposed()) continue;
                color.dispose();
            }
            this.fColors = null;
        }
        super.handleDispose(event);
    }

    private void disconnect(ContributorInfo legInfo) {
        if (legInfo != null) {
            legInfo.disconnect();
        }
    }

    @Override
    protected void createControls(Composite composite) {
        IContextService service;
        ISelectionProvider selectionProvider;
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.eclipse.compare.text_merge_view_context");
        if (this.fMarginWidth > 0) {
            this.fAncestorCanvas = new BufferedCanvas(composite, 0){

                @Override
                public void doPaint(GC gc) {
                    TextMergeViewer.this.paintSides(gc, TextMergeViewer.this.fAncestor, TextMergeViewer.this.fAncestorCanvas, false);
                }
            };
            this.fAncestorCanvas.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseDown(MouseEvent e) {
                    TextMergeViewer.this.setCurrentDiff2(TextMergeViewer.this.handleMouseInSides(TextMergeViewer.this.fAncestorCanvas, TextMergeViewer.this.fAncestor, e.y), false);
                }
            });
        }
        this.fAncestor = this.createPart(composite);
        this.setEditable((ISourceViewer)this.fAncestor.getSourceViewer(), false);
        this.fAncestor.getSourceViewer().getTextWidget().getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = NLS.bind((String)CompareMessages.TextMergeViewer_accessible_ancestor, (Object)TextMergeViewer.this.getCompareConfiguration().getAncestorLabel(TextMergeViewer.this.getInput()));
            }
        });
        this.fAncestor.getSourceViewer().addTextPresentationListener((ITextPresentationListener)new ChangeHighlighter(this.fAncestor));
        this.fSummaryHeader = new Canvas(composite, 0);
        this.fHeaderPainter = new HeaderPainter();
        this.fSummaryHeader.addPaintListener((PaintListener)this.fHeaderPainter);
        this.updateResolveStatus();
        if (this.fMarginWidth > 0) {
            this.fLeftCanvas = new BufferedCanvas(composite, 0){

                @Override
                public void doPaint(GC gc) {
                    TextMergeViewer.this.paintSides(gc, TextMergeViewer.this.fLeft, TextMergeViewer.this.fLeftCanvas, false);
                }
            };
            this.fLeftCanvas.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseDown(MouseEvent e) {
                    TextMergeViewer.this.setCurrentDiff2(TextMergeViewer.this.handleMouseInSides(TextMergeViewer.this.fLeftCanvas, TextMergeViewer.this.fLeft, e.y), false);
                }
            });
        }
        this.fLeft = this.createPart(composite);
        this.fLeft.getSourceViewer().getTextWidget().getVerticalBar().setVisible(!this.fSynchronizedScrolling);
        this.fLeft.getSourceViewer().getTextWidget().getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = NLS.bind((String)CompareMessages.TextMergeViewer_accessible_left, (Object)TextMergeViewer.this.getCompareConfiguration().getLeftLabel(TextMergeViewer.this.getInput()));
            }
        });
        this.fLeft.getSourceViewer().addTextPresentationListener((ITextPresentationListener)new ChangeHighlighter(this.fLeft));
        this.fRight = this.createPart(composite);
        this.fRight.getSourceViewer().getTextWidget().getVerticalBar().setVisible(!this.fSynchronizedScrolling);
        this.fRight.getSourceViewer().getTextWidget().getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = NLS.bind((String)CompareMessages.TextMergeViewer_accessible_right, (Object)TextMergeViewer.this.getCompareConfiguration().getRightLabel(TextMergeViewer.this.getInput()));
            }
        });
        this.fRight.getSourceViewer().addTextPresentationListener((ITextPresentationListener)new ChangeHighlighter(this.fRight));
        IWorkbenchPart part = this.getCompareConfiguration().getContainer().getWorkbenchPart();
        if (part != null && (selectionProvider = part.getSite().getSelectionProvider()) instanceof CompareEditorSelectionProvider) {
            CompareEditorSelectionProvider cesp = (CompareEditorSelectionProvider)selectionProvider;
            SourceViewer focusSourceViewer = this.fFocusPart == null ? null : this.fFocusPart.getSourceViewer();
            cesp.setViewers((TextViewer[])new SourceViewer[]{this.fLeft.getSourceViewer(), this.fRight.getSourceViewer(), this.fAncestor.getSourceViewer()}, (TextViewer)focusSourceViewer);
        }
        this.hsynchViewport((TextViewer)this.fAncestor.getSourceViewer(), (TextViewer)this.fLeft.getSourceViewer(), (TextViewer)this.fRight.getSourceViewer());
        this.hsynchViewport((TextViewer)this.fLeft.getSourceViewer(), (TextViewer)this.fAncestor.getSourceViewer(), (TextViewer)this.fRight.getSourceViewer());
        this.hsynchViewport((TextViewer)this.fRight.getSourceViewer(), (TextViewer)this.fAncestor.getSourceViewer(), (TextViewer)this.fLeft.getSourceViewer());
        if (this.fMarginWidth > 0) {
            this.fRightCanvas = new BufferedCanvas(composite, 0){

                @Override
                public void doPaint(GC gc) {
                    TextMergeViewer.this.paintSides(gc, TextMergeViewer.this.fRight, TextMergeViewer.this.fRightCanvas, TextMergeViewer.this.fSynchronizedScrolling);
                }
            };
            this.fRightCanvas.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseDown(MouseEvent e) {
                    TextMergeViewer.this.setCurrentDiff2(TextMergeViewer.this.handleMouseInSides(TextMergeViewer.this.fRightCanvas, TextMergeViewer.this.fRight, e.y), false);
                }
            });
        }
        this.fScrollCanvas = new Canvas(composite, 512);
        Rectangle trim = this.fLeft.getSourceViewer().getTextWidget().computeTrim(0, 0, 0, 0);
        this.fTopInset = trim.y;
        this.fVScrollBar = this.fScrollCanvas.getVerticalBar();
        this.fVScrollBar.setIncrement(1);
        this.fVScrollBar.setVisible(true);
        this.fVScrollBar.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                int vpos = ((ScrollBar)e.widget).getSelection();
                TextMergeViewer.this.synchronizedScrollVertical(vpos);
            }
        });
        this.fBirdsEyeCanvas = new BufferedCanvas(composite, 0){

            @Override
            public void doPaint(GC gc) {
                TextMergeViewer.this.paintBirdsEyeView(this, gc);
            }
        };
        this.fBirdsEyeCanvas.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                TextMergeViewer.this.setCurrentDiff2(TextMergeViewer.this.handlemouseInBirdsEyeView(TextMergeViewer.this.fBirdsEyeCanvas, e.y), true);
            }
        });
        this.fBirdsEyeCanvas.addMouseMoveListener(new MouseMoveListener(){
            private Cursor fLastCursor;

            public void mouseMove(MouseEvent e) {
                Cursor cursor = null;
                DocumentMerger.Diff diff = TextMergeViewer.this.handlemouseInBirdsEyeView(TextMergeViewer.this.fBirdsEyeCanvas, e.y);
                if (diff != null && diff.getKind() != 0) {
                    cursor = TextMergeViewer.this.fBirdsEyeCursor;
                }
                if (this.fLastCursor != cursor) {
                    TextMergeViewer.this.fBirdsEyeCanvas.setCursor(cursor);
                    this.fLastCursor = cursor;
                }
            }
        });
        IWorkbenchPart workbenchPart = this.getCompareConfiguration().getContainer().getWorkbenchPart();
        if (workbenchPart != null && (service = (IContextService)workbenchPart.getSite().getService(IContextService.class)) != null) {
            service.activateContext("org.eclipse.ui.textEditorScope");
        }
    }

    private void hsynchViewport(TextViewer tv1, TextViewer tv2, TextViewer tv3) {
        StyledText st1 = tv1.getTextWidget();
        final StyledText st2 = tv2.getTextWidget();
        final StyledText st3 = tv3.getTextWidget();
        final ScrollBar sb1 = st1.getHorizontalBar();
        sb1.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (TextMergeViewer.this.fSynchronizedScrolling) {
                    int v = sb1.getSelection();
                    if (st2.isVisible()) {
                        st2.setHorizontalPixel(v);
                    }
                    if (st3.isVisible()) {
                        st3.setHorizontalPixel(v);
                    }
                }
            }
        });
    }

    private void setCurrentDiff2(DocumentMerger.Diff diff, boolean reveal) {
        if (diff != null && diff.getKind() != 0) {
            this.setCurrentDiff(diff, reveal);
        }
    }

    private DocumentMerger.Diff handleMouseInSides(Canvas canvas, MergeSourceViewer tp, int my) {
        int lineHeight = tp.getSourceViewer().getTextWidget().getLineHeight();
        int visibleHeight = tp.getViewportHeight();
        if (!this.fHighlightRanges) {
            return null;
        }
        if (this.fMerger.hasChanges()) {
            int shift = tp.getVerticalScrollOffset() + 1;
            Point region = new Point(0, 0);
            char leg = this.getLeg(tp);
            Iterator iterator = this.fMerger.changesIterator();
            while (iterator.hasNext()) {
                DocumentMerger.Diff diff = (DocumentMerger.Diff)iterator.next();
                if (diff.isDeleted() || this.fShowCurrentOnly2 && !this.isCurrentDiff(diff)) continue;
                tp.getLineRange(diff.getPosition(leg), region);
                int y = region.x * lineHeight + shift;
                int h = region.y * lineHeight;
                if (y + h < 0) continue;
                if (y >= visibleHeight) break;
                if (my < y || my >= y + h) continue;
                return diff;
            }
        }
        return null;
    }

    private DocumentMerger.Diff getDiffUnderMouse(Canvas canvas, int mx, int my, Rectangle r) {
        if (!this.fSynchronizedScrolling) {
            return null;
        }
        int lineHeight = this.fLeft.getSourceViewer().getTextWidget().getLineHeight();
        int visibleHeight = this.fRight.getViewportHeight();
        Point size = canvas.getSize();
        int w = size.x;
        if (!this.fHighlightRanges) {
            return null;
        }
        if (this.fMerger.hasChanges()) {
            int lshift = this.fLeft.getVerticalScrollOffset();
            int rshift = this.fRight.getVerticalScrollOffset();
            Point region = new Point(0, 0);
            Iterator iterator = this.fMerger.changesIterator();
            while (iterator.hasNext()) {
                DocumentMerger.Diff diff = (DocumentMerger.Diff)iterator.next();
                if (diff.isDeleted() || this.fShowCurrentOnly2 && !this.isCurrentDiff(diff)) continue;
                this.fLeft.getLineRange(diff.getPosition('L'), region);
                int ly = region.x * lineHeight + lshift;
                int lh = region.y * lineHeight;
                this.fRight.getLineRange(diff.getPosition('R'), region);
                int ry = region.x * lineHeight + rshift;
                int rh = region.y * lineHeight;
                if (Math.max(ly + lh, ry + rh) < 0) continue;
                if (Math.min(ly, ry) >= visibleHeight) break;
                int SIZE = this.fIsCarbon ? 30 : 20;
                int cx = (w - SIZE) / 2;
                int cy = (ly + lh / 2 + (ry + rh / 2) - SIZE) / 2;
                if (my < cy || my >= cy + SIZE || mx < cx || mx >= cx + SIZE) continue;
                if (r != null) {
                    r.x = cx;
                    r.y = cy;
                    r.width = SIZE;
                    r.height = SIZE;
                }
                return diff;
            }
        }
        return null;
    }

    private DocumentMerger.Diff handlemouseInBirdsEyeView(Canvas canvas, int my) {
        return this.fMerger.findDiff(this.getViewportHeight(), this.fSynchronizedScrolling, canvas.getSize(), my);
    }

    private void paintBirdsEyeView(Canvas canvas, GC gc) {
        int virtualHeight;
        Rectangle r = new Rectangle(0, 0, 0, 0);
        Point size = canvas.getSize();
        int n = virtualHeight = this.fSynchronizedScrolling ? this.fMerger.getVirtualHeight() : this.fMerger.getRightHeight();
        if (virtualHeight < this.getViewportHeight()) {
            return;
        }
        Display display = canvas.getDisplay();
        int y = 0;
        Iterator iterator = this.fMerger.rangesIterator();
        while (iterator.hasNext()) {
            int h;
            DocumentMerger.Diff diff = (DocumentMerger.Diff)iterator.next();
            int n2 = h = this.fSynchronizedScrolling ? diff.getMaxDiffHeight() : diff.getRightHeight();
            if (this.fMerger.useChange(diff)) {
                Color c;
                int yy = y * size.y / virtualHeight;
                int hh = h * size.y / virtualHeight;
                if (hh < 3) {
                    hh = 3;
                }
                if ((c = this.getColor(display, this.getFillColor(diff))) != null) {
                    gc.setBackground(c);
                    gc.fillRectangle(2, yy, size.x - 4, hh);
                }
                if ((c = this.getColor(display, this.getStrokeColor(diff))) != null) {
                    gc.setForeground(c);
                    r.x = 2;
                    r.y = yy;
                    r.width = size.x - 4 - 1;
                    r.height = hh;
                    if (this.isCurrentDiff(diff)) {
                        gc.setLineWidth(2);
                        ++r.x;
                        ++r.y;
                        --r.width;
                        --r.height;
                    } else {
                        gc.setLineWidth(0);
                    }
                    gc.drawRectangle(r);
                }
            }
            y += h;
        }
    }

    private void refreshBirdsEyeView() {
        if (this.fBirdsEyeCanvas != null) {
            this.fBirdsEyeCanvas.redraw();
        }
    }

    @Override
    protected boolean handleSetFocus() {
        StyledText st;
        if (this.fRedoDiff) {
            new UIJob(CompareMessages.DocumentMerger_0){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    TextMergeViewer.this.update(true);
                    TextMergeViewer.this.updateStructure();
                    return Status.OK_STATUS;
                }
            }.schedule();
            this.fRedoDiff = false;
        }
        if (this.fFocusPart == null) {
            if (this.fLeft != null && this.fLeft.getEnabled()) {
                this.fFocusPart = this.fLeft;
            } else if (this.fRight != null && this.fRight.getEnabled()) {
                this.fFocusPart = this.fRight;
            } else if (this.fAncestor != null && this.fAncestor.getEnabled()) {
                this.fFocusPart = this.fAncestor;
            }
        }
        if (this.fFocusPart != null && (st = this.fFocusPart.getSourceViewer().getTextWidget()) != null) {
            return st.setFocus();
        }
        return false;
    }

    @Override
    protected final Control createCenterControl(Composite parent) {
        if (this.fSynchronizedScrolling) {
            BufferedCanvas canvas = new BufferedCanvas(parent, 0){

                @Override
                public void doPaint(GC gc) {
                    TextMergeViewer.this.paintCenter(this, gc);
                }
            };
            new HoverResizer(canvas, 1);
            if (this.fNormalCursor == null) {
                this.fNormalCursor = new Cursor((Device)canvas.getDisplay(), 0);
            }
            int style = this.fIsMac ? 0x800000 : 8;
            this.fLeftToRightButton = new Button((Composite)canvas, style);
            this.fLeftToRightButton.setCursor(this.fNormalCursor);
            this.fLeftToRightButton.setText(COPY_LEFT_TO_RIGHT_INDICATOR);
            this.fLeftToRightButton.setToolTipText(Utilities.getString(this.getResourceBundle(), "action.CopyDiffLeftToRight.tooltip"));
            this.fLeftToRightButton.pack();
            this.fLeftToRightButton.setVisible(false);
            this.fLeftToRightButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    TextMergeViewer.this.handleCenterButtonSelection(true);
                }
            });
            this.fRightToLeftButton = new Button((Composite)canvas, style);
            this.fRightToLeftButton.setCursor(this.fNormalCursor);
            this.fRightToLeftButton.setText(COPY_RIGHT_TO_LEFT_INDICATOR);
            this.fRightToLeftButton.setToolTipText(Utilities.getString(this.getResourceBundle(), "action.CopyDiffRightToLeft.tooltip"));
            this.fRightToLeftButton.pack();
            this.fRightToLeftButton.setVisible(false);
            this.fRightToLeftButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    TextMergeViewer.this.handleCenterButtonSelection(false);
                }
            });
            return canvas;
        }
        return super.createCenterControl(parent);
    }

    private void handleCenterButtonSelection(boolean leftToRight) {
        this.fLeftToRightButton.setVisible(false);
        this.fRightToLeftButton.setVisible(false);
        if (this.fButtonDiff != null) {
            this.setCurrentDiff(this.fButtonDiff, false);
            this.copy(this.fCurrentDiff, leftToRight, false);
        }
    }

    private boolean handleMouseMoveOverCenter(Canvas canvas, int x, int y) {
        Rectangle r = new Rectangle(0, 0, 0, 0);
        DocumentMerger.Diff diff = this.getDiffUnderMouse(canvas, x, y, r);
        if (diff != this.fButtonDiff) {
            if (diff != null) {
                this.fButtonDiff = diff;
                boolean leftEditable = this.fLeft.getSourceViewer().isEditable();
                boolean rightEditable = this.fRight.getSourceViewer().isEditable();
                if (leftEditable && rightEditable) {
                    int height = r.height;
                    int leftToRightY = r.y - height / 2;
                    int rightToLeftY = leftToRightY + height;
                    Rectangle bounds = canvas.getBounds();
                    if (leftToRightY < 0) {
                        leftToRightY = 0;
                        rightToLeftY = height;
                    } else if (rightToLeftY + height > bounds.height) {
                        leftToRightY = bounds.height - height - height;
                        rightToLeftY = leftToRightY + height;
                    }
                    Rectangle leftToRightBounds = new Rectangle(r.x, leftToRightY, r.width, r.height);
                    this.fLeftToRightButton.setBounds(leftToRightBounds);
                    this.fLeftToRightButton.setVisible(true);
                    Rectangle rightToLeftBounds = new Rectangle(r.x, rightToLeftY, r.width, r.height);
                    this.fRightToLeftButton.setBounds(rightToLeftBounds);
                    this.fRightToLeftButton.setVisible(true);
                } else if (leftEditable) {
                    this.fRightToLeftButton.setBounds(r);
                    this.fRightToLeftButton.setVisible(true);
                    this.fLeftToRightButton.setVisible(false);
                } else if (rightEditable) {
                    this.fLeftToRightButton.setBounds(r);
                    this.fLeftToRightButton.setVisible(true);
                    this.fRightToLeftButton.setVisible(false);
                } else {
                    this.fButtonDiff = null;
                }
            } else {
                this.fRightToLeftButton.setVisible(false);
                this.fLeftToRightButton.setVisible(false);
                this.fButtonDiff = null;
            }
        }
        return this.fButtonDiff != null;
    }

    @Override
    protected final int getCenterWidth() {
        if (this.fSynchronizedScrolling) {
            return 34;
        }
        return super.getCenterWidth();
    }

    private int getDirection() {
        switch (this.fTextDirection) {
            case 0x2000000: 
            case 0x4000000: {
                if (this.fInheritedDirection == this.fTextDirection) {
                    return 0;
                }
                return this.fTextDirection;
            }
        }
        return this.fInheritedDirection;
    }

    protected SourceViewer createSourceViewer(Composite parent, int textOrientation) {
        return new SourceViewer(parent, (IVerticalRuler)new CompositeRuler(), textOrientation | 0x100 | 0x200);
    }

    protected boolean isEditorBacked(ITextViewer textViewer) {
        return false;
    }

    protected IEditorInput getEditorInput(ISourceViewer sourceViewer) {
        if (this.fLeft != null && sourceViewer == this.fLeft.getSourceViewer() && this.fLeftContributor != null) {
            return this.fLeftContributor.getDocumentKey();
        }
        if (this.fRight != null && sourceViewer == this.fRight.getSourceViewer() && this.fRightContributor != null) {
            return this.fRightContributor.getDocumentKey();
        }
        if (this.fAncestor != null && sourceViewer == this.fAncestor.getSourceViewer() && this.fAncestorContributor != null) {
            return this.fAncestorContributor.getDocumentKey();
        }
        return null;
    }

    private MergeSourceViewer createPart(Composite parent) {
        final MergeSourceViewer viewer = new MergeSourceViewer(this.createSourceViewer(parent, this.getDirection()), this.getResourceBundle(), this.getCompareConfiguration().getContainer());
        StyledText te = viewer.getSourceViewer().getTextWidget();
        if (!this.fConfirmSave) {
            viewer.hideSaveAction();
        }
        te.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                TextMergeViewer.this.paint(e, viewer);
            }
        });
        te.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                TextMergeViewer.this.handleSelectionChanged(viewer);
            }
        });
        te.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                TextMergeViewer.this.handleSelectionChanged(viewer);
            }
        });
        te.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent fe) {
                TextMergeViewer.this.setActiveViewer(viewer, true);
            }

            public void focusLost(FocusEvent fe) {
                TextMergeViewer.this.setActiveViewer(viewer, false);
            }
        });
        viewer.getSourceViewer().addViewportListener(new IViewportListener(){

            public void viewportChanged(int verticalPosition) {
                TextMergeViewer.this.syncViewport(viewer);
            }
        });
        Font font = JFaceResources.getFont((String)this.fSymbolicFontName);
        if (font != null) {
            te.setFont(font);
        }
        if (this.fBackground != null) {
            te.setBackground(this.getColor(parent.getDisplay(), this.fBackground));
        }
        this.contributeFindAction(viewer);
        this.contributeGotoLineAction(viewer);
        this.contributeChangeEncodingAction(viewer);
        this.contributeDiffBackgroundListener(viewer);
        return viewer;
    }

    private void setActiveViewer(MergeSourceViewer viewer, boolean activate) {
        this.connectContributedActions(viewer, activate);
        if (activate) {
            this.fFocusPart = viewer;
            this.connectGlobalActions(this.fFocusPart);
        } else {
            this.connectGlobalActions(null);
        }
    }

    private SourceViewerDecorationSupport getSourceViewerDecorationSupport(ISourceViewer viewer) {
        SourceViewerDecorationSupport support = new SourceViewerDecorationSupport(viewer, null, null, EditorsUI.getSharedTextColors());
        support.setCursorLinePainterPreferenceKeys(CURRENT_LINE, CURRENT_LINE_COLOR);
        this.fSourceViewerDecorationSupport.add(support);
        return support;
    }

    private void contributeFindAction(MergeSourceViewer viewer) {
        IWorkbenchPart wp = this.getCompareConfiguration().getContainer().getWorkbenchPart();
        FindReplaceAction action = wp != null ? new FindReplaceAction(this.getResourceBundle(), "Editor.FindReplace.", wp) : new FindReplaceAction(this.getResourceBundle(), "Editor.FindReplace.", viewer.getSourceViewer().getControl().getShell(), this.getFindReplaceTarget());
        action.setActionDefinitionId("org.eclipse.ui.edit.findReplace");
        viewer.addAction("find", (IAction)action);
    }

    private void contributeGotoLineAction(MergeSourceViewer viewer) {
        GotoLineAction action = new GotoLineAction((ITextEditor)viewer.getAdapter(ITextEditor.class));
        action.setActionDefinitionId("org.eclipse.ui.edit.text.goto.line");
        viewer.addAction("gotoLine", (IAction)action);
    }

    private void contributeChangeEncodingAction(MergeSourceViewer viewer) {
        ChangeEncodingAction action = new ChangeEncodingAction(this.getTextEditorAdapter());
        viewer.addAction("changeEncoding", (IAction)action);
    }

    private void contributeDiffBackgroundListener(final MergeSourceViewer viewer) {
        viewer.getSourceViewer().getTextWidget().addLineBackgroundListener(new LineBackgroundListener(){

            public void lineGetBackground(LineBackgroundEvent event) {
                StyledText textWidget = viewer.getSourceViewer().getTextWidget();
                if (textWidget != null) {
                    DocumentMerger.Diff diff;
                    int caret = textWidget.getCaretOffset();
                    int length = event.lineText.length();
                    if ((event.lineOffset > caret || caret > event.lineOffset + length) && (diff = TextMergeViewer.this.findDiff(viewer, event.lineOffset, event.lineOffset + length)) != null && TextMergeViewer.this.updateDiffBackground(diff)) {
                        event.lineBackground = TextMergeViewer.this.getColor(TextMergeViewer.this.fComposite.getDisplay(), TextMergeViewer.this.getFillColor(diff));
                    }
                }
            }
        });
    }

    private void connectGlobalActions(final MergeSourceViewer part) {
        if (this.fHandlerService != null) {
            if (part != null) {
                part.updateActions();
            }
            this.fHandlerService.updatePaneActionHandlers(new Runnable(){

                @Override
                public void run() {
                    int i = 0;
                    while (i < GLOBAL_ACTIONS.length) {
                        IAction action = null;
                        if (part != null) {
                            action = part.getAction(TEXT_ACTIONS[i]);
                        }
                        TextMergeViewer.this.fHandlerService.setGlobalActionHandler(GLOBAL_ACTIONS[i], action);
                        ++i;
                    }
                }
            });
        }
    }

    private void connectContributedActions(final MergeSourceViewer viewer, final boolean connect) {
        if (this.fHandlerService != null) {
            this.fHandlerService.updatePaneActionHandlers(new Runnable(){

                @Override
                public void run() {
                    if (viewer != null) {
                        IWorkbenchPart part;
                        TextMergeViewer.this.setActionsActivated(viewer.getSourceViewer(), connect);
                        if (TextMergeViewer.this.isEditorBacked((ITextViewer)viewer.getSourceViewer()) && connect && (part = TextMergeViewer.this.getCompareConfiguration().getContainer().getWorkbenchPart()) instanceof CompareEditor) {
                            ((CompareEditor)part).refreshActionBarsContributor();
                        }
                    }
                }
            });
        }
    }

    protected void setActionsActivated(SourceViewer sourceViewer, boolean state) {
    }

    private IDocument getElementDocument(char type, Object element) {
        if (element instanceof IDocument) {
            return (IDocument)element;
        }
        ITypedElement te = Utilities.getLeg(type, element);
        IDocument document = null;
        switch (type) {
            case 'A': {
                document = this.getDocument(te, this.fAncestorContributor);
                break;
            }
            case 'L': {
                document = this.getDocument(te, this.fLeftContributor);
                break;
            }
            case 'R': {
                document = this.getDocument(te, this.fRightContributor);
                break;
            }
        }
        if (document != null) {
            return document;
        }
        return Utilities.getDocument(type, element, this.isUsingDefaultContentProvider(), this.canHaveSharedDocument());
    }

    private boolean isUsingDefaultContentProvider() {
        return this.getContentProvider() instanceof MergeViewerContentProvider;
    }

    private boolean canHaveSharedDocument() {
        return this.getDocumentPartitioning() != null || this.getDocumentPartitioner() == null;
    }

    private IDocument getDocument(ITypedElement te, ContributorInfo info) {
        if (info != null && info.getElement() == te) {
            return info.getDocument();
        }
        return null;
    }

    IDocument getDocument(char type, Object input) {
        IDocument doc = this.getElementDocument(type, input);
        if (doc != null) {
            return doc;
        }
        if (input instanceof IDiffElement) {
            IDiffContainer parent = ((IDiffElement)input).getParent();
            return this.getElementDocument(type, parent);
        }
        return null;
    }

    boolean sameDoc(char type, Object newInput, Object oldInput) {
        IDocument oldDoc;
        IDocument newDoc = this.getDocument(type, newInput);
        return newDoc == (oldDoc = this.getDocument(type, oldInput));
    }

    @Override
    protected boolean doSave(Object newInput, Object oldInput) {
        if (oldInput != null && newInput != null && this.sameDoc('A', newInput, oldInput) && this.sameDoc('L', newInput, oldInput) && this.sameDoc('R', newInput, oldInput)) {
            return false;
        }
        this.removeFromDocumentManager('A', oldInput);
        this.removeFromDocumentManager('L', oldInput);
        this.removeFromDocumentManager('R', oldInput);
        return super.doSave(newInput, oldInput);
    }

    private void removeFromDocumentManager(char leg, Object oldInput) {
        IDocument document = this.getDocument(leg, oldInput);
        if (document != null) {
            DocumentManager.remove(document);
        }
    }

    private ITypedElement getParent(char type) {
        Object input = this.getInput();
        if (input instanceof IDiffElement) {
            IDiffContainer parent = ((IDiffElement)input).getParent();
            return Utilities.getLeg(type, parent);
        }
        return null;
    }

    @Override
    protected void updateContent(Object ancestor, Object left, Object right) {
        ICompareInput ci;
        IDiffContainer parent;
        boolean emptyInput = ancestor == null && left == null && right == null;
        Object input = this.getInput();
        this.configureCompareFilterActions(input, ancestor, left, right);
        Position leftRange = null;
        Position rightRange = null;
        if (!emptyInput && (left == null || right == null) && input instanceof IDiffElement && (parent = ((IDiffElement)input).getParent()) instanceof ICompareInput && ((ci = (ICompareInput)((Object)parent)).getAncestor() instanceof IDocumentRange || ci.getLeft() instanceof IDocumentRange || ci.getRight() instanceof IDocumentRange)) {
            if (left instanceof IDocumentRange) {
                leftRange = ((IDocumentRange)left).getRange();
            }
            if (right instanceof IDocumentRange) {
                rightRange = ((IDocumentRange)right).getRange();
            }
            ancestor = ci.getAncestor();
            left = this.getCompareConfiguration().isMirrored() ? ci.getRight() : ci.getLeft();
            right = this.getCompareConfiguration().isMirrored() ? ci.getLeft() : ci.getRight();
        }
        this.fHighlightRanges = left != null && right != null;
        this.resetDiffs();
        this.fHasErrors = false;
        IMergeViewerContentProvider cp = this.getMergeContentProvider();
        if (cp instanceof MergeViewerContentProvider) {
            MergeViewerContentProvider mcp = (MergeViewerContentProvider)cp;
            mcp.setAncestorError(null);
            mcp.setLeftError(null);
            mcp.setRightError(null);
        }
        ContributorInfo oldLeftContributor = this.fLeftContributor;
        ContributorInfo oldRightContributor = this.fRightContributor;
        ContributorInfo oldAncestorContributor = this.fAncestorContributor;
        this.fLeftContributor = this.createLegInfoFor(left, 'L');
        this.fRightContributor = this.createLegInfoFor(right, 'R');
        this.fAncestorContributor = this.createLegInfoFor(ancestor, 'A');
        this.fLeftContributor.transferContributorStateFrom(oldLeftContributor);
        this.fRightContributor.transferContributorStateFrom(oldRightContributor);
        this.fAncestorContributor.transferContributorStateFrom(oldAncestorContributor);
        this.disconnect(oldLeftContributor);
        this.disconnect(oldRightContributor);
        this.disconnect(oldAncestorContributor);
        this.fLeftContributor.setEncodingIfAbsent(this.fRightContributor);
        this.fRightContributor.setEncodingIfAbsent(this.fLeftContributor);
        this.fAncestorContributor.setEncodingIfAbsent(this.fLeftContributor);
        if (!this.isConfigured) {
            this.configureSourceViewer(this.fAncestor.getSourceViewer(), false, null);
            this.configureSourceViewer(this.fLeft.getSourceViewer(), this.isLeftEditable() && cp.isLeftEditable(input), this.fLeftContributor);
            this.configureSourceViewer(this.fRight.getSourceViewer(), this.isRightEditable() && cp.isRightEditable(input), this.fRightContributor);
            this.isConfigured = true;
        }
        this.fLeftContributor.setDocument(this.fLeft, this.isLeftEditable() && cp.isLeftEditable(input));
        this.fLeftLineCount = this.fLeft.getLineCount();
        this.fRightContributor.setDocument(this.fRight, this.isRightEditable() && cp.isRightEditable(input));
        this.fRightLineCount = this.fRight.getLineCount();
        this.fAncestorContributor.setDocument(this.fAncestor, false);
        this.setSyncScrolling(this.fPreferenceStore.getBoolean("org.eclipse.compare.SynchronizeScrolling"));
        this.update(false);
        if (!(this.fHasErrors || emptyInput || this.fComposite.isDisposed())) {
            if (this.isRefreshing()) {
                this.fLeftContributor.updateSelection(this.fLeft, !this.fSynchronizedScrolling);
                this.fRightContributor.updateSelection(this.fRight, !this.fSynchronizedScrolling);
                this.fAncestorContributor.updateSelection(this.fAncestor, !this.fSynchronizedScrolling);
                if (this.fSynchronizedScrolling && this.fSynchronziedScrollPosition != -1) {
                    this.synchronizedScrollVertical(this.fSynchronziedScrollPosition);
                }
            } else if (this.isPatchHunk()) {
                if (right != null && Adapters.adapt((Object)right, IHunk.class) != null) {
                    this.fLeft.getSourceViewer().setTopIndex(this.getHunkStart());
                } else {
                    this.fRight.getSourceViewer().setTopIndex(this.getHunkStart());
                }
            } else {
                DocumentMerger.Diff selectDiff = null;
                if (leftRange != null) {
                    selectDiff = this.fMerger.findDiff('L', leftRange);
                } else if (rightRange != null) {
                    selectDiff = this.fMerger.findDiff('R', rightRange);
                }
                if (selectDiff != null) {
                    this.setCurrentDiff(selectDiff, true);
                } else {
                    this.selectFirstDiff(true);
                }
            }
        }
    }

    private void configureSourceViewer(SourceViewer sourceViewer, boolean editable, ContributorInfo contributor) {
        IDocument document;
        this.setEditable((ISourceViewer)sourceViewer, editable);
        this.configureTextViewer((TextViewer)sourceViewer);
        if (editable && contributor != null && (document = sourceViewer.getDocument()) != null) {
            contributor.connectPositionUpdater(document);
        }
        if (!this.isCursorLinePainterInstalled(sourceViewer)) {
            this.getSourceViewerDecorationSupport((ISourceViewer)sourceViewer).install(this.fPreferenceStore);
        }
    }

    private boolean isCursorLinePainterInstalled(SourceViewer viewer) {
        Listener[] listeners = viewer.getTextWidget().getListeners(3001);
        int i = 0;
        while (i < listeners.length) {
            TypedListener listener;
            if (listeners[i] instanceof TypedListener && (listener = (TypedListener)listeners[i]).getEventListener() instanceof CursorLinePainter) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected void setEditable(ISourceViewer sourceViewer, boolean state) {
        sourceViewer.setEditable(state);
    }

    private boolean isRefreshing() {
        return this.isRefreshing > 0;
    }

    private ContributorInfo createLegInfoFor(Object element, char leg) {
        return new ContributorInfo(this, element, leg);
    }

    private boolean updateDiffBackground(DocumentMerger.Diff diff) {
        if (!this.fHighlightRanges) {
            return false;
        }
        if (diff == null || diff.isToken()) {
            return false;
        }
        return !this.fShowCurrentOnly || this.isCurrentDiff(diff);
    }

    private void documentChanged(DocumentEvent e, boolean dirty) {
        final IDocument doc = e.getDocument();
        if (doc == this.fLeft.getSourceViewer().getDocument()) {
            this.setLeftDirty(dirty);
        } else if (doc == this.fRight.getSourceViewer().getDocument()) {
            this.setRightDirty(dirty);
        }
        if (!this.isLeftDirty() && !this.isRightDirty()) {
            this.fRedoDiff = false;
            final DocumentMerger.Diff oldDiff = this.getLastDiff();
            new UIJob(CompareMessages.DocumentMerger_0){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    if (!TextMergeViewer.this.getControl().isDisposed()) {
                        TextMergeViewer.this.doDiff();
                        if (!TextMergeViewer.this.getControl().isDisposed()) {
                            DocumentMerger.Diff newDiff = TextMergeViewer.this.findNewDiff(oldDiff);
                            if (newDiff != null) {
                                TextMergeViewer.this.updateStatus(newDiff);
                                TextMergeViewer.this.setCurrentDiff(newDiff, true);
                            }
                            TextMergeViewer.this.invalidateLines();
                            TextMergeViewer.this.updateLines(doc);
                        }
                    }
                    return Status.OK_STATUS;
                }
            }.schedule();
        } else {
            this.updateLines(doc);
        }
    }

    private void saveDiff() {
        this.fSavedDiff = this.fCurrentDiff;
    }

    private DocumentMerger.Diff getLastDiff() {
        if (this.fCurrentDiff != null) {
            return this.fCurrentDiff;
        }
        return this.fSavedDiff;
    }

    private DocumentMerger.Diff findNewDiff(DocumentMerger.Diff oldDiff) {
        if (oldDiff == null) {
            return null;
        }
        DocumentMerger.Diff newDiff = this.findNewDiff(oldDiff, 'L');
        if (newDiff == null) {
            newDiff = this.findNewDiff(oldDiff, 'R');
        }
        return newDiff;
    }

    private DocumentMerger.Diff findNewDiff(DocumentMerger.Diff oldDiff, char type) {
        int offset = oldDiff.getPosition((char)type).offset;
        int length = oldDiff.getPosition((char)type).length;
        if (length == 0) {
            if (offset > 0) {
                --offset;
            }
            length = 1;
        }
        return this.fMerger.findDiff(type, offset, offset + length);
    }

    protected int findInsertionPosition(char type, ICompareInput input) {
        ITypedElement other = null;
        char otherType = '\u0000';
        switch (type) {
            case 'A': {
                other = input.getLeft();
                otherType = 'L';
                if (other != null) break;
                other = input.getRight();
                otherType = 'R';
                break;
            }
            case 'L': {
                other = input.getRight();
                otherType = 'R';
                if (other != null) break;
                other = input.getAncestor();
                otherType = 'A';
                break;
            }
            case 'R': {
                other = input.getLeft();
                otherType = 'L';
                if (other != null) break;
                other = input.getAncestor();
                otherType = 'A';
                break;
            }
        }
        if (other instanceof IDocumentRange) {
            IDocumentRange dr = (IDocumentRange)((Object)other);
            Position p = dr.getRange();
            DocumentMerger.Diff diff = this.findDiff(otherType, p.offset);
            return this.fMerger.findInsertionPoint(diff, type);
        }
        return 0;
    }

    private void setError(char type, String message) {
        IMergeViewerContentProvider cp = this.getMergeContentProvider();
        if (cp instanceof MergeViewerContentProvider) {
            MergeViewerContentProvider mcp = (MergeViewerContentProvider)cp;
            switch (type) {
                case 'A': {
                    mcp.setAncestorError(message);
                    break;
                }
                case 'L': {
                    mcp.setLeftError(message);
                    break;
                }
                case 'R': {
                    mcp.setRightError(message);
                    break;
                }
            }
        }
        this.fHasErrors = true;
    }

    private void updateDirtyState(IEditorInput key, IDocumentProvider documentProvider, char type) {
        boolean dirty = documentProvider.canSaveDocument((Object)key);
        boolean oldLeftDirty = this.isLeftDirty();
        boolean oldRightDirty = this.isRightDirty();
        if (type == 'L') {
            this.setLeftDirty(dirty);
        } else if (type == 'R') {
            this.setRightDirty(dirty);
        }
        if (oldLeftDirty && !this.isLeftDirty() || oldRightDirty && !this.isRightDirty()) {
            this.fRedoDiff = true;
        }
    }

    private Position getNewRange(char type, Object input) {
        switch (type) {
            case 'A': {
                return this.fNewAncestorRanges.get(input);
            }
            case 'L': {
                return this.fNewLeftRanges.get(input);
            }
            case 'R': {
                return this.fNewRightRanges.get(input);
            }
        }
        return null;
    }

    private void addNewRange(char type, Object input, Position range) {
        switch (type) {
            case 'A': {
                this.fNewAncestorRanges.put(input, range);
                break;
            }
            case 'L': {
                this.fNewLeftRanges.put(input, range);
                break;
            }
            case 'R': {
                this.fNewRightRanges.put(input, range);
                break;
            }
        }
    }

    @Override
    protected byte[] getContents(boolean left) {
        String contents;
        IDocument d;
        MergeSourceViewer v;
        MergeSourceViewer mergeSourceViewer = v = left ? this.fLeft : this.fRight;
        if (v != null && (d = v.getSourceViewer().getDocument()) != null && (contents = d.get()) != null) {
            byte[] bytes;
            try {
                bytes = contents.getBytes(left ? this.fLeftContributor.internalGetEncoding() : this.fRightContributor.internalGetEncoding());
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                bytes = contents.getBytes();
            }
            return bytes;
        }
        return null;
    }

    private IRegion normalizeDocumentRegion(IDocument doc, IRegion region) {
        if (region == null || doc == null) {
            return region;
        }
        int maxLength = doc.getLength();
        int start = region.getOffset();
        if (start < 0) {
            start = 0;
        } else if (start > maxLength) {
            start = maxLength;
        }
        int length = region.getLength();
        if (length < 0) {
            length = 0;
        } else if (start + length > maxLength) {
            length = maxLength - start;
        }
        return new Region(start, length);
    }

    @Override
    protected final void handleResizeAncestor(int x, int y, int width, int height) {
        if (width > 0) {
            Rectangle trim = this.fLeft.getSourceViewer().getTextWidget().computeTrim(0, 0, 0, 0);
            int scrollbarHeight = trim.height;
            if (Utilities.okToUse((Widget)this.fAncestorCanvas)) {
                this.fAncestorCanvas.setVisible(true);
            }
            if (this.fAncestor.isControlOkToUse()) {
                this.fAncestor.getSourceViewer().getTextWidget().setVisible(true);
            }
            if (this.fAncestorCanvas != null) {
                this.fAncestorCanvas.setBounds(x, y, this.fMarginWidth, height - scrollbarHeight);
                x += this.fMarginWidth;
                width -= this.fMarginWidth;
            }
            this.fAncestor.setBounds(x, y, width, height);
        } else {
            if (Utilities.okToUse((Widget)this.fAncestorCanvas)) {
                this.fAncestorCanvas.setVisible(false);
            }
            if (this.fAncestor.isControlOkToUse()) {
                StyledText t = this.fAncestor.getSourceViewer().getTextWidget();
                t.setVisible(false);
                this.fAncestor.setBounds(0, 0, 0, 0);
                if (this.fFocusPart == this.fAncestor) {
                    this.fFocusPart = this.fLeft;
                    this.fFocusPart.getSourceViewer().getTextWidget().setFocus();
                }
            }
        }
    }

    @Override
    protected final void handleResizeLeftRight(int x, int y, int width1, int centerWidth, int width2, int height) {
        if (this.fBirdsEyeCanvas != null) {
            width2 -= 12;
        }
        Rectangle trim = this.fLeft.getSourceViewer().getTextWidget().computeTrim(0, 0, 0, 0);
        int scrollbarHeight = trim.height + trim.x;
        Composite composite = (Composite)this.getControl();
        int leftTextWidth = width1;
        if (this.fLeftCanvas != null) {
            this.fLeftCanvas.setBounds(x, y, this.fMarginWidth, height - scrollbarHeight);
            x += this.fMarginWidth;
            leftTextWidth -= this.fMarginWidth;
        }
        this.fLeft.setBounds(x, y, leftTextWidth, height);
        x += leftTextWidth;
        if (this.fCenter == null || this.fCenter.isDisposed()) {
            this.fCenter = this.createCenterControl(composite);
        }
        this.fCenter.setBounds(x, y, centerWidth, height - scrollbarHeight);
        x += centerWidth;
        if (!this.fSynchronizedScrolling && this.fRightCanvas != null) {
            this.fRightCanvas.setBounds(x, y, this.fMarginWidth, height - scrollbarHeight);
            this.fRightCanvas.redraw();
            x += this.fMarginWidth;
        }
        int scrollbarWidth = 0;
        if (this.fSynchronizedScrolling && this.fScrollCanvas != null) {
            trim = this.fLeft.getSourceViewer().getTextWidget().computeTrim(0, 0, 0, 0);
            scrollbarWidth = trim.width + 2 * trim.x + 1;
        }
        int rightTextWidth = width2 - scrollbarWidth;
        if (this.fRightCanvas != null) {
            rightTextWidth -= this.fMarginWidth;
        }
        this.fRight.setBounds(x, y, rightTextWidth, height);
        x += rightTextWidth;
        if (this.fSynchronizedScrolling) {
            if (this.fRightCanvas != null) {
                this.fRightCanvas.setBounds(x, y, this.fMarginWidth, height - scrollbarHeight);
                x += this.fMarginWidth;
            }
            if (this.fScrollCanvas != null) {
                this.fScrollCanvas.setBounds(x, y, scrollbarWidth, height - scrollbarHeight);
            }
        }
        if (this.fBirdsEyeCanvas != null) {
            int verticalScrollbarButtonHeight = scrollbarWidth;
            int horizontalScrollbarButtonHeight = scrollbarHeight;
            if (this.fIsMac) {
                verticalScrollbarButtonHeight += 2;
                horizontalScrollbarButtonHeight = 18;
            }
            if (this.fSummaryHeader != null) {
                this.fSummaryHeader.setBounds(x + scrollbarWidth, y, 12, verticalScrollbarButtonHeight);
            }
            this.fBirdsEyeCanvas.setBounds(x + scrollbarWidth, y += verticalScrollbarButtonHeight, 12, height - (2 * verticalScrollbarButtonHeight + horizontalScrollbarButtonHeight));
        }
        this.updateVScrollBar();
        this.refreshBirdsEyeView();
    }

    private void handleSelectionChanged(MergeSourceViewer tw) {
        Point p = tw.getSourceViewer().getSelectedRange();
        DocumentMerger.Diff d = this.findDiff(tw, p.x, p.x + p.y);
        this.updateStatus(d);
        this.setCurrentDiff(d, false);
    }

    private static IRegion toRegion(Position position) {
        if (position != null) {
            return new Region(position.getOffset(), position.getLength());
        }
        return null;
    }

    private void doDiff() {
        IDocument lDoc = this.fLeft.getSourceViewer().getDocument();
        IDocument rDoc = this.fRight.getSourceViewer().getDocument();
        if (lDoc == null || rDoc == null) {
            return;
        }
        this.fAncestor.resetLineBackground();
        this.fLeft.resetLineBackground();
        this.fRight.resetLineBackground();
        this.saveDiff();
        this.fCurrentDiff = null;
        try {
            this.fMerger.doDiff();
        }
        catch (CoreException e) {
            CompareUIPlugin.log(e.getStatus());
            String title = Utilities.getString(this.getResourceBundle(), "tooComplexError.title");
            String msg = Utilities.getString(this.getResourceBundle(), "tooComplexError.message");
            MessageDialog.openError((Shell)this.fComposite.getShell(), (String)title, (String)msg);
        }
        this.invalidateTextPresentation();
    }

    private DocumentMerger.Diff findDiff(char type, int pos) {
        try {
            return this.fMerger.findDiff(type, pos);
        }
        catch (CoreException e) {
            CompareUIPlugin.log(e.getStatus());
            String title = Utilities.getString(this.getResourceBundle(), "tooComplexError.title");
            String msg = Utilities.getString(this.getResourceBundle(), "tooComplexError.message");
            MessageDialog.openError((Shell)this.fComposite.getShell(), (String)title, (String)msg);
            return null;
        }
    }

    private void resetPositions(IDocument doc) {
        if (doc == null) {
            return;
        }
        try {
            doc.removePositionCategory(DIFF_RANGE_CATEGORY);
        }
        catch (BadPositionCategoryException badPositionCategoryException) {}
        doc.addPositionCategory(DIFF_RANGE_CATEGORY);
    }

    private void updateControls() {
        IAction a;
        IMergeViewerContentProvider cp;
        if (this.getControl().isDisposed()) {
            return;
        }
        boolean leftToRight = false;
        boolean rightToLeft = false;
        this.updateStatus(this.fCurrentDiff);
        this.updateResolveStatus();
        if (this.fCurrentDiff != null && (cp = this.getMergeContentProvider()) != null && !this.isPatchHunk()) {
            rightToLeft = cp.isLeftEditable(this.getInput());
            leftToRight = cp.isRightEditable(this.getInput());
        }
        if (this.fDirectionLabel != null) {
            if (this.fHighlightRanges && this.fCurrentDiff != null && this.isThreeWay() && !this.isIgnoreAncestor()) {
                this.fDirectionLabel.setImage(this.fCurrentDiff.getImage());
            } else {
                this.fDirectionLabel.setImage(null);
            }
        }
        if (this.fCopyDiffLeftToRightItem != null) {
            this.fCopyDiffLeftToRightItem.getAction().setEnabled(leftToRight);
        }
        if (this.fCopyDiffRightToLeftItem != null) {
            this.fCopyDiffRightToLeftItem.getAction().setEnabled(rightToLeft);
        }
        if (this.fNextDiff != null) {
            a = this.fNextDiff.getAction();
            a.setEnabled(this.isNavigationButtonEnabled(true, false));
        }
        if (this.fPreviousDiff != null) {
            a = this.fPreviousDiff.getAction();
            a.setEnabled(this.isNavigationButtonEnabled(false, false));
        }
        if (this.fNextChange != null) {
            a = this.fNextChange.getAction();
            a.setEnabled(this.isNavigationButtonEnabled(true, true));
        }
        if (this.fPreviousChange != null) {
            a = this.fPreviousChange.getAction();
            a.setEnabled(this.isNavigationButtonEnabled(false, true));
        }
    }

    private boolean isNavigationButtonEnabled(boolean down, boolean deep) {
        String value = this.fPreferenceStore.getString(ICompareUIConstants.PREF_NAVIGATION_END_ACTION);
        if (value.equals("doNothing")) {
            return this.getNextVisibleDiff(down, deep) != null;
        }
        if (value.equals("loop")) {
            return this.isNavigationPossible();
        }
        if (value.equals("next")) {
            return this.getNextVisibleDiff(down, deep) != null || this.hasNextElement(down);
        }
        if (value.equals("prompt")) {
            return this.isNavigationPossible() || this.hasNextElement(true);
        }
        Assert.isTrue((boolean)false);
        return false;
    }

    private void updateResolveStatus() {
        RGB rgb = null;
        if (this.showResolveUI()) {
            int unresolvedIncoming = 0;
            int unresolvedConflicting = 0;
            if (this.fMerger.hasChanges()) {
                Iterator iterator = this.fMerger.changesIterator();
                while (iterator.hasNext()) {
                    DocumentMerger.Diff d = (DocumentMerger.Diff)iterator.next();
                    if (d.isResolved()) continue;
                    if (d.getKind() == 1) {
                        ++unresolvedConflicting;
                        break;
                    }
                    ++unresolvedIncoming;
                }
            }
            rgb = unresolvedConflicting > 0 ? this.SELECTED_CONFLICT : (unresolvedIncoming > 0 ? this.SELECTED_INCOMING : this.RESOLVED);
        }
        if (this.fHeaderPainter.setColor(rgb)) {
            this.fSummaryHeader.redraw();
        }
    }

    private void updateStatus(DocumentMerger.Diff diff) {
        String format;
        String diffDescription;
        if (diff == null) {
            diffDescription = CompareMessages.TextMergeViewer_diffDescription_noDiff_format;
        } else {
            if (diff.isToken()) {
                diff = diff.getParent();
            }
            format = CompareMessages.TextMergeViewer_diffDescription_diff_format;
            diffDescription = MessageFormat.format((String)format, (Object[])new Object[]{this.getDiffType(diff), this.getDiffNumber(diff), this.getDiffRange(this.fLeft, diff.getPosition('L')), this.getDiffRange(this.fRight, diff.getPosition('R'))});
        }
        format = CompareMessages.TextMergeViewer_statusLine_format;
        String s = MessageFormat.format((String)format, (Object[])new Object[]{this.getCursorPosition(this.fLeft), this.getCursorPosition(this.fRight), diffDescription});
        this.getCompareConfiguration().getContainer().setStatusMessage(s);
    }

    private String getDiffType(DocumentMerger.Diff diff) {
        String s = "";
        switch (diff.getKind()) {
            case 3: {
                s = this.getCompareConfiguration().isMirrored() ? CompareMessages.TextMergeViewer_direction_incoming : CompareMessages.TextMergeViewer_direction_outgoing;
                break;
            }
            case 2: {
                s = this.getCompareConfiguration().isMirrored() ? CompareMessages.TextMergeViewer_direction_outgoing : CompareMessages.TextMergeViewer_direction_incoming;
                break;
            }
            case 1: {
                s = CompareMessages.TextMergeViewer_direction_conflicting;
                break;
            }
        }
        String format = CompareMessages.TextMergeViewer_diffType_format;
        return MessageFormat.format((String)format, (Object[])new Object[]{s, diff.changeType()});
    }

    private String getDiffNumber(DocumentMerger.Diff diff) {
        int diffNumber = 0;
        if (this.fMerger.hasChanges()) {
            Iterator iterator = this.fMerger.changesIterator();
            while (iterator.hasNext()) {
                DocumentMerger.Diff d = (DocumentMerger.Diff)iterator.next();
                ++diffNumber;
                if (d == diff) break;
            }
        }
        return Integer.toString(diffNumber);
    }

    private String getDiffRange(MergeSourceViewer v, Position pos) {
        Point p = v.getLineRange(pos, new Point(0, 0));
        int endLine = p.x + p.y;
        int startLine = p.x + 1;
        String format = endLine < startLine ? CompareMessages.TextMergeViewer_beforeLine_format : CompareMessages.TextMergeViewer_range_format;
        return MessageFormat.format((String)format, (Object[])new Object[]{Integer.toString(startLine), Integer.toString(endLine)});
    }

    private String getCursorPosition(MergeSourceViewer v) {
        if (v != null) {
            StyledText styledText = v.getSourceViewer().getTextWidget();
            IDocument document = v.getSourceViewer().getDocument();
            if (document != null) {
                int offset = v.getSourceViewer().getVisibleRegion().getOffset();
                int caret = offset + styledText.getCaretOffset();
                try {
                    int line = document.getLineOfOffset(caret);
                    int lineOffset = document.getLineOffset(line);
                    int occurrences = 0;
                    int i = lineOffset;
                    while (i < caret) {
                        if ('\t' == document.getChar(i)) {
                            ++occurrences;
                        }
                        ++i;
                    }
                    int tabWidth = styledText.getTabs();
                    int column = caret - lineOffset + (tabWidth - 1) * occurrences;
                    String format = CompareMessages.TextMergeViewer_cursorPosition_format;
                    return MessageFormat.format((String)format, (Object[])new Object[]{Integer.toString(line + 1), Integer.toString(column + 1)});
                }
                catch (BadLocationException badLocationException) {}
            }
        }
        return "";
    }

    @Override
    protected void updateHeader() {
        super.updateHeader();
        this.updateControls();
    }

    @Override
    protected void createToolItems(ToolBarManager tbm) {
        this.fHandlerService = CompareHandlerService.createFor(this.getCompareConfiguration().getContainer(), this.fLeft.getSourceViewer().getControl().getShell());
        Action ignoreAncestorAction = new Action(){

            public void run() {
                if (!TextMergeViewer.this.isIgnoreAncestor()) {
                    TextMergeViewer.this.getCompareConfiguration().setProperty(ICompareUIConstants.PROP_ANCESTOR_VISIBLE, Boolean.FALSE);
                }
                TextMergeViewer.this.getCompareConfiguration().setProperty(ICompareUIConstants.PROP_IGNORE_ANCESTOR, !TextMergeViewer.this.isIgnoreAncestor());
                Utilities.initToggleAction((IAction)this, TextMergeViewer.this.getResourceBundle(), "action.IgnoreAncestor.", TextMergeViewer.this.isIgnoreAncestor());
            }
        };
        ignoreAncestorAction.setChecked(this.isIgnoreAncestor());
        Utilities.initAction((IAction)ignoreAncestorAction, this.getResourceBundle(), "action.IgnoreAncestor.");
        Utilities.initToggleAction((IAction)ignoreAncestorAction, this.getResourceBundle(), "action.IgnoreAncestor.", this.isIgnoreAncestor());
        this.fIgnoreAncestorItem = new ActionContributionItem((IAction)ignoreAncestorAction);
        this.fIgnoreAncestorItem.setVisible(false);
        tbm.appendToGroup("modes", (IContributionItem)this.fIgnoreAncestorItem);
        tbm.add((IContributionItem)new Separator());
        Action a = new Action(){

            public void run() {
                if (TextMergeViewer.this.navigate(true, false, false)) {
                    TextMergeViewer.this.endOfDocumentReached(true);
                }
            }
        };
        Utilities.initAction((IAction)a, this.getResourceBundle(), "action.NextDiff.");
        this.fNextDiff = new ActionContributionItem((IAction)a);
        tbm.appendToGroup("navigation", (IContributionItem)this.fNextDiff);
        a = new Action(){

            public void run() {
                if (TextMergeViewer.this.navigate(false, false, false)) {
                    TextMergeViewer.this.endOfDocumentReached(false);
                }
            }
        };
        Utilities.initAction((IAction)a, this.getResourceBundle(), "action.PrevDiff.");
        this.fPreviousDiff = new ActionContributionItem((IAction)a);
        tbm.appendToGroup("navigation", (IContributionItem)this.fPreviousDiff);
        a = new Action(){

            public void run() {
                if (TextMergeViewer.this.navigate(true, false, true)) {
                    TextMergeViewer.this.endOfDocumentReached(true);
                }
            }
        };
        Utilities.initAction((IAction)a, this.getResourceBundle(), "action.NextChange.");
        this.fNextChange = new ActionContributionItem((IAction)a);
        tbm.appendToGroup("navigation", (IContributionItem)this.fNextChange);
        this.fHandlerService.registerAction((IAction)a, "org.eclipse.compare.selectNextChange");
        a = new Action(){

            public void run() {
                if (TextMergeViewer.this.navigate(false, false, true)) {
                    TextMergeViewer.this.endOfDocumentReached(false);
                }
            }
        };
        Utilities.initAction((IAction)a, this.getResourceBundle(), "action.PrevChange.");
        this.fPreviousChange = new ActionContributionItem((IAction)a);
        tbm.appendToGroup("navigation", (IContributionItem)this.fPreviousChange);
        this.fHandlerService.registerAction((IAction)a, "org.eclipse.compare.selectPreviousChange");
        a = new Action(){

            public void run() {
                TextMergeViewer.this.copyDiffLeftToRight();
            }
        };
        Utilities.initAction((IAction)a, this.getResourceBundle(), "action.CopyDiffLeftToRight.");
        this.fCopyDiffLeftToRightItem = new ActionContributionItem((IAction)a);
        this.fCopyDiffLeftToRightItem.setVisible(this.isRightEditable());
        tbm.appendToGroup("merge", (IContributionItem)this.fCopyDiffLeftToRightItem);
        this.fHandlerService.registerAction((IAction)a, "org.eclipse.compare.copyLeftToRight");
        a = new Action(){

            public void run() {
                TextMergeViewer.this.copyDiffRightToLeft();
            }
        };
        Utilities.initAction((IAction)a, this.getResourceBundle(), "action.CopyDiffRightToLeft.");
        this.fCopyDiffRightToLeftItem = new ActionContributionItem((IAction)a);
        this.fCopyDiffRightToLeftItem.setVisible(this.isLeftEditable());
        tbm.appendToGroup("merge", (IContributionItem)this.fCopyDiffRightToLeftItem);
        this.fHandlerService.registerAction((IAction)a, "org.eclipse.compare.copyRightToLeft");
        this.fIgnoreWhitespace = ChangePropertyAction.createIgnoreWhiteSpaceAction(this.getResourceBundle(), this.getCompareConfiguration());
        this.fIgnoreWhitespace.setActionDefinitionId(ICompareUIConstants.COMMAND_IGNORE_WHITESPACE);
        this.fLeft.addTextAction((IAction)this.fIgnoreWhitespace);
        this.fRight.addTextAction((IAction)this.fIgnoreWhitespace);
        this.fAncestor.addTextAction((IAction)this.fIgnoreWhitespace);
        this.fHandlerService.registerAction((IAction)this.fIgnoreWhitespace, this.fIgnoreWhitespace.getActionDefinitionId());
        boolean needsLeftPainter = !this.isEditorBacked((ITextViewer)this.fLeft.getSourceViewer());
        boolean needsRightPainter = !this.isEditorBacked((ITextViewer)this.fLeft.getSourceViewer());
        boolean needsAncestorPainter = !this.isEditorBacked((ITextViewer)this.fAncestor.getSourceViewer());
        this.showWhitespaceAction = new ShowWhitespaceAction(new MergeSourceViewer[]{this.fLeft, this.fRight, this.fAncestor}, new boolean[]{needsLeftPainter, needsRightPainter, needsAncestorPainter});
        this.fHandlerService.registerAction((IAction)this.showWhitespaceAction, "org.eclipse.ui.edit.text.toggleShowWhitespaceCharacters");
        this.toggleLineNumbersAction = new LineNumberRulerToggleAction(CompareMessages.TextMergeViewer_16, new MergeSourceViewer[]{this.fLeft, this.fRight, this.fAncestor}, "lineNumberRuler");
        this.fHandlerService.registerAction((IAction)this.toggleLineNumbersAction, "org.eclipse.ui.editors.lineNumberToggle");
    }

    private void configureCompareFilterActions(Object input, Object ancestor, Object left, Object right) {
        if (this.getCompareConfiguration() != null) {
            CompareFilterDescriptor[] compareFilterDescriptors = CompareUIPlugin.getDefault().findCompareFilters(input);
            Object current = this.getCompareConfiguration().getProperty("COMPARE_FILTER_ACTIONS");
            boolean currentFiltersMatch = false;
            if (current != null && current instanceof List && ((List)current).size() == compareFilterDescriptors.length) {
                currentFiltersMatch = true;
                List currentFilterActions = (List)current;
                int i = 0;
                while (i < compareFilterDescriptors.length) {
                    boolean match = false;
                    int j = 0;
                    while (j < currentFilterActions.size()) {
                        if (compareFilterDescriptors[i].getFilterId().equals(((ChangeCompareFilterPropertyAction)((Object)currentFilterActions.get(j))).getFilterId())) {
                            match = true;
                            break;
                        }
                        ++j;
                    }
                    if (!match) {
                        currentFiltersMatch = false;
                        break;
                    }
                    ++i;
                }
            }
            if (!currentFiltersMatch) {
                this.getCompareConfiguration().setProperty("COMPARE_FILTERS_INITIALIZING", Boolean.TRUE);
                this.disposeCompareFilterActions(true);
                this.fCompareFilterActions.clear();
                int i = 0;
                while (i < compareFilterDescriptors.length) {
                    ChangeCompareFilterPropertyAction compareFilterAction = new ChangeCompareFilterPropertyAction(compareFilterDescriptors[i], this.getCompareConfiguration());
                    compareFilterAction.setInput(input, ancestor, left, right);
                    this.fCompareFilterActions.add(compareFilterAction);
                    this.fLeft.addTextAction((IAction)compareFilterAction);
                    this.fRight.addTextAction((IAction)compareFilterAction);
                    this.fAncestor.addTextAction((IAction)compareFilterAction);
                    if (this.getCompareConfiguration().getContainer().getActionBars() != null) {
                        this.getCompareConfiguration().getContainer().getActionBars().getToolBarManager().appendToGroup("compare.filters", (IAction)compareFilterAction);
                        if (compareFilterAction.getActionDefinitionId() != null) {
                            this.getCompareConfiguration().getContainer().getActionBars().setGlobalActionHandler(compareFilterAction.getActionDefinitionId(), (IAction)compareFilterAction);
                        }
                    }
                    ++i;
                }
                if (!this.fCompareFilterActions.isEmpty() && this.getCompareConfiguration().getContainer().getActionBars() != null) {
                    this.getCompareConfiguration().getContainer().getActionBars().getToolBarManager().markDirty();
                    this.getCompareConfiguration().getContainer().getActionBars().getToolBarManager().update(true);
                    this.getCompareConfiguration().getContainer().getActionBars().updateActionBars();
                }
                this.getCompareConfiguration().setProperty("COMPARE_FILTER_ACTIONS", this.fCompareFilterActions);
                this.getCompareConfiguration().setProperty("COMPARE_FILTERS_INITIALIZING", null);
            } else {
                int i = 0;
                while (i < this.fCompareFilterActions.size()) {
                    this.fCompareFilterActions.get(i).setInput(input, ancestor, left, right);
                    ++i;
                }
            }
        }
    }

    private void disposeCompareFilterActions(boolean updateActionBars) {
        for (ChangeCompareFilterPropertyAction compareFilterAction : this.fCompareFilterActions) {
            this.fLeft.removeTextAction((IAction)compareFilterAction);
            this.fRight.removeTextAction((IAction)compareFilterAction);
            this.fAncestor.removeTextAction((IAction)compareFilterAction);
            if (updateActionBars && this.getCompareConfiguration().getContainer().getActionBars() != null) {
                this.getCompareConfiguration().getContainer().getActionBars().getToolBarManager().remove(compareFilterAction.getId());
                if (compareFilterAction.getActionDefinitionId() != null) {
                    this.getCompareConfiguration().getContainer().getActionBars().setGlobalActionHandler(compareFilterAction.getActionDefinitionId(), null);
                }
            }
            compareFilterAction.dispose();
        }
        if (updateActionBars && !this.fCompareFilterActions.isEmpty() && this.getCompareConfiguration().getContainer().getActionBars() != null) {
            this.getCompareConfiguration().getContainer().getActionBars().getToolBarManager().markDirty();
            this.getCompareConfiguration().getContainer().getActionBars().getToolBarManager().update(true);
        }
        this.fCompareFilterActions.clear();
        this.getCompareConfiguration().setProperty("COMPARE_FILTERS", null);
        this.getCompareConfiguration().setProperty("COMPARE_FILTER_ACTIONS", null);
    }

    @Override
    protected void handlePropertyChangeEvent(PropertyChangeEvent event) {
        String key = event.getProperty();
        if (key.equals("IGNORE_WHITESPACE") || key.equals("org.eclipse.compare.ShowPseudoConflicts") || key.equals("COMPARE_FILTERS") && this.getCompareConfiguration().getProperty("COMPARE_FILTERS_INITIALIZING") == null) {
            this.fShowPseudoConflicts = this.fPreferenceStore.getBoolean("org.eclipse.compare.ShowPseudoConflicts");
            this.update(true);
            if (this.fFocusPart != null) {
                this.handleSelectionChanged(this.fFocusPart);
            }
        } else if (key.equals("org.eclipse.compare.UseSingleLine")) {
            this.fUseSingleLine = this.fPreferenceStore.getBoolean("org.eclipse.compare.UseSingleLine");
            this.fBasicCenterCurve = null;
            this.updateControls();
            this.invalidateLines();
        } else if (key.equals("org.eclipse.compare.HighlightTokenChanges")) {
            this.fHighlightTokenChanges = this.fPreferenceStore.getBoolean("org.eclipse.compare.HighlightTokenChanges");
            this.updateControls();
            this.updatePresentation();
        } else if (key.equals(this.fSymbolicFontName)) {
            this.updateFont();
            this.invalidateLines();
        } else if (key.equals(INCOMING_COLOR) || key.equals(OUTGOING_COLOR) || key.equals(CONFLICTING_COLOR) || key.equals(RESOLVED_COLOR)) {
            this.updateColors(null);
            this.invalidateLines();
            this.invalidateTextPresentation();
        } else if (key.equals("org.eclipse.compare.SynchronizeScrolling")) {
            boolean b = this.fPreferenceStore.getBoolean("org.eclipse.compare.SynchronizeScrolling");
            this.setSyncScrolling(b);
        } else if (key.equals("AbstractTextEditor.Color.Background")) {
            if (!this.fIsUsingSystemBackground) {
                this.setBackgroundColor(TextMergeViewer.createColor(this.fPreferenceStore, "AbstractTextEditor.Color.Background"));
            }
        } else if (key.equals("AbstractTextEditor.Color.Background.SystemDefault")) {
            this.fIsUsingSystemBackground = this.fPreferenceStore.getBoolean("AbstractTextEditor.Color.Background.SystemDefault");
            if (this.fIsUsingSystemBackground) {
                this.setBackgroundColor(null);
            } else {
                this.setBackgroundColor(TextMergeViewer.createColor(this.fPreferenceStore, "AbstractTextEditor.Color.Background"));
            }
        } else if (key.equals("AbstractTextEditor.Color.Foreground")) {
            if (!this.fIsUsingSystemForeground) {
                this.setForegroundColor(TextMergeViewer.createColor(this.fPreferenceStore, "AbstractTextEditor.Color.Foreground"));
            }
        } else if (key.equals("AbstractTextEditor.Color.Foreground.SystemDefault")) {
            this.fIsUsingSystemForeground = this.fPreferenceStore.getBoolean("AbstractTextEditor.Color.Foreground.SystemDefault");
            if (this.fIsUsingSystemForeground) {
                this.setForegroundColor(null);
            } else {
                this.setForegroundColor(TextMergeViewer.createColor(this.fPreferenceStore, "AbstractTextEditor.Color.Foreground"));
            }
        } else if (key.equals(ICompareUIConstants.PREF_NAVIGATION_END_ACTION)) {
            this.updateControls();
        } else if (key.equals("DISABLE_CAPPING_TEMPORARILY")) {
            if (Boolean.TRUE.equals(event.getNewValue())) {
                this.getCompareConfiguration().setProperty("DISABLE_CAPPING_TEMPORARILY", null);
                this.handleCompareInputChange();
            }
        } else {
            super.handlePropertyChangeEvent(event);
            if (key.equals(ICompareUIConstants.PROP_IGNORE_ANCESTOR)) {
                this.update(true);
                this.selectFirstDiff(true);
            }
        }
    }

    private void selectFirstDiff(boolean first) {
        if (this.fLeft == null || this.fRight == null) {
            return;
        }
        if (this.fLeft.getSourceViewer().getDocument() == null || this.fRight.getSourceViewer().getDocument() == null) {
            return;
        }
        DocumentMerger.Diff firstDiff = null;
        firstDiff = first ? this.findNext(this.fRight, -1, -1, false) : this.findPrev(this.fRight, 9999999, 9999999, false);
        this.setCurrentDiff(firstDiff, true);
    }

    private void setSyncScrolling(boolean newMode) {
        if (this.fSynchronizedScrolling != newMode) {
            this.fSynchronizedScrolling = newMode;
            this.scrollVertical(0, 0, 0, null);
            Control center = this.getCenterControl();
            if (center != null && !center.isDisposed()) {
                center.dispose();
            }
            this.fLeft.getSourceViewer().getTextWidget().getVerticalBar().setVisible(!this.fSynchronizedScrolling);
            this.fRight.getSourceViewer().getTextWidget().getVerticalBar().setVisible(!this.fSynchronizedScrolling);
            this.fComposite.layout(true);
        }
    }

    @Override
    protected void updateToolItems() {
        if (this.fCopyDiffLeftToRightItem != null) {
            this.fCopyDiffLeftToRightItem.setVisible(this.isRightEditable());
        }
        if (this.fCopyDiffRightToLeftItem != null) {
            this.fCopyDiffRightToLeftItem.setVisible(this.isLeftEditable());
        }
        if (!this.isPatchHunk()) {
            IAction a;
            if (this.fIgnoreAncestorItem != null) {
                this.fIgnoreAncestorItem.setVisible(this.isThreeWay());
            }
            if (this.fCopyDiffLeftToRightItem != null && (a = this.fCopyDiffLeftToRightItem.getAction()) != null) {
                a.setEnabled(a.isEnabled() && !this.fHasErrors);
            }
            if (this.fCopyDiffRightToLeftItem != null && (a = this.fCopyDiffRightToLeftItem.getAction()) != null) {
                a.setEnabled(a.isEnabled() && !this.fHasErrors);
            }
        }
        super.updateToolItems();
    }

    private void updateLines(IDocument d) {
        int l;
        boolean left = false;
        boolean right = false;
        if (d == this.fLeft.getSourceViewer().getDocument()) {
            l = this.fLeft.getLineCount();
            left = this.fLeftLineCount != l;
            this.fLeftLineCount = l;
        } else if (d == this.fRight.getSourceViewer().getDocument()) {
            l = this.fRight.getLineCount();
            right = this.fRightLineCount != l;
            this.fRightLineCount = l;
        }
        if (left || right) {
            Control center;
            if (left) {
                if (this.fLeftCanvas != null) {
                    this.fLeftCanvas.redraw();
                }
            } else if (this.fRightCanvas != null) {
                this.fRightCanvas.redraw();
            }
            if ((center = this.getCenterControl()) != null) {
                center.redraw();
            }
            this.updateVScrollBar();
            this.refreshBirdsEyeView();
        }
    }

    private void invalidateLines() {
        if (this.isThreeWay() && this.isAncestorVisible()) {
            if (Utilities.okToUse((Widget)this.fAncestorCanvas)) {
                this.fAncestorCanvas.redraw();
            }
            if (this.fAncestor != null && this.fAncestor.isControlOkToUse()) {
                this.fAncestor.getSourceViewer().getTextWidget().redraw();
            }
        }
        if (Utilities.okToUse((Widget)this.fLeftCanvas)) {
            this.fLeftCanvas.redraw();
        }
        if (this.fLeft != null && this.fLeft.isControlOkToUse()) {
            this.fLeft.getSourceViewer().getTextWidget().redraw();
        }
        if (Utilities.okToUse((Widget)this.getCenterControl())) {
            this.getCenterControl().redraw();
        }
        if (this.fRight != null && this.fRight.isControlOkToUse()) {
            this.fRight.getSourceViewer().getTextWidget().redraw();
        }
        if (Utilities.okToUse((Widget)this.fRightCanvas)) {
            this.fRightCanvas.redraw();
        }
    }

    private boolean showResolveUI() {
        if (!this.isThreeWay() || this.isIgnoreAncestor()) {
            return false;
        }
        return this.isAnySideEditable();
    }

    private boolean isAnySideEditable() {
        return this.isLeftEditable() || this.isRightEditable();
    }

    private void paintCenter(Canvas canvas, GC g) {
        Display display = canvas.getDisplay();
        this.checkForColorUpdate(display);
        if (!this.fSynchronizedScrolling) {
            return;
        }
        int lineHeightLeft = this.fLeft.getSourceViewer().getTextWidget().getLineHeight();
        int lineHeightRight = this.fRight.getSourceViewer().getTextWidget().getLineHeight();
        int visibleHeight = this.fRight.getViewportHeight();
        Point size = canvas.getSize();
        int x = 0;
        int w = size.x;
        g.setBackground(canvas.getBackground());
        g.fillRectangle(x + 1, 0, w - 2, size.y);
        if (!this.fIsMotif) {
            g.setBackground(display.getSystemColor(18));
            g.fillRectangle(0, 0, 1, size.y);
            g.fillRectangle(w - 1, 0, 1, size.y);
        }
        if (!this.fHighlightRanges) {
            return;
        }
        if (this.fMerger.hasChanges()) {
            int lshift = this.fLeft.getVerticalScrollOffset();
            int rshift = this.fRight.getVerticalScrollOffset();
            Point region = new Point(0, 0);
            Iterator iterator = this.fMerger.changesIterator();
            while (iterator.hasNext()) {
                int i;
                DocumentMerger.Diff diff = (DocumentMerger.Diff)iterator.next();
                if (diff.isDeleted() || this.fShowCurrentOnly2 && !this.isCurrentDiff(diff)) continue;
                this.fLeft.getLineRange(diff.getPosition('L'), region);
                int ly = region.x * lineHeightLeft + lshift;
                int lh = region.y * lineHeightLeft;
                this.fRight.getLineRange(diff.getPosition('R'), region);
                int ry = region.x * lineHeightRight + rshift;
                int rh = region.y * lineHeightRight;
                if (Math.max(ly + lh, ry + rh) < 0) continue;
                if (Math.min(ly, ry) >= visibleHeight) break;
                this.fPts[0] = x;
                this.fPts[1] = ly;
                this.fPts[2] = w;
                this.fPts[3] = ry;
                this.fPts[6] = x;
                this.fPts[7] = ly + lh;
                this.fPts[4] = w;
                this.fPts[5] = ry + rh;
                Color fillColor = this.getColor(display, this.getFillColor(diff));
                Color strokeColor = this.getColor(display, this.getStrokeColor(diff));
                if (this.fUseSingleLine) {
                    int w2 = 3;
                    g.setBackground(fillColor);
                    g.fillRectangle(0, ly, w2, lh);
                    g.fillRectangle(w - w2, ry, w2, rh);
                    g.setLineWidth(0);
                    g.setForeground(strokeColor);
                    g.drawRectangle(-1, ly, w2, lh);
                    g.drawRectangle(w - w2, ry, w2, rh);
                    if (this.fUseSplines) {
                        int[] points = this.getCenterCurvePoints(w2, ly + lh / 2, w - w2, ry + rh / 2);
                        i = 1;
                        while (i < points.length) {
                            g.drawLine(w2 + i - 1, points[i - 1], w2 + i, points[i]);
                            ++i;
                        }
                    } else {
                        g.drawLine(w2, ly + lh / 2, w - w2, ry + rh / 2);
                    }
                } else if (this.fUseSplines) {
                    g.setBackground(fillColor);
                    g.setLineWidth(0);
                    g.setForeground(strokeColor);
                    int[] topPoints = this.getCenterCurvePoints(this.fPts[0], this.fPts[1], this.fPts[2], this.fPts[3]);
                    int[] bottomPoints = this.getCenterCurvePoints(this.fPts[6], this.fPts[7], this.fPts[4], this.fPts[5]);
                    g.setForeground(fillColor);
                    g.drawLine(0, bottomPoints[0], 0, topPoints[0]);
                    i = 1;
                    while (i < bottomPoints.length) {
                        g.setForeground(fillColor);
                        g.drawLine(i, bottomPoints[i], i, topPoints[i]);
                        g.setForeground(strokeColor);
                        g.drawLine(i - 1, topPoints[i - 1], i, topPoints[i]);
                        g.drawLine(i - 1, bottomPoints[i - 1], i, bottomPoints[i]);
                        ++i;
                    }
                } else {
                    g.setBackground(fillColor);
                    g.fillPolygon(this.fPts);
                    g.setLineWidth(0);
                    g.setForeground(strokeColor);
                    g.drawLine(this.fPts[0], this.fPts[1], this.fPts[2], this.fPts[3]);
                    g.drawLine(this.fPts[6], this.fPts[7], this.fPts[4], this.fPts[5]);
                }
                if (!this.fUseSingleLine || !this.isAnySideEditable()) continue;
                int cx = (w - 5) / 2;
                int cy = (ly + lh / 2 + (ry + rh / 2) - 5) / 2;
                g.setBackground(fillColor);
                g.fillRectangle(cx, cy, 5, 5);
                g.setForeground(strokeColor);
                g.drawRectangle(cx, cy, 5, 5);
            }
        }
    }

    private int[] getCenterCurvePoints(int startx, int starty, int endx, int endy) {
        if (this.fBasicCenterCurve == null) {
            this.buildBaseCenterCurve(endx - startx);
        }
        double height = endy - starty;
        height /= 2.0;
        int width = endx - startx;
        int[] points = new int[width];
        int i = 0;
        while (i < width) {
            points[i] = (int)(-height * this.fBasicCenterCurve[i] + height + (double)starty);
            ++i;
        }
        return points;
    }

    private void buildBaseCenterCurve(int w) {
        double width = w;
        this.fBasicCenterCurve = new double[this.getCenterWidth()];
        int i = 0;
        while (i < this.getCenterWidth()) {
            double r = (double)i / width;
            this.fBasicCenterCurve[i] = Math.cos(Math.PI * r);
            ++i;
        }
    }

    private void paintSides(GC g, MergeSourceViewer tp, Canvas canvas, boolean right) {
        Display display = canvas.getDisplay();
        int lineHeight = tp.getSourceViewer().getTextWidget().getLineHeight();
        int visibleHeight = tp.getViewportHeight();
        Point size = canvas.getSize();
        int x = 0;
        int w = this.fMarginWidth;
        int w2 = w / 2;
        g.setBackground(canvas.getBackground());
        g.fillRectangle(x, 0, w, size.y);
        if (!this.fIsMotif) {
            g.setBackground(display.getSystemColor(18));
            if (right) {
                g.fillRectangle(0, 0, 1, size.y);
            } else {
                g.fillRectangle(size.x - 1, 0, 1, size.y);
            }
        }
        if (!this.fHighlightRanges) {
            return;
        }
        if (this.fMerger.hasChanges()) {
            int shift = tp.getVerticalScrollOffset() + 1;
            Point region = new Point(0, 0);
            char leg = this.getLeg(tp);
            Iterator iterator = this.fMerger.changesIterator();
            while (iterator.hasNext()) {
                DocumentMerger.Diff diff = (DocumentMerger.Diff)iterator.next();
                if (diff.isDeleted() || this.fShowCurrentOnly2 && !this.isCurrentDiff(diff)) continue;
                tp.getLineRange(diff.getPosition(leg), region);
                int y = region.x * lineHeight + shift;
                int h = region.y * lineHeight;
                if (y + h < 0) continue;
                if (y >= visibleHeight) break;
                g.setBackground(this.getColor(display, this.getFillColor(diff)));
                if (right) {
                    g.fillRectangle(x, y, w2, h);
                } else {
                    g.fillRectangle(x + w2, y, w2, h);
                }
                g.setLineWidth(0);
                g.setForeground(this.getColor(display, this.getStrokeColor(diff)));
                if (right) {
                    g.drawRectangle(x - 1, y - 1, w2, h);
                    continue;
                }
                g.drawRectangle(x + w2, y - 1, w2, h);
            }
        }
    }

    private void paint(PaintEvent event, MergeSourceViewer tp) {
        if (!this.fHighlightRanges) {
            return;
        }
        if (!this.fMerger.hasChanges()) {
            return;
        }
        Control canvas = (Control)event.widget;
        GC g = event.gc;
        Display display = canvas.getDisplay();
        int lineHeight = tp.getSourceViewer().getTextWidget().getLineHeight();
        int w = canvas.getSize().x;
        int shift = tp.getVerticalScrollOffset() + 1;
        int maxh = event.y + event.height;
        shift += this.fTopInset;
        Point range = new Point(0, 0);
        char leg = this.getLeg(tp);
        Iterator iterator = this.fMerger.changesIterator();
        while (iterator.hasNext()) {
            DocumentMerger.Diff diff = (DocumentMerger.Diff)iterator.next();
            if (diff.isDeleted() || this.fShowCurrentOnly && !this.isCurrentDiff(diff)) continue;
            tp.getLineRange(diff.getPosition(leg), range);
            int y = range.x * lineHeight + shift;
            int h = range.y * lineHeight;
            if (y + h < event.y) continue;
            if (y > maxh) break;
            g.setBackground(this.getColor(display, this.getStrokeColor(diff)));
            g.fillRectangle(0, y - 1, w, 1);
            g.fillRectangle(0, y + h - 1, w, 1);
        }
    }

    private RGB getFillColor(DocumentMerger.Diff diff) {
        boolean selected = this.fCurrentDiff != null && this.fCurrentDiff.getParent() == diff;
        RGB selected_fill = this.getBackground(null);
        if (this.isThreeWay() && !this.isIgnoreAncestor()) {
            switch (diff.getKind()) {
                case 2: {
                    if (!this.getCompareConfiguration().isMirrored()) {
                        return selected ? selected_fill : this.INCOMING_FILL;
                    }
                    return selected ? selected_fill : this.OUTGOING_FILL;
                }
                case 1: 
                case 4: {
                    return selected ? selected_fill : this.CONFLICT_FILL;
                }
                case 3: {
                    if (!this.getCompareConfiguration().isMirrored()) {
                        return selected ? selected_fill : this.OUTGOING_FILL;
                    }
                    return selected ? selected_fill : this.INCOMING_FILL;
                }
            }
            return null;
        }
        return selected ? selected_fill : this.OUTGOING_FILL;
    }

    private RGB getStrokeColor(DocumentMerger.Diff diff) {
        boolean selected;
        boolean bl = selected = this.fCurrentDiff != null && this.fCurrentDiff.getParent() == diff;
        if (this.isThreeWay() && !this.isIgnoreAncestor()) {
            switch (diff.getKind()) {
                case 2: {
                    if (!this.getCompareConfiguration().isMirrored()) {
                        return selected ? this.SELECTED_INCOMING : this.INCOMING;
                    }
                    return selected ? this.SELECTED_OUTGOING : this.OUTGOING;
                }
                case 1: 
                case 4: {
                    return selected ? this.SELECTED_CONFLICT : this.CONFLICT;
                }
                case 3: {
                    if (!this.getCompareConfiguration().isMirrored()) {
                        return selected ? this.SELECTED_OUTGOING : this.OUTGOING;
                    }
                    return selected ? this.SELECTED_INCOMING : this.INCOMING;
                }
            }
            return null;
        }
        return selected ? this.SELECTED_OUTGOING : this.OUTGOING;
    }

    private Color getColor(Display display, RGB rgb) {
        Color c;
        if (rgb == null) {
            return null;
        }
        if (this.fColors == null) {
            this.fColors = new HashMap<RGB, Color>(20);
        }
        if ((c = this.fColors.get(rgb)) == null) {
            c = new Color((Device)display, rgb);
            this.fColors.put(rgb, c);
        }
        return c;
    }

    static RGB interpolate(RGB fg, RGB bg, double scale) {
        if (fg != null && bg != null) {
            return new RGB((int)((1.0 - scale) * (double)fg.red + scale * (double)bg.red), (int)((1.0 - scale) * (double)fg.green + scale * (double)bg.green), (int)((1.0 - scale) * (double)fg.blue + scale * (double)bg.blue));
        }
        if (fg != null) {
            return fg;
        }
        if (bg != null) {
            return bg;
        }
        return new RGB(128, 128, 128);
    }

    private DocumentMerger.Diff getNextVisibleDiff(boolean down, boolean deep) {
        DocumentMerger.Diff diff = null;
        MergeSourceViewer part = this.getNavigationPart();
        if (part == null) {
            return null;
        }
        Point s = part.getSourceViewer().getSelectedRange();
        char leg = this.getLeg(part);
        while (true) {
            diff = null;
            diff = this.internalGetNextDiff(down, deep, part, s);
            if (diff == null || diff.getKind() != 4 || this.isAncestorVisible()) break;
            Position position = diff.getPosition(leg);
            s = new Point(position.getOffset(), position.getLength());
            diff = null;
        }
        return diff;
    }

    private DocumentMerger.Diff internalGetNextDiff(boolean down, boolean deep, MergeSourceViewer part, Point s) {
        if (this.fMerger.hasChanges()) {
            if (down) {
                return this.findNext(part, s.x, s.x + s.y, deep);
            }
            return this.findPrev(part, s.x, s.x + s.y, deep);
        }
        return null;
    }

    private MergeSourceViewer getNavigationPart() {
        MergeSourceViewer part = this.fFocusPart;
        if (part == null) {
            part = this.fRight;
        }
        return part;
    }

    private DocumentMerger.Diff getWrappedDiff(DocumentMerger.Diff diff, boolean down) {
        return this.fMerger.getWrappedDiff(diff, down);
    }

    private boolean navigate(boolean down, boolean wrap, boolean deep) {
        DocumentMerger.Diff diff = null;
        boolean wrapped = false;
        do {
            if ((diff = this.getNextVisibleDiff(down, deep)) == null && wrap) {
                if (wrapped) break;
                wrapped = true;
                diff = this.getWrappedDiff(diff, down);
            }
            if (diff == null) continue;
            this.setCurrentDiff(diff, true, deep);
        } while (diff != null && diff.getKind() == 4 && !this.isAncestorVisible());
        return diff == null;
    }

    private void endOfDocumentReached(boolean down) {
        Control c = this.getControl();
        if (Utilities.okToUse((Widget)c)) {
            this.handleEndOfDocumentReached(c.getShell(), down);
        }
    }

    private void handleEndOfDocumentReached(Shell shell, boolean next) {
        IPreferenceStore store = CompareUIPlugin.getDefault().getPreferenceStore();
        String value = store.getString(ICompareUIConstants.PREF_NAVIGATION_END_ACTION);
        if (!value.equals("prompt")) {
            this.performEndOfDocumentAction(shell, store, ICompareUIConstants.PREF_NAVIGATION_END_ACTION, next);
        } else {
            String nextMessage;
            String loopMessage;
            String message;
            String title;
            shell.getDisplay().beep();
            if (next) {
                title = CompareMessages.TextMergeViewer_0;
                message = CompareMessages.TextMergeViewer_1;
                loopMessage = CompareMessages.TextMergeViewer_2;
                nextMessage = CompareMessages.TextMergeViewer_3;
            } else {
                title = CompareMessages.TextMergeViewer_4;
                message = CompareMessages.TextMergeViewer_5;
                loopMessage = CompareMessages.TextMergeViewer_6;
                nextMessage = CompareMessages.TextMergeViewer_7;
            }
            String[] localLoopOption = new String[]{loopMessage, "loop"};
            String[] nextElementOption = new String[]{nextMessage, "next"};
            String[] doNothingOption = new String[]{CompareMessages.TextMergeViewer_17, "doNothing"};
            NavigationEndDialog dialog = new NavigationEndDialog(shell, title, null, message, new String[][]{localLoopOption, nextElementOption, doNothingOption});
            int result = dialog.open();
            if (result == 0) {
                this.performEndOfDocumentAction(shell, store, ICompareUIConstants.PREF_NAVIGATION_END_ACTION_LOCAL, next);
                if (dialog.getToggleState()) {
                    String oldValue = store.getString(ICompareUIConstants.PREF_NAVIGATION_END_ACTION);
                    store.putValue(ICompareUIConstants.PREF_NAVIGATION_END_ACTION, store.getString(ICompareUIConstants.PREF_NAVIGATION_END_ACTION_LOCAL));
                    store.firePropertyChangeEvent(ICompareUIConstants.PREF_NAVIGATION_END_ACTION, (Object)oldValue, (Object)store.getString(ICompareUIConstants.PREF_NAVIGATION_END_ACTION_LOCAL));
                }
            }
        }
    }

    private void performEndOfDocumentAction(Shell shell, IPreferenceStore store, String key, boolean next) {
        String value = store.getString(key);
        if (value.equals("doNothing")) {
            return;
        }
        if (value.equals("next")) {
            ICompareNavigator navigator = this.getCompareConfiguration().getContainer().getNavigator();
            if (this.hasNextElement(next)) {
                navigator.selectChange(next);
            }
        } else {
            this.selectFirstDiff(next);
        }
    }

    private boolean hasNextElement(boolean down) {
        ICompareNavigator navigator = this.getCompareConfiguration().getContainer().getNavigator();
        if (navigator instanceof CompareNavigator) {
            CompareNavigator n = (CompareNavigator)navigator;
            return n.hasChange(down);
        }
        return false;
    }

    private DocumentMerger.Diff findDiff(MergeSourceViewer tp, int rangeStart, int rangeEnd) {
        char contributor = this.getLeg(tp);
        return this.fMerger.findDiff(contributor, rangeStart, rangeEnd);
    }

    private DocumentMerger.Diff findNext(MergeSourceViewer tp, int start, int end, boolean deep) {
        return this.fMerger.findNext(this.getLeg(tp), start, end, deep);
    }

    private DocumentMerger.Diff findPrev(MergeSourceViewer tp, int start, int end, boolean deep) {
        return this.fMerger.findPrev(this.getLeg(tp), start, end, deep);
    }

    private void setCurrentDiff(DocumentMerger.Diff d, boolean revealAndSelect) {
        this.setCurrentDiff(d, revealAndSelect, false);
    }

    private void setCurrentDiff(DocumentMerger.Diff d, boolean revealAndSelect, boolean deep) {
        boolean diffChanged;
        boolean bl = diffChanged = this.fCurrentDiff != d;
        if (this.fLeftToRightButton != null && !this.fLeftToRightButton.isDisposed()) {
            this.fLeftToRightButton.setVisible(false);
        }
        if (this.fRightToLeftButton != null && !this.fRightToLeftButton.isDisposed()) {
            this.fRightToLeftButton.setVisible(false);
        }
        if (d != null && revealAndSelect) {
            if (d.isToken() || !this.fHighlightTokenChanges || deep || !d.hasChildren()) {
                if (this.isThreeWay() && !this.isIgnoreAncestor()) {
                    this.fAncestor.setSelection(d.getPosition('A'));
                }
                this.fLeft.setSelection(d.getPosition('L'));
                this.fRight.setSelection(d.getPosition('R'));
            } else {
                if (this.isThreeWay() && !this.isIgnoreAncestor()) {
                    this.fAncestor.setSelection(new Position(d.getPosition((char)'A').offset, 0));
                }
                this.fLeft.setSelection(new Position(d.getPosition((char)'L').offset, 0));
                this.fRight.setSelection(new Position(d.getPosition((char)'R').offset, 0));
            }
            this.saveDiff();
            this.fCurrentDiff = d;
            this.revealDiff(d, d.isToken());
        } else {
            this.saveDiff();
            this.fCurrentDiff = d;
        }
        this.updateControls();
        if (diffChanged) {
            this.invalidateLines();
        }
        this.refreshBirdsEyeView();
    }

    private void revealDiff(DocumentMerger.Diff d, boolean smart) {
        boolean ancestorIsVisible = false;
        boolean leftIsVisible = false;
        boolean rightIsVisible = false;
        if (smart) {
            int as;
            Point region = new Point(0, 0);
            int ls = this.fLeft.getLineRange((Position)d.getPosition((char)'L'), (Point)region).x;
            int rs = this.fRight.getLineRange((Position)d.getPosition((char)'R'), (Point)region).x;
            if (this.isThreeWay() && !this.isIgnoreAncestor() && (as = this.fAncestor.getLineRange((Position)d.getPosition((char)'A'), (Point)region).x) >= this.fAncestor.getSourceViewer().getTopIndex() && as <= this.fAncestor.getSourceViewer().getBottomIndex()) {
                ancestorIsVisible = true;
            }
            if (ls >= this.fLeft.getSourceViewer().getTopIndex() && ls <= this.fLeft.getSourceViewer().getBottomIndex()) {
                leftIsVisible = true;
            }
            if (rs >= this.fRight.getSourceViewer().getTopIndex() && rs <= this.fRight.getSourceViewer().getBottomIndex()) {
                rightIsVisible = true;
            }
        }
        if (!leftIsVisible || !rightIsVisible) {
            int avpos = 0;
            int lvpos = 0;
            int rvpos = 0;
            MergeSourceViewer allButThis = null;
            if (leftIsVisible) {
                lvpos = rvpos = this.realToVirtualPosition('L', this.fLeft.getSourceViewer().getTopIndex());
                avpos = rvpos;
                allButThis = this.fLeft;
            } else if (rightIsVisible) {
                lvpos = rvpos = this.realToVirtualPosition('R', this.fRight.getSourceViewer().getTopIndex());
                avpos = rvpos;
                allButThis = this.fRight;
            } else if (ancestorIsVisible) {
                lvpos = rvpos = this.realToVirtualPosition('A', this.fAncestor.getSourceViewer().getTopIndex());
                avpos = rvpos;
                allButThis = this.fAncestor;
            } else {
                int delta;
                int vpos = 0;
                Iterator iterator = this.fMerger.rangesIterator();
                while (iterator.hasNext()) {
                    DocumentMerger.Diff diff = (DocumentMerger.Diff)iterator.next();
                    if (diff == d) break;
                    if (this.fSynchronizedScrolling) {
                        vpos += diff.getMaxDiffHeight();
                        continue;
                    }
                    avpos += diff.getAncestorHeight();
                    lvpos += diff.getLeftHeight();
                    rvpos += diff.getRightHeight();
                }
                if (this.fSynchronizedScrolling) {
                    lvpos = rvpos = vpos;
                    avpos = rvpos;
                }
                if ((avpos -= (delta = this.fRight.getViewportLines() / 4)) < 0) {
                    avpos = 0;
                }
                if ((lvpos -= delta) < 0) {
                    lvpos = 0;
                }
                if ((rvpos -= delta) < 0) {
                    rvpos = 0;
                }
            }
            this.scrollVertical(avpos, lvpos, rvpos, allButThis);
            if (this.fVScrollBar != null) {
                this.fVScrollBar.setSelection(avpos);
            }
        }
        if (d.isToken()) {
            TextMergeViewer.reveal(this.fAncestor, d.getPosition('A'));
            TextMergeViewer.reveal(this.fLeft, d.getPosition('L'));
            TextMergeViewer.reveal(this.fRight, d.getPosition('R'));
        } else {
            TextMergeViewer.hscroll(this.fAncestor);
            TextMergeViewer.hscroll(this.fLeft);
            TextMergeViewer.hscroll(this.fRight);
        }
    }

    private static void reveal(MergeSourceViewer v, Position p) {
        Rectangle r;
        StyledText st;
        if (v != null && p != null && (st = v.getSourceViewer().getTextWidget()) != null && !(r = st.getClientArea()).isEmpty()) {
            v.getSourceViewer().revealRange(p.offset, p.length);
        }
    }

    private static void hscroll(MergeSourceViewer v) {
        StyledText st;
        if (v != null && (st = v.getSourceViewer().getTextWidget()) != null) {
            st.setHorizontalIndex(0);
        }
    }

    void copyAllUnresolved(boolean leftToRight) {
        if (this.fMerger.hasChanges() && this.isThreeWay() && !this.isIgnoreAncestor()) {
            IRewriteTarget target = leftToRight ? this.fRight.getSourceViewer().getRewriteTarget() : this.fLeft.getSourceViewer().getRewriteTarget();
            boolean compoundChangeStarted = false;
            try {
                Iterator iterator = this.fMerger.changesIterator();
                while (iterator.hasNext()) {
                    DocumentMerger.Diff diff = (DocumentMerger.Diff)iterator.next();
                    switch (diff.getKind()) {
                        case 3: {
                            if (!leftToRight) break;
                            if (!compoundChangeStarted) {
                                target.beginCompoundChange();
                                compoundChangeStarted = true;
                            }
                            this.copy(diff, leftToRight);
                            break;
                        }
                        case 2: {
                            if (leftToRight) break;
                            if (!compoundChangeStarted) {
                                target.beginCompoundChange();
                                compoundChangeStarted = true;
                            }
                            this.copy(diff, leftToRight);
                            break;
                        }
                    }
                }
            }
            finally {
                if (compoundChangeStarted) {
                    target.endCompoundChange();
                }
            }
        }
    }

    @Override
    protected void copy(boolean leftToRight) {
        if (!this.validateChange(!leftToRight)) {
            return;
        }
        if (this.showResolveUI()) {
            this.copyAllUnresolved(leftToRight);
            this.invalidateLines();
            return;
        }
        this.copyOperationInProgress = true;
        if (leftToRight) {
            if (this.fLeft.getEnabled()) {
                String text = this.fLeft.getSourceViewer().getTextWidget().getText();
                this.fRight.getSourceViewer().getTextWidget().setText(text);
                this.fRight.setEnabled(true);
            } else {
                this.fRight.getSourceViewer().getTextWidget().setText("");
                this.fRight.setEnabled(false);
            }
            this.fRightLineCount = this.fRight.getLineCount();
            this.setRightDirty(true);
        } else {
            if (this.fRight.getEnabled()) {
                String text = this.fRight.getSourceViewer().getTextWidget().getText();
                this.fLeft.getSourceViewer().getTextWidget().setText(text);
                this.fLeft.setEnabled(true);
            } else {
                this.fLeft.getSourceViewer().getTextWidget().setText("");
                this.fLeft.setEnabled(false);
            }
            this.fLeftLineCount = this.fLeft.getLineCount();
            this.setLeftDirty(true);
        }
        this.copyOperationInProgress = false;
        this.update(false);
        this.selectFirstDiff(true);
    }

    private void historyNotification(OperationHistoryEvent event) {
        switch (event.getEventType()) {
            case 5: {
                if (!this.copyOperationInProgress) break;
                this.copyUndoable = event.getOperation();
                break;
            }
            case 10: {
                if (this.copyUndoable != event.getOperation()) break;
                this.update(false);
                break;
            }
        }
    }

    private void copyDiffLeftToRight() {
        this.copy(this.fCurrentDiff, true, false);
    }

    private void copyDiffRightToLeft() {
        this.copy(this.fCurrentDiff, false, false);
    }

    private void copy(DocumentMerger.Diff diff, boolean leftToRight, boolean gotoNext) {
        if (this.copy(diff, leftToRight)) {
            if (gotoNext) {
                this.navigate(true, true, false);
            } else {
                this.revealDiff(diff, true);
                this.updateControls();
            }
        }
    }

    private boolean copy(DocumentMerger.Diff diff, boolean leftToRight) {
        if (diff != null) {
            if (!this.validateChange(!leftToRight)) {
                return false;
            }
            if (leftToRight) {
                this.fRight.setEnabled(true);
            } else {
                this.fLeft.setEnabled(true);
            }
            boolean result = this.fMerger.copy(diff, leftToRight);
            if (result) {
                this.updateResolveStatus();
            }
            return result;
        }
        return false;
    }

    private boolean validateChange(boolean left) {
        ContributorInfo info = left ? this.fLeftContributor : this.fRightContributor;
        return info.validateChange();
    }

    private int getViewportHeight() {
        StyledText te = this.fLeft.getSourceViewer().getTextWidget();
        int vh = te.getClientArea().height;
        if (vh == 0) {
            Rectangle trim = te.computeTrim(0, 0, 0, 0);
            int scrollbarHeight = trim.height;
            int headerHeight = this.getHeaderHeight();
            Composite composite = (Composite)this.getControl();
            Rectangle r = composite.getClientArea();
            vh = r.height - headerHeight - scrollbarHeight;
        }
        return vh / te.getLineHeight();
    }

    private int realToVirtualPosition(char contributor, int vpos) {
        if (!this.fSynchronizedScrolling) {
            return vpos;
        }
        return this.fMerger.realToVirtualPosition(contributor, vpos);
    }

    private void scrollVertical(int avpos, int lvpos, int rvpos, MergeSourceViewer allBut) {
        Control center;
        int y;
        int s = 0;
        if (this.fSynchronizedScrolling) {
            s = this.fMerger.getVirtualHeight() - rvpos;
            int height = this.fRight.getViewportLines() / 4;
            if (s < 0) {
                s = 0;
            }
            if (s > height) {
                s = height;
            }
        }
        this.fInScrolling = true;
        if (this.isThreeWay() && allBut != this.fAncestor && (this.fSynchronizedScrolling || allBut == null)) {
            y = this.virtualToRealPosition('A', avpos + s) - s;
            this.fAncestor.vscroll(y);
        }
        if (allBut != this.fLeft && (this.fSynchronizedScrolling || allBut == null)) {
            y = this.virtualToRealPosition('L', lvpos + s) - s;
            this.fLeft.vscroll(y);
        }
        if (allBut != this.fRight && (this.fSynchronizedScrolling || allBut == null)) {
            y = this.virtualToRealPosition('R', rvpos + s) - s;
            this.fRight.vscroll(y);
        }
        this.fInScrolling = false;
        if (this.isThreeWay() && this.fAncestorCanvas != null) {
            this.fAncestorCanvas.repaint();
        }
        if (this.fLeftCanvas != null) {
            this.fLeftCanvas.repaint();
        }
        if ((center = this.getCenterControl()) instanceof BufferedCanvas) {
            ((BufferedCanvas)center).repaint();
        }
        if (this.fRightCanvas != null) {
            this.fRightCanvas.repaint();
        }
    }

    private void syncViewport(MergeSourceViewer w) {
        if (this.fInScrolling) {
            return;
        }
        int ix = w.getSourceViewer().getTopIndex();
        int ix2 = w.getDocumentRegionOffset();
        int viewPosition = this.realToVirtualPosition(this.getLeg(w), ix - ix2);
        this.scrollVertical(viewPosition, viewPosition, viewPosition, w);
        if (this.fVScrollBar != null) {
            int value = Math.max(0, Math.min(viewPosition, this.fMerger.getVirtualHeight() - this.getViewportHeight()));
            this.fVScrollBar.setSelection(value);
        }
    }

    private void updateVScrollBar() {
        if (Utilities.okToUse((Widget)this.fVScrollBar) && this.fSynchronizedScrolling) {
            int virtualHeight = this.fMerger.getVirtualHeight();
            int viewPortHeight = this.getViewportHeight();
            int pageIncrement = viewPortHeight - 1;
            int thumb = viewPortHeight > virtualHeight ? virtualHeight : viewPortHeight;
            this.fVScrollBar.setPageIncrement(pageIncrement);
            this.fVScrollBar.setMaximum(virtualHeight);
            this.fVScrollBar.setThumb(thumb);
        }
    }

    private int virtualToRealPosition(char contributor, int v) {
        if (!this.fSynchronizedScrolling) {
            return v;
        }
        return this.fMerger.virtualToRealPosition(contributor, v);
    }

    @Override
    void flushLeftSide(Object oldInput, IProgressMonitor monitor) {
        IMergeViewerContentProvider content = this.getMergeContentProvider();
        Object leftContent = content.getLeftContent(oldInput);
        if (leftContent != null && this.isLeftEditable() && this.isLeftDirty() && this.fLeftContributor.hasSharedDocument(leftContent) && this.flush(this.fLeftContributor)) {
            this.setLeftDirty(false);
        }
        if (!(content instanceof MergeViewerContentProvider) || this.isLeftDirty()) {
            super.flushLeftSide(oldInput, monitor);
        }
    }

    @Override
    void flushRightSide(Object oldInput, IProgressMonitor monitor) {
        IMergeViewerContentProvider content = this.getMergeContentProvider();
        Object rightContent = content.getRightContent(oldInput);
        if (rightContent != null && this.isRightEditable() && this.isRightDirty() && this.fRightContributor.hasSharedDocument(rightContent) && this.flush(this.fRightContributor)) {
            this.setRightDirty(false);
        }
        if (!(content instanceof MergeViewerContentProvider) || this.isRightDirty()) {
            super.flushRightSide(oldInput, monitor);
        }
    }

    @Override
    protected void flushContent(Object oldInput, IProgressMonitor monitor) {
        this.flushLeftSide(oldInput, monitor);
        this.flushRightSide(oldInput, monitor);
        IMergeViewerContentProvider content = this.getMergeContentProvider();
        if (!(content instanceof MergeViewerContentProvider) || this.isLeftDirty() || this.isRightDirty()) {
            super.flushContent(oldInput, monitor);
        }
    }

    private boolean flush(ContributorInfo info) {
        try {
            return info.flush();
        }
        catch (CoreException e) {
            this.handleException(e);
            return false;
        }
    }

    private void handleException(Throwable throwable) {
        if (throwable instanceof InvocationTargetException) {
            InvocationTargetException ite = (InvocationTargetException)throwable;
            this.handleException(ite.getTargetException());
            return;
        }
        CompareUIPlugin.log(throwable);
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter == IMergeViewerTestAdapter.class) {
            return (T)new IMergeViewerTestAdapter(){

                @Override
                public IDocument getDocument(char leg) {
                    switch (leg) {
                        case 'L': {
                            return TextMergeViewer.this.fLeft.getSourceViewer().getDocument();
                        }
                        case 'R': {
                            return TextMergeViewer.this.fRight.getSourceViewer().getDocument();
                        }
                        case 'A': {
                            return TextMergeViewer.this.fAncestor.getSourceViewer().getDocument();
                        }
                    }
                    return null;
                }

                @Override
                public int getChangesCount() {
                    return TextMergeViewer.this.fMerger.changesCount();
                }
            };
        }
        if (adapter == OutlineViewerCreator.class) {
            if (this.fOutlineViewerCreator == null) {
                this.fOutlineViewerCreator = new InternalOutlineViewerCreator();
            }
            return (T)this.fOutlineViewerCreator;
        }
        if (adapter == IFindReplaceTarget.class) {
            return (T)this.getFindReplaceTarget();
        }
        if (adapter == CompareHandlerService.class) {
            return (T)this.fHandlerService;
        }
        if (adapter == CompareHandlerService[].class) {
            return (T)new CompareHandlerService[]{this.fHandlerService, super.getCompareHandlerService()};
        }
        if (adapter == IEditorInput.class) {
            if (this.fLeft != null && this.fLeft == this.fFocusPart && this.fLeftContributor != null) {
                return (T)this.fLeftContributor.getDocumentKey();
            }
            if (this.fRight != null && this.fRight == this.fFocusPart && this.fRightContributor != null) {
                return (T)this.fRightContributor.getDocumentKey();
            }
            if (this.fAncestor != null && this.fAncestor == this.fFocusPart && this.fAncestorContributor != null) {
                return (T)this.fAncestorContributor.getDocumentKey();
            }
        }
        return null;
    }

    @Override
    protected void handleCompareInputChange() {
        try {
            this.beginRefresh();
            super.handleCompareInputChange();
        }
        finally {
            this.endRefresh();
        }
    }

    private void beginRefresh() {
        ++this.isRefreshing;
        this.fLeftContributor.cacheSelection(this.fLeft);
        this.fRightContributor.cacheSelection(this.fRight);
        this.fAncestorContributor.cacheSelection(this.fAncestor);
        if (this.fSynchronizedScrolling) {
            this.fSynchronziedScrollPosition = this.fVScrollBar.getSelection();
        }
    }

    private void endRefresh() {
        --this.isRefreshing;
        this.fLeftContributor.cacheSelection(null);
        this.fRightContributor.cacheSelection(null);
        this.fAncestorContributor.cacheSelection(null);
        this.fSynchronziedScrollPosition = -1;
    }

    private void synchronizedScrollVertical(int vpos) {
        this.scrollVertical(vpos, vpos, vpos, null);
    }

    private boolean isIgnoreAncestor() {
        return Utilities.getBoolean(this.getCompareConfiguration(), ICompareUIConstants.PROP_IGNORE_ANCESTOR, false);
    }

    void update(boolean includeControls) {
        if (this.getControl().isDisposed()) {
            return;
        }
        if (this.fHasErrors) {
            this.resetDiffs();
        } else {
            this.doDiff();
        }
        if (includeControls) {
            this.updateControls();
        }
        this.updateVScrollBar();
        this.updatePresentation();
    }

    private void resetDiffs() {
        this.saveDiff();
        this.fCurrentDiff = null;
        this.fMerger.reset();
        this.resetPositions(this.fLeft.getSourceViewer().getDocument());
        this.resetPositions(this.fRight.getSourceViewer().getDocument());
        this.resetPositions(this.fAncestor.getSourceViewer().getDocument());
    }

    private boolean isPatchHunk() {
        return Utilities.isHunk(this.getInput());
    }

    private boolean isPatchHunkOk() {
        if (this.isPatchHunk()) {
            return Utilities.isHunkOk(this.getInput());
        }
        return false;
    }

    private int getHunkStart() {
        Object input = this.getInput();
        if (input != null && input instanceof DiffNode) {
            Object element;
            Object element2;
            ITypedElement right = ((DiffNode)input).getRight();
            if (right != null && (element2 = Adapters.adapt((Object)right, IHunk.class)) instanceof IHunk) {
                return ((IHunk)element2).getStartPosition();
            }
            ITypedElement left = ((DiffNode)input).getLeft();
            if (left != null && (element = Adapters.adapt((Object)left, IHunk.class)) instanceof IHunk) {
                return ((IHunk)element).getStartPosition();
            }
        }
        return 0;
    }

    private IFindReplaceTarget getFindReplaceTarget() {
        if (this.fFindReplaceTarget == null) {
            this.fFindReplaceTarget = new FindReplaceTarget();
        }
        return this.fFindReplaceTarget;
    }

    char getLeg(MergeSourceViewer w) {
        if (w == this.fLeft) {
            return 'L';
        }
        if (w == this.fRight) {
            return 'R';
        }
        if (w == this.fAncestor) {
            return 'A';
        }
        return 'A';
    }

    private boolean isCurrentDiff(DocumentMerger.Diff diff) {
        if (diff == null) {
            return false;
        }
        if (diff == this.fCurrentDiff) {
            return true;
        }
        return this.fCurrentDiff != null && this.fCurrentDiff.getParent() == diff;
    }

    private boolean isNavigationPossible() {
        if (this.fCurrentDiff == null && this.fMerger.hasChanges()) {
            return true;
        }
        if (this.fMerger.changesCount() > 1) {
            return true;
        }
        if (this.fCurrentDiff != null && this.fCurrentDiff.hasChildren()) {
            return true;
        }
        return this.fCurrentDiff != null && this.fCurrentDiff.isToken();
    }

    private ITextEditor getTextEditorAdapter() {
        return new ITextEditor(){

            public void close(boolean save) {
            }

            public void doRevertToSaved() {
            }

            public IAction getAction(String actionId) {
                return null;
            }

            public IDocumentProvider getDocumentProvider() {
                return null;
            }

            public IRegion getHighlightRange() {
                return null;
            }

            public ISelectionProvider getSelectionProvider() {
                return null;
            }

            public boolean isEditable() {
                return false;
            }

            public void removeActionActivationCode(String actionId) {
            }

            public void resetHighlightRange() {
            }

            public void selectAndReveal(int offset, int length) {
            }

            public void setAction(String actionId, IAction action) {
            }

            public void setActionActivationCode(String actionId, char activationCharacter, int activationKeyCode, int activationStateMask) {
            }

            public void setHighlightRange(int offset, int length, boolean moveCursor) {
            }

            public void showHighlightRangeOnly(boolean showHighlightRangeOnly) {
            }

            public boolean showsHighlightRangeOnly() {
                return false;
            }

            public IEditorInput getEditorInput() {
                if (TextMergeViewer.this.fFocusPart == TextMergeViewer.this.fAncestor && TextMergeViewer.this.fAncestorContributor != null) {
                    return TextMergeViewer.this.fAncestorContributor.getDocumentKey();
                }
                if (TextMergeViewer.this.fFocusPart == TextMergeViewer.this.fLeft && TextMergeViewer.this.fLeftContributor != null) {
                    return TextMergeViewer.this.fLeftContributor.getDocumentKey();
                }
                if (TextMergeViewer.this.fFocusPart == TextMergeViewer.this.fRight && TextMergeViewer.this.fRightContributor != null) {
                    return TextMergeViewer.this.fRightContributor.getDocumentKey();
                }
                return null;
            }

            public IEditorSite getEditorSite() {
                return null;
            }

            public void init(IEditorSite site, IEditorInput input) throws PartInitException {
            }

            public void addPropertyListener(IPropertyListener listener) {
            }

            public void createPartControl(Composite parent) {
            }

            public void dispose() {
            }

            public IWorkbenchPartSite getSite() {
                return new IWorkbenchPartSite(){

                    public String getId() {
                        return null;
                    }

                    @Deprecated
                    public IKeyBindingService getKeyBindingService() {
                        return null;
                    }

                    public IWorkbenchPart getPart() {
                        return null;
                    }

                    public String getPluginId() {
                        return null;
                    }

                    public String getRegisteredName() {
                        return null;
                    }

                    public void registerContextMenu(MenuManager menuManager, ISelectionProvider selectionProvider) {
                    }

                    public void registerContextMenu(String menuId, MenuManager menuManager, ISelectionProvider selectionProvider) {
                    }

                    public IWorkbenchPage getPage() {
                        return null;
                    }

                    public ISelectionProvider getSelectionProvider() {
                        return null;
                    }

                    public Shell getShell() {
                        return (this).TextMergeViewer.this.fComposite.getShell();
                    }

                    public IWorkbenchWindow getWorkbenchWindow() {
                        return null;
                    }

                    public void setSelectionProvider(ISelectionProvider provider) {
                    }

                    public <T> T getAdapter(Class<T> adapter) {
                        return null;
                    }

                    public <T> T getService(Class<T> api) {
                        return null;
                    }

                    public boolean hasService(Class<?> api) {
                        return false;
                    }
                };
            }

            public String getTitle() {
                return null;
            }

            public Image getTitleImage() {
                return null;
            }

            public String getTitleToolTip() {
                return null;
            }

            public void removePropertyListener(IPropertyListener listener) {
            }

            public void setFocus() {
            }

            public <T> T getAdapter(Class<T> adapter) {
                if (adapter == IEncodingSupport.class) {
                    if (TextMergeViewer.this.fFocusPart == TextMergeViewer.this.fAncestor) {
                        return (T)this.getEncodingSupport(TextMergeViewer.this.fAncestorContributor);
                    }
                    if (TextMergeViewer.this.fFocusPart == TextMergeViewer.this.fLeft) {
                        return (T)this.getEncodingSupport(TextMergeViewer.this.fLeftContributor);
                    }
                    if (TextMergeViewer.this.fFocusPart == TextMergeViewer.this.fRight) {
                        return (T)this.getEncodingSupport(TextMergeViewer.this.fRightContributor);
                    }
                }
                return null;
            }

            private IEncodingSupport getEncodingSupport(ContributorInfo contributor) {
                if (contributor != null && contributor.getDefaultEncoding() != null) {
                    return contributor;
                }
                return null;
            }

            public void doSave(IProgressMonitor monitor) {
            }

            public void doSaveAs() {
            }

            public boolean isDirty() {
                if (TextMergeViewer.this.fFocusPart == TextMergeViewer.this.fLeft) {
                    return TextMergeViewer.this.isLeftDirty();
                }
                if (TextMergeViewer.this.fFocusPart == TextMergeViewer.this.fRight) {
                    return TextMergeViewer.this.isRightDirty();
                }
                return false;
            }

            public boolean isSaveAsAllowed() {
                return false;
            }

            public boolean isSaveOnCloseNeeded() {
                return false;
            }
        };
    }

    private void updateStructure() {
        this.getCompareConfiguration().setProperty("ALL_STRUCTURE_REFRESH", null);
    }

    private void updateStructure(char leg) {
        String key = null;
        switch (leg) {
            case 'A': {
                key = "ANCESTOR_STRUCTURE_REFRESH";
                break;
            }
            case 'L': {
                key = "LEFT_STRUCTURE_REFRESH";
                break;
            }
            case 'R': {
                key = "RIGHT_STRUCTURE_REFRESH";
                break;
            }
        }
        Assert.isNotNull((Object)key);
        this.getCompareConfiguration().setProperty(key, null);
    }

    private class ChangeHighlighter
    implements ITextPresentationListener {
        private final MergeSourceViewer viewer;

        public ChangeHighlighter(MergeSourceViewer viewer) {
            this.viewer = viewer;
        }

        public void applyTextPresentation(TextPresentation textPresentation) {
            if (!TextMergeViewer.this.fHighlightTokenChanges) {
                return;
            }
            IRegion region = textPresentation.getExtent();
            DocumentMerger.Diff[] changeDiffs = TextMergeViewer.this.fMerger.getChangeDiffs(TextMergeViewer.this.getLeg(this.viewer), region);
            int i = 0;
            while (i < changeDiffs.length) {
                DocumentMerger.Diff diff = changeDiffs[i];
                StyleRange range = this.getStyleRange(diff, region);
                if (range != null) {
                    textPresentation.mergeStyleRange(range);
                }
                ++i;
            }
        }

        private StyleRange getStyleRange(DocumentMerger.Diff diff, IRegion region) {
            int regionEnd;
            Color cTextFill = TextMergeViewer.this.getColor(null, this.getTextFillColor(diff));
            if (cTextFill == null) {
                return null;
            }
            Position p = diff.getPosition(TextMergeViewer.this.getLeg(this.viewer));
            int start = p.getOffset();
            int length = p.getLength();
            if (start < region.getOffset()) {
                length -= region.getOffset() - start;
                start = region.getOffset();
            }
            if (start + length > (regionEnd = region.getOffset() + region.getLength())) {
                length = regionEnd - start;
            }
            if (length < 0) {
                return null;
            }
            return new StyleRange(start, length, null, cTextFill);
        }

        private RGB getTextFillColor(DocumentMerger.Diff diff) {
            if (TextMergeViewer.this.isThreeWay() && !TextMergeViewer.this.isIgnoreAncestor()) {
                switch (diff.getKind()) {
                    case 2: {
                        return TextMergeViewer.this.getCompareConfiguration().isMirrored() ? TextMergeViewer.this.OUTGOING_TEXT_FILL : TextMergeViewer.this.INCOMING_TEXT_FILL;
                    }
                    case 1: 
                    case 4: {
                        return TextMergeViewer.this.CONFLICT_TEXT_FILL;
                    }
                    case 3: {
                        return TextMergeViewer.this.getCompareConfiguration().isMirrored() ? TextMergeViewer.this.INCOMING_TEXT_FILL : TextMergeViewer.this.OUTGOING_TEXT_FILL;
                    }
                }
                return null;
            }
            return TextMergeViewer.this.OUTGOING_TEXT_FILL;
        }
    }

    class ChildPositionUpdater
    extends DefaultPositionUpdater {
        protected ChildPositionUpdater(String category) {
            super(category);
        }

        protected boolean notDeleted() {
            return true;
        }

        protected void adaptToInsert() {
            if (this.fPosition == TextMergeViewer.this.fLeft.getRegion() || this.fPosition == TextMergeViewer.this.fRight.getRegion()) {
                int myStart = this.fPosition.offset;
                int myEnd = this.fPosition.offset + this.fPosition.length;
                myEnd = Math.max(myStart, myEnd);
                int yoursStart = this.fOffset;
                int yoursEnd = this.fOffset + this.fReplaceLength - 1;
                yoursEnd = Math.max(yoursStart, yoursEnd);
                if (myEnd < yoursStart) {
                    return;
                }
                if (myStart <= yoursStart) {
                    this.fPosition.length += this.fReplaceLength;
                } else {
                    this.fPosition.offset += this.fReplaceLength;
                }
            } else {
                super.adaptToInsert();
            }
        }
    }

    class ContributorInfo
    implements IElementStateListener,
    VerifyListener,
    IDocumentListener,
    IEncodingSupport {
        private final TextMergeViewer fViewer;
        private final Object fElement;
        private char fLeg;
        private String fEncoding;
        private IDocumentProvider fDocumentProvider;
        private IEditorInput fDocumentKey;
        private ISelection fSelection;
        private int fTopIndex = -1;
        private boolean fNeedsValidation = false;
        private MergeSourceViewer fSourceViewer;

        public ContributorInfo(TextMergeViewer viewer, Object element, char leg) {
            this.fViewer = viewer;
            this.fElement = element;
            this.fLeg = leg;
            if (this.fElement instanceof IEncodedStreamContentAccessor) {
                try {
                    this.fEncoding = ((IEncodedStreamContentAccessor)this.fElement).getCharset();
                }
                catch (CoreException coreException) {}
            }
        }

        public void setEncoding(String encoding) {
            if (this.fDocumentKey == null || this.fDocumentProvider == null) {
                return;
            }
            if (this.fDocumentProvider instanceof IStorageDocumentProvider) {
                IStorageDocumentProvider provider = (IStorageDocumentProvider)this.fDocumentProvider;
                String current = provider.getEncoding((Object)this.fDocumentKey);
                boolean dirty = this.fDocumentProvider.canSaveDocument((Object)this.fDocumentKey);
                if (!dirty) {
                    String internal;
                    String string = internal = encoding == null ? "" : encoding;
                    if (!internal.equals(current)) {
                        provider.setEncoding((Object)this.fDocumentKey, encoding);
                        try {
                            try {
                                this.fDocumentProvider.resetDocument((Object)this.fDocumentKey);
                            }
                            catch (CoreException e) {
                                CompareUIPlugin.log(e);
                                TextMergeViewer.this.update(true);
                                TextMergeViewer.this.updateStructure(this.fLeg);
                            }
                        }
                        finally {
                            TextMergeViewer.this.update(true);
                            TextMergeViewer.this.updateStructure(this.fLeg);
                        }
                    }
                }
            }
        }

        public String getEncoding() {
            if (this.fDocumentProvider != null && this.fDocumentKey != null && this.fDocumentProvider instanceof IStorageDocumentProvider) {
                IStorageDocumentProvider provider = (IStorageDocumentProvider)this.fDocumentProvider;
                return provider.getEncoding((Object)this.fDocumentKey);
            }
            return null;
        }

        public String getDefaultEncoding() {
            if (this.fDocumentProvider != null && this.fDocumentKey != null && this.fDocumentProvider instanceof IStorageDocumentProvider) {
                IStorageDocumentProvider provider = (IStorageDocumentProvider)this.fDocumentProvider;
                return provider.getDefaultEncoding();
            }
            return null;
        }

        private String internalGetEncoding() {
            if (this.fElement instanceof IEncodedStreamContentAccessor) {
                try {
                    this.fEncoding = ((IEncodedStreamContentAccessor)this.fElement).getCharset();
                }
                catch (CoreException coreException) {}
            }
            if (this.fEncoding != null) {
                return this.fEncoding;
            }
            return ResourcesPlugin.getEncoding();
        }

        public void setEncodingIfAbsent(ContributorInfo otherContributor) {
            if (this.fEncoding == null) {
                this.fEncoding = otherContributor.fEncoding;
            }
        }

        public IDocument getDocument() {
            IDocument document;
            if (this.fDocumentProvider != null && (document = this.fDocumentProvider.getDocument((Object)this.getDocumentKey())) != null) {
                return document;
            }
            if (this.fElement instanceof IDocument) {
                return (IDocument)this.fElement;
            }
            if (this.fElement instanceof IDocumentRange) {
                return ((IDocumentRange)this.fElement).getDocument();
            }
            if (this.fElement instanceof IStreamContentAccessor) {
                return DocumentManager.get(this.fElement);
            }
            return null;
        }

        public void setDocument(MergeSourceViewer viewer, boolean isEditable) {
            Assert.isTrue((this.fSourceViewer == null ? 1 : 0) != 0);
            this.fSourceViewer = viewer;
            try {
                this.internalSetDocument(viewer);
            }
            catch (RuntimeException e) {
                this.clearCachedDocument();
                throw e;
            }
            TextMergeViewer.this.setEditable((ISourceViewer)viewer.getSourceViewer(), isEditable);
            if (isEditable) {
                this.fNeedsValidation = true;
                viewer.getSourceViewer().getTextWidget().addVerifyListener((VerifyListener)this);
            }
        }

        private boolean internalSetDocument(MergeSourceViewer tp) {
            IDocument oldDoc;
            if (tp == null) {
                return false;
            }
            IDocument newDocument = null;
            Position range = null;
            if (this.fElement instanceof IDocumentRange) {
                newDocument = ((IDocumentRange)this.fElement).getDocument();
                range = ((IDocumentRange)this.fElement).getRange();
                this.connectToSharedDocument();
            } else if (this.fElement instanceof IDocument) {
                newDocument = (IDocument)this.fElement;
                TextMergeViewer.this.setupDocument(newDocument);
            } else if (this.fElement instanceof IStreamContentAccessor) {
                newDocument = DocumentManager.get(this.fElement);
                if (newDocument == null) {
                    newDocument = this.createDocument();
                    DocumentManager.put(this.fElement, newDocument);
                    TextMergeViewer.this.setupDocument(newDocument);
                } else if (this.fDocumentProvider == null) {
                    this.connectToSharedDocument();
                }
            } else if (this.fElement == null) {
                ITypedElement parent = this.fViewer.getParent(this.fLeg);
                if (parent instanceof IDocumentRange) {
                    newDocument = ((IDocumentRange)((Object)parent)).getDocument();
                    newDocument.addPositionCategory(TextMergeViewer.DIFF_RANGE_CATEGORY);
                    Object input = this.fViewer.getInput();
                    range = this.fViewer.getNewRange(this.fLeg, input);
                    if (range == null) {
                        int pos = 0;
                        if (input instanceof ICompareInput) {
                            pos = this.fViewer.findInsertionPosition(this.fLeg, (ICompareInput)input);
                        }
                        range = new Position(pos, 0);
                        try {
                            newDocument.addPosition(TextMergeViewer.DIFF_RANGE_CATEGORY, range);
                        }
                        catch (BadPositionCategoryException badPositionCategoryException) {
                        }
                        catch (BadLocationException badLocationException) {
                            // empty catch block
                        }
                        this.fViewer.addNewRange(this.fLeg, input, range);
                    }
                } else if (parent instanceof IDocument) {
                    newDocument = ((IDocumentRange)this.fElement).getDocument();
                }
            }
            boolean enabled = true;
            if (newDocument == null) {
                newDocument = new Document("");
                enabled = false;
            }
            if (newDocument != (oldDoc = tp.getSourceViewer().getDocument())) {
                this.updateViewerDocument(tp, newDocument, range);
            } else {
                this.updateViewerDocumentRange(tp, range);
            }
            newDocument.addDocumentListener((IDocumentListener)this);
            tp.setEnabled(enabled);
            return enabled;
        }

        private void updateViewerDocumentRange(MergeSourceViewer tp, Position range) {
            tp.setRegion(range);
            if (this.fViewer.fSubDoc) {
                if (range != null) {
                    IRegion r = this.fViewer.normalizeDocumentRegion(tp.getSourceViewer().getDocument(), TextMergeViewer.toRegion(range));
                    tp.getSourceViewer().setVisibleRegion(r.getOffset(), r.getLength());
                } else {
                    tp.getSourceViewer().resetVisibleRegion();
                }
            } else {
                tp.getSourceViewer().resetVisibleRegion();
            }
        }

        private void updateViewerDocument(MergeSourceViewer tp, IDocument document, Position range) {
            this.unsetDocument(tp);
            if (document == null) {
                return;
            }
            this.connectPositionUpdater(document);
            tp.setRegion(range);
            SourceViewer sourceViewer = tp.getSourceViewer();
            sourceViewer.setRedraw(false);
            try {
                if (this.fViewer.fSubDoc && range != null) {
                    IRegion r = this.fViewer.normalizeDocumentRegion(document, TextMergeViewer.toRegion(range));
                    sourceViewer.setDocument(document, r.getOffset(), r.getLength());
                } else {
                    sourceViewer.setDocument(document);
                }
            }
            finally {
                sourceViewer.setRedraw(true);
            }
            tp.rememberDocument(document);
        }

        void connectPositionUpdater(IDocument document) {
            document.addPositionCategory(TextMergeViewer.DIFF_RANGE_CATEGORY);
            if (this.fViewer.fPositionUpdater == null) {
                TextMergeViewer textMergeViewer = this.fViewer;
                textMergeViewer.getClass();
                this.fViewer.fPositionUpdater = (IPositionUpdater)textMergeViewer.new ChildPositionUpdater(TextMergeViewer.DIFF_RANGE_CATEGORY);
            } else {
                document.removePositionUpdater(this.fViewer.fPositionUpdater);
            }
            document.addPositionUpdater(this.fViewer.fPositionUpdater);
        }

        private void unsetDocument(MergeSourceViewer tp) {
            IDocument oldDoc = this.internalGetDocument(tp);
            if (oldDoc != null) {
                tp.rememberDocument(null);
                try {
                    oldDoc.removePositionCategory(TextMergeViewer.DIFF_RANGE_CATEGORY);
                }
                catch (BadPositionCategoryException badPositionCategoryException) {}
                if (TextMergeViewer.this.fPositionUpdater != null) {
                    oldDoc.removePositionUpdater(TextMergeViewer.this.fPositionUpdater);
                }
                oldDoc.removeDocumentListener((IDocumentListener)this);
            }
        }

        private IDocument createDocument() {
            IDocument newDoc = this.connectToSharedDocument();
            if (newDoc == null) {
                IStreamContentAccessor sca = (IStreamContentAccessor)this.fElement;
                String s = null;
                try {
                    String encoding = this.internalGetEncoding();
                    s = Utilities.readString(sca, encoding);
                }
                catch (CoreException ex) {
                    this.fViewer.setError(this.fLeg, ex.getMessage());
                }
                newDoc = new Document(s != null ? s : "");
            }
            return newDoc;
        }

        private IDocument connectToSharedDocument() {
            IEditorInput key = this.getDocumentKey();
            if (key != null) {
                if (this.fDocumentProvider != null) {
                    return this.fDocumentProvider.getDocument((Object)key);
                }
                IDocumentProvider documentProvider = this.getDocumentProvider();
                if (documentProvider != null) {
                    try {
                        this.connect(documentProvider, key);
                        this.setCachedDocumentProvider(key, documentProvider);
                        IDocument newDoc = documentProvider.getDocument((Object)key);
                        this.fViewer.updateDirtyState(key, documentProvider, this.fLeg);
                        return newDoc;
                    }
                    catch (CoreException e) {
                        CompareUIPlugin.log(e);
                    }
                }
            }
            return null;
        }

        private void connect(IDocumentProvider documentProvider, IEditorInput input) throws CoreException {
            ISharedDocumentAdapter sda = (ISharedDocumentAdapter)Adapters.adapt((Object)this.fElement, ISharedDocumentAdapter.class);
            if (sda != null) {
                sda.connect(documentProvider, input);
            } else {
                documentProvider.connect((Object)input);
            }
        }

        private void disconnect(IDocumentProvider provider, IEditorInput input) {
            ISharedDocumentAdapter sda = (ISharedDocumentAdapter)Adapters.adapt((Object)this.fElement, ISharedDocumentAdapter.class);
            if (sda != null) {
                sda.disconnect(provider, input);
            } else {
                provider.disconnect((Object)input);
            }
        }

        private void setCachedDocumentProvider(IEditorInput key, IDocumentProvider documentProvider) {
            this.fDocumentKey = key;
            this.fDocumentProvider = documentProvider;
            documentProvider.addElementStateListener((IElementStateListener)this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void disconnect() {
            StyledText textWidget;
            IDocumentProvider provider = null;
            IEditorInput input = this.getDocumentKey();
            ContributorInfo contributorInfo = this;
            synchronized (contributorInfo) {
                if (this.fDocumentProvider != null) {
                    provider = this.fDocumentProvider;
                    this.fDocumentProvider = null;
                    this.fDocumentKey = null;
                }
            }
            if (provider != null) {
                this.disconnect(provider, input);
                provider.removeElementStateListener((IElementStateListener)this);
            }
            if (this.fSourceViewer != null && (textWidget = this.fSourceViewer.getSourceViewer().getTextWidget()) != null && !textWidget.isDisposed()) {
                IDocument oldDoc;
                if (this.fNeedsValidation) {
                    this.fSourceViewer.getSourceViewer().getTextWidget().removeVerifyListener((VerifyListener)this);
                    this.fNeedsValidation = false;
                }
                if ((oldDoc = this.internalGetDocument(this.fSourceViewer)) != null) {
                    oldDoc.removeDocumentListener((IDocumentListener)this);
                }
            }
            this.clearCachedDocument();
        }

        private void clearCachedDocument() {
            IDocument doc = DocumentManager.get(this.fElement);
            if (doc != null) {
                DocumentManager.remove(doc);
            }
        }

        private IDocument internalGetDocument(MergeSourceViewer tp) {
            IDocument oldDoc = tp.getSourceViewer().getDocument();
            if (oldDoc == null) {
                oldDoc = tp.getRememberedDocument();
            }
            return oldDoc;
        }

        private IEditorInput getDocumentKey() {
            ISharedDocumentAdapter sda;
            if (this.fDocumentKey != null) {
                return this.fDocumentKey;
            }
            if (this.isUsingDefaultContentProvider() && this.fElement != null && this.canHaveSharedDocument() && (sda = (ISharedDocumentAdapter)Adapters.adapt((Object)this.fElement, ISharedDocumentAdapter.class)) != null) {
                return sda.getDocumentKey(this.fElement);
            }
            return null;
        }

        private IDocumentProvider getDocumentProvider() {
            IEditorInput input;
            if (this.fDocumentProvider != null) {
                return this.fDocumentProvider;
            }
            if (this.isUsingDefaultContentProvider() && (input = this.getDocumentKey()) != null) {
                return SharedDocumentAdapter.getDocumentProvider(input);
            }
            return null;
        }

        private boolean isUsingDefaultContentProvider() {
            return this.fViewer.isUsingDefaultContentProvider();
        }

        private boolean canHaveSharedDocument() {
            return this.fViewer.canHaveSharedDocument();
        }

        boolean hasSharedDocument(Object object) {
            return this.fElement == object && this.fDocumentProvider != null && this.fDocumentProvider.getDocument((Object)this.getDocumentKey()) != null;
        }

        public boolean flush() throws CoreException {
            IEditorInput input;
            IDocument document;
            if (this.fDocumentProvider != null && (document = this.fDocumentProvider.getDocument((Object)(input = this.getDocumentKey()))) != null) {
                ISharedDocumentAdapter sda = (ISharedDocumentAdapter)Adapters.adapt((Object)this.fElement, ISharedDocumentAdapter.class);
                if (sda != null) {
                    sda.flushDocument(this.fDocumentProvider, input, document, false);
                    return true;
                }
                try {
                    this.fDocumentProvider.aboutToChange((Object)input);
                    this.fDocumentProvider.saveDocument((IProgressMonitor)new NullProgressMonitor(), (Object)input, document, false);
                    return true;
                }
                finally {
                    this.fDocumentProvider.changed((Object)input);
                }
            }
            return false;
        }

        public void elementMoved(Object originalElement, Object movedElement) {
            IEditorInput input = this.getDocumentKey();
            if (input != null && input.equals(originalElement)) {
                this.resetDocument();
            }
        }

        public void elementDirtyStateChanged(Object element, boolean isDirty) {
            if (!this.checkState()) {
                return;
            }
            IEditorInput input = this.getDocumentKey();
            if (input != null && input.equals(element)) {
                this.fViewer.updateDirtyState(input, this.getDocumentProvider(), this.fLeg);
            }
        }

        public void elementDeleted(Object element) {
            IEditorInput input = this.getDocumentKey();
            if (input != null && input.equals(element)) {
                this.resetDocument();
            }
        }

        private void resetDocument() {
            this.clearCachedDocument();
            if (this.checkState()) {
                this.fViewer.refresh();
            }
        }

        private boolean checkState() {
            if (this.fViewer == null) {
                return false;
            }
            Control control = this.fViewer.getControl();
            if (control == null) {
                return false;
            }
            return !control.isDisposed();
        }

        public void elementContentReplaced(Object element) {
            if (!this.checkState()) {
                return;
            }
            IEditorInput input = this.getDocumentKey();
            if (input != null && input.equals(element)) {
                this.fViewer.updateDirtyState(input, this.getDocumentProvider(), this.fLeg);
                new UIJob(CompareMessages.DocumentMerger_0){

                    public IStatus runInUIThread(IProgressMonitor monitor) {
                        TextMergeViewer.this.update(true);
                        TextMergeViewer.this.updateStructure(ContributorInfo.this.fLeg);
                        return Status.OK_STATUS;
                    }
                }.schedule();
            }
        }

        public void elementContentAboutToBeReplaced(Object element) {
        }

        public Object getElement() {
            return this.fElement;
        }

        public void cacheSelection(MergeSourceViewer viewer) {
            if (viewer == null) {
                this.fSelection = null;
                this.fTopIndex = -1;
            } else {
                this.fSelection = viewer.getSourceViewer().getSelection();
                this.fTopIndex = viewer.getSourceViewer().getTopIndex();
            }
        }

        public void updateSelection(MergeSourceViewer viewer, boolean includeScroll) {
            if (this.fSelection != null) {
                viewer.getSourceViewer().setSelection(this.fSelection);
            }
            if (includeScroll && this.fTopIndex != -1) {
                viewer.getSourceViewer().setTopIndex(this.fTopIndex);
            }
        }

        public void transferContributorStateFrom(ContributorInfo oldContributor) {
            if (oldContributor != null) {
                this.fSelection = oldContributor.fSelection;
                this.fTopIndex = oldContributor.fTopIndex;
                this.fEncoding = oldContributor.fEncoding;
            }
        }

        public boolean validateChange() {
            IStatus status;
            if (this.fElement == null) {
                return true;
            }
            if (this.fDocumentProvider instanceof IDocumentProviderExtension) {
                IDocumentProviderExtension ext = (IDocumentProviderExtension)this.fDocumentProvider;
                if (ext.isReadOnly((Object)this.fDocumentKey)) {
                    try {
                        ext.validateState((Object)this.fDocumentKey, (Object)TextMergeViewer.this.getControl().getShell());
                        ext.updateStateCache((Object)this.fDocumentKey);
                    }
                    catch (CoreException e) {
                        ErrorDialog.openError((Shell)TextMergeViewer.this.getControl().getShell(), (String)CompareMessages.TextMergeViewer_12, (String)CompareMessages.TextMergeViewer_13, (IStatus)e.getStatus());
                        return false;
                    }
                }
                return !ext.isReadOnly((Object)this.fDocumentKey);
            }
            IEditableContentExtension ext = (IEditableContentExtension)Adapters.adapt((Object)this.fElement, IEditableContentExtension.class);
            if (ext != null && ext.isReadOnly() && !(status = ext.validateEdit(TextMergeViewer.this.getControl().getShell())).isOK()) {
                if (status.getSeverity() == 4) {
                    ErrorDialog.openError((Shell)TextMergeViewer.this.getControl().getShell(), (String)CompareMessages.TextMergeViewer_14, (String)CompareMessages.TextMergeViewer_15, (IStatus)status);
                    return false;
                }
                if (status.getSeverity() == 8) {
                    return false;
                }
            }
            return true;
        }

        public void verifyText(VerifyEvent e) {
            if (!this.validateChange()) {
                e.doit = false;
            }
        }

        public void documentAboutToBeChanged(DocumentEvent e) {
        }

        public void documentChanged(DocumentEvent e) {
            boolean dirty = true;
            if (this.fDocumentProvider != null && this.fDocumentKey != null) {
                dirty = this.fDocumentProvider.canSaveDocument((Object)this.fDocumentKey);
            }
            TextMergeViewer.this.documentChanged(e, dirty);
            if (this.fNeedsValidation && this.fSourceViewer != null && !this.fSourceViewer.getSourceViewer().getTextWidget().isDisposed()) {
                this.fSourceViewer.getSourceViewer().getTextWidget().removeVerifyListener((VerifyListener)this);
                this.fNeedsValidation = false;
            }
        }
    }

    private class FindReplaceTarget
    implements IFindReplaceTarget,
    IFindReplaceTargetExtension,
    IFindReplaceTargetExtension2,
    IFindReplaceTargetExtension3 {
        private FindReplaceTarget() {
        }

        public boolean canPerformFind() {
            return TextMergeViewer.this.fFocusPart != null;
        }

        public int findAndSelect(int widgetOffset, String findString, boolean searchForward, boolean caseSensitive, boolean wholeWord) {
            return TextMergeViewer.this.fFocusPart.getSourceViewer().getFindReplaceTarget().findAndSelect(widgetOffset, findString, searchForward, caseSensitive, wholeWord);
        }

        public Point getSelection() {
            return TextMergeViewer.this.fFocusPart.getSourceViewer().getFindReplaceTarget().getSelection();
        }

        public String getSelectionText() {
            return TextMergeViewer.this.fFocusPart.getSourceViewer().getFindReplaceTarget().getSelectionText();
        }

        public boolean isEditable() {
            return TextMergeViewer.this.fFocusPart.getSourceViewer().getFindReplaceTarget().isEditable();
        }

        public void replaceSelection(String text) {
            TextMergeViewer.this.fFocusPart.getSourceViewer().getFindReplaceTarget().replaceSelection(text);
        }

        public int findAndSelect(int offset, String findString, boolean searchForward, boolean caseSensitive, boolean wholeWord, boolean regExSearch) {
            IFindReplaceTarget findReplaceTarget = TextMergeViewer.this.fFocusPart.getSourceViewer().getFindReplaceTarget();
            if (findReplaceTarget instanceof IFindReplaceTargetExtension3) {
                return ((IFindReplaceTargetExtension3)findReplaceTarget).findAndSelect(offset, findString, searchForward, caseSensitive, wholeWord, regExSearch);
            }
            if (!regExSearch && findReplaceTarget != null) {
                return findReplaceTarget.findAndSelect(offset, findString, searchForward, caseSensitive, wholeWord);
            }
            return -1;
        }

        public void replaceSelection(String text, boolean regExReplace) {
            IFindReplaceTarget findReplaceTarget = TextMergeViewer.this.fFocusPart.getSourceViewer().getFindReplaceTarget();
            if (findReplaceTarget instanceof IFindReplaceTargetExtension3) {
                ((IFindReplaceTargetExtension3)findReplaceTarget).replaceSelection(text, regExReplace);
                return;
            }
            if (!regExReplace && findReplaceTarget != null) {
                findReplaceTarget.replaceSelection(text);
            }
        }

        public boolean validateTargetState() {
            IFindReplaceTarget findReplaceTarget = TextMergeViewer.this.fFocusPart.getSourceViewer().getFindReplaceTarget();
            if (findReplaceTarget instanceof IFindReplaceTargetExtension2) {
                return ((IFindReplaceTargetExtension2)findReplaceTarget).validateTargetState();
            }
            return true;
        }

        public void beginSession() {
            IFindReplaceTarget findReplaceTarget = TextMergeViewer.this.fFocusPart.getSourceViewer().getFindReplaceTarget();
            if (findReplaceTarget instanceof IFindReplaceTargetExtension) {
                ((IFindReplaceTargetExtension)findReplaceTarget).beginSession();
            }
        }

        public void endSession() {
            IFindReplaceTarget findReplaceTarget = TextMergeViewer.this.fFocusPart.getSourceViewer().getFindReplaceTarget();
            if (findReplaceTarget instanceof IFindReplaceTargetExtension) {
                ((IFindReplaceTargetExtension)findReplaceTarget).endSession();
            }
        }

        public IRegion getScope() {
            IFindReplaceTarget findReplaceTarget = TextMergeViewer.this.fFocusPart.getSourceViewer().getFindReplaceTarget();
            if (findReplaceTarget instanceof IFindReplaceTargetExtension) {
                return ((IFindReplaceTargetExtension)findReplaceTarget).getScope();
            }
            return null;
        }

        public void setScope(IRegion scope) {
            IFindReplaceTarget findReplaceTarget = TextMergeViewer.this.fFocusPart.getSourceViewer().getFindReplaceTarget();
            if (findReplaceTarget instanceof IFindReplaceTargetExtension) {
                ((IFindReplaceTargetExtension)findReplaceTarget).setScope(scope);
            }
        }

        public Point getLineSelection() {
            IFindReplaceTarget findReplaceTarget = TextMergeViewer.this.fFocusPart.getSourceViewer().getFindReplaceTarget();
            if (findReplaceTarget instanceof IFindReplaceTargetExtension) {
                return ((IFindReplaceTargetExtension)findReplaceTarget).getLineSelection();
            }
            return null;
        }

        public void setSelection(int offset, int length) {
            IFindReplaceTarget findReplaceTarget = TextMergeViewer.this.fFocusPart.getSourceViewer().getFindReplaceTarget();
            if (findReplaceTarget instanceof IFindReplaceTargetExtension) {
                ((IFindReplaceTargetExtension)findReplaceTarget).setSelection(offset, length);
            }
        }

        public void setScopeHighlightColor(Color color) {
            IFindReplaceTarget findReplaceTarget = TextMergeViewer.this.fFocusPart.getSourceViewer().getFindReplaceTarget();
            if (findReplaceTarget instanceof IFindReplaceTargetExtension) {
                ((IFindReplaceTargetExtension)findReplaceTarget).setScopeHighlightColor(color);
            }
        }

        public void setReplaceAllMode(boolean replaceAll) {
            IFindReplaceTarget findReplaceTarget = TextMergeViewer.this.fFocusPart.getSourceViewer().getFindReplaceTarget();
            if (findReplaceTarget instanceof IFindReplaceTargetExtension) {
                ((IFindReplaceTargetExtension)findReplaceTarget).setReplaceAllMode(replaceAll);
            }
        }
    }

    class HeaderPainter
    implements PaintListener {
        private static final int INSET = 2;
        private RGB fIndicatorColor;
        private Color fSeparatorColor;

        public HeaderPainter() {
            this.fSeparatorColor = TextMergeViewer.this.fSummaryHeader.getDisplay().getSystemColor(18);
        }

        public boolean setColor(RGB color) {
            RGB oldColor = this.fIndicatorColor;
            this.fIndicatorColor = color;
            if (color == null) {
                return oldColor != null;
            }
            if (oldColor != null) {
                return !color.equals((Object)oldColor);
            }
            return true;
        }

        private void drawBevelRect(GC gc, int x, int y, int w, int h, Color topLeft, Color bottomRight) {
            gc.setForeground(topLeft);
            gc.drawLine(x, y, x + w - 1, y);
            gc.drawLine(x, y, x, y + h - 1);
            gc.setForeground(bottomRight);
            gc.drawLine(x + w, y, x + w, y + h);
            gc.drawLine(x, y + h, x + w, y + h);
        }

        public void paintControl(PaintEvent e) {
            Point s = TextMergeViewer.this.fSummaryHeader.getSize();
            if (this.fIndicatorColor != null) {
                Display d = TextMergeViewer.this.fSummaryHeader.getDisplay();
                e.gc.setBackground(TextMergeViewer.this.getColor(d, this.fIndicatorColor));
                int min = Math.min(s.x, s.y) - 4;
                Rectangle r = new Rectangle((s.x - min) / 2, (s.y - min) / 2, min, min);
                e.gc.fillRectangle(r);
                if (d != null) {
                    this.drawBevelRect(e.gc, r.x, r.y, r.width - 1, r.height - 1, d.getSystemColor(18), d.getSystemColor(20));
                }
                e.gc.setForeground(this.fSeparatorColor);
                e.gc.setLineWidth(0);
                e.gc.drawLine(1, s.y - 1, s.x - 1 - 1, s.y - 1);
            }
        }
    }

    class HoverResizer
    extends ContentMergeViewer.Resizer {
        Canvas fCanvas;

        public HoverResizer(Canvas c, int dir) {
            super(TextMergeViewer.this, (Control)c, dir);
            this.fCanvas = c;
        }

        @Override
        public void mouseMove(MouseEvent e) {
            if (!this.fIsDown && TextMergeViewer.this.fUseSingleLine && TextMergeViewer.this.isAnySideEditable() && TextMergeViewer.this.handleMouseMoveOverCenter(this.fCanvas, e.x, e.y)) {
                return;
            }
            super.mouseMove(e);
        }
    }

    private final class InternalOutlineViewerCreator
    extends OutlineViewerCreator
    implements ISelectionChangedListener {
        private InternalOutlineViewerCreator() {
        }

        @Override
        public Viewer findStructureViewer(Viewer oldViewer, ICompareInput input, Composite parent, CompareConfiguration configuration) {
            if (input != this.getInput()) {
                return null;
            }
            final Viewer v = CompareUI.findStructureViewer(oldViewer, input, parent, configuration);
            if (v != null) {
                v.getControl().addDisposeListener(new DisposeListener(){

                    public void widgetDisposed(DisposeEvent e) {
                        v.removeSelectionChangedListener((ISelectionChangedListener)InternalOutlineViewerCreator.this);
                    }
                });
                v.addSelectionChangedListener((ISelectionChangedListener)this);
            }
            return v;
        }

        @Override
        public boolean hasViewerFor(Object input) {
            return true;
        }

        public void selectionChanged(SelectionChangedEvent event) {
            IStructuredSelection ss;
            Object element;
            DocumentMerger.Diff diff;
            ISelection s = event.getSelection();
            if (s instanceof IStructuredSelection && (diff = this.findDiff(element = (ss = (IStructuredSelection)s).getFirstElement())) != null) {
                TextMergeViewer.this.setCurrentDiff(diff, true);
            }
        }

        private DocumentMerger.Diff findDiff(Object element) {
            if (element instanceof ICompareInput) {
                ICompareInput ci = (ICompareInput)element;
                Position p = this.getPosition(ci.getLeft());
                if (p != null) {
                    return this.findDiff(p, true);
                }
                p = this.getPosition(ci.getRight());
                if (p != null) {
                    return this.findDiff(p, false);
                }
            }
            return null;
        }

        private DocumentMerger.Diff findDiff(Position p, boolean left) {
            Iterator iterator = TextMergeViewer.this.fMerger.rangesIterator();
            while (iterator.hasNext()) {
                DocumentMerger.Diff diff = (DocumentMerger.Diff)iterator.next();
                Position diffPos = left ? diff.getPosition('L') : diff.getPosition('R');
                if (diffPos.offset + diffPos.length >= p.offset && diff.getKind() != 0) {
                    return diff;
                }
                if (diffPos.offset < p.offset) continue;
                return diff;
            }
            return null;
        }

        private Position getPosition(ITypedElement left) {
            if (left instanceof DocumentRangeNode) {
                DocumentRangeNode drn = (DocumentRangeNode)((Object)left);
                return drn.getRange();
            }
            return null;
        }

        @Override
        public Object getInput() {
            return TextMergeViewer.this.getInput();
        }
    }

    private static class LineNumberRulerToggleAction
    extends TextEditorPropertyAction {
        public LineNumberRulerToggleAction(String label, MergeSourceViewer[] viewers, String preferenceKey) {
            super(label, viewers, preferenceKey);
        }

        @Override
        protected boolean toggleState(boolean checked) {
            return true;
        }
    }
}

