/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.widgets.table.ui.nattable.internal;

import net.sourceforge.nattable.NatTable;
import org.eclipse.emf.edit.ui.dnd.LocalTransfer;
import org.eclipse.emf.facet.widgets.table.ui.internal.exported.ITableWidgetInternal;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;

public final class TableDragSourceListener
implements DragSourceListener {
    private ISelection selection;
    private final ITableWidgetInternal tableWidgetController;
    private final NatTable natTable;

    public TableDragSourceListener(ITableWidgetInternal tableWidgetController, NatTable natTable) {
        this.tableWidgetController = tableWidgetController;
        this.natTable = natTable;
    }

    public void dragStart(DragSourceEvent event) {
        this.selection = this.tableWidgetController.getSelection();
        event.doit = !this.selection.isEmpty() && this.natTable.getRegionLabelsByXY(event.x, event.y).hasLabel("BODY");
    }

    public void dragSetData(DragSourceEvent event) {
        if (this.selection instanceof IStructuredSelection) {
            if (LocalTransfer.getInstance().isSupportedType(event.dataType)) {
                event.data = this.selection;
            } else if (LocalSelectionTransfer.getTransfer().isSupportedType(event.dataType)) {
                LocalSelectionTransfer.getTransfer().setSelection(this.selection);
                event.data = this.selection;
            }
        } else {
            event.doit = false;
        }
    }

    public void dragFinished(DragSourceEvent event) {
        this.selection = null;
    }
}

