/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.dot.internal.ui.language.contentassist;

import java.util.Map;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.dot.internal.language.htmllabel.DotHtmlLabelHelper;
import org.eclipse.gef.dot.internal.language.htmllabel.HtmlAttr;
import org.eclipse.gef.dot.internal.language.htmllabel.HtmlTag;
import org.eclipse.gef.dot.internal.ui.language.contentassist.AbstractDotHtmlLabelProposalProvider;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.swt.graphics.Image;
import org.eclipse.xtext.Assignment;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.ui.editor.contentassist.ConfigurableCompletionProposal;
import org.eclipse.xtext.ui.editor.contentassist.ContentAssistContext;
import org.eclipse.xtext.ui.editor.contentassist.ICompletionProposalAcceptor;

public class DotHtmlLabelProposalProvider
extends AbstractDotHtmlLabelProposalProvider {
    @Override
    public void complete_HtmlTag(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        String parentName = null;
        parentName = model instanceof HtmlTag ? ((HtmlTag)model).getName() : DotHtmlLabelHelper.getRootTagKey();
        for (String tagName : (Set)DotHtmlLabelHelper.getValidTags().get(parentName)) {
            Image image;
            String proposal;
            String displayString = proposal = this.calculateProposalString(tagName);
            ICompletionProposal completionProposal = this.createCompletionProposal(proposal, displayString, image = null, context);
            if (!(completionProposal instanceof ConfigurableCompletionProposal)) continue;
            ConfigurableCompletionProposal configurableCompletionProposal = (ConfigurableCompletionProposal)completionProposal;
            int cursorPosition = this.calculateCursorPosition(displayString);
            String tagDescription = DotHtmlLabelHelper.getTagDescription((String)tagName);
            configurableCompletionProposal.setCursorPosition(cursorPosition);
            configurableCompletionProposal.setAdditionalProposalInfo((Object)tagDescription);
            acceptor.accept((ICompletionProposal)configurableCompletionProposal);
        }
    }

    @Override
    public void completeHtmlAttr_Name(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        super.completeHtmlAttr_Name(model, assignment, context, acceptor);
        if (model instanceof HtmlTag) {
            HtmlTag htmlTag = (HtmlTag)model;
            String htmlTagName = htmlTag.getName();
            Map validAttributes = DotHtmlLabelHelper.getValidAttributes();
            if (validAttributes.containsKey(htmlTagName)) {
                Set validAttributeNames = (Set)validAttributes.get(htmlTagName);
                for (String validAttributeName : validAttributeNames) {
                    ICompletionProposal completionProposal = this.createCompletionProposal(validAttributeName, context);
                    if (!(completionProposal instanceof ConfigurableCompletionProposal)) continue;
                    ConfigurableCompletionProposal configurableCompletionProposal = (ConfigurableCompletionProposal)completionProposal;
                    String replacementString = String.valueOf(validAttributeName) + "=\"\"";
                    configurableCompletionProposal.setReplacementString(replacementString);
                    configurableCompletionProposal.setCursorPosition(replacementString.length() - 1);
                    acceptor.accept((ICompletionProposal)configurableCompletionProposal);
                }
            }
        }
    }

    @Override
    public void completeHtmlAttr_Value(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        super.completeHtmlAttr_Value(model, assignment, context, acceptor);
        if (model instanceof HtmlAttr) {
            HtmlAttr htmlAttr = (HtmlAttr)model;
            HtmlTag htmlTag = (HtmlTag)htmlAttr.eContainer();
            this.proposeHtmlAttributeValues(htmlTag.getName(), htmlAttr.getName(), context, acceptor);
        }
    }

    protected boolean isValidProposal(String proposal, String prefix, ContentAssistContext context) {
        if (prefix == null) {
            return false;
        }
        if (context.getCurrentModel() instanceof HtmlAttr && prefix.startsWith("\"")) {
            prefix = prefix.substring(1);
            return context.getMatcher().isCandidateMatchingPrefix(proposal, prefix);
        }
        return super.isValidProposal(proposal, prefix, context);
    }

    private void proposeHtmlAttributeValues(String htmlTagName, String htmlAttributeName, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        block60: {
            block58: {
                block56: {
                    block54: {
                        if (!"BR".equalsIgnoreCase(htmlTagName)) break block54;
                        switch (htmlAttributeName.toUpperCase()) {
                            case "ALIGN": {
                                this.proposeHtmlAttributeValues(context, acceptor, "CENTER", "LEFT", "RIGHT");
                                break;
                            }
                        }
                    }
                    if (!"IMG".equalsIgnoreCase(htmlTagName)) break block56;
                    switch (htmlAttributeName.toUpperCase()) {
                        case "SCALE": {
                            this.proposeHtmlAttributeValues(context, acceptor, "FALSE", "TRUE", "WIDTH", "HEIGHT", "BOTH");
                            break;
                        }
                    }
                }
                if (!"TABLE".equalsIgnoreCase(htmlTagName)) break block58;
                switch (htmlAttributeName.toUpperCase()) {
                    case "ALIGN": {
                        this.proposeHtmlAttributeValues(context, acceptor, "CENTER", "LEFT", "RIGHT");
                        break;
                    }
                    case "FIXEDSIZE": {
                        this.proposeHtmlAttributeValues(context, acceptor, "FALSE", "TRUE");
                        break;
                    }
                    case "ROWS": 
                    case "COLUMNS": {
                        this.proposeHtmlAttributeValues(context, acceptor, "*");
                        break;
                    }
                    case "SIDES": {
                        this.proposeHtmlAttributeValues(context, acceptor, "L", "T", "R", "B", "LT", "LR", "LB", "TR", "TB", "RB", "LTR", "TRB", "LRB", "LTB", "LTRB");
                        break;
                    }
                    case "VALIGN": {
                        this.proposeHtmlAttributeValues(context, acceptor, "MIDDLE", "BOTTOM", "TOP");
                        break;
                    }
                }
            }
            if (!"TD".equalsIgnoreCase(htmlTagName)) break block60;
            switch (htmlAttributeName.toUpperCase()) {
                case "ALIGN": {
                    this.proposeHtmlAttributeValues(context, acceptor, "CENTER", "LEFT", "RIGHT", "TEXT");
                    break;
                }
                case "BALIGN": {
                    this.proposeHtmlAttributeValues(context, acceptor, "CENTER", "LEFT", "RIGHT");
                    break;
                }
                case "FIXEDSIZE": {
                    this.proposeHtmlAttributeValues(context, acceptor, "FALSE", "TRUE");
                    break;
                }
                case "SIDES": {
                    this.proposeHtmlAttributeValues(context, acceptor, "L", "T", "R", "B", "LT", "LR", "LB", "TR", "TB", "RB", "LTR", "TRB", "LRB", "LTB", "LTRB");
                    break;
                }
                case "VALIGN": {
                    this.proposeHtmlAttributeValues(context, acceptor, "MIDDLE", "BOTTOM", "TOP");
                    break;
                }
            }
        }
    }

    private void proposeHtmlAttributeValues(ContentAssistContext context, ICompletionProposalAcceptor acceptor, String ... proposals) {
        String[] stringArray = proposals;
        int n = proposals.length;
        int n2 = 0;
        while (n2 < n) {
            String proposal = stringArray[n2];
            ICompletionProposal completionProposal = this.createCompletionProposal(proposal, context);
            if (context.getCurrentNode().getText().startsWith("\"") && completionProposal instanceof ConfigurableCompletionProposal) {
                ConfigurableCompletionProposal configurableCompletionProposal = (ConfigurableCompletionProposal)completionProposal;
                configurableCompletionProposal.setReplacementOffset(configurableCompletionProposal.getReplacementOffset() + 1);
                configurableCompletionProposal.setReplacementLength(configurableCompletionProposal.getReplacementLength() - 1);
                configurableCompletionProposal.setReplaceContextLength(configurableCompletionProposal.getReplaceContextLength() - 1);
            }
            acceptor.accept(completionProposal);
            ++n2;
        }
    }

    private String calculateProposalString(String tagName) {
        StringBuilder sb = new StringBuilder();
        if (DotHtmlLabelHelper.getNonSelfClosingTags().contains(tagName.toUpperCase())) {
            sb.append("<");
            sb.append(tagName);
            sb.append(">");
            sb.append("</");
            sb.append(tagName);
            sb.append(">");
        } else {
            sb.append("<");
            sb.append(tagName);
            sb.append("/>");
        }
        return sb.toString();
    }

    private int calculateCursorPosition(String htmlTagText) {
        if (htmlTagText.contains("/>")) {
            return htmlTagText.indexOf("/>");
        }
        return htmlTagText.indexOf("><") + 1;
    }
}

