/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.mvc.fx.operations;

import java.util.ArrayList;
import java.util.List;
import javafx.scene.Node;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.AbstractOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.gef.mvc.fx.operations.ITransactionalOperation;
import org.eclipse.gef.mvc.fx.parts.IBendableContentPart;

public class BendVisualOperation
extends AbstractOperation
implements ITransactionalOperation {
    private IBendableContentPart<? extends Node> part;
    private List<IBendableContentPart.BendPoint> initialBendPoints = new ArrayList<IBendableContentPart.BendPoint>();
    private List<IBendableContentPart.BendPoint> finalBendPoints = new ArrayList<IBendableContentPart.BendPoint>();

    public BendVisualOperation(IBendableContentPart<? extends Node> part) {
        super("Bend");
        this.part = part;
        this.initialBendPoints.addAll(part.getVisualBendPoints());
        this.finalBendPoints.addAll(part.getVisualBendPoints());
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        this.part.setVisualBendPoints(this.finalBendPoints);
        return Status.OK_STATUS;
    }

    public List<IBendableContentPart.BendPoint> getFinalBendPoints() {
        return this.finalBendPoints;
    }

    public List<IBendableContentPart.BendPoint> getInitialBendPoints() {
        return this.initialBendPoints;
    }

    public IBendableContentPart<? extends Node> getPart() {
        return this.part;
    }

    @Override
    public boolean isContentRelevant() {
        return false;
    }

    @Override
    public boolean isNoOp() {
        return this.initialBendPoints.equals(this.finalBendPoints);
    }

    public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        return this.execute(monitor, info);
    }

    public void setFinalBendPoints(List<IBendableContentPart.BendPoint> finalBendPoints) {
        this.finalBendPoints.clear();
        this.finalBendPoints.addAll(finalBendPoints);
    }

    public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        this.part.setVisualBendPoints(this.initialBendPoints);
        return Status.OK_STATUS;
    }
}

