/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.mvc.fx.parts;

import com.google.common.reflect.TypeToken;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Provider;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javafx.scene.Node;
import javafx.scene.paint.Color;
import org.eclipse.gef.common.adapt.AdapterKey;
import org.eclipse.gef.fx.anchors.DynamicAnchor;
import org.eclipse.gef.fx.anchors.ProjectionStrategy;
import org.eclipse.gef.fx.nodes.Connection;
import org.eclipse.gef.fx.utils.NodeUtils;
import org.eclipse.gef.geometry.planar.IGeometry;
import org.eclipse.gef.geometry.planar.Line;
import org.eclipse.gef.geometry.planar.Point;
import org.eclipse.gef.mvc.fx.parts.IFeedbackPart;
import org.eclipse.gef.mvc.fx.parts.IFeedbackPartFactory;
import org.eclipse.gef.mvc.fx.parts.IVisualPart;
import org.eclipse.gef.mvc.fx.parts.SelectionFeedbackPart;
import org.eclipse.gef.mvc.fx.parts.SelectionLinkFeedbackPart;

public class DefaultSelectionFeedbackPartFactory
implements IFeedbackPartFactory {
    public static final String PRIMARY_SELECTION_FEEDBACK_COLOR_PROVIDER = "PRIMARY_SELECTION_FEEDBACK_COLOR_PROVIDER";
    public static final Color DEFAULT_PRIMARY_SELECTION_FEEDBACK_COLOR = Color.web((String)"#3f51b5");
    public static final String SECONDARY_SELECTION_FEEDBACK_COLOR_PROVIDER = "SECONDARY_SELECTION_FEEDBACK_COLOR_PROVIDER";
    public static final Color DEFAULT_SECONDARY_SELECTION_FEEDBACK_COLOR = Color.web((String)"#9fa8da");
    public static final String SELECTION_FEEDBACK_GEOMETRY_PROVIDER = "SELECTION_FEEDBACK_GEOMETRY_PROVIDER";
    public static final String SELECTION_LINK_FEEDBACK_GEOMETRY_PROVIDER = "SELECTION_LINK_FEEDBACK_GEOMETRY_PROVIDER";
    @Inject
    private Injector injector;

    @Override
    public List<IFeedbackPart<? extends Node>> createFeedbackParts(List<? extends IVisualPart<? extends Node>> targets, Map<Object, Object> contextMap) {
        if (targets == null || targets.isEmpty()) {
            throw new IllegalArgumentException("Part factory is called without targets.");
        }
        ArrayList<IFeedbackPart<? extends Node>> feedbackParts = new ArrayList<IFeedbackPart<? extends Node>>();
        final IVisualPart<? extends Node> target = targets.iterator().next();
        final Provider selectionFeedbackGeometryProvider = (Provider)target.getAdapter(AdapterKey.get((TypeToken)new TypeToken<Provider<? extends IGeometry>>(){}, (String)SELECTION_FEEDBACK_GEOMETRY_PROVIDER));
        if (selectionFeedbackGeometryProvider != null) {
            Provider<IGeometry> provider = new Provider<IGeometry>(){

                public IGeometry get() {
                    return NodeUtils.localToScene(target.getVisual(), (IGeometry)((IGeometry)selectionFeedbackGeometryProvider.get()));
                }
            };
            SelectionFeedbackPart selectionFeedbackPart = (SelectionFeedbackPart)this.injector.getInstance(SelectionFeedbackPart.class);
            selectionFeedbackPart.setGeometryProvider((Provider<? extends IGeometry>)provider);
            feedbackParts.add(selectionFeedbackPart);
        }
        for (IVisualPart<? extends Node> iVisualPart : targets) {
            if (iVisualPart.getAnchoragesUnmodifiable().isEmpty()) continue;
            for (Map.Entry entry : iVisualPart.getAnchoragesUnmodifiable().entries()) {
                IFeedbackPart<? extends Node> anchorLinkFeedbackPart;
                IVisualPart anchorage = (IVisualPart)entry.getKey();
                String role = (String)entry.getValue();
                if (!(anchorage instanceof IVisualPart)) continue;
                Provider anchorageGeometryProvider = (Provider)anchorage.getAdapter(AdapterKey.get((TypeToken)new TypeToken<Provider<? extends IGeometry>>(){}, (String)SELECTION_LINK_FEEDBACK_GEOMETRY_PROVIDER));
                Provider anchoredGeometryProvider = (Provider)iVisualPart.getAdapter(AdapterKey.get((TypeToken)new TypeToken<Provider<? extends IGeometry>>(){}, (String)SELECTION_LINK_FEEDBACK_GEOMETRY_PROVIDER));
                if (anchoredGeometryProvider == null || anchorageGeometryProvider == null || (anchorLinkFeedbackPart = this.createLinkFeedbackPart(anchorage, (Provider<? extends IGeometry>)anchorageGeometryProvider, iVisualPart, (Provider<? extends IGeometry>)anchoredGeometryProvider, role)) == null) continue;
                feedbackParts.add(anchorLinkFeedbackPart);
            }
        }
        return feedbackParts;
    }

    protected IFeedbackPart<? extends Node> createLinkFeedbackPart(final IVisualPart<? extends Node> anchorage, final Provider<? extends IGeometry> anchorageLinkFeedbackGeometryProvider, final IVisualPart<? extends Node> anchored, final Provider<? extends IGeometry> anchoredLinkFeedbackGeometryProvider, String role) {
        if (!(anchored.getVisual() instanceof Connection)) {
            Provider<IGeometry> linkFeedbackGeometryProvider = new Provider<IGeometry>(){
                private final ProjectionStrategy computationStrategy = new ProjectionStrategy();

                private Point computePosition(Node n1, IGeometry n1Geometry, Node n2, IGeometry n2Geometry) {
                    Point n2RefPoint = n2Geometry.getBounds().getCenter();
                    HashSet<Object> parameters = new HashSet<Object>();
                    parameters.add(new DynamicAnchor.AnchorageReferenceGeometry(n1Geometry));
                    parameters.add(new DynamicAnchor.AnchoredReferencePoint(n2RefPoint));
                    return this.computationStrategy.computePositionInScene(n1, n2, parameters);
                }

                public IGeometry get() {
                    Object anchoredVisual = anchored.getVisual();
                    IGeometry anchoredGeometryInLocal = (IGeometry)anchoredLinkFeedbackGeometryProvider.get();
                    Object anchorageVisual = anchorage.getVisual();
                    IGeometry anchorageGeometryInLocal = (IGeometry)anchorageLinkFeedbackGeometryProvider.get();
                    Point sourcePointInScene = this.computePosition((Node)anchoredVisual, anchoredGeometryInLocal, (Node)anchorageVisual, anchorageGeometryInLocal);
                    Point targetPointInScene = this.computePosition((Node)anchorageVisual, anchorageGeometryInLocal, (Node)anchoredVisual, anchoredGeometryInLocal);
                    return new Line(sourcePointInScene, targetPointInScene);
                }
            };
            SelectionLinkFeedbackPart part = (SelectionLinkFeedbackPart)this.injector.getInstance(SelectionLinkFeedbackPart.class);
            part.setGeometryProvider((Provider<? extends IGeometry>)linkFeedbackGeometryProvider);
            return part;
        }
        return null;
    }
}

