/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.lfs.server.fs;

import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.MessageFormat;
import javax.servlet.AsyncContext;
import javax.servlet.ReadListener;
import javax.servlet.ServletException;
import javax.servlet.WriteListener;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jgit.lfs.errors.InvalidLongObjectIdException;
import org.eclipse.jgit.lfs.lib.AnyLongObjectId;
import org.eclipse.jgit.lfs.lib.LongObjectId;
import org.eclipse.jgit.lfs.server.fs.FileLfsRepository;
import org.eclipse.jgit.lfs.server.fs.ObjectDownloadListener;
import org.eclipse.jgit.lfs.server.fs.ObjectUploadListener;
import org.eclipse.jgit.lfs.server.internal.LfsServerText;

@WebServlet(asyncSupported=true)
public class FileLfsServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private final FileLfsRepository repository;
    private final long timeout;
    private static Gson gson = FileLfsServlet.createGson();

    public FileLfsServlet(FileLfsRepository repository, long timeout) {
        this.repository = repository;
        this.timeout = timeout;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse rsp) throws ServletException, IOException {
        AnyLongObjectId obj = this.getObjectToTransfer(req, rsp);
        if (obj != null) {
            if (this.repository.getSize(obj) == -1L) {
                FileLfsServlet.sendError(rsp, 404, MessageFormat.format(LfsServerText.get().objectNotFound, obj.getName()));
                return;
            }
            AsyncContext context = req.startAsync();
            context.setTimeout(this.timeout);
            rsp.getOutputStream().setWriteListener((WriteListener)new ObjectDownloadListener(this.repository, context, rsp, obj));
        }
    }

    protected AnyLongObjectId getObjectToTransfer(HttpServletRequest req, HttpServletResponse rsp) throws IOException {
        String info = req.getPathInfo();
        int length = 65;
        if (info.length() != length) {
            FileLfsServlet.sendError(rsp, 422, MessageFormat.format(LfsServerText.get().invalidPathInfo, info));
            return null;
        }
        try {
            return LongObjectId.fromString((String)info.substring(1, length));
        }
        catch (InvalidLongObjectIdException e) {
            FileLfsServlet.sendError(rsp, 422, e.getMessage());
            return null;
        }
    }

    protected void doPut(HttpServletRequest req, HttpServletResponse rsp) throws ServletException, IOException {
        AnyLongObjectId id = this.getObjectToTransfer(req, rsp);
        if (id != null) {
            AsyncContext context = req.startAsync();
            context.setTimeout(this.timeout);
            req.getInputStream().setReadListener((ReadListener)new ObjectUploadListener(this.repository, context, req, rsp, id));
        }
    }

    protected static void sendError(HttpServletResponse rsp, int status, String message) throws IOException {
        rsp.setStatus(status);
        PrintWriter writer = rsp.getWriter();
        gson.toJson((Object)new Error(message), (Appendable)writer);
        writer.flush();
        writer.close();
        rsp.flushBuffer();
    }

    private static Gson createGson() {
        GsonBuilder gb = new GsonBuilder().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).setPrettyPrinting().disableHtmlEscaping();
        return gb.create();
    }

    static class Error {
        String message;

        Error(String m) {
            this.message = m;
        }
    }
}

