/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.controllers.propertysources;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;
import java.util.SortedMap;
import org.apache.commons.collections.IteratorUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jubula.client.core.businessprocess.AbstractParamInterfaceBP;
import org.eclipse.jubula.client.core.businessprocess.IParamNameMapper;
import org.eclipse.jubula.client.core.businessprocess.IWritableComponentNameCache;
import org.eclipse.jubula.client.core.businessprocess.ParamNameBP;
import org.eclipse.jubula.client.core.businessprocess.ParamNameBPDecorator;
import org.eclipse.jubula.client.core.businessprocess.TestCaseParamBP;
import org.eclipse.jubula.client.core.events.DataEventDispatcher;
import org.eclipse.jubula.client.core.model.ICapPO;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.IParamDescriptionPO;
import org.eclipse.jubula.client.core.model.IParamNodePO;
import org.eclipse.jubula.client.core.model.IParameterInterfacePO;
import org.eclipse.jubula.client.core.propertytester.NodePropertyTester;
import org.eclipse.jubula.client.core.utils.GuiParamValueConverter;
import org.eclipse.jubula.client.core.utils.IParamValueValidator;
import org.eclipse.jubula.client.core.utils.NullValidator;
import org.eclipse.jubula.client.core.utils.StringHelper;
import org.eclipse.jubula.client.ui.rcp.Plugin;
import org.eclipse.jubula.client.ui.rcp.controllers.propertydescriptors.IVerifiable;
import org.eclipse.jubula.client.ui.rcp.controllers.propertydescriptors.JBPropertyDescriptor;
import org.eclipse.jubula.client.ui.rcp.controllers.propertysources.AbstractPropertySource;
import org.eclipse.jubula.client.ui.rcp.controllers.propertysources.IParameterPropertyController;
import org.eclipse.jubula.client.ui.rcp.editors.IJBEditor;
import org.eclipse.jubula.client.ui.rcp.i18n.Messages;
import org.eclipse.jubula.tools.internal.xml.businessmodell.Param;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;

public abstract class AbstractNodePropertySource
extends AbstractPropertySource<INodePO> {
    public static final String P_ELEMENT_DISPLAY_COMMENT = Messages.AbstractGuiNodePropertySourceComment;
    public static final String P_TRACKED_CHANGES_CAT = Messages.SpecTestCaseGUIPropertySourceTrackedChangesCategory;
    private TestCaseParamBP m_testCaseParamBP;
    private boolean m_readOnly;
    private IParameterPropertyController.ParameterInputType m_activeParameterInputType = IParameterPropertyController.ParameterInputType.LOCAL;
    private IPropertyDescriptor m_commentDesc = null;
    private IPropertyDescriptor m_taskIdPropDesc = null;

    public AbstractNodePropertySource(INodePO guiNode) {
        super(guiNode);
        this.m_testCaseParamBP = new TestCaseParamBP();
    }

    protected void initPropDescriptor() {
        if (this.m_commentDesc == null) {
            this.m_commentDesc = new TextPropertyDescriptor((Object)new CommentController(), P_ELEMENT_DISPLAY_COMMENT);
        }
        this.addPropertyDescriptor(this.m_commentDesc);
    }

    protected TestCaseParamBP getTestCaseParamBP() {
        return this.m_testCaseParamBP;
    }

    public boolean isReadOnly() {
        return this.m_readOnly;
    }

    protected void setReadOnly(boolean readOnly) {
        this.m_readOnly = readOnly;
    }

    public void setActiveParameterInputType(IParameterPropertyController.ParameterInputType inputType) {
        this.m_activeParameterInputType = inputType;
    }

    public boolean isParameterEntryEnabled(IParameterPropertyController parameterPropertyController) {
        return parameterPropertyController.getInputType().isEnabled(this.m_activeParameterInputType);
    }

    protected INodePO getPoNode() {
        return (INodePO)this.getNode();
    }

    protected IParamNameMapper getActiveParamNameMapper() {
        ParamNameBPDecorator editorMapper;
        IEditorPart activeEditor = Plugin.getActiveEditor();
        ParamNameBP mapper = ParamNameBP.getInstance();
        if (activeEditor instanceof IJBEditor && (editorMapper = ((IJBEditor)activeEditor).getEditorHelper().getEditSupport().getParamMapper()) != null) {
            mapper = editorMapper;
        }
        return mapper;
    }

    protected IWritableComponentNameCache getActiveComponentNameCache() {
        IEditorPart activeEditor = Plugin.getActiveEditor();
        IWritableComponentNameCache cache = null;
        if (activeEditor instanceof IJBEditor) {
            cache = ((IJBEditor)activeEditor).getCompNameCache();
        }
        return cache;
    }

    protected IParamValueValidator getValidatorForConverter(IParamDescriptionPO desc) {
        List pdList = this.getPropertyDescriptorList();
        IVerifiable descr = null;
        for (IPropertyDescriptor pd : pdList) {
            AbstractParamValueController ctrl;
            if (!(pd.getId() instanceof AbstractParamValueController) || !(ctrl = (AbstractParamValueController)pd.getId()).getParamDesc().equals(desc)) continue;
            descr = (IVerifiable)pd;
        }
        return descr != null ? descr.getDataValidator() : new NullValidator();
    }

    public boolean isPropertySet(Object id) {
        if (id instanceof IParameterPropertyController) {
            return ((IParameterPropertyController)id).isPropertySet();
        }
        return false;
    }

    public void updateParameterInputType() {
        this.setActiveParameterInputType(this.calculateActiveParameterInputType());
    }

    private IParameterPropertyController.ParameterInputType calculateActiveParameterInputType() {
        IPropertyDescriptor[] iPropertyDescriptorArray = this.getPropertyDescriptors();
        int n = iPropertyDescriptorArray.length;
        int n2 = 0;
        while (n2 < n) {
            IParameterPropertyController controller;
            IPropertyDescriptor desc = iPropertyDescriptorArray[n2];
            if (desc.getId() instanceof IParameterPropertyController && (controller = (IParameterPropertyController)desc.getId()).isPropertySet()) {
                return controller.getInputType();
            }
            ++n2;
        }
        return IParameterPropertyController.ParameterInputType.LOCAL;
    }

    protected String getParameterNameDescr(IParamDescriptionPO desc) {
        StringBuilder sb = new StringBuilder(desc.getName());
        sb.append(" ");
        sb.append("[");
        sb.append((String)StringHelper.getInstance().getMap().get(desc.getType()));
        sb.append("]");
        return sb.toString();
    }

    protected IPropertyDescriptor getTaskIdPropDesc() {
        return this.m_taskIdPropDesc;
    }

    protected void setTaskIdPropDesc(IPropertyDescriptor taskIdPropDesc) {
        this.m_taskIdPropDesc = taskIdPropDesc;
    }

    protected void initTrackedChangesPropDescriptor() {
        SortedMap changes = this.getPoNode().getTrackedChanges();
        int i = 0;
        for (Object o : changes.keySet()) {
            if (!(o instanceof Long)) continue;
            Long key = (Long)o;
            JBPropertyDescriptor propDes = new JBPropertyDescriptor(new TrackedChangesValueController(i), this.formatDateForTrackedChanges(key));
            propDes.setCategory(P_TRACKED_CHANGES_CAT);
            this.addPropertyDescriptor((IPropertyDescriptor)propDes);
            ++i;
        }
    }

    private String formatDateForTrackedChanges(Long dateInMillis) {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(dateInMillis);
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String s = df.format(cal.getTime());
        return s;
    }

    public abstract class AbstractParamValueController
    extends AbstractPropertySource.AbstractPropertyController
    implements IParameterPropertyController {
        private IParamDescriptionPO m_paramDescr;
        private IParamNameMapper m_paramNameMapper;

        public AbstractParamValueController(AbstractNodePropertySource s, IParamDescriptionPO paramDescr, IParamNameMapper paramNameMapper) {
            super(s);
            this.m_paramDescr = paramDescr;
            this.m_paramNameMapper = paramNameMapper;
        }

        protected Iterator getValueSetIterator() {
            INodePO node = AbstractNodePropertySource.this.getPoNode();
            if (!(node instanceof ICapPO)) {
                return IteratorUtils.EMPTY_ITERATOR;
            }
            Param param = ((ICapPO)node).getMetaAction().findParam(this.m_paramDescr.getUniqueId());
            return param.valueSetIterator();
        }

        public String getProperty() {
            IParamNodePO paramNode = (IParamNodePO)AbstractNodePropertySource.this.getPoNode();
            String property = AbstractParamInterfaceBP.getGuiStringForParamValue((IParameterInterfacePO)paramNode, (IParamDescriptionPO)this.m_paramDescr, (int)0);
            return property == null ? "" : property;
        }

        public final boolean setProperty(Object value) {
            if (this.getPropertySource().isReadOnly()) {
                return true;
            }
            boolean propSet = false;
            if (value instanceof String) {
                IParamNodePO node = (IParamNodePO)AbstractNodePropertySource.this.getPoNode();
                GuiParamValueConverter conv = new GuiParamValueConverter((String)value, (IParameterInterfacePO)node, this.getParamDesc(), AbstractNodePropertySource.this.getValidatorForConverter(this.getParamDesc()));
                if (conv.getErrors().isEmpty()) {
                    AbstractNodePropertySource.this.getTestCaseParamBP().startParameterUpdate(conv, 0, this.m_paramNameMapper);
                    DataEventDispatcher.getInstance().firePropertyChanged(false);
                }
                AbstractNodePropertySource.this.checkEntrySets(node);
                propSet = true;
                return propSet;
            }
            Object val = ((List)value).get(0);
            IParamNodePO node = (IParamNodePO)AbstractNodePropertySource.this.getPoNode();
            IParamNameMapper mapper = (IParamNameMapper)((List)value).get(1);
            GuiParamValueConverter conv = new GuiParamValueConverter((String)val, (IParameterInterfacePO)node, this.getParamDesc(), AbstractNodePropertySource.this.getValidatorForConverter(this.getParamDesc()));
            if (conv.getErrors().isEmpty()) {
                AbstractNodePropertySource.this.getTestCaseParamBP().startParameterUpdate(conv, 0, mapper);
                DataEventDispatcher.getInstance().firePropertyChanged(false);
            }
            AbstractNodePropertySource.this.checkEntrySets(node);
            propSet = true;
            return propSet;
        }

        public IParamDescriptionPO getParamDesc() {
            return this.m_paramDescr;
        }

        public IParamNodePO getParamNode() {
            return (IParamNodePO)AbstractNodePropertySource.this.getPoNode();
        }

        @Override
        public boolean isPropertySet() {
            return StringUtils.isNotEmpty((String)this.getProperty());
        }

        @Override
        public IParameterPropertyController.ParameterInputType getInputType() {
            return IParameterPropertyController.ParameterInputType.LOCAL;
        }
    }

    protected class CommentController
    extends AbstractPropertySource.AbstractPropertyController {
        protected CommentController() {
        }

        public boolean setProperty(Object value) {
            if (value != null) {
                AbstractNodePropertySource.this.getPoNode().setComment(String.valueOf(value));
            } else {
                AbstractNodePropertySource.this.getPoNode().setComment(null);
            }
            return true;
        }

        public Object getProperty() {
            if (AbstractNodePropertySource.this.getPoNode() != null && AbstractNodePropertySource.this.getPoNode().getComment() != null) {
                return AbstractNodePropertySource.this.getPoNode().getComment();
            }
            return "";
        }

        @Override
        public Image getImage() {
            return DEFAULT_IMAGE;
        }
    }

    public class ElementNameController
    extends AbstractPropertySource.AbstractPropertyController {
        public boolean setProperty(Object value) {
            String name = null;
            if (value != null) {
                name = String.valueOf(value);
            }
            AbstractNodePropertySource.this.getPoNode().setName(name);
            DataEventDispatcher.getInstance().firePropertyChanged(false);
            return true;
        }

        public Object getProperty() {
            String name;
            if (AbstractNodePropertySource.this.getPoNode() != null && (name = AbstractNodePropertySource.this.getPoNode().getName()) != null) {
                return name;
            }
            return "";
        }
    }

    protected class ReadOnlyTaskIdController
    extends TaskIdController {
        protected ReadOnlyTaskIdController() {
        }

        @Override
        public boolean setProperty(Object value) {
            return true;
        }

        @Override
        public Image getImage() {
            return READONLY_IMAGE;
        }
    }

    protected class TaskIdController
    extends AbstractPropertySource.AbstractPropertyController {
        protected TaskIdController() {
        }

        public boolean setProperty(Object value) {
            if (value != null) {
                AbstractNodePropertySource.this.getPoNode().setTaskId(String.valueOf(value));
            } else {
                AbstractNodePropertySource.this.getPoNode().setTaskId(null);
            }
            return true;
        }

        public Object getProperty() {
            String taskId = NodePropertyTester.getTaskIdforNode((INodePO)AbstractNodePropertySource.this.getPoNode());
            if (taskId != null) {
                return taskId;
            }
            return "";
        }

        @Override
        public Image getImage() {
            return DEFAULT_IMAGE;
        }
    }

    public class TrackedChangesValueController
    extends AbstractPropertySource.AbstractPropertyController {
        private int m_index = 0;

        public TrackedChangesValueController(int i) {
            this.m_index = i;
        }

        public boolean setProperty(Object value) {
            return true;
        }

        public Object getProperty() {
            SortedMap changes;
            INodePO poNode = AbstractNodePropertySource.this.getPoNode();
            if (poNode != null && (changes = AbstractNodePropertySource.this.getPoNode().getTrackedChanges()) != null) {
                ArrayList values = new ArrayList(changes.values());
                return values.get(this.m_index);
            }
            return "";
        }
    }
}

