/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.ui.views;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.linuxtools.docker.core.DockerConnectionManager;
import org.eclipse.linuxtools.docker.core.DockerException;
import org.eclipse.linuxtools.docker.core.EnumDockerConnectionState;
import org.eclipse.linuxtools.docker.core.EnumDockerStatus;
import org.eclipse.linuxtools.docker.core.IDockerConnection;
import org.eclipse.linuxtools.docker.core.IDockerConnectionManagerListener;
import org.eclipse.linuxtools.docker.core.IDockerContainer;
import org.eclipse.linuxtools.docker.core.IDockerContainerListener;
import org.eclipse.linuxtools.docker.core.IDockerPortMapping;
import org.eclipse.linuxtools.docker.ui.Activator;
import org.eclipse.linuxtools.internal.docker.core.DockerConnection;
import org.eclipse.linuxtools.internal.docker.ui.DockerConnectionWatcher;
import org.eclipse.linuxtools.internal.docker.ui.SWTImagesFactory;
import org.eclipse.linuxtools.internal.docker.ui.commands.CommandUtils;
import org.eclipse.linuxtools.internal.docker.ui.propertytesters.ContainerPropertyTester;
import org.eclipse.linuxtools.internal.docker.ui.views.ContainersWithLabelsViewerFilter;
import org.eclipse.linuxtools.internal.docker.ui.views.DVMessages;
import org.eclipse.linuxtools.internal.docker.ui.views.DockerContainersComparator;
import org.eclipse.linuxtools.internal.docker.ui.views.DockerContainersContentProvider;
import org.eclipse.linuxtools.internal.docker.ui.views.HideStoppedContainersViewerFilter;
import org.eclipse.linuxtools.internal.docker.ui.views.LabelProviderUtils;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.ITabbedPropertySheetPageContributor;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public class DockerContainersView
extends ViewPart
implements IDockerContainerListener,
ISelectionListener,
ITabbedPropertySheetPageContributor,
IDockerConnectionManagerListener {
    private static final String TOGGLE_STATE = "org.eclipse.ui.commands.toggleState";
    private static final String SHOW_ALL_CONTAINERS_COMMAND_ID = "org.eclipse.linuxtools.docker.ui.commands.showAllContainers";
    private static final String SHOW_ALL_CONTAINERS_PREFERENCE = "showAllContainers";
    private static final String FILTER_CONTAINERS_COMMAND_ID = "org.eclipse.linuxtools.docker.ui.commands.filterContainersWithLabels";
    private static final String FILTER_WITH_LABELS_PREFERENCE = "filterWithLabels";
    private static final String CONTAINER_FILTER_LABELS = "containerFilterLabels";
    public static final String VIEW_ID = "org.eclipse.linuxtools.docker.ui.dockerContainersView";
    private static final String NoConnectionSelected = "ViewerNoConnectionSelected.msg";
    private static final String ConnectionNotAvailable = "ViewerConnectionNotAvailable.msg";
    private static final String ViewAllTitle = "ContainersViewTitle.all.msg";
    private static final String ViewFilteredTitle = "ContainersViewTitle.filtered.msg";
    private Form form;
    private Text search;
    private TableViewer viewer;
    private IDockerConnection connection;
    private final HideStoppedContainersViewerFilter hideStoppedContainersViewerFilter = new HideStoppedContainersViewerFilter();
    private final ContainersWithLabelsViewerFilter containersWithLabelsViewerFilter = new ContainersWithLabelsViewerFilter();
    private final Image STARTED_IMAGE = SWTImagesFactory.DESC_CONTAINER_STARTED.createImage();
    private final Image PAUSED_IMAGE = SWTImagesFactory.DESC_CONTAINER_PAUSED.createImage();
    private final Image STOPPED_IMAGE = SWTImagesFactory.DESC_CONTAINER_STOPPED.createImage();
    private IAction pauseAction;
    private IAction unpauseAction;
    private IAction startAction;
    private IAction stopAction;
    private IAction killAction;
    private IAction restartAction;
    private IAction removeAction;

    public void setFocus() {
    }

    public void dispose() {
        if (this.connection != null) {
            this.connection.removeContainerListener((IDockerContainerListener)this);
        }
        this.getSite().getWorkbenchWindow().getSelectionService().removeSelectionListener("org.eclipse.linuxtools.docker.ui.dockerExplorerView", (ISelectionListener)this);
        DockerConnectionManager.getInstance().removeConnectionManagerListener((IDockerConnectionManagerListener)this);
        this.STARTED_IMAGE.dispose();
        this.PAUSED_IMAGE.dispose();
        this.STOPPED_IMAGE.dispose();
        super.dispose();
    }

    public String getContributorId() {
        return "org.eclipse.linuxtools.docker.ui.propertiesViewContributor";
    }

    public String getFormTitle() {
        return this.form.getText();
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter == IPropertySheetPage.class) {
            return (T)new TabbedPropertySheetPage((ITabbedPropertySheetPageContributor)this, true);
        }
        return (T)super.getAdapter(adapter);
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
    }

    public void createPartControl(Composite parent) {
        FormToolkit toolkit = new FormToolkit(parent.getDisplay());
        this.form = toolkit.createForm(parent);
        this.form.setText(DVMessages.getString(NoConnectionSelected));
        Composite container = this.form.getBody();
        GridLayoutFactory.fillDefaults().numColumns(1).margins(0, 0).applyTo(container);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)container);
        this.createTableViewer(container);
        this.getSite().registerContextMenu(new MenuManager(), null);
        this.getSite().getWorkbenchWindow().getSelectionService().addSelectionListener("org.eclipse.linuxtools.docker.ui.dockerExplorerView", (ISelectionListener)this);
        this.hookContextMenu();
        this.hookToolBarItems();
        IEclipsePreferences preferences = InstanceScope.INSTANCE.getNode("org.eclipse.linuxtools.docker.ui");
        boolean showAll = preferences.getBoolean(SHOW_ALL_CONTAINERS_PREFERENCE, true);
        this.showAllContainers(showAll);
        ICommandService service = (ICommandService)this.getViewSite().getWorkbenchWindow().getService(ICommandService.class);
        service.getCommand(SHOW_ALL_CONTAINERS_COMMAND_ID).getState(TOGGLE_STATE).setValue((Object)showAll);
        service.refreshElements(SHOW_ALL_CONTAINERS_COMMAND_ID, null);
        boolean filterByLabels = preferences.getBoolean(FILTER_WITH_LABELS_PREFERENCE, false);
        this.showContainersWithLabels(filterByLabels);
        service.getCommand(FILTER_CONTAINERS_COMMAND_ID).getState(TOGGLE_STATE).setValue((Object)filterByLabels);
        service.refreshElements(FILTER_CONTAINERS_COMMAND_ID, null);
        DockerConnectionManager.getInstance().addConnectionManagerListener((IDockerConnectionManagerListener)this);
        ISelection selection = this.getSite().getWorkbenchWindow().getSelectionService().getSelection("org.eclipse.linuxtools.docker.ui.dockerExplorerView");
        if (selection != null) {
            this.selectionChanged(null, selection);
            DockerConnectionWatcher.getInstance().selectionChanged(null, selection);
        }
    }

    private void createTableViewer(Composite container) {
        this.search = new Text(container, 640);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, false).applyTo((Control)this.search);
        this.search.addModifyListener(this.onSearch());
        Composite tableArea = new Composite(container, 0);
        GridLayoutFactory.fillDefaults().numColumns(1).margins(0, 0).applyTo(tableArea);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)tableArea);
        TableColumnLayout tableLayout = new TableColumnLayout();
        tableArea.setLayout((Layout)tableLayout);
        this.viewer = new TableViewer(tableArea, 66306);
        this.viewer.setContentProvider((IContentProvider)new DockerContainersContentProvider());
        Table table = this.viewer.getTable();
        GridLayoutFactory.fillDefaults().numColumns(1).margins(0, 0).applyTo((Composite)table);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)table);
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        TableViewerColumn nameColumn = this.createColumn(DVMessages.getString("NAME"));
        this.setLayout(nameColumn, tableLayout, 150);
        nameColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof IDockerContainer) {
                    return ((IDockerContainer)element).name();
                }
                return super.getText(element);
            }

            public Image getImage(Object element) {
                if (element instanceof IDockerContainer) {
                    IDockerContainer container = (IDockerContainer)element;
                    EnumDockerStatus containerStatus = EnumDockerStatus.fromStatusMessage((String)container.status());
                    if (containerStatus == EnumDockerStatus.RUNNING) {
                        return DockerContainersView.this.STARTED_IMAGE;
                    }
                    if (containerStatus == EnumDockerStatus.PAUSED) {
                        return DockerContainersView.this.PAUSED_IMAGE;
                    }
                    return DockerContainersView.this.STOPPED_IMAGE;
                }
                return super.getImage(element);
            }
        });
        TableViewerColumn imageColumn = this.createColumn(DVMessages.getString("IMAGE"));
        this.setLayout(imageColumn, tableLayout, 150);
        imageColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof IDockerContainer) {
                    return ((IDockerContainer)element).image();
                }
                return super.getText(element);
            }
        });
        TableViewerColumn creationDateColumn = this.createColumn(DVMessages.getString("CREATED"));
        this.setLayout(creationDateColumn, tableLayout, 150);
        creationDateColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof IDockerContainer) {
                    return LabelProviderUtils.toCreatedDate(((IDockerContainer)element).created());
                }
                return super.getText(element);
            }
        });
        TableViewerColumn commandColumn = this.createColumn(DVMessages.getString("COMMAND"));
        this.setLayout(commandColumn, tableLayout, 150);
        commandColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof IDockerContainer) {
                    return ((IDockerContainer)element).command();
                }
                return super.getText(element);
            }
        });
        TableViewerColumn portsColumn = this.createColumn(DVMessages.getString("PORTS"));
        this.setLayout(portsColumn, tableLayout, 150);
        portsColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof IDockerContainer) {
                    StringBuilder ports = new StringBuilder();
                    Iterator iterator = ((IDockerContainer)element).ports().iterator();
                    while (iterator.hasNext()) {
                        IDockerPortMapping portMapping = (IDockerPortMapping)iterator.next();
                        ports.append(LabelProviderUtils.containerPortMappingToString(portMapping));
                        if (!iterator.hasNext()) continue;
                        ports.append(", ");
                    }
                    return ports.toString();
                }
                return super.getText(element);
            }
        });
        TableViewerColumn statusColumn = this.createColumn(DVMessages.getString("STATUS"));
        this.setLayout(statusColumn, tableLayout, 150);
        statusColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof IDockerContainer) {
                    return ((IDockerContainer)element).status();
                }
                return super.getText(element);
            }
        });
        DockerContainersComparator comparator = new DockerContainersComparator(this.viewer);
        comparator.setColumn(creationDateColumn.getColumn());
        comparator.setColumn(creationDateColumn.getColumn());
        this.viewer.setComparator((ViewerComparator)comparator);
        this.viewer.setFilters(new ViewerFilter[]{this.getContainersFilter()});
        this.setConnection(CommandUtils.getCurrentConnection(null));
        this.viewer.addSelectionChangedListener(this.onContainerSelection());
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
    }

    private void hookToolBarItems() {
        IToolBarManager mgr = this.getViewSite().getActionBars().getToolBarManager();
        this.pauseAction = this.createAction(DVMessages.getString("DockerContainersView.pause.label"), "org.eclipse.linuxtools.docker.ui.commands.pauseContainers", SWTImagesFactory.DESC_PAUSE);
        this.unpauseAction = this.createAction(DVMessages.getString("DockerContainersView.unpause.label"), "org.eclipse.linuxtools.docker.ui.commands.unpauseContainers", SWTImagesFactory.DESC_RESUME);
        this.startAction = this.createAction(DVMessages.getString("DockerContainersView.start.label"), "org.eclipse.linuxtools.docker.ui.commands.startContainers", SWTImagesFactory.DESC_START);
        this.stopAction = this.createAction(DVMessages.getString("DockerContainersView.stop.label"), "org.eclipse.linuxtools.docker.ui.commands.stopContainers", SWTImagesFactory.DESC_STOP);
        this.killAction = this.createAction(DVMessages.getString("DockerContainersView.kill.label"), "org.eclipse.linuxtools.docker.ui.commands.killContainers", SWTImagesFactory.DESC_KILL);
        this.restartAction = this.createAction(DVMessages.getString("DockerContainersView.restart.label"), "org.eclipse.linuxtools.docker.ui.commands.restartContainers", SWTImagesFactory.DESC_RESTART);
        this.removeAction = this.createAction(DVMessages.getString("DockerContainersView.remove.label"), "org.eclipse.linuxtools.docker.ui.commands.removeContainers", SWTImagesFactory.DESC_REMOVE);
        mgr.add(this.startAction);
        mgr.add(this.pauseAction);
        mgr.add(this.unpauseAction);
        mgr.add(this.stopAction);
        mgr.add(this.killAction);
        mgr.add(this.restartAction);
        mgr.add(this.removeAction);
    }

    private IAction createAction(String label, final String id, ImageDescriptor img) {
        Action ret = new Action(label, img){

            public void run() {
                IStructuredSelection sel = DockerContainersView.this.getStructuredSelection();
                CommandUtils.execute(id, sel);
            }
        };
        ret.setEnabled(false);
        return ret;
    }

    private TableViewerColumn createColumn(String title) {
        TableViewerColumn propertyColumn = new TableViewerColumn(this.viewer, 2048);
        propertyColumn.getColumn().setText(title);
        propertyColumn.getColumn().addSelectionListener(this.onColumnSelected());
        return propertyColumn;
    }

    private SelectionListener onColumnSelected() {
        return SelectionListener.widgetSelectedAdapter(e -> {
            TableColumn sortColumn = (TableColumn)e.getSource();
            DockerContainersComparator comparator = (DockerContainersComparator)this.viewer.getComparator();
            comparator.setColumn(sortColumn);
            this.viewer.refresh();
        });
    }

    private void setLayout(TableViewerColumn viewerColumn, TableColumnLayout tableLayout, int weight) {
        tableLayout.setColumnData((Widget)viewerColumn.getColumn(), (ColumnLayoutData)new ColumnWeightData(weight, true));
    }

    private ModifyListener onSearch() {
        return e -> {
            if (this.viewer != null) {
                this.viewer.refresh();
            }
        };
    }

    private ViewerFilter getContainersFilter() {
        return new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (element instanceof IDockerContainer) {
                    return element.toString().contains(DockerContainersView.this.search.getText());
                }
                return false;
            }
        };
    }

    private void updateToolBarItemEnablement(IStructuredSelection sel) {
        this.pauseAction.setEnabled(ContainerPropertyTester.isRunning(sel));
        this.unpauseAction.setEnabled(ContainerPropertyTester.isPaused(sel));
        this.startAction.setEnabled(ContainerPropertyTester.isStopped(sel));
        this.stopAction.setEnabled(ContainerPropertyTester.isAnyRunning(sel));
        this.killAction.setEnabled(ContainerPropertyTester.isAnyRunning(sel));
        this.restartAction.setEnabled(!sel.toList().isEmpty() && !ContainerPropertyTester.isPaused(sel));
        this.removeAction.setEnabled(ContainerPropertyTester.isStopped(sel));
    }

    private ISelectionChangedListener onContainerSelection() {
        return event -> {
            IStructuredSelection s = event.getStructuredSelection();
            this.updateToolBarItemEnablement(s);
        };
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        ITreeSelection treeSelection = (ITreeSelection)selection;
        if (treeSelection.isEmpty()) {
            this.setConnection(null);
            return;
        }
        Object firstSegment = treeSelection.getPaths()[0].getFirstSegment();
        if (firstSegment instanceof IDockerConnection) {
            IDockerConnection connection = (IDockerConnection)firstSegment;
            this.setConnection(connection);
            this.setLabelFilterIds();
        }
    }

    private void setLabelFilterIds() {
        IEclipsePreferences preferences = InstanceScope.INSTANCE.getNode("org.eclipse.linuxtools.docker.ui");
        boolean filterLabels = preferences.getBoolean(FILTER_WITH_LABELS_PREFERENCE, Boolean.FALSE.booleanValue());
        if (filterLabels) {
            String filterLabelString = preferences.get(CONTAINER_FILTER_LABELS, "");
            if (filterLabelString.isEmpty()) {
                this.containersWithLabelsViewerFilter.setIds(null);
            } else {
                String[] labels = filterLabelString.split("\u00a0");
                LinkedHashMap<String, String> labelMap = new LinkedHashMap<String, String>();
                String[] stringArray = labels;
                int n = labels.length;
                int n2 = 0;
                while (n2 < n) {
                    String label = stringArray[n2];
                    if (label.length() > 1) {
                        String[] tokens = label.split("=");
                        String key = tokens[0];
                        String value = "";
                        if (tokens.length > 1) {
                            value = tokens[1];
                        }
                        labelMap.put(key, value);
                    }
                    ++n2;
                }
                HashSet<String> filterIds = new HashSet();
                try {
                    filterIds = ((DockerConnection)this.connection).getContainerIdsWithLabels(labelMap);
                }
                catch (DockerException e) {
                    Activator.log(e);
                }
                this.containersWithLabelsViewerFilter.setIds(filterIds);
            }
        }
    }

    public void listChanged(IDockerConnection connection, List<IDockerContainer> containers) {
        if (connection.getName().equals(connection.getName())) {
            Display.getDefault().asyncExec(() -> {
                if (this.viewer != null && !this.viewer.getTable().isDisposed()) {
                    this.setLabelFilterIds();
                    this.viewer.refresh();
                    this.refreshViewTitle();
                    this.updateToolBarItemEnablement(this.viewer.getStructuredSelection());
                }
            });
        }
    }

    public IDockerConnection getConnection() {
        return this.connection;
    }

    public void setConnection(final IDockerConnection connection) {
        if (connection != null && connection.equals(this.connection)) {
            return;
        }
        if (this.connection != null) {
            this.connection.removeContainerListener((IDockerContainerListener)this);
        }
        this.connection = connection;
        if (this.viewer != null && this.connection != null) {
            Job refreshJob = new Job(DVMessages.getString("ContainersRefresh.msg")){

                protected IStatus run(IProgressMonitor monitor) {
                    connection.getContainers(true);
                    DockerContainersView.this.setLabelFilterIds();
                    connection.addContainerListener((IDockerContainerListener)DockerContainersView.this);
                    Display.getDefault().asyncExec(() -> {
                        DockerContainersView.this.viewer.setInput((Object)connection);
                        DockerContainersView.this.refreshViewTitle();
                    });
                    return Status.OK_STATUS;
                }
            };
            refreshJob.schedule();
        } else if (this.viewer != null) {
            this.viewer.setInput((Object)new IDockerContainer[0]);
            this.form.setText(DVMessages.getString(NoConnectionSelected));
        }
    }

    public IStructuredSelection getStructuredSelection() {
        if (this.viewer != null) {
            return this.viewer.getStructuredSelection();
        }
        return StructuredSelection.EMPTY;
    }

    public TableViewer getViewer() {
        return this.viewer;
    }

    public void showAllContainers(boolean enabled) {
        if (this.viewer == null) {
            return;
        }
        if (!enabled) {
            this.viewer.addFilter((ViewerFilter)this.hideStoppedContainersViewerFilter);
        } else {
            ArrayList<ViewerFilter> filters = new ArrayList<ViewerFilter>(Arrays.asList(this.viewer.getFilters()));
            Iterator iterator = filters.iterator();
            while (iterator.hasNext()) {
                ViewerFilter viewerFilter = (ViewerFilter)iterator.next();
                if (!viewerFilter.equals((Object)this.hideStoppedContainersViewerFilter)) continue;
                iterator.remove();
            }
            this.viewer.setFilters(filters.toArray(new ViewerFilter[0]));
        }
        IEclipsePreferences preferences = InstanceScope.INSTANCE.getNode("org.eclipse.linuxtools.docker.ui");
        preferences.putBoolean(SHOW_ALL_CONTAINERS_PREFERENCE, enabled);
        this.refreshViewTitle();
    }

    public void showContainersWithLabels(boolean enabled) {
        if (this.viewer == null) {
            return;
        }
        if (enabled) {
            this.viewer.addFilter((ViewerFilter)this.containersWithLabelsViewerFilter);
        } else {
            ArrayList<ViewerFilter> filters = new ArrayList<ViewerFilter>(Arrays.asList(this.viewer.getFilters()));
            Iterator iterator = filters.iterator();
            while (iterator.hasNext()) {
                ViewerFilter viewerFilter = (ViewerFilter)iterator.next();
                if (!viewerFilter.equals((Object)this.containersWithLabelsViewerFilter)) continue;
                iterator.remove();
            }
            this.viewer.setFilters(filters.toArray(new ViewerFilter[0]));
        }
        IEclipsePreferences preferences = InstanceScope.INSTANCE.getNode("org.eclipse.linuxtools.docker.ui");
        preferences.putBoolean(FILTER_WITH_LABELS_PREFERENCE, enabled);
        this.refreshViewTitle();
    }

    private void refreshViewTitle() {
        if (this.viewer == null || this.viewer.getControl().isDisposed() || this.form == null || this.connection == null) {
            return;
        }
        if (this.connection.getState() == EnumDockerConnectionState.CLOSED) {
            this.form.setText(DVMessages.getFormattedString(ConnectionNotAvailable, this.connection.getName()));
            this.form.setEnabled(false);
        } else if (!this.connection.isContainersLoaded()) {
            this.form.setText(this.connection.getName());
            this.form.setEnabled(false);
        } else {
            int containersSize;
            int itemCount = this.viewer.getTable().getItemCount();
            if (itemCount < (containersSize = this.connection.getContainers().size())) {
                this.form.setText(DVMessages.getFormattedString(ViewFilteredTitle, this.connection.getName(), Integer.toString(itemCount), Integer.toString(containersSize)));
            } else {
                this.form.setText(DVMessages.getFormattedString(ViewAllTitle, this.connection.getName(), Integer.toString(containersSize)));
            }
            this.form.setEnabled(true);
        }
    }

    public void changeEvent(final IDockerConnection connection, int type) {
        if (type == 3) {
            Job refreshJob = new Job(DVMessages.getString("ContainersRefresh.msg")){

                protected IStatus run(IProgressMonitor monitor) {
                    connection.getContainers(true);
                    return Status.OK_STATUS;
                }
            };
            refreshJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                public void done(IJobChangeEvent event) {
                    Display.getDefault().asyncExec(() -> DockerContainersView.this.refreshViewTitle());
                }
            });
            refreshJob.schedule();
        } else if (type == 2) {
            Display.getDefault().asyncExec(() -> this.refreshViewTitle());
        }
    }
}

