/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.qvt.oml.debug.core.vm;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.m2m.internal.qvt.oml.ast.binding.ASTBindingHelper;
import org.eclipse.m2m.internal.qvt.oml.common.util.LineNumberProvider;
import org.eclipse.m2m.internal.qvt.oml.expressions.Module;
import org.eclipse.m2m.qvt.oml.debug.core.QVTODebugCore;
import org.eclipse.m2m.qvt.oml.debug.core.vm.UnitLocation;
import org.eclipse.m2m.qvt.oml.debug.core.vm.VMBreakpoint;
import org.eclipse.m2m.qvt.oml.debug.core.vm.VMBreakpointManager;
import org.eclipse.m2m.qvt.oml.ecore.ImperativeOCL.BlockExp;
import org.eclipse.ocl.expressions.LoopExp;
import org.eclipse.ocl.expressions.OCLExpression;
import org.eclipse.ocl.utilities.ASTNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class IterateBreakpointHelper {
    private final Set<VMBreakpoint> fBreakpoints;
    private final VMBreakpointManager fBPM;

    IterateBreakpointHelper(VMBreakpointManager breakpointManager) {
        this.fBPM = breakpointManager;
        this.fBreakpoints = new HashSet<VMBreakpoint>();
    }

    VMBreakpoint stepIterateElement(LoopExp<EClassifier, ?> element, UnitLocation currentLocation) {
        Module currentModule = currentLocation.getModule();
        LineNumberProvider lineNumProvider = this.getLineNumberProvider(currentModule);
        if (lineNumProvider == null) {
            return null;
        }
        OCLExpression body = element.getBody();
        if (body == null) {
            return null;
        }
        int bodyLine = lineNumProvider.getLineNumber(body.getStartPosition());
        int elementLine = lineNumProvider.getLineNumber(element.getStartPosition());
        OCLExpression iterateBreakpointedElement = body;
        if (body instanceof BlockExp) {
            BlockExp blockExp = (BlockExp)body;
            int bodyEndLine = lineNumProvider.getLineNumber(blockExp.getEndPosition());
            if (bodyEndLine == elementLine || blockExp.getBody().isEmpty()) {
                return null;
            }
            iterateBreakpointedElement = (ASTNode)blockExp.getBody().get(0);
        } else if (bodyLine == elementLine) {
            return null;
        }
        URI unitURI = currentLocation.getURI();
        VMBreakpoint breakpoint = this.createIterateBreakpoint(unitURI, (ASTNode)iterateBreakpointedElement, elementLine);
        return breakpoint;
    }

    boolean isIterateBreakpoint(VMBreakpoint breakpoint) {
        return this.fBreakpoints.contains(breakpoint);
    }

    VMBreakpoint createIterateBreakpoint(URI unitURI, ASTNode breakpointedElement, int line) {
        VMBreakpoint breakpoint = null;
        try {
            breakpoint = this.fBPM.createVMPrivateBreakpoint(unitURI, breakpointedElement, line, false);
            this.fBreakpoints.add(breakpoint);
        }
        catch (CoreException e) {
            QVTODebugCore.log(e.getStatus());
        }
        return breakpoint;
    }

    void removeIterateBreakpoint(VMBreakpoint breakpoint) {
        this.fBPM.removeBreakpoint(breakpoint);
        this.fBreakpoints.remove(breakpoint);
    }

    void removeAllIterateBreakpoints() {
        for (VMBreakpoint brk : this.fBreakpoints) {
            this.fBPM.removeBreakpoint(brk);
        }
        this.fBreakpoints.clear();
    }

    private LineNumberProvider getLineNumberProvider(Module module) {
        return ASTBindingHelper.getModuleSourceBinding((Module)module).getLineNumberProvider();
    }
}

