/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.debug.vm.core;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.debug.vm.core.VMLineBreakpoint;
import org.eclipse.ocl.examples.debug.vm.utils.Trace;
import org.eclipse.ocl.xtext.base.as2cs.BaseLocationInFileProvider;

public abstract class VMDebugCore {
    private Map<URI, URI> platformPluginMap;
    private @NonNull Object pluginMapLock = new Object();

    public static @NonNull URI getResourceURI(IResource resource) {
        return URI.createPlatformResourceURI((String)resource.getFullPath().toString(), (boolean)true);
    }

    public void error(String message, Throwable throwable) {
        this.error(0, message, throwable);
    }

    public void error(Throwable throwable) {
        this.error("", throwable);
    }

    public void error(String message) {
        this.error(0, message, null);
    }

    public void error(int code, String message, Throwable throwable) {
        this.log(4, code, message, throwable);
    }

    public abstract @NonNull String getBreakpointMarkerId();

    public abstract @NonNull String getDebuggerActiveProperty();

    public abstract @NonNull String getModelId();

    public abstract @Nullable ILog getLog();

    public abstract @NonNull String getPluginId();

    public abstract @NonNull Trace getTrace();

    public abstract @NonNull String getVMThreadName();

    public @NonNull IStatus createDebugError(String string, IOException e) {
        return this.createStatus(4, string, e);
    }

    public @NonNull IStatus createStatus(int severity, String message, Throwable throwable) {
        return new Status(severity, this.getPluginId(), message, throwable);
    }

    public @NonNull IStatus createStatus(int severity, String message) {
        return this.createStatus(severity, message, null);
    }

    public @NonNull IStatus createError(String message, int code, Throwable throwable) {
        return new Status(4, this.getPluginId(), code, message, throwable);
    }

    public abstract @NonNull List<@NonNull ? extends VMLineBreakpoint> getLineBreakpoints();

    public abstract @NonNull BaseLocationInFileProvider getLocationInFileProvider();

    public <T extends IBreakpoint> @NonNull List<T> getOCLBreakpoints(@NonNull Class<T> breakpointType) {
        IBreakpoint[] breakpoints = DebugPlugin.getDefault().getBreakpointManager().getBreakpoints(this.getModelId());
        ArrayList<IBreakpoint> result = new ArrayList<IBreakpoint>(breakpoints.length);
        IBreakpoint[] iBreakpointArray = breakpoints;
        int n = breakpoints.length;
        int n2 = 0;
        while (n2 < n) {
            IBreakpoint bp = iBreakpointArray[n2];
            if (breakpointType.isInstance(bp)) {
                result.add((IBreakpoint)breakpointType.cast(bp));
            }
            ++n2;
        }
        return result;
    }

    public void log(int severity, int code, String message, Throwable throwable) {
        String msg = message == null ? "" : message;
        try {
            ILog log = this.getLog();
            if (log != null) {
                log.log((IStatus)new Status(severity, this.getPluginId(), code, msg, throwable));
            } else {
                switch (code) {
                    case 2: {
                        System.err.print("WARNING ");
                        break;
                    }
                    case 4: 
                    case 8: {
                        System.err.print("ERROR ");
                        break;
                    }
                    default: {
                        return;
                    }
                }
                System.err.print(code);
                System.err.print(": ");
                System.err.println(message);
                if (throwable != null) {
                    throwable.printStackTrace(System.err);
                }
            }
        }
        catch (IllegalArgumentException iae) {
            iae.printStackTrace();
        }
    }

    public void log(IStatus status) {
        ILog log = this.getLog();
        if (log != null) {
            log.log(status);
        }
    }

    public void log(Throwable e) {
        this.log((IStatus)new Status(4, this.getPluginId(), "Exception caught", e));
    }

    public URI resolvePlatformPluginURI(IFile file) {
        URI uri = URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true);
        return this.resolvePlatformPluginURI(uri);
    }

    public URI resolvePlatformPluginURI(URI uri) {
        Map<URI, URI> uriMap = this.getPlatformPluginMap();
        if (uri.isPlatformResource() && uri.segmentCount() > 2) {
            URI baseURI = uri.trimSegments(uri.segmentCount() - 2);
            URI key = baseURI.appendSegment("");
            URI mappedBaseURI = uriMap.get(key);
            if (mappedBaseURI == null) {
                mappedBaseURI = uriMap.get(baseURI);
            }
            if (mappedBaseURI != null) {
                List segmentsList = uri.segmentsList();
                segmentsList = segmentsList.subList(2, segmentsList.size());
                if (mappedBaseURI.hasTrailingPathSeparator()) {
                    mappedBaseURI = mappedBaseURI.trimSegments(1);
                }
                return mappedBaseURI.appendSegments(segmentsList.toArray(new String[segmentsList.size()]));
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<URI, URI> getPlatformPluginMap() {
        Object object = this.pluginMapLock;
        synchronized (object) {
            if (this.platformPluginMap == null) {
                this.platformPluginMap = new HashMap<URI, URI>();
                Map plugin2ResourceMap = EcorePlugin.computePlatformPluginToPlatformResourceMap();
                this.platformPluginMap.putAll(plugin2ResourceMap);
                for (Map.Entry entry : plugin2ResourceMap.entrySet()) {
                    this.platformPluginMap.put((URI)entry.getValue(), (URI)entry.getKey());
                }
            }
        }
        return this.platformPluginMap;
    }

    public IFile resolveWorskpaceFile(URI uri) {
        IFile sourceFile = this.toFile(uri);
        return sourceFile;
    }

    public IFile toFile(URI uri) {
        List<IFile> files = this.toFiles(uri);
        return files.isEmpty() ? null : files.get(0);
    }

    public List<IFile> toFiles(URI uri) {
        if (uri.isPlatformResource()) {
            String platformString = uri.toPlatformString(true);
            IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(platformString));
            return Collections.singletonList(file);
        }
        if (uri.isFile()) {
            java.net.URI javaURI;
            try {
                javaURI = java.net.URI.create(uri.toString());
            }
            catch (IllegalArgumentException e) {
                this.log(e);
                return Collections.emptyList();
            }
            IFile[] files = ResourcesPlugin.getWorkspace().getRoot().findFilesForLocationURI(javaURI);
            ArrayList<IFile> result = new ArrayList<IFile>(files.length);
            IFile[] iFileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                IFile nextFile = iFileArray[n2];
                result.add(nextFile);
                ++n2;
            }
            return result;
        }
        return Collections.emptyList();
    }
}

