/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.internal.library.executor;

import com.google.common.collect.Iterables;
import java.lang.ref.WeakReference;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.ecore.util.EcoreEList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.CompleteEnvironment;
import org.eclipse.ocl.pivot.CompleteInheritance;
import org.eclipse.ocl.pivot.CompletePackage;
import org.eclipse.ocl.pivot.Element;
import org.eclipse.ocl.pivot.Enumeration;
import org.eclipse.ocl.pivot.EnumerationLiteral;
import org.eclipse.ocl.pivot.Model;
import org.eclipse.ocl.pivot.Operation;
import org.eclipse.ocl.pivot.Package;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.StandardLibrary;
import org.eclipse.ocl.pivot.TupleType;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.TypedElement;
import org.eclipse.ocl.pivot.ids.ClassId;
import org.eclipse.ocl.pivot.ids.CollectionTypeId;
import org.eclipse.ocl.pivot.ids.DataTypeId;
import org.eclipse.ocl.pivot.ids.EnumerationId;
import org.eclipse.ocl.pivot.ids.EnumerationLiteralId;
import org.eclipse.ocl.pivot.ids.IdManager;
import org.eclipse.ocl.pivot.ids.IdResolver;
import org.eclipse.ocl.pivot.ids.IdVisitor;
import org.eclipse.ocl.pivot.ids.LambdaTypeId;
import org.eclipse.ocl.pivot.ids.MapTypeId;
import org.eclipse.ocl.pivot.ids.NestedPackageId;
import org.eclipse.ocl.pivot.ids.NsURIPackageId;
import org.eclipse.ocl.pivot.ids.OclInvalidTypeId;
import org.eclipse.ocl.pivot.ids.OclVoidTypeId;
import org.eclipse.ocl.pivot.ids.OperationId;
import org.eclipse.ocl.pivot.ids.PackageId;
import org.eclipse.ocl.pivot.ids.PrimitiveTypeId;
import org.eclipse.ocl.pivot.ids.PropertyId;
import org.eclipse.ocl.pivot.ids.RootPackageId;
import org.eclipse.ocl.pivot.ids.TemplateBinding;
import org.eclipse.ocl.pivot.ids.TemplateParameterId;
import org.eclipse.ocl.pivot.ids.TemplateableTypeId;
import org.eclipse.ocl.pivot.ids.TuplePartId;
import org.eclipse.ocl.pivot.ids.TupleTypeId;
import org.eclipse.ocl.pivot.ids.TypeId;
import org.eclipse.ocl.pivot.ids.UnspecifiedId;
import org.eclipse.ocl.pivot.internal.executor.ExecutorTuplePart;
import org.eclipse.ocl.pivot.internal.library.executor.JavaType;
import org.eclipse.ocl.pivot.internal.values.BagImpl;
import org.eclipse.ocl.pivot.internal.values.OrderedSetImpl;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.ValueUtil;
import org.eclipse.ocl.pivot.values.Bag;
import org.eclipse.ocl.pivot.values.BagValue;
import org.eclipse.ocl.pivot.values.CollectionValue;
import org.eclipse.ocl.pivot.values.IntegerValue;
import org.eclipse.ocl.pivot.values.InvalidValueException;
import org.eclipse.ocl.pivot.values.MapValue;
import org.eclipse.ocl.pivot.values.OCLValue;
import org.eclipse.ocl.pivot.values.OrderedSet;
import org.eclipse.ocl.pivot.values.OrderedSetValue;
import org.eclipse.ocl.pivot.values.SequenceValue;
import org.eclipse.ocl.pivot.values.SetValue;
import org.eclipse.ocl.pivot.values.Unlimited;
import org.eclipse.ocl.pivot.values.UnlimitedNaturalValue;
import org.eclipse.ocl.pivot.values.Value;

public abstract class AbstractIdResolver
implements IdResolver.IdResolverExtension {
    protected final @NonNull CompleteEnvironment environment;
    protected final @NonNull StandardLibrary standardLibrary;
    private final @NonNull Set<EObject> directRoots = new HashSet<EObject>();
    private boolean directRootsProcessed = false;
    private boolean crossReferencedRootsProcessed = false;
    protected final @NonNull Map<Object, Class> key2type = new HashMap<Object, Class>();
    private Map<EnumerationLiteralId, Enumerator> enumerationLiteral2enumerator = null;
    private Map<Enumerator, EnumerationLiteralId> enumerator2enumerationLiteralId = null;
    private Map<String, Map<Type, WeakReference<TypedElement>>> tupleParts = null;
    protected final @NonNull Map<String, Package> nsURI2package = new HashMap<String, Package>();
    protected final @NonNull Map<String, Package> roots2package = new HashMap<String, Package>();

    public AbstractIdResolver(@NonNull CompleteEnvironment environment) {
        this.environment = environment;
        this.standardLibrary = environment.getOwnedStandardLibrary();
    }

    protected abstract @NonNull Package addEPackage(@NonNull EPackage var1);

    private void addPackage(@NonNull Package userPackage) {
        String nsURI = userPackage.getURI();
        if (nsURI != null) {
            this.nsURI2package.put(nsURI, userPackage);
            EPackage ePackage = userPackage.getEPackage();
            if (ePackage != null) {
                if (ClassUtil.basicGetMetamodelAnnotation(ePackage) != null && this.roots2package.get("$metamodel$") == null) {
                    this.roots2package.put("$metamodel$", userPackage);
                }
            } else {
                for (Class asType : userPackage.getOwnedClasses()) {
                    if (!"Boolean".equals(asType.getName())) continue;
                    if (this.roots2package.get("$metamodel$") == null) {
                        this.roots2package.put("$metamodel$", userPackage);
                    }
                    break;
                }
            }
        } else {
            String name = userPackage.getName();
            if (name != null) {
                this.roots2package.put(name, userPackage);
            }
        }
        this.addPackages(userPackage.getOwnedPackages());
    }

    private void addPackages(Iterable<? extends Package> userPackages) {
        for (Package package_ : userPackages) {
            assert (package_ != null);
            this.addPackage(package_);
        }
    }

    @Override
    public void addRoot(@NonNull EObject eObject) {
        this.directRoots.add(eObject);
    }

    @Override
    public @Nullable Package basicGetPackage(@NonNull PackageId packageId) {
        Element element = packageId.accept(this);
        if (element instanceof Package) {
            return (Package)element;
        }
        return null;
    }

    @Override
    public @Nullable Object boxedValueOf(@Nullable Object unboxedValue) {
        if (unboxedValue == null) {
            return unboxedValue;
        }
        if (unboxedValue instanceof Value) {
            return unboxedValue;
        }
        if (unboxedValue instanceof Boolean) {
            return unboxedValue;
        }
        if (unboxedValue instanceof String) {
            return unboxedValue;
        }
        if (unboxedValue instanceof Number) {
            if (unboxedValue instanceof Integer || unboxedValue instanceof Long || unboxedValue instanceof Short || unboxedValue instanceof Byte) {
                return ValueUtil.integerValueOf(((Number)unboxedValue).longValue());
            }
            if (unboxedValue instanceof Float || unboxedValue instanceof Double) {
                return ValueUtil.realValueOf(((Number)unboxedValue).doubleValue());
            }
            if (unboxedValue instanceof BigDecimal) {
                return ValueUtil.realValueOf((BigDecimal)unboxedValue);
            }
            if (unboxedValue instanceof BigInteger) {
                return ValueUtil.integerValueOf((BigInteger)unboxedValue);
            }
            if (unboxedValue instanceof Unlimited) {
                return unboxedValue;
            }
        } else {
            if (unboxedValue instanceof Character) {
                return ValueUtil.integerValueOf(((Character)unboxedValue).charValue());
            }
            if (unboxedValue.getClass().isArray()) {
                try {
                    @NonNull Object @NonNull [] unboxedValues = (Object[])unboxedValue;
                    Type dynamicType = this.getDynamicTypeOf(unboxedValues);
                    if (dynamicType == null) {
                        dynamicType = this.standardLibrary.getOclInvalidType();
                    }
                    TypeId elementTypeId = dynamicType.getTypeId();
                    CollectionTypeId collectedTypeId = TypeId.SEQUENCE.getSpecializedId(elementTypeId);
                    return this.createSequenceOfEach(collectedTypeId, (Object[])unboxedValue);
                }
                catch (IllegalArgumentException unboxedValues) {}
            } else {
                if (unboxedValue instanceof Iterable) {
                    Iterable unboxedValues = (Iterable)unboxedValue;
                    Type dynamicType = this.getDynamicTypeOf(unboxedValues);
                    if (dynamicType == null) {
                        dynamicType = this.standardLibrary.getOclInvalidType();
                    }
                    TypeId elementTypeId = dynamicType.getTypeId();
                    if (unboxedValue instanceof LinkedHashSet || unboxedValue instanceof OrderedSet) {
                        CollectionTypeId collectedTypeId = TypeId.ORDERED_SET.getSpecializedId(elementTypeId);
                        return this.createOrderedSetOfAll(collectedTypeId, unboxedValues);
                    }
                    if (unboxedValue instanceof Bag) {
                        CollectionTypeId collectedTypeId = TypeId.BAG.getSpecializedId(elementTypeId);
                        return this.createBagOfAll(collectedTypeId, unboxedValues);
                    }
                    if (unboxedValue instanceof Set) {
                        CollectionTypeId collectedTypeId = TypeId.SET.getSpecializedId(elementTypeId);
                        return this.createSetOfAll(collectedTypeId, unboxedValues);
                    }
                    CollectionTypeId collectedTypeId = TypeId.SEQUENCE.getSpecializedId(elementTypeId);
                    return this.createSequenceOfAll(collectedTypeId, unboxedValues);
                }
                if (unboxedValue instanceof Type) {
                    return unboxedValue;
                }
                if (unboxedValue instanceof EnumerationLiteral) {
                    return ((EnumerationLiteral)unboxedValue).getEnumerationLiteralId();
                }
                if (unboxedValue instanceof EEnumLiteral) {
                    return IdManager.getEnumerationLiteralId((EEnumLiteral)unboxedValue);
                }
                if (unboxedValue instanceof EObject) {
                    return unboxedValue;
                }
                if (unboxedValue instanceof Element) {
                    return unboxedValue;
                }
                if (unboxedValue instanceof EnumerationLiteralId) {
                    return unboxedValue;
                }
                if (unboxedValue instanceof Enumerator) {
                    return this.boxedValueOfEnumerator((Enumerator)unboxedValue);
                }
            }
        }
        return unboxedValue;
    }

    @Override
    public @Nullable Object boxedValueOf(@NonNull Object unboxedValue, @Nullable EClassifier eClassifier) {
        if (unboxedValue instanceof Value) {
            return unboxedValue;
        }
        if (eClassifier instanceof EEnum) {
            EEnum eEnum = (EEnum)eClassifier;
            String name = ClassUtil.nonNullModel(((Enumerator)unboxedValue).getName());
            EnumerationId enumId = IdManager.getEnumerationId(eEnum);
            EnumerationLiteralId enumerationLiteralId = enumId.getEnumerationLiteralId(name);
            return enumerationLiteralId;
        }
        return this.boxedValueOf(unboxedValue);
    }

    @Override
    public @Nullable Object boxedValueOf(@NonNull Object unboxedValue, @NonNull ETypedElement eFeature, @Nullable TypeId typeId) {
        EClassifier eClassifier = eFeature.getEType();
        if (typeId instanceof CollectionTypeId) {
            ArrayList<Object> unboxedValues = (ArrayList<Object>)unboxedValue;
            if (eClassifier instanceof EDataType) {
                ArrayList<Object> values = new ArrayList<Object>(unboxedValues.size());
                for (Object e : unboxedValues) {
                    if (e == null) continue;
                    values.add(this.boxedValueOf(e, eClassifier));
                }
                unboxedValues = values;
            }
            return this.createCollectionOfAll((CollectionTypeId)typeId, unboxedValues);
        }
        return this.boxedValueOf(unboxedValue, eClassifier);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public @Nullable Object boxedValueOfEnumerator(@NonNull Enumerator unboxedValue) {
        EnumerationLiteralId enumerationLiteralId;
        Map<Enumerator, EnumerationLiteralId> enumerator2enumerationLiteralId2 = this.enumerator2enumerationLiteralId;
        if (enumerator2enumerationLiteralId2 == null) {
            AbstractIdResolver abstractIdResolver = this;
            synchronized (abstractIdResolver) {
                enumerator2enumerationLiteralId2 = this.enumerator2enumerationLiteralId;
                if (enumerator2enumerationLiteralId2 == null) {
                    this.enumerator2enumerationLiteralId = enumerator2enumerationLiteralId2 = new HashMap<Enumerator, EnumerationLiteralId>();
                    for (CompletePackage completePackage : this.standardLibrary.getAllCompletePackages()) {
                        for (Class dType : completePackage.getAllClasses()) {
                            if (!(dType instanceof Enumeration)) continue;
                            for (EnumerationLiteral dEnumerationLiteral : ((Enumeration)dType).getOwnedLiterals()) {
                                Enumerator enumerator = dEnumerationLiteral.getEnumerator();
                                EnumerationLiteralId enumerationLiteralId2 = dEnumerationLiteral.getEnumerationLiteralId();
                                this.enumerator2enumerationLiteralId.put(enumerator, enumerationLiteralId2);
                            }
                        }
                    }
                }
            }
        }
        if ((enumerationLiteralId = enumerator2enumerationLiteralId2.get(unboxedValue)) == null) {
            throw new InvalidValueException("Unknown enumeration " + unboxedValue.getName(), new Object[0]);
        }
        return enumerationLiteralId;
    }

    @Override
    public @NonNull BagValue createBagOfAll(@NonNull CollectionTypeId typeId, @NonNull Iterable<? extends Object> unboxedValues) {
        BagImpl<Object> boxedValues = new BagImpl<Object>();
        for (Object object : unboxedValues) {
            boxedValues.add(this.boxedValueOf(object));
        }
        return ValueUtil.createBagValue(typeId, boxedValues);
    }

    @Override
    public @NonNull BagValue createBagOfEach(@NonNull CollectionTypeId typeId, Object ... unboxedValues) {
        BagImpl<Object> boxedValues = new BagImpl<Object>();
        Object[] objectArray = unboxedValues;
        int n = unboxedValues.length;
        int n2 = 0;
        while (n2 < n) {
            Object unboxedValue = objectArray[n2];
            boxedValues.add(this.boxedValueOf(unboxedValue));
            ++n2;
        }
        return ValueUtil.createBagValue(typeId, boxedValues);
    }

    @Override
    public @NonNull CollectionValue createCollectionOfAll(boolean isOrdered, boolean isUnique, @NonNull TypeId elementTypeId, @NonNull Iterable<? extends Object> unboxedValues) {
        if (isOrdered) {
            if (isUnique) {
                return this.createOrderedSetOfAll(TypeId.ORDERED_SET.getSpecializedId(elementTypeId), unboxedValues);
            }
            return this.createSequenceOfAll(TypeId.SEQUENCE.getSpecializedId(elementTypeId), unboxedValues);
        }
        if (isUnique) {
            return this.createSetOfAll(TypeId.SET.getSpecializedId(elementTypeId), unboxedValues);
        }
        return this.createBagOfAll(TypeId.BAG.getSpecializedId(elementTypeId), unboxedValues);
    }

    @Override
    public @NonNull CollectionValue createCollectionOfAll(@NonNull CollectionTypeId collectedId, @NonNull Iterable<?> unboxedValues) {
        CollectionTypeId collectionId = collectedId.getGeneralizedId();
        if (collectionId == TypeId.BAG) {
            return this.createBagOfAll(collectedId, unboxedValues);
        }
        if (collectionId == TypeId.ORDERED_SET) {
            return this.createOrderedSetOfAll(collectedId, unboxedValues);
        }
        if (collectionId == TypeId.SEQUENCE) {
            return this.createSequenceOfAll(collectedId, unboxedValues);
        }
        if (collectionId == TypeId.SET) {
            return this.createSetOfAll(collectedId, unboxedValues);
        }
        if (unboxedValues instanceof LinkedHashSet) {
            return this.createOrderedSetOfAll(collectedId, unboxedValues);
        }
        if (unboxedValues instanceof Set) {
            return this.createSetOfAll(collectedId, unboxedValues);
        }
        if (unboxedValues instanceof Bag) {
            return this.createBagOfAll(collectedId, unboxedValues);
        }
        return this.createSequenceOfAll(collectedId, unboxedValues);
    }

    @Override
    public @Nullable Object createInstance(@NonNull TypeId typeId, @NonNull String stringValue) {
        Id2InstanceVisitor visitor = new Id2InstanceVisitor(stringValue);
        return typeId.accept(visitor);
    }

    @Override
    public @NonNull MapValue createMapOfAll(@NonNull TypeId keyTypeId, @NonNull TypeId valueTypeId, @NonNull Map<Object, Object> unboxedValues) {
        HashMap<Object, Object> boxedValues = new HashMap<Object, Object>();
        for (Map.Entry<Object, Object> unboxedValue : unboxedValues.entrySet()) {
            boxedValues.put(this.boxedValueOf(unboxedValue.getKey()), this.boxedValueOf(unboxedValue.getValue()));
        }
        return ValueUtil.createMapValue(keyTypeId, valueTypeId, boxedValues);
    }

    @Override
    public @NonNull OrderedSetValue createOrderedSetOfAll(@NonNull CollectionTypeId typeId, @NonNull Iterable<? extends Object> unboxedValues) {
        OrderedSetImpl<Object> boxedValues = new OrderedSetImpl<Object>();
        for (Object object : unboxedValues) {
            boxedValues.add(this.boxedValueOf(object));
        }
        return ValueUtil.createOrderedSetValue(typeId, boxedValues);
    }

    @Override
    public @NonNull OrderedSetValue createOrderedSetOfEach(@NonNull CollectionTypeId typeId, Object ... unboxedValues) {
        OrderedSetImpl<Object> boxedValues = new OrderedSetImpl<Object>();
        Object[] objectArray = unboxedValues;
        int n = unboxedValues.length;
        int n2 = 0;
        while (n2 < n) {
            Object unboxedValue = objectArray[n2];
            boxedValues.add(this.boxedValueOf(unboxedValue));
            ++n2;
        }
        return ValueUtil.createOrderedSetValue(typeId, boxedValues);
    }

    @Override
    public @NonNull SequenceValue createSequenceOfAll(@NonNull CollectionTypeId typeId, @NonNull Iterable<? extends Object> unboxedValues) {
        ArrayList<Object> boxedValues = new ArrayList<Object>();
        for (Object object : unboxedValues) {
            boxedValues.add(this.boxedValueOf(object));
        }
        return ValueUtil.createSequenceValue(typeId, boxedValues);
    }

    @Override
    public @NonNull SequenceValue createSequenceOfEach(@NonNull CollectionTypeId typeId, Object ... unboxedValues) {
        ArrayList<Object> boxedValues = new ArrayList<Object>();
        Object[] objectArray = unboxedValues;
        int n = unboxedValues.length;
        int n2 = 0;
        while (n2 < n) {
            Object unboxedValue = objectArray[n2];
            boxedValues.add(this.boxedValueOf(unboxedValue));
            ++n2;
        }
        return ValueUtil.createSequenceValue(typeId, boxedValues);
    }

    @Override
    public @NonNull SetValue createSetOfAll(@NonNull CollectionTypeId typeId, @NonNull Iterable<? extends Object> unboxedValues) {
        HashSet<Object> boxedValues = new HashSet<Object>();
        for (Object object : unboxedValues) {
            boxedValues.add(this.boxedValueOf(object));
        }
        return ValueUtil.createSetValue(typeId, boxedValues);
    }

    @Override
    public @NonNull SetValue createSetOfEach(@NonNull CollectionTypeId typeId, Object ... unboxedValues) {
        HashSet<Object> boxedValues = new HashSet<Object>();
        Object[] objectArray = unboxedValues;
        int n = unboxedValues.length;
        int n2 = 0;
        while (n2 < n) {
            Object unboxedValue = objectArray[n2];
            boxedValues.add(this.boxedValueOf(unboxedValue));
            ++n2;
        }
        return ValueUtil.createSetValue(typeId, boxedValues);
    }

    @Override
    public void dispose() {
        this.tupleParts = null;
        this.key2type.clear();
        this.enumerationLiteral2enumerator = null;
        this.enumerator2enumerationLiteralId = null;
    }

    @Override
    public @Nullable Object ecoreValueOf(@Nullable java.lang.Class<?> instanceClass, @Nullable Object value) {
        if (value instanceof Value) {
            return ((Value)value).asEcoreObject(this, instanceClass);
        }
        if (value instanceof Number) {
            Number number = (Number)value;
            if (instanceClass == Double.class || instanceClass == Double.TYPE) {
                return number.doubleValue();
            }
            if (instanceClass == Float.class || instanceClass == Float.TYPE) {
                return Float.valueOf(number.floatValue());
            }
            if (instanceClass == Short.class || instanceClass == Short.TYPE) {
                return number.shortValue();
            }
            if (instanceClass == Integer.class || instanceClass == Integer.TYPE) {
                return number.intValue();
            }
            if (instanceClass == Long.class || instanceClass == Long.TYPE) {
                return number.longValue();
            }
            if (instanceClass == BigDecimal.class) {
                return BigDecimal.valueOf(number.doubleValue());
            }
            if (instanceClass == BigInteger.class) {
                return BigInteger.valueOf(number.longValue());
            }
            if (number instanceof BigDecimal || number instanceof Double || number instanceof Float) {
                return number.doubleValue();
            }
            return number.intValue();
        }
        if (value instanceof EnumerationLiteralId) {
            return this.unboxedValueOf((EnumerationLiteralId)value);
        }
        if (value instanceof EEnumLiteral) {
            return ((EEnumLiteral)value).getInstance();
        }
        if (value instanceof Iterable) {
            if (value instanceof EcoreEList.UnmodifiableEList) {
                return value;
            }
            Iterable values = (Iterable)value;
            return this.ecoreValuesOfAll(instanceClass, values);
        }
        return value;
    }

    @Override
    public <T> @NonNull EList<T> ecoreValueOfAll(@Nullable java.lang.Class<T> instanceClass, @NonNull Iterable<? extends Object> values) {
        Object[] ecoreValues = new Object[Iterables.size(values)];
        int i = 0;
        for (Object object : values) {
            ecoreValues[i++] = this.ecoreValueOf(instanceClass, object);
        }
        return new EcoreEList.UnmodifiableEList(null, null, ecoreValues.length, ecoreValues);
    }

    @Override
    @Deprecated
    public @NonNull EList<Object> ecoreValuesOfAll(@Nullable java.lang.Class<?> instanceClass, @NonNull Iterable<Object> values) {
        Object[] ecoreValues = new Object[Iterables.size(values)];
        int i = 0;
        for (Object value : values) {
            ecoreValues[i++] = this.ecoreValueOf(instanceClass, value);
        }
        return new EcoreEList.UnmodifiableEList(null, null, ecoreValues.length, ecoreValues);
    }

    @Override
    @Deprecated
    public @NonNull EList<Object> ecoreValuesOfEach(@Nullable java.lang.Class<?> instanceClass, Object ... values) {
        Object[] ecoreValues = new Object[values.length];
        int i = 0;
        Object[] objectArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            Object value = objectArray[n2];
            ecoreValues[i++] = this.ecoreValueOf(instanceClass, value);
            ++n2;
        }
        return new EcoreEList.UnmodifiableEList(null, null, ecoreValues.length, ecoreValues);
    }

    @Override
    public @NonNull Class getClass(@NonNull TypeId typeId, @Nullable Object context) {
        Element type = typeId.accept(this);
        assert (type != null);
        return (Class)type;
    }

    @Override
    public @NonNull Class getCollectionType(@NonNull CollectionTypeId typeId) {
        return this.getCollectionType(typeId, false, null, null);
    }

    public @NonNull Class getCollectionType(@NonNull CollectionTypeId typeId, boolean isNullFree, @Nullable IntegerValue lower, @Nullable UnlimitedNaturalValue upper) {
        CollectionTypeId generalizedId = typeId.getGeneralizedId();
        if (typeId == generalizedId && !isNullFree && lower == null && upper == null) {
            if (generalizedId == TypeId.BAG) {
                return this.standardLibrary.getBagType();
            }
            if (generalizedId == TypeId.COLLECTION) {
                return this.standardLibrary.getCollectionType();
            }
            if (generalizedId == TypeId.ORDERED_SET) {
                return this.standardLibrary.getOrderedSetType();
            }
            if (generalizedId == TypeId.SEQUENCE) {
                return this.standardLibrary.getSequenceType();
            }
            if (generalizedId == TypeId.SET) {
                return this.standardLibrary.getSetType();
            }
            if (generalizedId == TypeId.UNIQUE_COLLECTION) {
                return this.standardLibrary.getUniqueCollectionType();
            }
            throw new UnsupportedOperationException();
        }
        TypeId elementTypeId = typeId.getElementTypeId();
        Type elementType = this.getType(elementTypeId, null);
        if (generalizedId == TypeId.BAG) {
            return this.environment.getBagType(elementType, isNullFree, lower, upper);
        }
        if (generalizedId == TypeId.COLLECTION) {
            return this.environment.getCollectionType(this.standardLibrary.getCollectionType(), elementType, isNullFree, lower, upper);
        }
        if (generalizedId == TypeId.ORDERED_SET) {
            return this.environment.getOrderedSetType(elementType, isNullFree, lower, upper);
        }
        if (generalizedId == TypeId.SEQUENCE) {
            return this.environment.getSequenceType(elementType, isNullFree, lower, upper);
        }
        if (generalizedId == TypeId.SET) {
            return this.environment.getSetType(elementType, isNullFree, lower, upper);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public @NonNull Class getDynamicTypeOf(@Nullable Object value) {
        if (value instanceof CollectionValue) {
            CollectionValue collectionValue = (CollectionValue)value;
            CollectionTypeId collectionTypeId = collectionValue.getTypeId();
            Type elementType = this.getDynamicTypeOf(collectionValue.iterable());
            if (elementType == null) {
                elementType = this.getType(collectionTypeId.getElementTypeId(), null);
            }
            CollectionTypeId collectedId = collectionTypeId;
            CollectionTypeId collectionId = collectedId.getGeneralizedId();
            TypeId elementTypeId = elementType.getTypeId();
            collectedId = collectionId.getSpecializedId(elementTypeId);
            IntegerValue size = collectionValue.size();
            return this.getCollectionType(collectedId, false, size, size.asUnlimitedNaturalValue());
        }
        return this.getStaticTypeOf(value);
    }

    @Override
    public @Nullable Type getDynamicTypeOf(Object ... values) {
        Type elementType = null;
        Object[] objectArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            Object value = objectArray[n2];
            Class valueType = this.getDynamicTypeOf(value);
            elementType = elementType == null ? valueType : elementType.getCommonType(this, valueType);
            ++n2;
        }
        if (elementType == null) {
            elementType = this.standardLibrary.getOclInvalidType();
        }
        return elementType;
    }

    @Override
    public @Nullable Type getDynamicTypeOf(@NonNull Iterable<?> values) {
        Type elementType = null;
        for (Object value : values) {
            Class valueType = this.getDynamicTypeOf(value);
            elementType = elementType == null ? valueType : elementType.getCommonType(this, valueType);
        }
        return elementType;
    }

    @Override
    public @NonNull CompleteEnvironment getEnvironment() {
        return this.environment;
    }

    @Override
    public synchronized @NonNull Class getJavaType(@NonNull java.lang.Class<?> javaClass) {
        Class type = this.key2type.get(javaClass);
        if (type != null) {
            return type;
        }
        type = new JavaType(javaClass);
        this.key2type.put(javaClass, type);
        return type;
    }

    @Override
    public @NonNull Class getMapType(@NonNull MapTypeId typeId) {
        MapTypeId generalizedId = typeId.getGeneralizedId();
        if (typeId == generalizedId) {
            if (generalizedId == TypeId.MAP) {
                return this.standardLibrary.getMapType();
            }
            throw new UnsupportedOperationException();
        }
        TypeId keyTypeId = typeId.getKeyTypeId();
        TypeId valueTypeId = typeId.getValueTypeId();
        Type keyType = this.getType(keyTypeId, null);
        Type valueType = this.getType(valueTypeId, null);
        if (generalizedId == TypeId.MAP) {
            return this.environment.getMapType(this.standardLibrary.getMapType(), keyType, valueType);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public @Nullable Iterable<@NonNull Class> getModelClassesOf(@NonNull Object value) {
        return null;
    }

    @Override
    public @NonNull Operation getOperation(@NonNull OperationId operationId) {
        Element element = operationId.accept(this);
        if (element instanceof Operation) {
            return (Operation)element;
        }
        throw new IllegalStateException("No " + operationId);
    }

    @Override
    public @NonNull Package getPackage(@NonNull PackageId packageId) {
        Element element = packageId.accept(this);
        if (element instanceof Package) {
            return (Package)element;
        }
        throw new IllegalStateException("No " + packageId);
    }

    @Override
    public @NonNull Property getProperty(@NonNull PropertyId propertyId) {
        Element element = propertyId.accept(this);
        if (element instanceof Property) {
            return (Property)element;
        }
        throw new IllegalStateException("No " + propertyId);
    }

    @Override
    public @NonNull StandardLibrary getStandardLibrary() {
        return this.standardLibrary;
    }

    @Override
    public @NonNull Class getStaticTypeOf(@Nullable Object value) {
        if (value instanceof EObject) {
            EClass eClass = ((EObject)value).eClass();
            assert (eClass != null);
            Class type = this.key2type.get(eClass);
            if (type == null) {
                type = this.getInheritance((EClassifier)eClass).getPivotClass();
                assert (type != null);
                this.key2type.put(eClass, type);
            }
            return type;
        }
        if (value instanceof Value) {
            TypeId typeId = ((Value)value).getTypeId();
            Class type = this.key2type.get(typeId);
            if (type == null) {
                type = (Class)typeId.accept(this);
                assert (type != null);
                this.key2type.put(typeId, type);
            }
            return type;
        }
        if (value == null) {
            return this.standardLibrary.getOclVoidType();
        }
        if (value instanceof Boolean) {
            return this.standardLibrary.getBooleanType();
        }
        if (value instanceof String) {
            return this.standardLibrary.getStringType();
        }
        if (value instanceof Number) {
            if (value instanceof BigDecimal || value instanceof Double || value instanceof Float) {
                return this.standardLibrary.getRealType();
            }
            if (value instanceof BigInteger || value instanceof Byte || value instanceof Integer || value instanceof Long || value instanceof Short) {
                return this.standardLibrary.getIntegerType();
            }
        } else if (value instanceof EnumerationLiteralId) {
            EnumerationLiteral enumLiteral = (EnumerationLiteral)((EnumerationLiteralId)value).accept(this);
            assert (enumLiteral != null);
            Enumeration enumeration = enumLiteral.getOwningEnumeration();
            assert (enumeration != null);
            return enumeration;
        }
        java.lang.Class<?> jClass = value.getClass();
        assert (jClass != null);
        return this.getJavaType(jClass);
    }

    @Override
    public @NonNull Class getStaticTypeOf(@Nullable Object value, Object ... values) {
        Object bestTypeId = this.getTypeKeyOf(value);
        Class bestType = this.key2type.get(bestTypeId);
        assert (bestType != null);
        AbstractCollection assessedTypeKeys = null;
        int count = 0;
        Object[] objectArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            Object anotherValue = objectArray[n2];
            Object anotherTypeId = this.getTypeKeyOf(anotherValue);
            if (assessedTypeKeys == null ? anotherTypeId != bestTypeId : !assessedTypeKeys.contains(anotherTypeId)) {
                Class anotherType = this.key2type.get(anotherTypeId);
                assert (anotherType != null);
                Type commonType = bestType.getCommonType(this, anotherType);
                if (commonType != bestType && commonType instanceof Class) {
                    if (assessedTypeKeys == null) {
                        assessedTypeKeys = new ArrayList<Object>();
                        assessedTypeKeys.add(bestTypeId);
                    } else if (count++ == 4) {
                        assessedTypeKeys = new HashSet(assessedTypeKeys);
                    }
                    assessedTypeKeys.add(anotherTypeId);
                    bestType = (Class)commonType;
                    bestTypeId = anotherTypeId;
                }
            }
            ++n2;
        }
        return bestType;
    }

    @Override
    public @NonNull Class getStaticTypeOf(@Nullable Object value, @NonNull Iterable<?> values) {
        Object bestTypeKey = this.getTypeKeyOf(value);
        Class bestType = this.key2type.get(bestTypeKey);
        assert (bestType != null);
        AbstractCollection assessedTypeKeys = null;
        int count = 0;
        for (Object anotherValue : values) {
            assert (anotherValue != null);
            Object anotherTypeKey = this.getTypeKeyOf(anotherValue);
            if (!(assessedTypeKeys == null ? anotherTypeKey != bestTypeKey : !assessedTypeKeys.contains(anotherTypeKey))) continue;
            Class anotherType = this.key2type.get(anotherTypeKey);
            assert (anotherType != null);
            Type commonType = bestType.getCommonType(this, anotherType);
            if (commonType == bestType) continue;
            if (assessedTypeKeys == null) {
                assessedTypeKeys = new ArrayList<Object>();
                assessedTypeKeys.add(bestTypeKey);
            } else if (count++ == 4) {
                assessedTypeKeys = new HashSet(assessedTypeKeys);
            }
            assessedTypeKeys.add(anotherTypeKey);
        }
        return bestType;
    }

    @Override
    public @NonNull TypedElement getTuplePart(@NonNull String name, @NonNull TypeId typeId) {
        return this.getTuplePart(name, this.getType(typeId, null));
    }

    public synchronized @NonNull TypedElement getTuplePart(@NonNull String name, @NonNull Type type) {
        TypedElement tupleProperty;
        Map<Type, WeakReference<TypedElement>> typeMap;
        if (this.tupleParts == null) {
            this.tupleParts = new WeakHashMap<String, Map<Type, WeakReference<TypedElement>>>();
        }
        if ((typeMap = this.tupleParts.get(name)) == null) {
            typeMap = new WeakHashMap<Type, WeakReference<TypedElement>>();
            this.tupleParts.put(name, typeMap);
        }
        if ((tupleProperty = this.weakGet(typeMap, type)) == null) {
            tupleProperty = new ExecutorTuplePart(type, name);
            typeMap.put(type, new WeakReference<TypedElement>(tupleProperty));
        }
        return tupleProperty;
    }

    @Override
    public abstract @NonNull TupleType getTupleType(@NonNull TupleTypeId var1);

    @Override
    public @NonNull Type getType(@NonNull TypeId typeId, @Nullable Object context) {
        Element type = typeId.accept(this);
        assert (type != null);
        return (Type)type;
    }

    private @NonNull Object getTypeKeyOf(@Nullable Object value) {
        if (value instanceof EObject) {
            EClass typeKey = ((EObject)value).eClass();
            assert (typeKey != null);
            Class type = this.key2type.get(typeKey);
            if (type == null) {
                type = this.getInheritance((EClassifier)typeKey).getPivotClass();
                assert (type != null);
                this.key2type.put(typeKey, type);
            }
            return typeKey;
        }
        if (value instanceof Value) {
            TypeId typeKey = ((Value)value).getTypeId();
            Class type = this.key2type.get(typeKey);
            if (type == null) {
                type = (Class)typeKey.accept(this);
                assert (type != null);
                this.key2type.put(typeKey, type);
            }
            return typeKey;
        }
        if (value == null) {
            OclVoidTypeId typeKey = TypeId.OCL_VOID;
            this.key2type.put(typeKey, this.standardLibrary.getOclVoidType());
            return typeKey;
        }
        java.lang.Class<?> typeKey = value.getClass();
        assert (typeKey != null);
        Class type = this.key2type.get(typeKey);
        if (type != null) {
            return typeKey;
        }
        if (value instanceof Boolean) {
            type = this.standardLibrary.getBooleanType();
        } else if (value instanceof String) {
            type = this.standardLibrary.getStringType();
        }
        if (type != null) {
            this.key2type.put(typeKey, type);
            return typeKey;
        }
        throw new UnsupportedOperationException();
    }

    public boolean isOrdered(@NonNull Object aCollection) {
        if (aCollection instanceof CollectionValue) {
            return ((CollectionValue)aCollection).isOrdered();
        }
        if (aCollection instanceof EcoreEList) {
            EStructuralFeature eStructuralFeature = ((EcoreEList)aCollection).getEStructuralFeature();
            if (eStructuralFeature != null) {
                return eStructuralFeature.isOrdered();
            }
        } else {
            if (aCollection instanceof List) {
                return true;
            }
            if (aCollection instanceof LinkedHashSet) {
                return true;
            }
        }
        return false;
    }

    public boolean isUnique(@NonNull Object aCollection) {
        if (aCollection instanceof CollectionValue) {
            return ((CollectionValue)aCollection).isUnique();
        }
        if (aCollection instanceof EcoreEList) {
            EStructuralFeature eStructuralFeature = ((EcoreEList)aCollection).getEStructuralFeature();
            if (eStructuralFeature != null) {
                return eStructuralFeature.isUnique();
            }
        } else if (aCollection instanceof Set) {
            return true;
        }
        return false;
    }

    @Override
    public boolean oclEquals(@Nullable Object thisObject, @Nullable Object thatObject) {
        boolean thatIsCollecting;
        if (thisObject == thatObject) {
            return true;
        }
        if (thisObject == null || thatObject == null) {
            return false;
        }
        boolean thisIsValue = thisObject instanceof Value;
        boolean thatIsValue = thatObject instanceof Value;
        if (thisIsValue && thatIsValue) {
            return ((Value)thisObject).equals(thatObject);
        }
        boolean thisIsOCLValue = thisObject instanceof OCLValue;
        boolean thatIsOCLValue = thatObject instanceof OCLValue;
        if (thisIsOCLValue || thatIsOCLValue) {
            OCLValue thisOCLValue = (OCLValue)(thisIsOCLValue ? thisObject : this.boxedValueOf(thisObject));
            OCLValue thatOCLValue = (OCLValue)(thatIsOCLValue ? thatObject : this.boxedValueOf(thatObject));
            assert (thisOCLValue != null);
            assert (thatOCLValue != null);
            return thisOCLValue.oclEquals(thatOCLValue);
        }
        boolean thisIsCollection = thisObject instanceof Collection;
        boolean thatIsCollection = thatObject instanceof Collection;
        boolean thisIsCollectionValue = thisObject instanceof CollectionValue;
        boolean thatIsCollectionValue = thatObject instanceof CollectionValue;
        boolean thisIsCollecting = thisIsCollection || thisIsCollectionValue;
        boolean bl = thatIsCollecting = thatIsCollection || thatIsCollectionValue;
        if (thisIsCollecting || thatIsCollecting) {
            int thatSize;
            boolean thatIsOrdered;
            boolean thatIsUnique;
            if (!thisIsCollecting || !thatIsCollecting) {
                return false;
            }
            boolean thisIsUnique = this.isUnique(thisObject);
            if (thisIsUnique != (thatIsUnique = this.isUnique(thatObject))) {
                return false;
            }
            boolean thisIsOrdered = this.isOrdered(thisObject);
            if (thisIsOrdered != (thatIsOrdered = this.isOrdered(thatObject))) {
                return false;
            }
            int thisSize = thisIsCollection ? ((Collection)thisObject).size() : ((CollectionValue)thisObject).intSize();
            int n = thatSize = thatIsCollection ? ((Collection)thatObject).size() : ((CollectionValue)thatObject).intSize();
            if (thisSize != thatSize) {
                return false;
            }
            Iterator thisIterator = ((Iterable)thisObject).iterator();
            Iterator thatIterator = ((Iterable)thatObject).iterator();
            if (thisIsOrdered) {
                while (thisIterator.hasNext() && thatIterator.hasNext()) {
                    Object thatElement;
                    Object thisElement = thisIterator.next();
                    if (this.oclEquals(thisElement, thatElement = thatIterator.next())) continue;
                    return false;
                }
                return !thisIterator.hasNext() && !thatIterator.hasNext();
            }
            if (thisSize < thatSize) {
                return this.oclEqualsUnordered(thisIterator, thatIterator);
            }
            return this.oclEqualsUnordered(thatIterator, thisIterator);
        }
        boolean thisIsNumber = thisObject instanceof Number;
        boolean thatIsNumber = thatObject instanceof Number;
        if (thisIsNumber || thatIsNumber) {
            Value thatValue;
            Value thisValue;
            if (thisIsNumber) {
                thisValue = ValueUtil.numberValueOf((Number)thisObject);
            } else if (thisObject instanceof Value) {
                thisValue = (Value)thisObject;
            } else {
                return false;
            }
            if (thatIsNumber) {
                thatValue = ValueUtil.numberValueOf((Number)thatObject);
            } else if (thatObject instanceof Value) {
                thatValue = (Value)thatObject;
            } else {
                return false;
            }
            return thisValue.equals(thatValue);
        }
        return thisObject.equals(thatObject);
    }

    private boolean oclEqualsUnordered(Iterator<?> smallerIterator, Iterator<?> largerIterator) {
        Object zeroOrMoreElements;
        Integer hashCode;
        HashMap<Integer, Object> map = new HashMap<Integer, Object>();
        while (smallerIterator.hasNext()) {
            Object smallerElement = smallerIterator.next();
            hashCode = this.oclHashCode(smallerElement);
            zeroOrMoreElements = map.get(hashCode);
            if (zeroOrMoreElements == null && !map.containsKey(hashCode)) {
                map.put(hashCode, smallerElement);
                continue;
            }
            if (zeroOrMoreElements instanceof MyList) {
                ((MyList)zeroOrMoreElements).add(smallerElement);
                continue;
            }
            MyList twoOrMoreElements = new MyList();
            twoOrMoreElements.add(zeroOrMoreElements);
            twoOrMoreElements.add(smallerElement);
            map.put(hashCode, twoOrMoreElements);
        }
        while (largerIterator.hasNext()) {
            Object largerElement = largerIterator.next();
            hashCode = this.oclHashCode(largerElement);
            zeroOrMoreElements = map.get(hashCode);
            if (zeroOrMoreElements == null && !map.containsKey(hashCode)) {
                return false;
            }
            if (zeroOrMoreElements instanceof MyList) {
                boolean gotIt = false;
                MyList largerElements = (MyList)zeroOrMoreElements;
                for (Object smallerElement : largerElements) {
                    if (!this.oclEquals(smallerElement, largerElement)) continue;
                    largerElements.remove(smallerElement);
                    if (largerElements.size() <= 0) {
                        map.remove(hashCode);
                    }
                    gotIt = true;
                }
                if (gotIt) continue;
                return false;
            }
            if (zeroOrMoreElements != largerElement) continue;
            if (!this.oclEquals(zeroOrMoreElements, largerElement)) {
                return false;
            }
            map.remove(hashCode);
        }
        return map.size() == 0;
    }

    @Override
    public int oclHashCode(@Nullable Object anObject) {
        if (anObject == null) {
            return 0;
        }
        if (anObject instanceof OCLValue) {
            return ((OCLValue)anObject).oclHashCode();
        }
        if (anObject instanceof Value) {
            return ((Value)anObject).hashCode();
        }
        if (anObject instanceof Collection) {
            return ValueUtil.computeCollectionHashCode(this.isOrdered(anObject), this.isUnique(anObject), (Iterable)anObject);
        }
        if (anObject instanceof Number) {
            if (anObject instanceof BigDecimal || anObject instanceof Double || anObject instanceof Float || anObject instanceof BigInteger || anObject instanceof Long) {
                Object boxedValue = this.boxedValueOf(anObject);
                assert (boxedValue != null);
                return boxedValue.hashCode();
            }
            return ((Number)anObject).intValue();
        }
        return anObject.hashCode();
    }

    protected synchronized void processCrossReferencedRoots() {
        if (this.crossReferencedRootsProcessed) {
            return;
        }
        this.crossReferencedRootsProcessed = true;
        new EcoreUtil.ExternalCrossReferencer(this.directRoots){
            private static final long serialVersionUID = 1L;
            private Set<EObject> moreRoots;
            {
                this.moreRoots = new HashSet<EObject>();
                this.findExternalCrossReferences();
            }

            protected boolean crossReference(EObject eObject, EReference eReference, EObject crossReferencedEObject) {
                EObject root = EcoreUtil.getRootContainer((EObject)crossReferencedEObject);
                if (this.moreRoots.add(root) && !AbstractIdResolver.this.directRoots.contains(root)) {
                    if (root instanceof Model) {
                        AbstractIdResolver.this.addPackages(((Model)root).getOwnedPackages());
                    } else if (root instanceof Package) {
                        AbstractIdResolver.this.addPackage((Package)root);
                    }
                }
                return false;
            }
        };
    }

    protected synchronized void processDirectRoots() {
        if (this.directRootsProcessed) {
            return;
        }
        this.directRootsProcessed = true;
        HashSet<EPackage> ePackages = new HashSet<EPackage>();
        for (EObject eObject : this.directRoots) {
            if (eObject instanceof Model) {
                this.addPackages(((Model)eObject).getOwnedPackages());
                continue;
            }
            ePackages.add(eObject.eClass().getEPackage());
        }
        for (EPackage ePackage : ePackages) {
            this.addEPackage(ePackage);
        }
    }

    @Override
    public @Nullable Object unboxedValueOf(@Nullable Object boxedValue) {
        if (boxedValue instanceof Value) {
            return ((Value)boxedValue).asUnboxedObject(this);
        }
        if (boxedValue instanceof EnumerationLiteralId) {
            return this.unboxedValueOf((EnumerationLiteralId)boxedValue);
        }
        return boxedValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public @NonNull Enumerator unboxedValueOf(@NonNull EnumerationLiteralId enumerationLiteralId) {
        Enumerator enumerator;
        if (this.enumerationLiteral2enumerator == null) {
            AbstractIdResolver abstractIdResolver = this;
            synchronized (abstractIdResolver) {
                if (this.enumerationLiteral2enumerator == null) {
                    this.enumerationLiteral2enumerator = new HashMap<EnumerationLiteralId, Enumerator>();
                }
            }
        }
        if ((enumerator = this.enumerationLiteral2enumerator.get(enumerationLiteralId)) == null) {
            Map<EnumerationLiteralId, Enumerator> map = this.enumerationLiteral2enumerator;
            synchronized (map) {
                enumerator = this.enumerationLiteral2enumerator.get(enumerationLiteralId);
                if (enumerator == null) {
                    EnumerationLiteral enumerationLiteral = (EnumerationLiteral)enumerationLiteralId.accept(this);
                    if (enumerationLiteral != null) {
                        enumerator = enumerationLiteral.getEnumerator();
                        this.enumerationLiteral2enumerator.put(enumerationLiteralId, enumerator);
                    }
                    if (enumerator == null) {
                        throw new UnsupportedOperationException();
                    }
                }
            }
        }
        return enumerator;
    }

    @Override
    public @NonNull EList<Object> unboxedValuesOfAll(@NonNull Collection<? extends Object> boxedValues) {
        Object[] unboxedValues = new Object[boxedValues.size()];
        int i = 0;
        for (Object object : boxedValues) {
            unboxedValues[i++] = this.unboxedValueOf(object);
        }
        return new EcoreEList.UnmodifiableEList(null, null, i, unboxedValues);
    }

    @Override
    public @NonNull EList<Object> unboxedValuesOfEach(Object ... boxedValues) {
        Object[] unboxedValues = new Object[boxedValues.length];
        int i = 0;
        Object[] objectArray = boxedValues;
        int n = boxedValues.length;
        int n2 = 0;
        while (n2 < n) {
            Object boxedValue = objectArray[n2];
            unboxedValues[i++] = this.unboxedValueOf(boxedValue);
            ++n2;
        }
        return new EcoreEList.UnmodifiableEList(null, null, boxedValues.length, unboxedValues);
    }

    @Override
    public @NonNull Type visitClassId(@NonNull ClassId id) {
        Package parentPackage = (Package)id.getParent().accept(this);
        assert (parentPackage != null);
        Type nestedType = this.environment.getNestedType(parentPackage, id.getName());
        if (nestedType == null) {
            nestedType = this.environment.getNestedType(parentPackage, id.getName());
            throw new UnsupportedOperationException();
        }
        return nestedType;
    }

    public @NonNull Type visitCollectedId(@NonNull CollectionTypeId id) {
        Type elementType = (Type)id.getElementTypeId().accept(this);
        if (elementType == null) {
            throw new UnsupportedOperationException();
        }
        CollectionTypeId collectionTypeId = id.getGeneralizedId();
        Class collectionType = this.getCollectionType(collectionTypeId);
        return this.environment.getCollectionType(collectionType, elementType, false, null, null);
    }

    @Override
    public @NonNull Type visitCollectionTypeId(@NonNull CollectionTypeId id) {
        return this.getCollectionType(id);
    }

    @Override
    public @NonNull Type visitDataTypeId(@NonNull DataTypeId id) {
        Package parentPackage = (Package)id.getParent().accept(this);
        assert (parentPackage != null);
        Type nestedType = this.environment.getNestedType(parentPackage, id.getName());
        if (nestedType == null && (nestedType = this.environment.getNestedType(parentPackage, id.getName())) == null) {
            throw new UnsupportedOperationException();
        }
        return nestedType;
    }

    @Override
    public @NonNull Enumeration visitEnumerationId(@NonNull EnumerationId id) {
        Package parentPackage = (Package)id.getParent().accept(this);
        assert (parentPackage != null);
        Type nestedType = this.environment.getNestedType(parentPackage, id.getName());
        if (nestedType == null) {
            nestedType = this.environment.getNestedType(parentPackage, id.getName());
            throw new UnsupportedOperationException();
        }
        if (!(nestedType instanceof Enumeration)) {
            throw new UnsupportedOperationException();
        }
        return (Enumeration)nestedType;
    }

    @Override
    public @NonNull EnumerationLiteral visitEnumerationLiteralId(@NonNull EnumerationLiteralId id) {
        Element parent = id.getParentId().accept(this);
        if (!(parent instanceof Enumeration)) {
            throw new UnsupportedOperationException();
        }
        EnumerationLiteral enumerationLiteral = ((Enumeration)parent).getEnumerationLiteral(id.getName());
        if (enumerationLiteral == null) {
            throw new UnsupportedOperationException();
        }
        return enumerationLiteral;
    }

    @Override
    public @NonNull Type visitInvalidId(@NonNull OclInvalidTypeId id) {
        return this.standardLibrary.getOclInvalidType();
    }

    @Override
    public @NonNull Type visitLambdaTypeId(@NonNull LambdaTypeId id) {
        throw new UnsupportedOperationException();
    }

    @Override
    public @NonNull Type visitMapTypeId(@NonNull MapTypeId id) {
        return this.getMapType(id);
    }

    @Override
    public @NonNull Package visitNestedPackageId(@NonNull NestedPackageId packageId) {
        Package parentPackage = (Package)packageId.getParent().accept(this);
        assert (parentPackage != null);
        Package nestedPackage = this.environment.getNestedPackage(parentPackage, packageId.getName());
        if (nestedPackage == null) {
            throw new UnsupportedOperationException();
        }
        return nestedPackage;
    }

    @Override
    public synchronized @NonNull Package visitNsURIPackageId(@NonNull NsURIPackageId id) {
        EPackage ePackage;
        String nsURI = id.getNsURI();
        Package knownPackage = this.nsURI2package.get(nsURI);
        if (knownPackage != null) {
            return knownPackage;
        }
        Package libraryPackage = this.standardLibrary.getNsURIPackage(nsURI);
        if (libraryPackage != null) {
            this.nsURI2package.put(nsURI, libraryPackage);
            return libraryPackage;
        }
        if (!this.directRootsProcessed) {
            this.processDirectRoots();
            knownPackage = this.nsURI2package.get(nsURI);
            if (knownPackage != null) {
                return knownPackage;
            }
        }
        if (!this.crossReferencedRootsProcessed) {
            this.processCrossReferencedRoots();
            knownPackage = this.nsURI2package.get(nsURI);
            if (knownPackage != null) {
                return knownPackage;
            }
        }
        if ((ePackage = id.getEPackage()) != null) {
            Package asPackage = this.addEPackage(ePackage);
            return asPackage;
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public @NonNull Type visitNullId(@NonNull OclVoidTypeId id) {
        return this.standardLibrary.getOclVoidType();
    }

    @Override
    public @NonNull Operation visitOperationId(@NonNull OperationId id) {
        Class domainType = (Class)id.getParent().accept(this);
        if (domainType == null) {
            throw new UnsupportedOperationException();
        }
        CompleteInheritance inheritance = this.standardLibrary.getInheritance(domainType);
        Operation memberOperation = inheritance.getMemberOperation(id);
        if (memberOperation == null) {
            throw new UnsupportedOperationException();
        }
        return memberOperation;
    }

    @Override
    public @NonNull Type visitPrimitiveTypeId(@NonNull PrimitiveTypeId id) {
        Type primitiveType = this.standardLibrary.getPrimitiveType(id);
        if (primitiveType == null) {
            throw new UnsupportedOperationException();
        }
        return primitiveType;
    }

    @Override
    public @NonNull Property visitPropertyId(@NonNull PropertyId id) {
        Class domainType = (Class)id.getParent().accept(this);
        if (domainType == null) {
            throw new UnsupportedOperationException();
        }
        CompleteInheritance inheritance = this.standardLibrary.getInheritance(domainType);
        Property memberProperty = inheritance.getMemberProperty(id.getName());
        if (memberProperty == null) {
            throw new UnsupportedOperationException();
        }
        return memberProperty;
    }

    @Override
    public @Nullable Package visitRootPackageId(@NonNull RootPackageId id) {
        if (id == IdManager.METAMODEL) {
            return ClassUtil.nonNullState(this.getStandardLibrary().getPackage());
        }
        String name = id.getName();
        Package knownPackage = this.roots2package.get(name);
        if (knownPackage != null) {
            return knownPackage;
        }
        if (!this.directRootsProcessed) {
            this.processDirectRoots();
            knownPackage = this.roots2package.get(name);
            if (knownPackage != null) {
                return knownPackage;
            }
        }
        if (!this.crossReferencedRootsProcessed) {
            this.processCrossReferencedRoots();
            knownPackage = this.roots2package.get(name);
            if (knownPackage != null) {
                return knownPackage;
            }
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public @NonNull Element visitTemplateBinding(@NonNull TemplateBinding id) {
        return id.getTemplateParameter();
    }

    @Override
    public @NonNull Element visitTemplateParameterId(@NonNull TemplateParameterId id) {
        throw new UnsupportedOperationException();
    }

    @Override
    public @NonNull Type visitTemplateableTypeId(@NonNull TemplateableTypeId id) {
        return this.getType(id, null);
    }

    @Override
    public @NonNull TypedElement visitTuplePartId(@NonNull TuplePartId id) {
        throw new UnsupportedOperationException();
    }

    @Override
    public @NonNull Type visitTupleTypeId(@NonNull TupleTypeId id) {
        return this.getTupleType(id);
    }

    @Override
    public @NonNull Type visitUnspecifiedId(@NonNull UnspecifiedId id) {
        return (Type)id.getSpecifier();
    }

    protected <K, V> @Nullable V weakGet(@NonNull Map<K, WeakReference<V>> map, @NonNull K key) {
        WeakReference<V> ref = map.get(key);
        if (ref == null) {
            return null;
        }
        @Nullable T value = ref.get();
        if (value == null) {
            map.remove(key);
        }
        return (V)value;
    }

    public static final class Id2InstanceVisitor
    implements IdVisitor<Object> {
        protected final @NonNull String stringValue;

        private Id2InstanceVisitor(@NonNull String stringValue) {
            this.stringValue = stringValue;
        }

        @Override
        public @Nullable Object visitClassId(@NonNull ClassId id) {
            throw new UnsupportedOperationException();
        }

        @Override
        public @Nullable Object visitCollectionTypeId(@NonNull CollectionTypeId id) {
            throw new UnsupportedOperationException();
        }

        @Override
        public @Nullable Object visitDataTypeId(@NonNull DataTypeId id) {
            throw new UnsupportedOperationException();
        }

        @Override
        public @Nullable Object visitEnumerationId(@NonNull EnumerationId id) {
            return id.getEnumerationLiteralId(this.stringValue);
        }

        @Override
        public @Nullable Object visitEnumerationLiteralId(@NonNull EnumerationLiteralId id) {
            throw new UnsupportedOperationException();
        }

        @Override
        public @Nullable Object visitInvalidId(@NonNull OclInvalidTypeId id) {
            throw new UnsupportedOperationException();
        }

        @Override
        public @Nullable Object visitLambdaTypeId(@NonNull LambdaTypeId id) {
            throw new UnsupportedOperationException();
        }

        @Override
        public @Nullable Object visitMapTypeId(@NonNull MapTypeId id) {
            throw new UnsupportedOperationException();
        }

        @Override
        public @Nullable Object visitNestedPackageId(@NonNull NestedPackageId id) {
            throw new UnsupportedOperationException();
        }

        @Override
        public @Nullable Object visitNsURIPackageId(@NonNull NsURIPackageId id) {
            throw new UnsupportedOperationException();
        }

        @Override
        public @Nullable Object visitNullId(@NonNull OclVoidTypeId id) {
            return null;
        }

        @Override
        public @Nullable Object visitOperationId(@NonNull OperationId id) {
            throw new UnsupportedOperationException();
        }

        @Override
        public @Nullable Object visitPrimitiveTypeId(@NonNull PrimitiveTypeId id) {
            if (id == TypeId.BOOLEAN) {
                return Boolean.valueOf(this.stringValue);
            }
            if (id == TypeId.STRING) {
                return this.stringValue;
            }
            if (id == TypeId.INTEGER) {
                return ValueUtil.integerValueOf(this.stringValue);
            }
            if (id == TypeId.REAL) {
                return ValueUtil.realValueOf(this.stringValue);
            }
            if (id == TypeId.UNLIMITED_NATURAL) {
                return ValueUtil.integerValueOf(this.stringValue);
            }
            throw new UnsupportedOperationException();
        }

        @Override
        public @Nullable Object visitPropertyId(@NonNull PropertyId id) {
            throw new UnsupportedOperationException();
        }

        @Override
        public @Nullable Object visitRootPackageId(@NonNull RootPackageId id) {
            throw new UnsupportedOperationException();
        }

        @Override
        public @Nullable Object visitTemplateBinding(@NonNull TemplateBinding id) {
            throw new UnsupportedOperationException();
        }

        @Override
        public @Nullable Object visitTemplateParameterId(@NonNull TemplateParameterId id) {
            throw new UnsupportedOperationException();
        }

        @Override
        public @Nullable Object visitTemplateableTypeId(@NonNull TemplateableTypeId id) {
            throw new UnsupportedOperationException();
        }

        @Override
        public @Nullable Object visitTuplePartId(@NonNull TuplePartId id) {
            throw new UnsupportedOperationException();
        }

        @Override
        public @Nullable Object visitTupleTypeId(@NonNull TupleTypeId id) {
            throw new UnsupportedOperationException();
        }

        @Override
        public @Nullable Object visitUnspecifiedId(@NonNull UnspecifiedId id) {
            throw new UnsupportedOperationException();
        }
    }

    private static class MyList
    extends ArrayList<Object> {
        private MyList() {
        }
    }
}

