/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.internal.utilities;

import java.util.List;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.internal.complete.StandardLibraryInternal;
import org.eclipse.ocl.pivot.internal.manager.MetamodelManagerInternal;
import org.eclipse.ocl.pivot.internal.resource.ASResourceFactoryRegistry;
import org.eclipse.ocl.pivot.internal.resource.EnvironmentFactoryAdapter;
import org.eclipse.ocl.pivot.internal.utilities.EnvironmentFactoryInternal;
import org.eclipse.ocl.pivot.resource.BasicProjectManager;
import org.eclipse.ocl.pivot.resource.ProjectManager;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.OCL;

public class OCLInternal
extends OCL {
    public static @NonNull EnvironmentFactoryAdapter adapt(@NonNull Notifier notifier) {
        List eAdapters = (List)ClassUtil.nonNullEMF(notifier.eAdapters());
        EnvironmentFactoryAdapter adapter = ClassUtil.getAdapter(EnvironmentFactoryAdapter.class, eAdapters);
        if (adapter == null) {
            ProjectManager projectMap = null;
            ResourceSet resourceSet = null;
            if (notifier instanceof ResourceSet) {
                resourceSet = (ResourceSet)notifier;
                projectMap = BasicProjectManager.findAdapter(resourceSet);
            }
            if (projectMap == null) {
                projectMap = BasicProjectManager.createDefaultProjectManager();
            }
            EnvironmentFactoryInternal environmentFactory = ASResourceFactoryRegistry.INSTANCE.createEnvironmentFactory(projectMap, resourceSet);
            adapter = EnvironmentFactoryAdapter.find(notifier);
            if (adapter == null) {
                adapter = new EnvironmentFactoryAdapter(environmentFactory, notifier);
                eAdapters.add(adapter);
            }
            assert (adapter != null);
            assert (adapter.getEnvironmentFactory() == environmentFactory);
        }
        return adapter;
    }

    public static @NonNull OCLInternal newInstance() {
        return OCLInternal.newInstance(null);
    }

    public static @NonNull OCLInternal newInstance(@Nullable ResourceSet resourceSet) {
        return OCLInternal.newInstance(BasicProjectManager.createDefaultProjectManager(), resourceSet);
    }

    public static @NonNull OCLInternal newInstance(@NonNull ProjectManager projectManager, @Nullable ResourceSet externalResourceSet) {
        EnvironmentFactoryInternal environmentFactory = ASResourceFactoryRegistry.INSTANCE.createEnvironmentFactory(projectManager, externalResourceSet);
        OCLInternal ocl = OCLInternal.newInstance(environmentFactory);
        if (externalResourceSet != null) {
            environmentFactory.adapt((Notifier)externalResourceSet);
        }
        return ocl;
    }

    public static @NonNull OCLInternal newInstance(@NonNull EnvironmentFactoryInternal environmentFactory) {
        return new OCLInternal(environmentFactory);
    }

    public OCLInternal(@NonNull EnvironmentFactoryInternal environmentFactory) {
        super(environmentFactory);
    }

    @Override
    public @NonNull EnvironmentFactoryInternal getEnvironmentFactory() {
        assert (this.environmentFactory != null);
        return this.environmentFactory;
    }

    @Override
    public @NonNull MetamodelManagerInternal getMetamodelManager() {
        assert (this.environmentFactory != null);
        return this.environmentFactory.getMetamodelManager();
    }

    @Override
    public @NonNull StandardLibraryInternal getStandardLibrary() {
        assert (this.environmentFactory != null);
        return this.environmentFactory.getStandardLibrary();
    }

    public static /* bridge */ /* synthetic */ OCL newInstance(ProjectManager projectManager, ResourceSet resourceSet) {
        return OCLInternal.newInstance(projectManager, resourceSet);
    }

    public static /* bridge */ /* synthetic */ OCL newInstance(ResourceSet resourceSet) {
        return OCLInternal.newInstance(resourceSet);
    }

    public static /* bridge */ /* synthetic */ OCL newInstance() {
        return OCLInternal.newInstance();
    }
}

