/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.viewpoints.policy;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.papyrus.infra.architecture.representation.ModelRule;
import org.eclipse.papyrus.infra.architecture.representation.OwningRule;
import org.eclipse.papyrus.infra.core.architecture.RepresentationKind;
import org.eclipse.papyrus.infra.core.architecture.merged.MergedArchitectureViewpoint;
import org.eclipse.papyrus.infra.viewpoints.policy.ViewPrototype;
import org.eclipse.swt.graphics.Image;

public class ViewPrototypeContentProvider
implements ITreeContentProvider {
    private static ImageDescriptor loadImage(String uri) {
        URL url = null;
        try {
            url = new URL(uri);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return ImageDescriptor.createFromURL(url);
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public Object[] getElements(Object inputElement) {
        return (Object[])inputElement;
    }

    private Object[] getChildren(ViewPrototype view) {
        if (view.getRepresentationKind() == null) {
            return new String[0];
        }
        ArrayList<EObject> data = new ArrayList<EObject>();
        data.add(view.getRepresentationKind().eContainer());
        data.addAll((Collection<EObject>)view.getRepresentationKind().getLanguage().getProfiles());
        data.addAll((Collection<EObject>)view.getRepresentationKind().getModelRules());
        data.addAll((Collection<EObject>)view.getRepresentationKind().getOwningRules());
        return data.toArray();
    }

    public Object[] getChildren(Object element) {
        if (element instanceof MergedArchitectureViewpoint) {
            MergedArchitectureViewpoint viewpoint = (MergedArchitectureViewpoint)element;
            ArrayList<ViewPrototype> protos = new ArrayList<ViewPrototype>();
            for (RepresentationKind kind : viewpoint.getRepresentationKinds()) {
                protos.add(ViewPrototype.get((EObject)kind));
            }
            Collections.sort(protos, new ViewPrototype.Comp());
            return protos.toArray();
        }
        if (element instanceof ViewPrototype) {
            return this.getChildren((ViewPrototype)element);
        }
        return new Object[0];
    }

    public Object getParent(Object element) {
        return null;
    }

    public boolean hasChildren(Object element) {
        if (element instanceof MergedArchitectureViewpoint) {
            return true;
        }
        return element instanceof ViewPrototype;
    }

    public static class LP
    extends LabelProvider {
        private static final String IMG_VIEWPOINT = "imageViewpoint";
        private static final String IMG_PROFILE = "imageProfile";
        private static final String IMG_MODEL = "imageModel";
        private static final String IMG_OWNER = "imageOwner";
        private ImageRegistry images = new ImageRegistry(JFaceResources.getResources());

        public LP() {
            this.images.put(IMG_VIEWPOINT, ViewPrototypeContentProvider.loadImage("platform:/plugin/org.eclipse.papyrus.infra.core.architecture.edit/icons/full/obj16/MergedArchitectureViewpoint.gif"));
            this.images.put(IMG_PROFILE, ViewPrototypeContentProvider.loadImage("platform:/plugin/org.eclipse.papyrus.infra.viewpoints.policy/icons/Profile.gif"));
            this.images.put(IMG_MODEL, ViewPrototypeContentProvider.loadImage("platform:/plugin/org.eclipse.papyrus.infra.core.architecture.edit/icons/full/obj16/ModelRule.gif"));
            this.images.put(IMG_OWNER, ViewPrototypeContentProvider.loadImage("platform:/plugin/org.eclipse.papyrus.infra.core.architecture.edit/icons/full/obj16/OwningRule.gif"));
        }

        public void dispose() {
            super.dispose();
            this.images.dispose();
        }

        public String getText(Object element) {
            if (element instanceof MergedArchitectureViewpoint) {
                return "Viewpoint " + ((MergedArchitectureViewpoint)element).getName();
            }
            if (element instanceof ViewPrototype) {
                return ((ViewPrototype)element).getLabel();
            }
            if (element instanceof EPackage) {
                return "Required profile: " + ((EPackage)element).getNsURI();
            }
            if (element instanceof ModelRule) {
                return this.getText((ModelRule)element);
            }
            if (element instanceof OwningRule) {
                return this.getText((OwningRule)element);
            }
            return element.toString();
        }

        private String getText(ModelRule rule) {
            StringBuilder builder = new StringBuilder("Possible root: ");
            boolean first = true;
            for (EClass ste : rule.getStereotypes()) {
                if (!first) {
                    builder.append(", ");
                }
                builder.append("<<");
                builder.append(ste.getEPackage().getNsPrefix());
                builder.append("::");
                builder.append(ste.getName());
                builder.append(">>");
                first = false;
            }
            if (rule.getElement() != null) {
                if (!first) {
                    builder.append(" ");
                }
                builder.append(rule.getElement().getEPackage().getNsPrefix());
                builder.append("::");
                builder.append(rule.getElement().getName());
            }
            return builder.toString();
        }

        private String getText(OwningRule rule) {
            StringBuilder builder = new StringBuilder("Possible owner: ");
            boolean first = true;
            for (EClass ste : rule.getStereotypes()) {
                if (!first) {
                    builder.append(", ");
                }
                builder.append("<<");
                builder.append(ste.getEPackage().getNsPrefix());
                builder.append("::");
                builder.append(ste.getName());
                builder.append(">>");
                first = false;
            }
            if (rule.getElement() != null) {
                if (!first) {
                    builder.append(" ");
                }
                builder.append(rule.getElement().getEPackage().getNsPrefix());
                builder.append("::");
                builder.append(rule.getElement().getName());
            }
            return builder.toString();
        }

        public Image getImage(Object element) {
            if (element instanceof MergedArchitectureViewpoint) {
                return this.images.get(IMG_VIEWPOINT);
            }
            if (element instanceof ViewPrototype) {
                return ((ViewPrototype)element).getIcon();
            }
            if (element instanceof EPackage) {
                return this.images.get(IMG_PROFILE);
            }
            if (element instanceof ModelRule) {
                return this.images.get(IMG_MODEL);
            }
            if (element instanceof OwningRule) {
                return this.images.get(IMG_OWNER);
            }
            return null;
        }
    }
}

