/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.activity.helper;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.papyrus.infra.gmfdiag.common.editpolicies.IMaskManagedLabelEditPolicy;
import org.eclipse.papyrus.uml.diagram.common.Messages;
import org.eclipse.papyrus.uml.diagram.common.helper.StereotypedElementLabelHelper;
import org.eclipse.papyrus.uml.internationalization.utils.utils.UMLLabelInternationalization;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Pin;
import org.eclipse.uml2.uml.TypedElement;

public class PinLabelHelper
extends StereotypedElementLabelHelper {
    private static PinLabelHelper labelHelper;
    private final Map<String, String> masks = new HashMap<String, String>();

    public static PinLabelHelper getInstance() {
        if (labelHelper == null) {
            labelHelper = new PinLabelHelper();
        }
        return labelHelper;
    }

    private PinLabelHelper() {
        this.masks.put("type", Messages.ICustomAppearance_PIN_DISP_TYPE);
    }

    protected String elementLabel(GraphicalEditPart editPart) {
        Pin namedElement;
        IMaskManagedLabelEditPolicy policy = (IMaskManagedLabelEditPolicy)editPart.getEditPolicy((Object)"MaskManagedLabelPolicy");
        if (policy == null) {
            policy = (IMaskManagedLabelEditPolicy)editPart.getEditPolicy((Object)"INDRIRECT_MASK_MANAGED_LABEL");
        }
        Set<String> displayValue = Collections.emptySet();
        if (policy != null) {
            displayValue = policy.getCurrentDisplayValue();
        }
        return (namedElement = this.getUMLElement(editPart)) != null ? this.getCustomLabel((NamedElement)namedElement, displayValue) : "";
    }

    private String getCustomLabel(NamedElement namedElement, Collection<String> maskValues) {
        StringBuffer buffer = new StringBuffer();
        if (maskValues.contains("name")) {
            buffer.append(" ");
            String name = UMLLabelInternationalization.getInstance().getLabel(namedElement);
            buffer.append(name == null ? "" : name);
        }
        if (namedElement instanceof TypedElement && maskValues.contains("type")) {
            if (((TypedElement)namedElement).getType() != null) {
                buffer.append(": " + UMLLabelInternationalization.getInstance().getLabel((NamedElement)((TypedElement)namedElement).getType()));
            } else {
                buffer.append(": <Undefined>");
            }
        }
        return buffer.toString().trim();
    }

    public Map<String, String> getMasks() {
        return this.masks;
    }

    public Pin getUMLElement(GraphicalEditPart editPart) {
        Element element = super.getUMLElement(editPart);
        return element instanceof Pin ? (Pin)element : null;
    }
}

