/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.edit.parts;

import java.util.List;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.DelegatingLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.Locator;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.RunnableWithResult;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.requests.ReconnectRequest;
import org.eclipse.gmf.runtime.common.core.util.Log;
import org.eclipse.gmf.runtime.common.core.util.Trace;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ConnectionEditPart;
import org.eclipse.gmf.runtime.diagram.ui.internal.DiagramUIDebugOptions;
import org.eclipse.gmf.runtime.diagram.ui.internal.DiagramUIPlugin;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateConnectionViewRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateUnspecifiedTypeConnectionRequest;
import org.eclipse.gmf.runtime.emf.type.core.IHintedType;
import org.eclipse.gmf.runtime.gef.ui.figures.NodeFigure;
import org.eclipse.gmf.runtime.notation.Anchor;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.FillStyle;
import org.eclipse.gmf.runtime.notation.IdentityAnchor;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.gmf.runtime.notation.datatype.GradientData;
import org.eclipse.papyrus.uml.diagram.common.editparts.RoundedCompartmentEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.helpers.AnchorHelper;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.ExecutionSpecificationRectangleFigure;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.LifelineEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.MessageReplyEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.MessageSyncEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.policies.AppliedStereotypeCommentCreationEditPolicyEx;
import org.eclipse.papyrus.uml.diagram.sequence.edit.policies.SequenceReferenceEditPolicy;
import org.eclipse.papyrus.uml.diagram.sequence.edit.policies.UpdateConnectionReferenceEditPolicy;
import org.eclipse.papyrus.uml.diagram.sequence.edit.policies.UpdateWeakReferenceForExecSpecEditPolicy;
import org.eclipse.papyrus.uml.diagram.sequence.figures.ExecutionSpecificationNodePlate;
import org.eclipse.papyrus.uml.diagram.sequence.providers.UMLElementTypes;
import org.eclipse.papyrus.uml.diagram.sequence.referencialgrilling.ConnectExecutionToGridEditPolicy;
import org.eclipse.papyrus.uml.diagram.sequence.referencialgrilling.ConnectYCoordinateToGrillingEditPolicy;
import org.eclipse.swt.graphics.Color;
import org.eclipse.uml2.uml.ExecutionSpecification;

public abstract class AbstractExecutionSpecificationEditPart
extends RoundedCompartmentEditPart {
    public static final String EXECUTION_FIX_ANCHOR_POSITION = "Execution Fix Anchor Position";
    public static int DEFAUT_HEIGHT = 100;
    public static int DEFAUT_WIDTH = 20;

    public AbstractExecutionSpecificationEditPart(View view) {
        super(view);
    }

    public List getChildren() {
        return super.getChildren();
    }

    protected void initExecutionSpecificationEndEditPart() {
        EObject element = this.resolveSemanticElement();
        if (!(element instanceof ExecutionSpecification)) {
            return;
        }
        ExecutionSpecification execution = (ExecutionSpecification)element;
        Diagram diagram = ((View)this.getModel()).getDiagram();
    }

    protected void createDefaultEditPolicies() {
        super.createDefaultEditPolicies();
        this.installEditPolicy(ConnectYCoordinateToGrillingEditPolicy.CONNECT_TO_GRILLING_MANAGEMENT, (EditPolicy)new ConnectExecutionToGridEditPolicy());
        this.installEditPolicy("AppliedStereotypeComment", (EditPolicy)new AppliedStereotypeCommentCreationEditPolicyEx());
        this.installEditPolicy("SEQUENCE_REFERENCE", (EditPolicy)new SequenceReferenceEditPolicy());
        this.installEditPolicy(UpdateConnectionReferenceEditPolicy.UDPATE_CONNECTION_REFERENCE, (EditPolicy)new UpdateConnectionReferenceEditPolicy());
        this.installEditPolicy("UpdateWeakReferenceForExecSpecEditPolicy", (EditPolicy)new UpdateWeakReferenceForExecSpecEditPolicy());
    }

    protected void setLineWidth(int width) {
        if (this.getPrimaryShape() instanceof NodeFigure) {
            this.getPrimaryShape().setLineWidth(width);
        }
    }

    protected void setTransparency(int transp) {
        this.getPrimaryShape().setTransparency(transp);
    }

    protected void setBackgroundColor(Color color) {
        this.getPrimaryShape().setBackgroundColor(color);
        this.getPrimaryShape().setIsUsingGradient(false);
        this.getPrimaryShape().setGradientData(-1, -1, 0);
    }

    protected void setGradient(GradientData gradient) {
        ExecutionSpecificationRectangleFigure fig = this.getPrimaryShape();
        FillStyle style = (FillStyle)this.getPrimaryView().getStyle(NotationPackage.Literals.FILL_STYLE);
        if (gradient != null) {
            fig.setIsUsingGradient(true);
            fig.setGradientData(style.getFillColor(), gradient.getGradientColor1(), gradient.getGradientStyle());
        } else {
            fig.setIsUsingGradient(false);
        }
    }

    public boolean supportsGradient() {
        return true;
    }

    public abstract ExecutionSpecificationRectangleFigure getPrimaryShape();

    public ConnectionAnchor getTargetConnectionAnchor(Request request) {
        Object fixPos = request.getExtendedData().get(EXECUTION_FIX_ANCHOR_POSITION);
        if (fixPos != null && (fixPos.equals(8) || fixPos.equals(32))) {
            return new AnchorHelper.FixedAnchorEx(this.getFigure(), (Integer)fixPos);
        }
        if (request instanceof CreateUnspecifiedTypeConnectionRequest) {
            CreateUnspecifiedTypeConnectionRequest createRequest = (CreateUnspecifiedTypeConnectionRequest)request;
            List relationshipTypes = createRequest.getElementTypes();
            for (Object obj : relationshipTypes) {
                if (!UMLElementTypes.Message_SynchEdge.equals(obj) || createRequest.getTargetEditPart().equals(createRequest.getSourceEditPart())) continue;
                return new AnchorHelper.FixedAnchorEx(this.getFigure(), 8);
            }
        } else if (request instanceof ReconnectRequest) {
            ReconnectRequest reconnectRequest = (ReconnectRequest)request;
            org.eclipse.gef.ConnectionEditPart connectionEditPart = reconnectRequest.getConnectionEditPart();
            if (connectionEditPart instanceof MessageSyncEditPart) {
                return new AnchorHelper.FixedAnchorEx(this.getFigure(), 8);
            }
        } else if (request instanceof CreateConnectionViewRequest) {
            CreateConnectionViewRequest createRequest = (CreateConnectionViewRequest)request;
            CreateConnectionViewRequest.ConnectionViewDescriptor viewDesc = ((CreateConnectionViewRequest)request).getConnectionViewDescriptor();
            if (((IHintedType)UMLElementTypes.Message_SynchEdge).getSemanticHint().equals(viewDesc.getSemanticHint()) && !createRequest.getTargetEditPart().equals(createRequest.getSourceEditPart())) {
                return new AnchorHelper.FixedAnchorEx(this.getFigure(), 8);
            }
        }
        return super.getTargetConnectionAnchor(request);
    }

    public ConnectionAnchor getTargetConnectionAnchor(org.eclipse.gef.ConnectionEditPart connEditPart) {
        int position;
        if (connEditPart instanceof MessageSyncEditPart) {
            return new AnchorHelper.FixedAnchorEx(this.getFigure(), 8);
        }
        final ConnectionEditPart connection = (ConnectionEditPart)connEditPart;
        String t = null;
        try {
            t = (String)this.getEditingDomain().runExclusive((Runnable)new RunnableWithResult.Impl(){

                public void run() {
                    Anchor a = ((Edge)connection.getModel()).getTargetAnchor();
                    if (a instanceof IdentityAnchor) {
                        this.setResult(((IdentityAnchor)a).getId());
                    } else {
                        this.setResult("");
                    }
                }
            });
        }
        catch (InterruptedException e) {
            Trace.catching((Plugin)DiagramUIPlugin.getInstance(), (String)DiagramUIDebugOptions.EXCEPTIONS_CATCHING, ((Object)((Object)this)).getClass(), (String)"getTargetConnectionAnchor", (Throwable)e);
            Log.error((Plugin)DiagramUIPlugin.getInstance(), (int)9, (String)"getTargetConnectionAnchor", (Throwable)e);
        }
        if (t != null && !"".equals(t) && (position = AnchorHelper.FixedAnchorEx.parsePosition(t)) != -1) {
            return new AnchorHelper.FixedAnchorEx(this.getFigure(), position);
        }
        return super.getTargetConnectionAnchor(connEditPart);
    }

    public ConnectionAnchor getSourceConnectionAnchor(Request request) {
        ReconnectRequest reconnectRequest;
        org.eclipse.gef.ConnectionEditPart connectionEditPart;
        Object fixPos = request.getExtendedData().get(EXECUTION_FIX_ANCHOR_POSITION);
        if (fixPos != null && (fixPos.equals(8) || fixPos.equals(32))) {
            return new AnchorHelper.FixedAnchorEx(this.getFigure(), (Integer)fixPos);
        }
        if (request instanceof CreateUnspecifiedTypeConnectionRequest) {
            CreateUnspecifiedTypeConnectionRequest createRequest = (CreateUnspecifiedTypeConnectionRequest)request;
            List relationshipTypes = createRequest.getElementTypes();
            for (Object obj : relationshipTypes) {
                if (!UMLElementTypes.Message_ReplyEdge.equals(obj)) continue;
                return new AnchorHelper.FixedAnchorEx(this.getFigure(), 32);
            }
        } else if (request instanceof ReconnectRequest && (connectionEditPart = (reconnectRequest = (ReconnectRequest)request).getConnectionEditPart()) instanceof MessageReplyEditPart) {
            return new AnchorHelper.FixedAnchorEx(this.getFigure(), 32);
        }
        return super.getSourceConnectionAnchor(request);
    }

    public ConnectionAnchor getSourceConnectionAnchor(org.eclipse.gef.ConnectionEditPart connEditPart) {
        int position;
        if (connEditPart instanceof MessageReplyEditPart) {
            return new AnchorHelper.FixedAnchorEx(this.getFigure(), 32);
        }
        final ConnectionEditPart connection = (ConnectionEditPart)connEditPart;
        String t = null;
        try {
            t = (String)this.getEditingDomain().runExclusive((Runnable)new RunnableWithResult.Impl(){

                public void run() {
                    Anchor a = ((Edge)connection.getModel()).getSourceAnchor();
                    if (a instanceof IdentityAnchor) {
                        this.setResult(((IdentityAnchor)a).getId());
                    } else {
                        this.setResult("");
                    }
                }
            });
        }
        catch (InterruptedException e) {
            Trace.catching((Plugin)DiagramUIPlugin.getInstance(), (String)DiagramUIDebugOptions.EXCEPTIONS_CATCHING, ((Object)((Object)this)).getClass(), (String)"getSourceConnectionAnchor", (Throwable)e);
            Log.error((Plugin)DiagramUIPlugin.getInstance(), (int)9, (String)"getSourceConnectionAnchor", (Throwable)e);
        }
        if (t != null && !"".equals(t) && (position = AnchorHelper.FixedAnchorEx.parsePosition(t)) != -1) {
            return new AnchorHelper.FixedAnchorEx(this.getFigure(), position);
        }
        return super.getSourceConnectionAnchor(connEditPart);
    }

    protected void refreshVisuals() {
        super.refreshVisuals();
        this.refreshTransparency();
        this.refreshShadow();
    }

    protected NodeFigure createMainFigureWithSVG() {
        NodeFigure figure = this.createSVGNodePlate();
        figure.setLayoutManager((LayoutManager)new DelegatingLayout(){

            public void layout(IFigure parent) {
                List children = parent.getChildren();
                int i = 0;
                while (i < children.size()) {
                    IFigure child = (IFigure)children.get(i);
                    Object locator = this.getConstraint(child);
                    if (locator instanceof Locator) {
                        ((Locator)locator).relocate(child);
                    }
                    ++i;
                }
            }
        });
        this.shape = this.createNodeShape();
        figure.add(this.shape, (Object)new FillParentLocator());
        this.setupContentPane(this.shape);
        return figure;
    }

    protected NodeFigure createSVGNodePlate() {
        ExecutionSpecificationNodePlate svgNodePlateFigure = new ExecutionSpecificationNodePlate((GraphicalEditPart)this, -1, -1);
        svgNodePlateFigure.setMinimumSize(new Dimension(this.getMapMode().DPtoLP(16), this.getMapMode().DPtoLP(20)));
        this.svgNodePlate = svgNodePlateFigure.withLinkLFEnabled();
        this.svgNodePlate.setDefaultNodePlate(this.createNodePlate());
        return this.svgNodePlate;
    }

    public void showTargetFeedback(Request request) {
        ChangeBoundsRequest changeBoundsRequest;
        if (request instanceof ChangeBoundsRequest && (changeBoundsRequest = (ChangeBoundsRequest)request).getEditParts().get(0) instanceof LifelineEditPart) {
            changeBoundsRequest.setMoveDelta(new Point(changeBoundsRequest.getMoveDelta().x, 0));
        }
        super.showTargetFeedback(request);
    }

    static class FillParentLocator
    implements Locator {
        FillParentLocator() {
        }

        public void relocate(IFigure target) {
            target.setBounds(target.getParent().getBounds());
        }
    }
}

