/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.referencialgrilling;

import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.ConnectionRouter;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.PrecisionRectangle;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gef.editpolicies.FeedbackHelper;
import org.eclipse.gef.requests.CreateConnectionRequest;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gef.requests.DropRequest;
import org.eclipse.gef.requests.ReconnectRequest;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.SetBoundsCommand;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.GraphicalNodeEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateConnectionViewAndElementRequest;
import org.eclipse.gmf.runtime.draw2d.ui.figures.BaseSlidableAnchor;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.gef.ui.figures.NodeFigure;
import org.eclipse.gmf.runtime.notation.Bounds;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.papyrus.commands.wrappers.GMFtoGEFCommandWrapper;
import org.eclipse.papyrus.infra.gmfdiag.common.editpart.NodeEditPart;
import org.eclipse.papyrus.infra.gmfdiag.common.editpolicies.DefaultGraphicalNodeEditPolicy;
import org.eclipse.papyrus.infra.gmfdiag.common.figure.node.PapyrusSlidableSnapToGridAnchor;
import org.eclipse.papyrus.infra.gmfdiag.common.service.palette.AspectUnspecifiedTypeConnectionTool;
import org.eclipse.papyrus.infra.gmfdiag.common.utils.DiagramEditPartsUtil;
import org.eclipse.papyrus.uml.diagram.sequence.command.CreateExecutionSpecificationWithMessage;
import org.eclipse.papyrus.uml.diagram.sequence.command.DropDestructionOccurenceSpecification;
import org.eclipse.papyrus.uml.diagram.sequence.command.SetMoveAllLineAtSamePositionCommand;
import org.eclipse.papyrus.uml.diagram.sequence.draw2d.routers.MessageRouter;
import org.eclipse.papyrus.uml.diagram.sequence.edit.helpers.AnchorHelper;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.CLifeLineEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.LifelineEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.MessageCreateEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.MessageDeleteEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.referencialgrilling.DisplayEvent;
import org.eclipse.papyrus.uml.diagram.sequence.referencialgrilling.GridManagementEditPolicy;
import org.eclipse.papyrus.uml.diagram.sequence.referencialgrilling.IGrillingEditpolicy;
import org.eclipse.papyrus.uml.diagram.sequence.referencialgrilling.SimpleSnapHelper;
import org.eclipse.papyrus.uml.diagram.sequence.util.LifelineEditPartUtil;
import org.eclipse.papyrus.uml.diagram.sequence.util.LifelineMessageCreateHelper;
import org.eclipse.papyrus.uml.diagram.sequence.util.LifelineMessageDeleteHelper;
import org.eclipse.papyrus.uml.diagram.sequence.util.SequenceUtil;
import org.eclipse.papyrus.uml.service.types.element.UMLDIElementTypes;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.PlatformUI;
import org.eclipse.uml2.uml.MessageEnd;
import org.eclipse.uml2.uml.MessageOccurrenceSpecification;
import org.eclipse.uml2.uml.OccurrenceSpecification;

public class LifeLineGraphicalNodeEditPolicy
extends DefaultGraphicalNodeEditPolicy
implements IGrillingEditpolicy {
    private GraphicalNodeEditPolicy graphicalNodeEditPolicy = null;
    private DisplayEvent displayEvent;
    private boolean precisionMode;
    public static ConnectionRouter messageRouter = new MessageRouter();

    protected Command getConnectionCreateCommand(CreateConnectionRequest request) {
        OccurrenceSpecification os;
        Point location;
        MessageOccurrenceSpecification mos;
        request.setLocation((Point)SequenceUtil.getSnappedLocation(this.getHost(), request.getLocation()));
        this.displayEvent.addFigureEvent(this.getHostFigure(), request.getLocation());
        MessageEnd end = this.getPreviousEventFromPosition(request.getLocation());
        if (end != null) {
            Map extendedData = request.getExtendedData();
            extendedData.put("previous event", end);
            request.setExtendedData(extendedData);
        }
        if ((mos = this.displayEvent.getMessageEvent(this.getHostFigure(), request.getLocation())) != null && (location = request.getLocation()) != this.displayEvent.getRealEventLocation(location)) {
            request.setLocation(this.displayEvent.getRealEventLocation(location));
        }
        if ((os = this.displayEvent.getActionExecutionSpecificationEvent(this.getHostFigure(), request.getLocation())) != null) {
            Map extendedData = request.getExtendedData();
            extendedData.put("MESSAGE_SENTEVENT_REPLACE_EXECUTIONEVENT", os);
            request.setExtendedData(extendedData);
            Point location2 = request.getLocation();
            if (location2 != this.displayEvent.getRealEventLocation(location2)) {
                request.setLocation(this.displayEvent.getRealEventLocation(location2));
            }
        }
        return super.getConnectionCreateCommand(request);
    }

    protected void eraseTargetConnectionFeedback(DropRequest request) {
        super.eraseTargetConnectionFeedback(request);
        this.displayEvent.removeFigureEvent(this.getHostFigure());
    }

    protected ConnectionAnchor getTargetConnectionAnchor(CreateConnectionRequest request) {
        ConnectionAnchor targetConnectionAnchor;
        request.setLocation((Point)SequenceUtil.getSnappedLocation(this.getHost(), request.getLocation()));
        ConnectionAnchor newTargetConnectionAnchor = targetConnectionAnchor = super.getTargetConnectionAnchor(request);
        if (targetConnectionAnchor != null) {
            CreateRequest requestForType;
            Point referenceTargetPoint = targetConnectionAnchor.getReferencePoint();
            if (request instanceof AspectUnspecifiedTypeConnectionTool.CreateAspectUnspecifiedTypeConnectionRequest && (requestForType = this.getCreateMessageRequest((AspectUnspecifiedTypeConnectionTool.CreateAspectUnspecifiedTypeConnectionRequest)request)) != null) {
                Map extendedData = requestForType.getExtendedData();
                Point sourceLocation = (Point)extendedData.get("EDGE_SOURCE_POINT");
                if (referenceTargetPoint != null && sourceLocation != null && (UMLDIElementTypes.MESSAGE_CREATE_EDGE.getSemanticHint().equals(((CreateConnectionViewAndElementRequest)requestForType).getConnectionViewAndElementDescriptor().getSemanticHint()) || this.isHorizontalConnection(sourceLocation, referenceTargetPoint) && request.getSourceEditPart() != request.getTargetEditPart() && !UMLDIElementTypes.MESSAGE_LOST_EDGE.getSemanticHint().equals(((CreateConnectionViewAndElementRequest)requestForType).getConnectionViewAndElementDescriptor().getSemanticHint()))) {
                    newTargetConnectionAnchor = this.getHorizontalAnchor(targetConnectionAnchor, referenceTargetPoint);
                }
            }
        }
        return newTargetConnectionAnchor;
    }

    protected ConnectionAnchor getSourceConnectionAnchor(CreateConnectionRequest request) {
        request.setLocation(this.displayEvent.getRealEventLocation(request.getLocation()));
        return super.getSourceConnectionAnchor(request);
    }

    protected CreateRequest getCreateMessageRequest(AspectUnspecifiedTypeConnectionTool.CreateAspectUnspecifiedTypeConnectionRequest request) {
        CreateRequest req = null;
        req = request.getRequestForType((IElementType)UMLDIElementTypes.MESSAGE_ASYNCH_EDGE);
        if (req == null) {
            req = request.getRequestForType((IElementType)UMLDIElementTypes.MESSAGE_SYNCH_EDGE);
        }
        if (req == null) {
            req = request.getRequestForType((IElementType)UMLDIElementTypes.MESSAGE_EDGE);
        }
        if (req == null) {
            req = request.getRequestForType((IElementType)UMLDIElementTypes.MESSAGE_OCCURRENCE_SPECIFICATION_SHAPE);
        }
        if (req == null) {
            req = request.getRequestForType((IElementType)UMLDIElementTypes.MESSAGE_REPLY_EDGE);
        }
        if (req == null) {
            req = request.getRequestForType((IElementType)UMLDIElementTypes.MESSAGE_DELETE_EDGE);
        }
        if (req == null) {
            req = request.getRequestForType((IElementType)UMLDIElementTypes.MESSAGE_FOUND_EDGE);
        }
        if (req == null) {
            req = request.getRequestForType((IElementType)UMLDIElementTypes.MESSAGE_LOST_EDGE);
        }
        if (req == null) {
            req = request.getRequestForType((IElementType)UMLDIElementTypes.MESSAGE_CREATE_EDGE);
        }
        return req;
    }

    protected ConnectionAnchor getHorizontalAnchor(ConnectionAnchor targetConnectionAnchor, Point referenceTargetPoint) {
        Object newTargetConnectionAnchor = null;
        if (targetConnectionAnchor.getOwner() instanceof NodeFigure) {
            NodeFigure figure = (NodeFigure)targetConnectionAnchor.getOwner();
            PrecisionPoint pt = BaseSlidableAnchor.getAnchorRelativeLocation((Point)referenceTargetPoint, (Rectangle)figure.getBounds());
            newTargetConnectionAnchor = new PapyrusSlidableSnapToGridAnchor(figure, pt){

                protected PointList getIntersectionPoints(Point ownReference, Point foreignReference) {
                    ownReference.setY(foreignReference.y());
                    return super.getIntersectionPoints(ownReference, foreignReference);
                }
            };
        } else {
            newTargetConnectionAnchor = targetConnectionAnchor;
        }
        return newTargetConnectionAnchor;
    }

    protected void eraseCreationFeedback(CreateConnectionRequest request) {
        super.eraseCreationFeedback(request);
        this.displayEvent = new DisplayEvent(this.getHost());
    }

    public void setHost(EditPart host) {
        super.setHost(host);
        this.displayEvent = new DisplayEvent(this.getHost());
    }

    protected ICommand getAfterConnectionCompleteCommand(CreateConnectionViewAndElementRequest request, TransactionalEditingDomain editingDomain) {
        return null;
    }

    protected Command getConnectionAndRelationshipCompleteCommand(CreateConnectionViewAndElementRequest request) {
        request.setLocation((Point)SequenceUtil.getSnappedLocation(this.getHost(), request.getLocation()));
        Point realEventLocation = this.displayEvent.getRealEventLocation(request.getLocation());
        if (request.getLocation() != realEventLocation) {
            request.setLocation(realEventLocation);
        }
        Command cmd = super.getConnectionAndRelationshipCompleteCommand(request);
        this.initModifier();
        if (!this.isAllowedMessageEnd(request)) {
            return UnexecutableCommand.INSTANCE;
        }
        this.forceHorizontalRequest(request);
        this.displayEvent.addFigureEvent(this.getHostFigure(), request.getLocation());
        this.updateExtendedData(request);
        if (request.getConnectionViewAndElementDescriptor().getSemanticHint().equals(UMLDIElementTypes.MESSAGE_CREATE_EDGE.getSemanticHint())) {
            return this.getCreateEdgeCommand(request, cmd);
        }
        if (request.getConnectionViewAndElementDescriptor().getSemanticHint().equals(UMLDIElementTypes.MESSAGE_DELETE_EDGE.getSemanticHint())) {
            return this.getDeleteEdgeCommand(request, cmd);
        }
        if (request.getConnectionViewAndElementDescriptor().getSemanticHint().equals(UMLDIElementTypes.MESSAGE_ASYNCH_EDGE.getSemanticHint()) || request.getConnectionViewAndElementDescriptor().getSemanticHint().equals(UMLDIElementTypes.MESSAGE_SYNCH_EDGE.getSemanticHint())) {
            return this.getSyncAsyncEdgeCommand(request, cmd);
        }
        if (request.getConnectionViewAndElementDescriptor().getSemanticHint().equals(UMLDIElementTypes.MESSAGE_FOUND_EDGE.getSemanticHint())) {
            return this.getBasicGraphicalNodeEditPolicy().getCommand((Request)request);
        }
        return cmd;
    }

    private void updateExtendedData(CreateConnectionViewAndElementRequest request) {
        OccurrenceSpecification os;
        MessageEnd end = this.getPreviousEventFromPosition(request.getLocation());
        if (end != null) {
            Map extendedData = request.getExtendedData();
            extendedData.put("second previous event", end);
            request.setExtendedData(extendedData);
        }
        if ((os = this.displayEvent.getActionExecutionSpecificationEvent(this.getHostFigure().getParent().getParent(), request.getLocation())) != null) {
            Map extendedData = request.getExtendedData();
            extendedData.put("MESSAGE_RECEIVEEVENT_REPLACE_EXECUTIONEVENT", os);
            request.setExtendedData(extendedData);
        }
    }

    private void initModifier() {
        PlatformUI.getWorkbench().getDisplay().addFilter(1, new Listener(){

            public void handleEvent(Event event) {
                LifeLineGraphicalNodeEditPolicy.this.precisionMode = event.keyCode == 131072;
            }
        });
        PlatformUI.getWorkbench().getDisplay().addFilter(2, new Listener(){

            public void handleEvent(Event event) {
                if (event.keyCode == 131072) {
                    LifeLineGraphicalNodeEditPolicy.this.precisionMode = false;
                }
            }
        });
    }

    protected void forceHorizontalRequest(CreateConnectionViewAndElementRequest request) {
        Map extendedData = request.getExtendedData();
        Object sourceLocation = extendedData.get("EDGE_SOURCE_POINT");
        if (sourceLocation instanceof Point) {
            Point sourceLocationPoint = (Point)sourceLocation;
            Point targetLocation = request.getLocation();
            if (sourceLocationPoint.y() != targetLocation.y() && (request.getConnectionViewAndElementDescriptor().getSemanticHint().equals(UMLDIElementTypes.MESSAGE_CREATE_EDGE.getSemanticHint()) || this.isHorizontalConnection(sourceLocationPoint, targetLocation))) {
                Point forceHorizontalPoint = new Point(targetLocation);
                forceHorizontalPoint.setY(sourceLocationPoint.y());
                request.setLocation(forceHorizontalPoint);
            }
        }
    }

    private boolean isHorizontalConnection(Point sourcePoint, Point targetPoint) {
        boolean horizontal = true;
        int realDelta = sourcePoint.y - targetPoint.y;
        horizontal = !this.precisionMode ? Math.abs(realDelta) <= 65 : Math.abs(realDelta) <= 10;
        return horizontal;
    }

    protected Command getSyncAsyncEdgeCommand(CreateConnectionViewAndElementRequest request, Command cmd) {
        DiagramEditPart diagramEditPart = this.getDiagramEditPart(this.getHost());
        GridManagementEditPolicy grid = (GridManagementEditPolicy)diagramEditPart.getEditPolicy((Object)GridManagementEditPolicy.GRID_MANAGEMENT);
        CreateExecutionSpecificationWithMessage createExecutionSpecificationwithMsg = new CreateExecutionSpecificationWithMessage(this.getDiagramEditPart(this.getHost()).getEditingDomain(), request, (EditPart)((NodeEditPart)request.getTargetEditPart()));
        CompoundCommand compoundCommand = new CompoundCommand();
        SetMoveAllLineAtSamePositionCommand setMoveAllLineAtSamePositionCommand = new SetMoveAllLineAtSamePositionCommand(grid, false);
        compoundCommand.add((Command)setMoveAllLineAtSamePositionCommand);
        compoundCommand.add(cmd);
        compoundCommand.add((Command)new GMFtoGEFCommandWrapper((ICommand)createExecutionSpecificationwithMsg));
        setMoveAllLineAtSamePositionCommand = new SetMoveAllLineAtSamePositionCommand(grid, true);
        compoundCommand.add((Command)setMoveAllLineAtSamePositionCommand);
        return compoundCommand;
    }

    protected Command getDeleteEdgeCommand(CreateConnectionViewAndElementRequest request, Command cmd) {
        if (!LifelineMessageDeleteHelper.hasIncomingMessageDelete(request.getTargetEditPart())) {
            Point relativeSnappedLocation = request.getLocation().getCopy();
            relativeSnappedLocation = SequenceUtil.getSnappedLocation(this.getHost(), relativeSnappedLocation);
            this.getHostFigure().getParent().translateToRelative((Translatable)relativeSnappedLocation);
            if (LifelineEditPartUtil.getNextEventsFromPosition(relativeSnappedLocation, (LifelineEditPart)request.getTargetEditPart()).isEmpty()) {
                NodeEditPart targetEditPart = (NodeEditPart)request.getTargetEditPart();
                DropDestructionOccurenceSpecification dropDestructionOccurenceSpecification = new DropDestructionOccurenceSpecification(this.getDiagramEditPart(this.getHost()).getEditingDomain(), (Request)request, (EditPart)targetEditPart, request.getLocation().getCopy());
                CompoundCommand compoundCommand = new CompoundCommand();
                compoundCommand.add(cmd);
                compoundCommand.add((Command)new GMFtoGEFCommandWrapper((ICommand)dropDestructionOccurenceSpecification));
                if (targetEditPart instanceof CLifeLineEditPart) {
                    Bounds lifelineBounds = (Bounds)((Node)targetEditPart.getModel()).getLayoutConstraint();
                    Dimension size = new Dimension(lifelineBounds.getWidth(), relativeSnappedLocation.y - lifelineBounds.getY());
                    SetBoundsCommand setSizeCommand = new SetBoundsCommand(this.getDiagramEditPart(this.getHost()).getEditingDomain(), "Size LifeLine", (IAdaptable)new EObjectAdapter((EObject)targetEditPart.getNotationView()), size);
                    compoundCommand.add((Command)new GMFtoGEFCommandWrapper((ICommand)setSizeCommand));
                }
                return compoundCommand;
            }
        }
        return UnexecutableCommand.INSTANCE;
    }

    protected Command getCreateEdgeCommand(CreateConnectionViewAndElementRequest request, Command cmd) {
        if (request.getTargetEditPart() instanceof LifelineEditPart && !LifelineMessageCreateHelper.hasIncomingMessageCreate(request.getTargetEditPart()) && !LifelineEditPartUtil.hasPreviousEvent(request.getLocation().getCopy(), (LifelineEditPart)request.getTargetEditPart())) {
            NodeEditPart nodeEP = (NodeEditPart)request.getTargetEditPart();
            Map requestParameters = request.getExtendedData();
            Point sourcePoint = ((Point)requestParameters.get("EDGE_SOURCE_POINT")).getCopy();
            return this.getSetLifelinePositionCommand(cmd, nodeEP, sourcePoint);
        }
        return UnexecutableCommand.INSTANCE;
    }

    protected CompoundCommand getSetLifelinePositionCommand(Command originalCommand, NodeEditPart targetEditPart, Point sourcePoint) {
        CompoundCommand compoundCommand = new CompoundCommand();
        if (targetEditPart instanceof CLifeLineEditPart) {
            PrecisionPoint snappedLocation = SequenceUtil.getSnappedLocation(this.getHost(), sourcePoint);
            this.getHostFigure().getParent().translateToRelative((Translatable)snappedLocation);
            int stickerHeight = ((CLifeLineEditPart)targetEditPart).getStickerHeight();
            if (stickerHeight != -1) {
                snappedLocation.y -= stickerHeight / 2;
            }
            Rectangle bounds = this.getHostFigure().getBounds();
            Rectangle newBounds = new Rectangle(new Point(bounds.x(), snappedLocation.y), new Dimension(bounds.width(), bounds.height() - snappedLocation.y));
            SetBoundsCommand setBoundsCommand = new SetBoundsCommand(this.getDiagramEditPart(this.getHost()).getEditingDomain(), "Move&Size LifeLine", (IAdaptable)new EObjectAdapter((EObject)targetEditPart.getNotationView()), newBounds);
            compoundCommand.add(originalCommand);
            compoundCommand.add((Command)new GMFtoGEFCommandWrapper((ICommand)setBoundsCommand));
        }
        return compoundCommand;
    }

    private boolean isAllowedMessageEnd(CreateConnectionViewAndElementRequest request) {
        Boolean allowed = true;
        if (!this.precisionMode) {
            Point targetLocation = request.getLocation();
            Map extendedData = request.getExtendedData();
            Object sourceLocation = extendedData.get("EDGE_SOURCE_POINT");
            if (sourceLocation instanceof Point) {
                allowed = allowed & this.isTargetLowerThanSource((Point)sourceLocation, targetLocation);
            }
        }
        return allowed;
    }

    private Boolean isTargetLowerThanSource(Point sourceLocation, Point targetLocation) {
        Boolean targetLowerThanSource = true;
        Point sourceLocationPoint = sourceLocation;
        targetLowerThanSource = sourceLocationPoint.y() <= targetLocation.y() + 65;
        return targetLowerThanSource;
    }

    protected GraphicalNodeEditPolicy getBasicGraphicalNodeEditPolicy() {
        if (this.graphicalNodeEditPolicy == null) {
            this.graphicalNodeEditPolicy = new GraphicalNodeEditPolicy();
            this.graphicalNodeEditPolicy.setHost(this.getHost());
        }
        return this.graphicalNodeEditPolicy;
    }

    protected Command getReconnectSourceCommand(ReconnectRequest request) {
        request.setLocation((Point)SequenceUtil.getSnappedLocation(this.getHost(), request.getLocation()));
        return this.getBasicGraphicalNodeEditPolicy().getCommand((Request)request);
    }

    protected Command getReconnectTargetCommand(ReconnectRequest request) {
        Command command = null;
        request.setLocation((Point)SequenceUtil.getSnappedLocation(this.getHost(), request.getLocation()));
        Command reconnectTargetCommand = this.getBasicGraphicalNodeEditPolicy().getCommand((Request)request);
        NodeEditPart nodeEP = (NodeEditPart)request.getTarget();
        if (nodeEP instanceof CLifeLineEditPart) {
            Point requestLocationCopy = request.getLocation().getCopy();
            if (request.getConnectionEditPart() instanceof MessageCreateEditPart) {
                if (!LifelineEditPartUtil.hasPreviousEvent(requestLocationCopy, (LifelineEditPart)this.getHost())) {
                    command = new CompoundCommand();
                    if (!LifelineMessageCreateHelper.hasIncomingMessageCreate((EditPart)nodeEP)) {
                        ((CompoundCommand)command).add((Command)this.getSetLifelinePositionCommand(reconnectTargetCommand, nodeEP, requestLocationCopy));
                    } else {
                        ((CompoundCommand)command).add(reconnectTargetCommand);
                    }
                    if (!request.getConnectionEditPart().getTarget().equals(request.getTarget())) {
                        ((CompoundCommand)command).add(LifelineEditPartUtil.getRestoreLifelinePositionOnMessageCreateRemovedCommand(request.getConnectionEditPart()));
                    }
                }
            } else if (request.getConnectionEditPart() instanceof MessageDeleteEditPart) {
                if (!LifelineEditPartUtil.hasNextEvent(requestLocationCopy, (LifelineEditPart)this.getHost())) {
                    command = new CompoundCommand();
                    if (!LifelineMessageDeleteHelper.hasIncomingMessageDelete((EditPart)nodeEP)) {
                        LifelineEditPart targetEditPart = (LifelineEditPart)this.getHost();
                        DropDestructionOccurenceSpecification dropDestructionOccurenceSpecification = new DropDestructionOccurenceSpecification(this.getDiagramEditPart(this.getHost()).getEditingDomain(), (Request)request, (EditPart)targetEditPart, requestLocationCopy);
                        CompoundCommand compoundCommand = new CompoundCommand();
                        compoundCommand.add(reconnectTargetCommand);
                        compoundCommand.add((Command)new GMFtoGEFCommandWrapper((ICommand)dropDestructionOccurenceSpecification));
                        if (targetEditPart instanceof CLifeLineEditPart) {
                            Bounds lifeLineBounds = (Bounds)((Node)targetEditPart.getModel()).getLayoutConstraint();
                            SetBoundsCommand setSizeCommand = new SetBoundsCommand(this.getDiagramEditPart(this.getHost()).getEditingDomain(), "Size LifeLine", (IAdaptable)new EObjectAdapter((EObject)targetEditPart.getNotationView()), new Dimension(lifeLineBounds.getWidth(), request.getLocation().y - lifeLineBounds.getY()));
                            compoundCommand.add((Command)new GMFtoGEFCommandWrapper((ICommand)setSizeCommand));
                        }
                    } else {
                        ((CompoundCommand)command).add(reconnectTargetCommand);
                    }
                    if (!request.getConnectionEditPart().getTarget().equals(request.getTarget())) {
                        ((CompoundCommand)command).add(LifelineEditPartUtil.getRestoreLifelinePositionOnMessageCreateRemovedCommand(request.getConnectionEditPart()));
                    }
                }
            } else {
                command = reconnectTargetCommand;
            }
        } else {
            command = reconnectTargetCommand;
        }
        return command;
    }

    public MessageEnd getPreviousEventFromPosition(Point point) {
        List<MessageEnd> previousEventsFromPosition = LifelineEditPartUtil.getPreviousEventsFromPosition(point, (LifelineEditPart)this.getHost());
        return previousEventsFromPosition.isEmpty() ? null : previousEventsFromPosition.get(0);
    }

    protected void computeTargetPosition(CreateConnectionRequest request, PrecisionPoint wanted) {
        ConnectionAnchor anchor = ((NodeEditPart)request.getTargetEditPart()).getTargetConnectionAnchor((Request)request);
        if (anchor instanceof AnchorHelper.InnerPointAnchor) {
            PrecisionPoint resultedPoint = BaseSlidableAnchor.parseTerminalString((String)((AnchorHelper.InnerPointAnchor)anchor).getTerminal());
            while (resultedPoint.getDistance((Point)wanted) > 2.0) {
                Point original = request.getLocation().getCopy();
                PrecisionPoint diff = new PrecisionPoint(original.x - resultedPoint.x, original.y - resultedPoint.y);
                PrecisionRectangle ptOnScreen = new PrecisionRectangle((double)resultedPoint.x, (double)resultedPoint.y, 0.0, 0.0);
                SimpleSnapHelper.snapAPoint(ptOnScreen, this.getHost().getRoot());
                PrecisionPoint Result = new PrecisionPoint(ptOnScreen.x + diff.x, ptOnScreen.y + diff.y);
                request.setLocation((Point)Result);
                anchor = ((NodeEditPart)request.getTargetEditPart()).getTargetConnectionAnchor((Request)request);
                resultedPoint = BaseSlidableAnchor.parseTerminalString((String)((AnchorHelper.InnerPointAnchor)anchor).getTerminal());
            }
        }
    }

    protected ConnectionRouter getDummyConnectionRouter(CreateConnectionRequest req) {
        return messageRouter;
    }

    protected FeedbackHelper getFeedbackHelper(CreateConnectionRequest request) {
        if (request.getTargetEditPart() instanceof NodeEditPart) {
            ConnectionAnchor targetAnchor = ((NodeEditPart)request.getTargetEditPart()).getTargetConnectionAnchor((Request)request);
            if (DiagramEditPartsUtil.isSnapToGridActive((EditPart)this.getHost()) && targetAnchor instanceof AnchorHelper.InnerPointAnchor) {
                PrecisionPoint pt = BaseSlidableAnchor.parseTerminalString((String)((AnchorHelper.InnerPointAnchor)targetAnchor).getTerminal());
                PrecisionRectangle ptOnScreen = new PrecisionRectangle((double)pt.x, (double)pt.y, 0.0, 0.0);
                SimpleSnapHelper.snapAPoint(ptOnScreen, this.getHost().getRoot());
                this.computeTargetPosition(request, new PrecisionPoint(ptOnScreen.x, ptOnScreen.y));
            }
        }
        return super.getFeedbackHelper(request);
    }
}

