/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.timing.custom.edit.policies;

import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.handles.MoveHandle;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.commands.SetBoundsCommand;
import org.eclipse.gmf.runtime.diagram.ui.editparts.LabelEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.NonResizableLabelEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.l10n.DiagramUIMessages;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.gmfdiag.common.utils.FigureUtils;
import org.eclipse.papyrus.uml.diagram.timing.custom.edit.commands.RefreshCommandForDo;
import org.eclipse.papyrus.uml.diagram.timing.custom.edit.commands.RefreshCommandForUndo;

public class ExternalLabelPrimaryDragRoleEditPolicy
extends NonResizableLabelEditPolicy {
    protected List<?> createSelectionHandles() {
        MoveHandle mh = new MoveHandle((GraphicalEditPart)this.getHost());
        mh.setBorder(null);
        return Collections.singletonList(mh);
    }

    protected Command getMoveCommand(ChangeBoundsRequest request) {
        LabelEditPart editPart = (LabelEditPart)this.getHost();
        IFigure parentFigure = this.getHostFigure().getParent();
        Rectangle parentBounds = parentFigure.getBounds();
        Rectangle updatedBounds = new Rectangle(this.getInitialFeedbackBounds());
        updatedBounds = updatedBounds.getTranslated(FigureUtils.scaleByZoom((Point)request.getMoveDelta(), (IFigure)parentFigure));
        updatedBounds = FigureUtils.constrainBoundsWithinContainingCompartment((Rectangle)updatedBounds, (IFigure)this.getHostFigure());
        updatedBounds = updatedBounds.getTranslated(parentBounds.getLocation().getNegated());
        CompoundCommand compoundCommand = new CompoundCommand();
        compoundCommand.add((Command)new RefreshCommandForUndo((GraphicalEditPart)editPart.getParent().getParent()));
        compoundCommand.add((Command)new ICommandProxy((ICommand)new SetBoundsCommand(editPart.getEditingDomain(), DiagramUIMessages.MoveLabelCommand_Label_Location, (IAdaptable)new EObjectAdapter((EObject)((View)editPart.getModel())), updatedBounds)));
        compoundCommand.add((Command)new RefreshCommandForDo((GraphicalEditPart)editPart));
        return compoundCommand;
    }
}

