/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.nattable.stereotype.display.utils;

import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.notation.BasicCompartment;
import org.eclipse.gmf.runtime.notation.DecorationNode;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxis.ITreeItemAxis;
import org.eclipse.papyrus.infra.nattable.utils.AxisUtils;
import org.eclipse.papyrus.uml.diagram.common.stereotype.display.helper.StereotypeDisplayCommandExecution;
import org.eclipse.papyrus.uml.diagram.common.stereotype.display.helper.StereotypeDisplayUtil;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Stereotype;

public class StereotypeDisplayTreeTableHelper {
    private static final String EMPTY_STRING = "";
    private static final String NA = "N/A";
    private StereotypeDisplayUtil helper = StereotypeDisplayUtil.getInstance();
    private static StereotypeDisplayTreeTableHelper labelHelper;

    private StereotypeDisplayTreeTableHelper() {
    }

    public static StereotypeDisplayTreeTableHelper getInstance() {
        if (labelHelper == null) {
            labelHelper = new StereotypeDisplayTreeTableHelper();
        }
        return labelHelper;
    }

    public String getShortValue(Object name) {
        String shortName = EMPTY_STRING;
        if (name instanceof String) {
            shortName = ((String)name).substring("stereotype_display_properties:/".length(), ((String)name).length());
        }
        return shortName;
    }

    public Object getDepthValue(Object rowElement) {
        Object parent;
        Object row = AxisUtils.getRepresentedElement((Object)rowElement);
        if (rowElement instanceof ITreeItemAxis && row instanceof Stereotype && (parent = AxisUtils.getRepresentedElement((Object)((ITreeItemAxis)rowElement).getParent().getParent().getParent().getParent())) instanceof View) {
            DecorationNode label = this.helper.getStereotypeLabel((View)parent, (Stereotype)row);
            if (label != null) {
                return this.helper.getDepth(label);
            }
            return NA;
        }
        return EMPTY_STRING;
    }

    public void setDepthValue(TransactionalEditingDomain domain, Object rowElement, Object newValue) {
        DecorationNode label;
        Object parent;
        Object row = AxisUtils.getRepresentedElement((Object)rowElement);
        if (row instanceof Stereotype && (parent = AxisUtils.getRepresentedElement((Object)((ITreeItemAxis)rowElement).getParent().getParent().getParent().getParent())) instanceof View && (label = this.helper.getStereotypeLabel((View)parent, (Stereotype)row)) != null && newValue instanceof String) {
            StereotypeDisplayCommandExecution.getInstance().setUserDepth(domain, (Stereotype)row, (View)label, (String)newValue);
        }
    }

    public Object getDisplayedValue(Object rowElement) {
        Object parent;
        Object row = AxisUtils.getRepresentedElement((Object)rowElement);
        if (rowElement instanceof ITreeItemAxis && row instanceof Stereotype && (parent = AxisUtils.getRepresentedElement((Object)((ITreeItemAxis)rowElement).getParent().getParent().getParent().getParent())) instanceof View) {
            DecorationNode propertyLabel = this.helper.getStereotypeLabel((View)parent, (Stereotype)row);
            if (propertyLabel != null) {
                return propertyLabel.isVisible();
            }
            return NA;
        }
        return EMPTY_STRING;
    }

    public void setDisplayedValue(TransactionalEditingDomain domain, Object rowElement, Object newValue) {
        DecorationNode label;
        Object parent;
        Object row = AxisUtils.getRepresentedElement((Object)rowElement);
        if (row instanceof Stereotype && (parent = AxisUtils.getRepresentedElement((Object)((ITreeItemAxis)rowElement).getParent().getParent().getParent().getParent())) instanceof View && newValue instanceof Boolean && (label = this.helper.getStereotypeLabel((View)parent, (Stereotype)row)) != null) {
            StereotypeDisplayCommandExecution.getInstance().setUserVisibility(domain, (View)label, ((Boolean)newValue).booleanValue());
        }
    }

    public Object getBraceValue(Object rowElement) {
        Object row = AxisUtils.getRepresentedElement((Object)rowElement);
        if (rowElement instanceof ITreeItemAxis) {
            Object parent;
            if (row instanceof Stereotype && (parent = AxisUtils.getRepresentedElement((Object)((ITreeItemAxis)rowElement).getParent().getParent().getParent().getParent())) instanceof View) {
                BasicCompartment brace = this.helper.getStereotypeBraceCompartment((View)parent, (Stereotype)row);
                if (brace != null) {
                    return brace.isVisible();
                }
                return NA;
            }
            if (row instanceof Property && ((Property)row).eContainer() instanceof Stereotype) {
                parent = AxisUtils.getRepresentedElement((Object)((ITreeItemAxis)rowElement).getParent().getParent().getParent().getParent().getParent().getParent());
                Object stereo = AxisUtils.getRepresentedElement((Object)((ITreeItemAxis)rowElement).getParent().getParent());
                if (parent instanceof View) {
                    DecorationNode brace = this.helper.getStereotypePropertyInBrace((View)parent, (Stereotype)stereo, (Property)row);
                    if (brace != null) {
                        return brace.isVisible();
                    }
                    return NA;
                }
            }
        }
        return EMPTY_STRING;
    }

    public void setBraceValue(TransactionalEditingDomain domain, Object rowElement, Object newValue) {
        BasicCompartment brace;
        Object parent;
        Object row = AxisUtils.getRepresentedElement((Object)rowElement);
        if (row instanceof Stereotype && (parent = AxisUtils.getRepresentedElement((Object)((ITreeItemAxis)rowElement).getParent().getParent().getParent().getParent())) instanceof View && newValue instanceof Boolean && (brace = this.helper.getStereotypeBraceCompartment((View)parent, (Stereotype)row)) != null) {
            StereotypeDisplayCommandExecution.getInstance().setUserVisibility(domain, (View)brace, ((Boolean)newValue).booleanValue());
        }
        if (row instanceof Property && ((Property)row).eContainer() instanceof Stereotype) {
            DecorationNode braceProperty;
            parent = AxisUtils.getRepresentedElement((Object)((ITreeItemAxis)rowElement).getParent().getParent().getParent().getParent().getParent().getParent());
            Object stereo = AxisUtils.getRepresentedElement((Object)((ITreeItemAxis)rowElement).getParent().getParent());
            if (parent instanceof View && stereo instanceof Stereotype && newValue instanceof Boolean && (braceProperty = this.helper.getStereotypePropertyInBrace((View)parent, (Stereotype)stereo, (Property)row)) != null) {
                StereotypeDisplayCommandExecution.getInstance().setUserVisibility(domain, (View)braceProperty, ((Boolean)newValue).booleanValue());
            }
        }
    }

    public Object getCommentValue(Object rowElement) {
        Object row = AxisUtils.getRepresentedElement((Object)rowElement);
        if (rowElement instanceof ITreeItemAxis) {
            Object parent;
            if (row instanceof Stereotype && (parent = AxisUtils.getRepresentedElement((Object)((ITreeItemAxis)rowElement).getParent().getParent().getParent().getParent())) instanceof View) {
                Node comment = this.helper.getStereotypeComment((View)parent);
                BasicCompartment compartment = this.helper.getStereotypeCompartment((View)comment, (Stereotype)row);
                if (comment != null && compartment != null) {
                    if (comment.isVisible() && compartment.isVisible()) {
                        return true;
                    }
                    return false;
                }
                return NA;
            }
            if (row instanceof Property && ((Property)row).eContainer() instanceof Stereotype) {
                parent = AxisUtils.getRepresentedElement((Object)((ITreeItemAxis)rowElement).getParent().getParent().getParent().getParent().getParent().getParent());
                Object stereo = AxisUtils.getRepresentedElement((Object)((ITreeItemAxis)rowElement).getParent().getParent());
                if (parent instanceof View && stereo instanceof Stereotype) {
                    DecorationNode comment = this.helper.getStereotypePropertyInComment((View)parent, (Stereotype)stereo, (Property)row);
                    if (comment != null) {
                        return comment.isVisible();
                    }
                    return NA;
                }
            }
        }
        return EMPTY_STRING;
    }

    public void setCommentValue(TransactionalEditingDomain domain, Object rowElement, Object newValue) {
        Node comment;
        Object parent;
        Object row = AxisUtils.getRepresentedElement((Object)rowElement);
        if (row instanceof Stereotype && (parent = AxisUtils.getRepresentedElement((Object)((ITreeItemAxis)rowElement).getParent().getParent().getParent().getParent())) instanceof View && newValue instanceof Boolean && (comment = this.helper.getStereotypeComment((View)parent)) != null) {
            BasicCompartment compartment = this.helper.getStereotypeCompartment((View)comment, (Stereotype)row);
            if (compartment != null) {
                StereotypeDisplayCommandExecution.getInstance().setUserVisibility(domain, (View)compartment, ((Boolean)newValue).booleanValue());
            }
            this.updateComment(domain, (View)comment);
        }
        if (row instanceof Property && ((Property)row).eContainer() instanceof Stereotype) {
            DecorationNode commentProperty;
            parent = AxisUtils.getRepresentedElement((Object)((ITreeItemAxis)rowElement).getParent().getParent().getParent().getParent().getParent().getParent());
            Object stereo = AxisUtils.getRepresentedElement((Object)((ITreeItemAxis)rowElement).getParent().getParent());
            if (parent instanceof View && stereo instanceof Stereotype && newValue instanceof Boolean && (commentProperty = this.helper.getStereotypePropertyInComment((View)parent, (Stereotype)stereo, (Property)row)) != null) {
                StereotypeDisplayCommandExecution.getInstance().setUserVisibility(domain, (View)commentProperty, ((Boolean)newValue).booleanValue());
            }
        }
    }

    public Object getCompartmentValue(Object rowElement) {
        Object row = AxisUtils.getRepresentedElement((Object)rowElement);
        if (rowElement instanceof ITreeItemAxis) {
            Object parent;
            if (row instanceof Stereotype && (parent = AxisUtils.getRepresentedElement((Object)((ITreeItemAxis)rowElement).getParent().getParent().getParent().getParent())) instanceof View) {
                BasicCompartment compartment = this.helper.getStereotypeCompartment((View)parent, (Stereotype)row);
                if (compartment != null) {
                    return compartment.isVisible();
                }
                return NA;
            }
            if (row instanceof Property && ((Property)row).eContainer() instanceof Stereotype) {
                parent = AxisUtils.getRepresentedElement((Object)((ITreeItemAxis)rowElement).getParent().getParent().getParent().getParent().getParent().getParent());
                Object stereo = AxisUtils.getRepresentedElement((Object)((ITreeItemAxis)rowElement).getParent().getParent());
                if (parent instanceof View) {
                    DecorationNode compartment = this.helper.getStereotypePropertyInCompartment((View)parent, (Stereotype)stereo, (Property)row);
                    if (compartment != null) {
                        return compartment.isVisible();
                    }
                    return NA;
                }
            }
        }
        return EMPTY_STRING;
    }

    public void setCompartmentValue(TransactionalEditingDomain domain, Object rowElement, Object newValue) {
        BasicCompartment compartment;
        Object parent;
        Object row = AxisUtils.getRepresentedElement((Object)rowElement);
        if (row instanceof Stereotype && (parent = AxisUtils.getRepresentedElement((Object)((ITreeItemAxis)rowElement).getParent().getParent().getParent().getParent())) instanceof View && newValue instanceof Boolean && (compartment = this.helper.getStereotypeCompartment((View)parent, (Stereotype)row)) != null) {
            StereotypeDisplayCommandExecution.getInstance().setUserVisibility(domain, (View)compartment, ((Boolean)newValue).booleanValue());
        }
        if (row instanceof Property && ((Property)row).eContainer() instanceof Stereotype) {
            DecorationNode property;
            parent = AxisUtils.getRepresentedElement((Object)((ITreeItemAxis)rowElement).getParent().getParent().getParent().getParent().getParent().getParent());
            Object stereo = AxisUtils.getRepresentedElement((Object)((ITreeItemAxis)rowElement).getParent().getParent());
            if (parent instanceof View && stereo instanceof Stereotype && newValue instanceof Boolean && (property = this.helper.getStereotypePropertyInCompartment((View)parent, (Stereotype)stereo, (Property)row)) != null) {
                StereotypeDisplayCommandExecution.getInstance().setUserVisibility(domain, (View)property, ((Boolean)newValue).booleanValue());
            }
        }
    }

    private void updateComment(TransactionalEditingDomain domain, View comment) {
        if (!StereotypeDisplayUtil.getInstance().hasVisibleCompartment(comment)) {
            StereotypeDisplayCommandExecution.getInstance().setUserVisibility(domain, comment, false);
        } else {
            StereotypeDisplayCommandExecution.getInstance().setUserVisibility(domain, comment, true);
        }
    }
}

