/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.cdtinterface.ui;

import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.cdt.core.CProjectNature;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescriptionManager;
import org.eclipse.cdt.ui.wizards.CDTCommonProjectWizard;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.photran.internal.cdtinterface.CDTInterfacePlugin;
import org.eclipse.photran.internal.cdtinterface.ui.Messages;
import org.eclipse.photran.internal.core.FProjectNature;

public class FortranProjectWizard
extends CDTCommonProjectWizard {
    public FortranProjectWizard() {
        this(Messages.FortranProjectWizard_Title, Messages.FortranProjectWizard_Description);
    }

    public FortranProjectWizard(String title, String desc) {
        super(title, desc);
    }

    public String[] getNatures() {
        return new String[]{"org.eclipse.photran.core.fnature", "org.eclipse.cdt.core.cnature"};
    }

    public String[] getLanguageIDs() {
        return new String[]{"org.eclipse.photran.cdtinterface.fortran"};
    }

    protected IProject continueCreation(IProject prj) {
        try {
            CProjectNature.addCNature((IProject)prj, (IProgressMonitor)new NullProgressMonitor());
            FProjectNature.addFNature((IProject)prj, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        return prj;
    }

    protected boolean setCreated() throws CoreException {
        ICProjectDescriptionManager mngr = CoreModel.getDefault().getProjectDescriptionManager();
        ICProjectDescription des = mngr.getProjectDescription(this.newProject, false);
        if (des.isCdtProjectCreating()) {
            des = mngr.getProjectDescription(this.newProject, true);
            des.setCdtProjectCreated();
            mngr.setProjectDescription(this.newProject, des, false, null);
            return true;
        }
        this.setFortranNatureFirst();
        return false;
    }

    private void setFortranNatureFirst() {
        IFile projFile = (IFile)this.newProject.findMember(".project");
        if (projFile.exists() && projFile.getLocation() != null) {
            try {
                String line;
                RandomAccessFile raFile = new RandomAccessFile(projFile.getLocation().toOSString(), "rws");
                ArrayList<String> lineList = new ArrayList<String>();
                while ((line = raFile.readLine()) != null) {
                    lineList.add(line);
                }
                raFile.close();
                Iterator itr = lineList.iterator();
                int first_index = -1;
                int phot_index = -1;
                while (itr.hasNext()) {
                    line = (String)itr.next();
                    if (line.trim().equals("<natures>")) {
                        first_index = lineList.indexOf(line) + 1;
                        continue;
                    }
                    if (!line.contains("photran")) continue;
                    phot_index = lineList.indexOf(line);
                }
                if (first_index < 0 || phot_index < 0) {
                    CDTInterfacePlugin.log((IStatus)new Status(2, "org.eclipse.photran.cdtinterface", "FortranProjectWizard#setFortranNatureFirst cannot proceed: Fortran nature not found (did you call #continueCreation?)"));
                    return;
                }
                String temp = (String)lineList.get(first_index);
                lineList.set(first_index, (String)lineList.get(phot_index));
                lineList.set(phot_index, temp);
                itr = lineList.iterator();
                StringBuffer content = new StringBuffer("");
                while (itr.hasNext()) {
                    content.append(String.valueOf((String)itr.next()) + "\n");
                }
                projFile.setContents((InputStream)new ByteArrayInputStream(content.toString().getBytes()), 1, null);
                lineList.clear();
            }
            catch (FileNotFoundException e) {
                CDTInterfacePlugin.log(e);
                e.printStackTrace();
            }
            catch (IOException e) {
                CDTInterfacePlugin.log(e);
                e.printStackTrace();
            }
            catch (CoreException e) {
                CDTInterfacePlugin.log(e);
                e.printStackTrace();
            }
        }
    }
}

