/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.codeassist.contexts;

import org.eclipse.dltk.annotations.NonNull;
import org.eclipse.dltk.core.CompletionRequestor;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.php.core.PHPVersion;
import org.eclipse.php.internal.core.codeassist.contexts.ClassStatementContext;
import org.eclipse.php.internal.core.codeassist.contexts.StatementContext;
import org.eclipse.php.internal.core.util.text.PHPTextSequenceUtilities;
import org.eclipse.php.internal.core.util.text.TextSequence;
import org.eclipse.php.internal.core.util.text.TextSequenceUtilities;
import org.eclipse.wst.sse.core.internal.parser.ContextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;

public abstract class UseStatementContext
extends StatementContext {
    protected TYPES type;
    protected TextSequence rebuiltUseStatementText;
    protected TextSequence longestStatementTextBeforeCursor;
    protected TextSequence biggestCommonStatementText;
    protected boolean isCursorInsideGroupStatement;

    private boolean hasUsePrefix(TextSequence statementText) {
        return statementText.length() >= 4 && "use".equalsIgnoreCase(statementText.subSequence(0, 3).toString()) && Character.isWhitespace(statementText.subSequence(3, 4).charAt(0));
    }

    private boolean buildUseStatement(int offset, @NonNull IStructuredDocumentRegion sdRegion, boolean isClassStatementContext) {
        TextSequence statementTextBeforeOpeningCurly;
        TextSequence statementText;
        ContextRegion[] foundDelimiter = new ContextRegion[1];
        this.longestStatementTextBeforeCursor = this.rebuiltUseStatementText = (statementText = PHPTextSequenceUtilities.getStatement(offset, sdRegion, true, foundDelimiter));
        this.biggestCommonStatementText = this.rebuiltUseStatementText;
        this.type = TYPES.NONE;
        this.isCursorInsideGroupStatement = false;
        boolean hasUsePrefix = this.hasUsePrefix(statementText);
        if (hasUsePrefix) {
            if (isClassStatementContext && this.getPHPVersion().isLessThan(PHPVersion.PHP5_4)) {
                return false;
            }
            this.type = isClassStatementContext ? TYPES.TRAIT : TYPES.USE;
            return true;
        }
        if (isClassStatementContext) {
            return false;
        }
        if (!this.getPHPVersion().isLessThan(PHPVersion.PHP7_0) && foundDelimiter[0] != null && foundDelimiter[0].getType() == "PHP_CURLY_OPEN" && foundDelimiter[0].getStart() >= 4 && this.hasUsePrefix(statementTextBeforeOpeningCurly = PHPTextSequenceUtilities.getStatement(foundDelimiter[0].getStart(), sdRegion, true, foundDelimiter))) {
            String s1 = statementTextBeforeOpeningCurly.toString();
            int endS1 = PHPTextSequenceUtilities.readBackwardSpaces(s1, s1.length());
            String s2 = statementText.toString();
            int idxS2 = s2.lastIndexOf(44) + 1;
            if ((idxS2 = PHPTextSequenceUtilities.readForwardSpaces(s2, idxS2)) < s2.length() && s2.charAt(idxS2) == '\\') {
                ++idxS2;
            }
            int start1 = statementTextBeforeOpeningCurly.getOriginalOffset(0);
            int start2 = statementText.getOriginalOffset(0);
            TextSequence res = TextSequenceUtilities.createTextSequence(statementTextBeforeOpeningCurly.getSource(), start1, start2 - start1 + statementText.length());
            res = res.cutTextSequence(endS1, start2 - start1 + idxS2);
            this.biggestCommonStatementText = TextSequenceUtilities.createTextSequence(statementTextBeforeOpeningCurly.getSource(), start1, endS1);
            this.longestStatementTextBeforeCursor = TextSequenceUtilities.createTextSequence(statementText.getSource(), start2 + idxS2, statementText.length() - idxS2);
            this.rebuiltUseStatementText = res;
            this.type = TYPES.GROUP;
            this.isCursorInsideGroupStatement = true;
            return true;
        }
        return false;
    }

    public boolean isCursorInsideGroupStatement() {
        return this.isCursorInsideGroupStatement;
    }

    public TYPES getType() {
        return this.type;
    }

    @Override
    @NonNull
    public TextSequence getStatementText() {
        return this.rebuiltUseStatementText;
    }

    public String getGroupPrefixBeforeOpeningCurly() {
        int statementLength = this.biggestCommonStatementText.length();
        int prefixEnd = PHPTextSequenceUtilities.readBackwardSpaces(this.biggestCommonStatementText, statementLength);
        int prefixStart = PHPTextSequenceUtilities.readNamespaceStartIndex(this.biggestCommonStatementText, prefixEnd, true);
        return prefixStart < 0 ? "" : this.biggestCommonStatementText.subSequence(prefixStart, prefixEnd).toString();
    }

    public String getLongestPrefixBeforeCursor() {
        if (this.hasWhitespaceBeforeCursor()) {
            return "";
        }
        int statementLength = this.longestStatementTextBeforeCursor.length();
        int prefixEnd = PHPTextSequenceUtilities.readBackwardSpaces(this.longestStatementTextBeforeCursor, statementLength);
        int prefixStart = PHPTextSequenceUtilities.readIdentifierStartIndex(this.getPHPVersion(), this.longestStatementTextBeforeCursor, prefixEnd, true);
        return prefixStart < 0 ? "" : this.longestStatementTextBeforeCursor.subSequence(prefixStart, prefixEnd).toString();
    }

    @Override
    public int getReplacementStart() {
        return this.getOffset() - this.getLongestPrefixBeforeCursor().length();
    }

    @Override
    public boolean isValid(@NonNull ISourceModule sourceModule, int offset, CompletionRequestor requestor) {
        if (!super.isValid(sourceModule, offset, requestor)) {
            return false;
        }
        boolean isClassStatementContext = new ClassStatementContext().isValid(sourceModule, offset, requestor);
        return this.buildUseStatement(offset, this.getStructuredDocumentRegion(), isClassStatementContext);
    }

    public static enum TYPES {
        NONE,
        TRAIT,
        USE,
        GROUP;

    }
}

