/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.pivot.qvtimperative.evaluation;

import com.google.common.collect.Iterables;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.CollectionType;
import org.eclipse.ocl.pivot.Import;
import org.eclipse.ocl.pivot.NamedElement;
import org.eclipse.ocl.pivot.OCLExpression;
import org.eclipse.ocl.pivot.Package;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.StandardLibrary;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.TypedElement;
import org.eclipse.ocl.pivot.VariableDeclaration;
import org.eclipse.ocl.pivot.ids.CollectionTypeId;
import org.eclipse.ocl.pivot.internal.evaluation.BasicEvaluationVisitor;
import org.eclipse.ocl.pivot.internal.evaluation.ExecutorInternal;
import org.eclipse.ocl.pivot.util.Visitable;
import org.eclipse.ocl.pivot.util.Visitor;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.NameUtil;
import org.eclipse.ocl.pivot.utilities.PivotUtil;
import org.eclipse.ocl.pivot.utilities.ValueUtil;
import org.eclipse.ocl.pivot.values.CollectionValue;
import org.eclipse.ocl.pivot.values.InvalidValueException;
import org.eclipse.qvtd.pivot.qvtbase.BaseModel;
import org.eclipse.qvtd.pivot.qvtbase.Domain;
import org.eclipse.qvtd.pivot.qvtbase.Function;
import org.eclipse.qvtd.pivot.qvtbase.FunctionParameter;
import org.eclipse.qvtd.pivot.qvtbase.Pattern;
import org.eclipse.qvtd.pivot.qvtbase.Predicate;
import org.eclipse.qvtd.pivot.qvtbase.Rule;
import org.eclipse.qvtd.pivot.qvtbase.Transformation;
import org.eclipse.qvtd.pivot.qvtbase.TypedModel;
import org.eclipse.qvtd.pivot.qvtimperative.AddStatement;
import org.eclipse.qvtd.pivot.qvtimperative.AppendParameter;
import org.eclipse.qvtd.pivot.qvtimperative.AppendParameterBinding;
import org.eclipse.qvtd.pivot.qvtimperative.BufferStatement;
import org.eclipse.qvtd.pivot.qvtimperative.CheckStatement;
import org.eclipse.qvtd.pivot.qvtimperative.ConnectionVariable;
import org.eclipse.qvtd.pivot.qvtimperative.DeclareStatement;
import org.eclipse.qvtd.pivot.qvtimperative.GuardParameter;
import org.eclipse.qvtd.pivot.qvtimperative.GuardParameterBinding;
import org.eclipse.qvtd.pivot.qvtimperative.ImperativeModel;
import org.eclipse.qvtd.pivot.qvtimperative.ImperativeTransformation;
import org.eclipse.qvtd.pivot.qvtimperative.ImperativeTypedModel;
import org.eclipse.qvtd.pivot.qvtimperative.LoopParameterBinding;
import org.eclipse.qvtd.pivot.qvtimperative.LoopVariable;
import org.eclipse.qvtd.pivot.qvtimperative.Mapping;
import org.eclipse.qvtd.pivot.qvtimperative.MappingCall;
import org.eclipse.qvtd.pivot.qvtimperative.MappingLoop;
import org.eclipse.qvtd.pivot.qvtimperative.MappingParameter;
import org.eclipse.qvtd.pivot.qvtimperative.MappingParameterBinding;
import org.eclipse.qvtd.pivot.qvtimperative.MappingStatement;
import org.eclipse.qvtd.pivot.qvtimperative.NewStatement;
import org.eclipse.qvtd.pivot.qvtimperative.ObservableStatement;
import org.eclipse.qvtd.pivot.qvtimperative.SetStatement;
import org.eclipse.qvtd.pivot.qvtimperative.SimpleParameter;
import org.eclipse.qvtd.pivot.qvtimperative.SimpleParameterBinding;
import org.eclipse.qvtd.pivot.qvtimperative.Statement;
import org.eclipse.qvtd.pivot.qvtimperative.VariableStatement;
import org.eclipse.qvtd.pivot.qvtimperative.evaluation.IQVTiEvaluationVisitor;
import org.eclipse.qvtd.pivot.qvtimperative.evaluation.QVTiExecutor;
import org.eclipse.qvtd.pivot.qvtimperative.utilities.QVTimperativeUtil;
import org.eclipse.qvtd.runtime.evaluation.Connection;
import org.eclipse.qvtd.runtime.evaluation.Interval;
import org.eclipse.qvtd.runtime.evaluation.InvocationConstructor;
import org.eclipse.qvtd.runtime.evaluation.InvocationFailedException;

public class QVTiEvaluationVisitor
extends BasicEvaluationVisitor
implements IQVTiEvaluationVisitor {
    protected final @NonNull QVTiExecutor executor;

    public QVTiEvaluationVisitor(@NonNull QVTiExecutor executor) {
        super((ExecutorInternal)executor);
        this.executor = executor;
    }

    private @Nullable Object doConnectionAccumulation(@NonNull ConnectionVariable targetVariable, @NonNull OCLExpression valueExpression) {
        try {
            Object targetValue = ClassUtil.nonNullState((Object)this.executor.getValueOf((TypedElement)targetVariable));
            Connection connectionCollection = (Connection)targetValue;
            Object values = valueExpression.accept((Visitor)this.undecoratedVisitor);
            assert (values != null);
            connectionCollection.appendElement(values);
            return connectionCollection;
        }
        catch (RuntimeException e) {
            this.executor.replace((TypedElement)targetVariable, e, false);
            throw e;
        }
    }

    private @Nullable Object doMappingCall(@NonNull MappingCall mappingCall) {
        Mapping referredMapping = mappingCall.getReferredMapping();
        if (referredMapping == null) {
            return null;
        }
        Iterable<@NonNull MappingParameterBinding> mappingParameterBindings = QVTimperativeUtil.getOwnedMappingParameterBindings(mappingCall);
        @NonNull Object @NonNull [] boundValues = new Object[Iterables.size(mappingParameterBindings)];
        int index = 0;
        for (MappingParameterBinding binding : mappingParameterBindings) {
            Type valueType;
            Object valueOrValues;
            Object value;
            MappingParameterBinding guardParameterBinding;
            Type varType;
            MappingParameter boundVariable = binding.getBoundVariable();
            if (boundVariable == null) {
                return null;
            }
            if (binding instanceof AppendParameterBinding) {
                AppendParameterBinding appendParameterBinding = (AppendParameterBinding)binding;
                ConnectionVariable value2 = appendParameterBinding.getValue();
                if (value2 == null) {
                    return null;
                }
                Object valueOrValues2 = this.executor.getValueOf((TypedElement)value2);
                if (valueOrValues2 == null) {
                    return null;
                }
                boundValues[index++] = valueOrValues2;
                continue;
            }
            if (binding instanceof GuardParameterBinding) {
                varType = boundVariable.getType();
                if (varType == null) {
                    return null;
                }
                guardParameterBinding = (GuardParameterBinding)binding;
                value = guardParameterBinding.getValue();
                if (value == null) {
                    return null;
                }
                valueOrValues = this.executor.getValueOf((TypedElement)value);
                if (valueOrValues == null) {
                    return null;
                }
                valueType = this.idResolver.getDynamicTypeOf(valueOrValues);
                if (!guardParameterBinding.isIsCheck() || valueType.conformsTo((StandardLibrary)this.environmentFactory.getStandardLibrary(), varType)) {
                    boundValues[index++] = valueOrValues;
                    continue;
                }
                return null;
            }
            if (binding instanceof LoopParameterBinding) {
                varType = boundVariable.getType();
                if (varType == null) {
                    return null;
                }
                guardParameterBinding = (LoopParameterBinding)binding;
                value = guardParameterBinding.getValue();
                if (value == null) {
                    return null;
                }
                valueOrValues = this.executor.getValueOf((TypedElement)value);
                if (valueOrValues == null) {
                    return null;
                }
                valueType = this.idResolver.getDynamicTypeOf(valueOrValues);
                if (!guardParameterBinding.isIsCheck() || valueType.conformsTo((StandardLibrary)this.environmentFactory.getStandardLibrary(), varType)) {
                    boundValues[index++] = valueOrValues;
                    continue;
                }
                return null;
            }
            if (!(binding instanceof SimpleParameterBinding)) continue;
            varType = boundVariable.getType();
            if (varType == null) {
                return null;
            }
            SimpleParameterBinding simpleParameterBinding = (SimpleParameterBinding)binding;
            value = simpleParameterBinding.getValue();
            if (value == null) {
                return null;
            }
            valueOrValues = value.accept((Visitor)this.undecoratedVisitor);
            if (valueOrValues == null) {
                return null;
            }
            assert (!(boundVariable instanceof ConnectionVariable));
            valueType = this.idResolver.getDynamicTypeOf(valueOrValues);
            if (!simpleParameterBinding.isIsCheck() || valueType.conformsTo((StandardLibrary)this.environmentFactory.getStandardLibrary(), varType)) {
                boundValues[index++] = valueOrValues;
                continue;
            }
            return null;
        }
        return this.executor.internalExecuteMappingCall(mappingCall, boundValues, this.undecoratedVisitor);
    }

    private @Nullable Object doMappingInstall(@NonNull MappingCall mappingCall) {
        Mapping referredMapping = mappingCall.getReferredMapping();
        if (referredMapping == null) {
            return null;
        }
        InvocationConstructor invocationConstructor = this.executor.getInvocationConstructor(mappingCall, this.undecoratedVisitor);
        Iterable<@NonNull MappingParameterBinding> mappingBindings = QVTimperativeUtil.getOwnedMappingParameterBindings(mappingCall);
        assert (mappingBindings != null);
        for (MappingParameterBinding asMappingCallBinding : mappingBindings) {
            Object value;
            ConnectionVariable connectionVariable;
            if (asMappingCallBinding instanceof GuardParameterBinding) {
                connectionVariable = ((GuardParameterBinding)asMappingCallBinding).getValue();
                assert (connectionVariable != null);
                value = this.executor.getValueOf((TypedElement)connectionVariable);
                assert (value != null);
                invocationConstructor.addConsumedConnection((Connection)value);
                continue;
            }
            if (!(asMappingCallBinding instanceof AppendParameterBinding)) continue;
            connectionVariable = ((AppendParameterBinding)asMappingCallBinding).getValue();
            assert (connectionVariable != null);
            value = this.executor.getValueOf((TypedElement)connectionVariable);
            assert (value != null);
            invocationConstructor.addAppendedConnection((Connection)value);
        }
        return Boolean.TRUE;
    }

    @Override
    public @Nullable Object visitAddStatement(@NonNull AddStatement connectionStatement) {
        OCLExpression valueExpression;
        ConnectionVariable targetVariable = connectionStatement.getTargetVariable();
        if (targetVariable != null && (valueExpression = connectionStatement.getOwnedExpression()) != null) {
            this.doConnectionAccumulation(targetVariable, valueExpression);
            return true;
        }
        return null;
    }

    @Override
    public Object visitAppendParameter(@NonNull AppendParameter object) {
        CollectionValue.Accumulator accumulator = ValueUtil.createCollectionAccumulatorValue((CollectionTypeId)((CollectionTypeId)object.getTypeId()));
        return this.executor.replace((TypedElement)object, accumulator, false);
    }

    @Override
    public Object visitAppendParameterBinding(@NonNull AppendParameterBinding object) {
        return this.visiting((Visitable)object);
    }

    public @Nullable Object visitBaseModel(@NonNull BaseModel object) {
        return this.visiting((Visitable)object);
    }

    @Override
    public Object visitBufferStatement(@NonNull BufferStatement object) {
        Mapping asMapping = QVTimperativeUtil.getContainingMapping((EObject)object);
        assert (asMapping != null);
        Interval interval = this.executor.getInterval(asMapping);
        Connection connection = null;
        OCLExpression ownedExpression = object.getOwnedExpression();
        String name = object.getName();
        assert (name != null);
        if (ownedExpression != null) {
            Object initValue = ownedExpression.accept((Visitor)this.undecoratedVisitor);
            connection = interval.createConnection(name, ownedExpression.getTypeId(), object.isIsStrict());
            if (initValue != null) {
                for (Object value : (Iterable)initValue) {
                    assert (value != null);
                    connection.appendElement(value);
                }
            }
        } else {
            connection = interval.createConnection(name, object.getTypeId(), object.isIsStrict());
        }
        return this.executor.replace((TypedElement)object, connection, false);
    }

    @Override
    public @Nullable Object visitCheckStatement(@NonNull CheckStatement predicate) {
        OCLExpression exp = predicate.getOwnedExpression();
        Object expResult = exp.accept((Visitor)this.undecoratedVisitor);
        return expResult;
    }

    @Override
    public Object visitConnectionVariable(@NonNull ConnectionVariable object) {
        return this.visiting((Visitable)object);
    }

    @Override
    public @Nullable Object visitDeclareStatement(@NonNull DeclareStatement asStatement) {
        Object initValue;
        OCLExpression ownedExpression = asStatement.getOwnedExpression();
        if (ownedExpression == null) {
            initValue = null;
        } else {
            initValue = ownedExpression.accept((Visitor)this.undecoratedVisitor);
            if (asStatement.isIsCheck()) {
                Type guardType = asStatement.getType();
                Type valueType = this.idResolver.getDynamicTypeOf(initValue);
                if (guardType == null || !valueType.conformsTo((StandardLibrary)this.standardLibrary, guardType)) {
                    return false;
                }
            }
        }
        return this.executor.replace((TypedElement)asStatement, initValue, false);
    }

    public @Nullable Object visitDomain(@NonNull Domain object) {
        return this.visiting((Visitable)object);
    }

    public @Nullable Object visitFunction(@NonNull Function object) {
        return this.visiting((Visitable)object);
    }

    public @Nullable Object visitFunctionParameter(@NonNull FunctionParameter object) {
        return this.visiting((Visitable)object);
    }

    @Override
    public @Nullable Object visitGuardParameter(@NonNull GuardParameter object) {
        return this.visiting((Visitable)object);
    }

    @Override
    public Object visitGuardParameterBinding(@NonNull GuardParameterBinding object) {
        return this.visiting((Visitable)object);
    }

    @Override
    public @Nullable Object visitImperativeModel(@NonNull ImperativeModel imperativeModel) {
        for (Package pkge : imperativeModel.getOwnedPackages()) {
            pkge.accept((Visitor)this.undecoratedVisitor);
        }
        return true;
    }

    @Override
    public @Nullable Object visitImperativeTransformation(@NonNull ImperativeTransformation transformation) {
        return this.executor.internalExecuteTransformation(transformation, this.undecoratedVisitor);
    }

    @Override
    public @Nullable Object visitImperativeTypedModel(@NonNull ImperativeTypedModel object) {
        return this.visiting((Visitable)object);
    }

    public @Nullable Object visitImport(@NonNull Import object) {
        return this.visiting((Visitable)object);
    }

    @Override
    public Object visitLoopParameterBinding(@NonNull LoopParameterBinding object) {
        return this.visiting((Visitable)object);
    }

    @Override
    public @Nullable Object visitLoopVariable(@NonNull LoopVariable object) {
        return this.visiting((Visitable)object);
    }

    @Override
    public @Nullable Object visitMapping(@NonNull Mapping mapping) {
        return this.executor.internalExecuteMapping(mapping, this.undecoratedVisitor);
    }

    @Override
    public @Nullable Object visitMappingCall(@NonNull MappingCall mappingCall) {
        if (mappingCall.isIsInstall()) {
            return this.doMappingInstall(mappingCall);
        }
        return this.doMappingCall(mappingCall);
    }

    @Override
    public @Nullable Object visitMappingLoop(@NonNull MappingLoop mappingLoop) {
        EList<LoopVariable> iterators;
        Object inValues = mappingLoop.getOwnedExpression().accept((Visitor)this.undecoratedVisitor);
        if (inValues instanceof Connection) {
            inValues = ((Connection)inValues).typedIterable(Object.class);
        }
        if (inValues instanceof Iterable && (iterators = mappingLoop.getOwnedIterators()).size() > 0) {
            LoopVariable iterator = (LoopVariable)ClassUtil.nonNullState((Object)((LoopVariable)iterators.get(0)));
            for (Object object : (Iterable)inValues) {
                if (!this.executor.replace((TypedElement)iterator, object, false)) {
                    return false;
                }
                for (MappingStatement mappingStatement : ClassUtil.nullFree(mappingLoop.getOwnedMappingStatements())) {
                    ((ExecutorInternal.ExecutorInternalExtension)this.context).pushEvaluationEnvironment((NamedElement)mappingStatement, (Object)mappingLoop);
                    try {
                        mappingStatement.accept((Visitor)this.undecoratedVisitor);
                    }
                    finally {
                        ((ExecutorInternal.ExecutorInternalExtension)this.context).popEvaluationEnvironment();
                    }
                }
            }
            this.executor.getInvocationManager().flush();
        }
        return true;
    }

    @Override
    public @Nullable Object visitMappingParameter(@NonNull MappingParameter object) {
        return this.visiting((Visitable)object);
    }

    @Override
    public @Nullable Object visitMappingParameterBinding(@NonNull MappingParameterBinding object) {
        return this.visiting((Visitable)object);
    }

    @Override
    public @Nullable Object visitMappingStatement(@NonNull MappingStatement object) {
        return this.visitStatement(object);
    }

    @Override
    public @Nullable Object visitNewStatement(@NonNull NewStatement newStatement) {
        if (this.executor.internalExecuteNewStatement(newStatement, this.undecoratedVisitor) != null) {
            return true;
        }
        return false;
    }

    @Override
    public @Nullable Object visitObservableStatement(@NonNull ObservableStatement object) {
        return this.visiting((Visitable)object);
    }

    public @Nullable Object visitPackage(@NonNull Package pkge) {
        return true;
    }

    public @Nullable Object visitPattern(@NonNull Pattern object) {
        return this.visiting((Visitable)object);
    }

    public @Nullable Object visitPredicate(@NonNull Predicate object) {
        return this.visiting((Visitable)object);
    }

    public @Nullable Object visitRule(@NonNull Rule object) {
        return this.visiting((Visitable)object);
    }

    @Override
    public @Nullable Object visitSetStatement(@NonNull SetStatement setStatement) {
        VariableDeclaration targetVariable = setStatement.getTargetVariable();
        if (targetVariable == null) {
            throw new InvalidValueException("Undefined variable", new Object[]{null, null, setStatement});
        }
        Object slotObject = this.executor.getValueOf((TypedElement)targetVariable);
        if (slotObject instanceof InvalidValueException) {
            throw (InvalidValueException)((Object)slotObject);
        }
        if (slotObject instanceof EObject) {
            Object childKey = null;
            try {
                Type type;
                Object boxedValue = setStatement.getOwnedExpression().accept((Visitor)this.undecoratedVisitor);
                Property targetProperty = QVTimperativeUtil.getTargetProperty(setStatement);
                Class instanceClass = PivotUtil.getEcoreInstanceClass((Property)targetProperty);
                Object ecoreValue = this.idResolver.ecoreValueOf(instanceClass, boxedValue);
                Property oppositeProperty = targetProperty.getOpposite();
                if (oppositeProperty != null && (type = oppositeProperty.getType()) instanceof CollectionType) {
                    boolean bl = ((CollectionType)type).isOrdered();
                }
                this.executor.internalExecuteSetStatement(setStatement, slotObject, ecoreValue, childKey);
                return true;
            }
            catch (InvocationFailedException e) {
                this.executor.internalExecuteSetStatement(setStatement, slotObject, (Object)e, childKey);
            }
        } else {
            throw new IllegalArgumentException("Unsupported " + setStatement.eClass().getName() + " specification. The assignment slot expression '" + setStatement.toString() + "'evaluates to non-ecore value: " + NameUtil.debugFullName((Object)slotObject));
        }
        return true;
    }

    @Override
    public @Nullable Object visitSimpleParameter(@NonNull SimpleParameter object) {
        return this.visiting((Visitable)object);
    }

    @Override
    public Object visitSimpleParameterBinding(@NonNull SimpleParameterBinding object) {
        return this.visiting((Visitable)object);
    }

    @Override
    public @Nullable Object visitStatement(@NonNull Statement object) {
        return this.visiting((Visitable)object);
    }

    public @Nullable Object visitTransformation(@NonNull Transformation object) {
        return this.visiting((Visitable)object);
    }

    public @Nullable Object visitTypedModel(@NonNull TypedModel object) {
        return this.visiting((Visitable)object);
    }

    @Override
    public @Nullable Object visitVariableStatement(@NonNull VariableStatement object) {
        return this.visiting((Visitable)object);
    }
}

