/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.modeling.xml.schema;

import javax.xml.namespace.QName;
import org.eclipse.sapphire.modeling.xml.schema.XmlDocumentSchema;
import org.w3c.dom.NodeList;

public abstract class XmlContentModel {
    protected final XmlDocumentSchema schema;
    protected final int minOccur;
    protected final int maxOccur;

    protected XmlContentModel(XmlDocumentSchema schema, int minOccur, int maxOccur) {
        this.schema = schema;
        this.minOccur = minOccur;
        this.maxOccur = maxOccur;
    }

    public XmlDocumentSchema getSchema() {
        return this.schema;
    }

    public int getMinOccur() {
        return this.minOccur;
    }

    public int getMaxOccur() {
        return this.maxOccur;
    }

    public abstract XmlContentModel findChildElementContentModel(QName var1);

    public final int findInsertionPosition(NodeList nodeList, QName element) {
        InsertionPosition point = this.findInsertionPosition(nodeList, nodeList.getLength(), element, new Position());
        if (point.listIndex == -1) {
            point.listIndex = nodeList.getLength();
        }
        return point.listIndex;
    }

    protected abstract InsertionPosition findInsertionPosition(NodeList var1, int var2, QName var3, Position var4);

    protected abstract void toString(StringBuilder var1, String var2);

    public final String toString() {
        StringBuilder buf = new StringBuilder();
        this.toString(buf, "");
        return buf.toString();
    }

    public static abstract class Factory {
        protected int minOccur = 1;
        protected int maxOccur = 1;

        public final int getMinOccur() {
            return this.minOccur;
        }

        public final void setMinOccur(int minOccur) {
            this.minOccur = minOccur;
        }

        public final int getMaxOccur() {
            return this.maxOccur;
        }

        public final void setMaxOccur(int maxOccur) {
            this.maxOccur = maxOccur;
        }

        public abstract XmlContentModel create(XmlDocumentSchema var1);
    }

    protected static final class InsertionPosition
    extends Position {
        public static final int G1_EXCEEDS_MAX_OCCUR = 1;
        public static final int G2_OK_TO_INSERT = 2;
        public static final int G3_OK_TO_INSERT = 3;
        public static final int G4_MEETS_OCCUR_REQUIREMENT = 4;
        public static final int MAX_GRADE = 4;
        public int grade = 0;

        public InsertionPosition() {
            this.listIndex = -1;
        }

        public void merge(InsertionPosition pt) {
            if (this.grade <= pt.grade && this.listIndex < pt.listIndex) {
                this.listIndex = pt.listIndex;
                this.grade = pt.grade;
            }
        }

        public String toString() {
            StringBuilder buf = new StringBuilder();
            buf.append("(");
            buf.append("pos=");
            buf.append(this.listIndex);
            buf.append(",grade=");
            buf.append(this.grade);
            buf.append(")");
            return buf.toString();
        }
    }

    protected static class Position {
        public int listIndex = 0;

        protected Position() {
        }
    }
}

