/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.def.internal;

import java.lang.reflect.Field;
import org.eclipse.sapphire.Context;
import org.eclipse.sapphire.LocalizableText;
import org.eclipse.sapphire.LoggingService;
import org.eclipse.sapphire.PropertyDef;
import org.eclipse.sapphire.Sapphire;
import org.eclipse.sapphire.Text;
import org.eclipse.sapphire.ui.def.IDefinitionReference;
import org.eclipse.sapphire.ui.def.IPackageReference;
import org.eclipse.sapphire.ui.def.ISapphireDocumentationDef;
import org.eclipse.sapphire.ui.def.ISapphireUiDef;
import org.eclipse.sapphire.ui.def.PartDef;

public final class SapphireUiDefMethods {
    @Text(value="Part \"{0}\" is not of type \"{1}\" as expected.")
    private static LocalizableText doesNotImplement;

    static {
        LocalizableText.init(SapphireUiDefMethods.class);
    }

    public static PartDef getPartDef(ISapphireUiDef rootdef, String id, boolean searchImportedDefinitions, Class<?> expectedType) {
        if (id != null) {
            for (PartDef def : rootdef.getPartDefs()) {
                if (!id.equals(def.getId().text())) continue;
                if (expectedType != null && !expectedType.isAssignableFrom(def.getClass())) {
                    String msg = doesNotImplement.format(new Object[]{id, expectedType.getName()});
                    ((LoggingService)Sapphire.service(LoggingService.class)).logError(msg);
                    return null;
                }
                return def;
            }
            if (searchImportedDefinitions) {
                for (IDefinitionReference ref : rootdef.getImportedDefinitions()) {
                    PartDef def;
                    ISapphireUiDef sdef = (ISapphireUiDef)ref.getPath().target();
                    if (sdef == null || (def = sdef.getPartDef(id, true, expectedType)) == null) continue;
                    return def;
                }
            }
        }
        return null;
    }

    public static ISapphireDocumentationDef getDocumentationDef(ISapphireUiDef rootdef, String id, boolean searchImportedDefinitions) {
        if (id != null) {
            for (ISapphireDocumentationDef def : rootdef.getDocumentationDefs()) {
                if (!id.equals(def.getId().text())) continue;
                return def;
            }
            if (searchImportedDefinitions) {
                for (IDefinitionReference ref : rootdef.getImportedDefinitions()) {
                    ISapphireDocumentationDef def;
                    ISapphireUiDef sdef = (ISapphireUiDef)ref.getPath().target();
                    if (sdef == null || (def = sdef.getDocumentationDef(id, true)) == null) continue;
                    return def;
                }
            }
        }
        return null;
    }

    public static Class<?> resolveClass(ISapphireUiDef def, String className) {
        Context context = (Context)def.adapt(Context.class);
        for (IPackageReference packageRef : def.getImportedPackages()) {
            String fullClassName;
            Class cl;
            String packageName = packageRef.getName().text();
            if (packageName == null || (cl = context.findClass(fullClassName = String.valueOf(packageName) + "." + className)) == null) continue;
            return cl;
        }
        return null;
    }

    public static PropertyDef resolveProperty(ISapphireUiDef def, String qualifiedPropertyName) {
        PropertyDef property = null;
        if (qualifiedPropertyName != null) {
            int dot = qualifiedPropertyName.indexOf(46);
            String className = qualifiedPropertyName.substring(0, dot);
            String propertyName = qualifiedPropertyName.substring(dot + 1);
            Class<?> cl = SapphireUiDefMethods.resolveClass(def, className);
            if (cl == null) {
                return null;
            }
            try {
                Field field = cl.getField(propertyName);
                property = (PropertyDef)field.get(null);
            }
            catch (Throwable e) {
                System.err.println("Failed to resolve property: " + qualifiedPropertyName);
                e.printStackTrace();
                return null;
            }
        }
        return property;
    }
}

