/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.s2e.nls.internal.ui.action;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.action.Action;
import org.eclipse.scout.sdk.core.util.SdkLog;
import org.eclipse.scout.sdk.s2e.job.AbstractJob;
import org.eclipse.scout.sdk.s2e.nls.NlsCore;
import org.eclipse.scout.sdk.s2e.nls.model.INlsEntry;
import org.eclipse.scout.sdk.s2e.nls.project.INlsProject;

public class RemoveAction
extends Action {
    private final INlsProject m_nlsProject;
    private IStatus m_status;
    private final List<INlsEntry> m_entries;

    public RemoveAction(String name, INlsProject project, INlsEntry entry) {
        this(name, project, Arrays.asList(entry));
    }

    public RemoveAction(String name, INlsProject project, List<INlsEntry> entries) {
        super(name);
        this.m_nlsProject = project;
        this.m_entries = new ArrayList<INlsEntry>(entries);
        this.setImageDescriptor(NlsCore.getImageDescriptor("text_remove"));
    }

    public void run() {
        AbstractJob job = new AbstractJob("update translations"){

            protected void execute(IProgressMonitor monitor) {
                RemoveAction.this.m_nlsProject.removeEntries(RemoveAction.this.m_entries, monitor);
            }
        };
        job.setUser(false);
        job.schedule();
        try {
            job.join();
            this.m_status = job.getResult();
        }
        catch (InterruptedException e) {
            SdkLog.error((String)"cold not remove the row key: {} in translation resources", (Object[])new Object[]{this.m_entries, e});
        }
    }

    public IStatus getStatus() {
        return this.m_status;
    }
}

