/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.internal.refresh;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.core.providers.IViewProvider;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewRequest;
import org.eclipse.gmf.runtime.notation.Bounds;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.LayoutConstraint;
import org.eclipse.gmf.runtime.notation.Location;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.Size;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.sirius.diagram.AbstractDNode;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DNode;
import org.eclipse.sirius.diagram.DNodeContainer;
import org.eclipse.sirius.diagram.DNodeList;
import org.eclipse.sirius.diagram.ResizeKind;
import org.eclipse.sirius.diagram.business.api.query.DDiagramElementQuery;
import org.eclipse.sirius.diagram.business.api.refresh.CanonicalSynchronizer;
import org.eclipse.sirius.diagram.business.internal.query.DNodeContainerExperimentalQuery;
import org.eclipse.sirius.diagram.ui.business.api.query.ViewQuery;
import org.eclipse.sirius.diagram.ui.business.api.view.SiriusLayoutDataManager;
import org.eclipse.sirius.diagram.ui.business.internal.query.DNodeQuery;
import org.eclipse.sirius.diagram.ui.business.internal.view.LayoutData;
import org.eclipse.sirius.diagram.ui.internal.providers.SiriusViewProvider;
import org.eclipse.sirius.diagram.ui.internal.refresh.CanonicalElementAdapter;
import org.eclipse.sirius.diagram.ui.internal.refresh.GMFHelper;
import org.eclipse.sirius.diagram.ui.internal.refresh.IsOrphanedSwitch;
import org.eclipse.sirius.diagram.ui.internal.refresh.borderednode.CanonicalDBorderItemLocator;
import org.eclipse.sirius.diagram.ui.internal.view.factories.AbstractContainerViewFactory;
import org.eclipse.sirius.diagram.ui.internal.view.factories.ViewSizeHint;
import org.eclipse.sirius.diagram.ui.part.SiriusDiagramUpdater;
import org.eclipse.sirius.diagram.ui.part.SiriusNodeDescriptor;
import org.eclipse.sirius.diagram.ui.part.SiriusVisualIDRegistry;
import org.eclipse.sirius.diagram.ui.provider.DiagramUIPlugin;
import org.eclipse.sirius.diagram.ui.tools.api.graphical.edit.styles.IBorderItemOffsets;
import org.eclipse.sirius.ext.base.Option;

public abstract class AbstractCanonicalSynchronizer
implements CanonicalSynchronizer {
    protected boolean storeViews2Arrange = true;
    protected IViewProvider viewpointViewProvider = new SiriusViewProvider();
    protected Map<View, Boolean> regionsContainersToLayoutWithImpactStatus = Maps.newHashMap();

    public void storeViewsToArrange(boolean storeViewsToArrange) {
        this.storeViews2Arrange = storeViewsToArrange;
    }

    protected Set<View> refreshSemantic(View view) {
        LinkedHashSet createdViews = Sets.newLinkedHashSet();
        createdViews.addAll(this.refreshSemanticChildren(view, ViewUtil.resolveSemanticElement((View)view)));
        for (View childView : Iterables.filter((Iterable)view.getChildren(), View.class)) {
            createdViews.addAll(this.refreshSemantic(childView));
        }
        return createdViews;
    }

    protected Set<View> refreshSemanticChildren(View gmfView, EObject semanticView) {
        ArrayList<SiriusNodeDescriptor> semanticChildren;
        List<View> viewChildren;
        List<View> orphaned;
        int type;
        if (semanticView == null) {
            return Collections.emptySet();
        }
        boolean isPartOfRegionsContainer = semanticView instanceof DNodeContainer && new DNodeContainerExperimentalQuery((DNodeContainer)semanticView).isRegionContainer();
        boolean isRegionsContainer = false;
        if (isPartOfRegionsContainer && ((type = SiriusVisualIDRegistry.getVisualID(gmfView.getType())) == 2002 || type == 3008)) {
            isRegionsContainer = true;
            this.regionsContainersToLayoutWithImpactStatus.put(gmfView, Boolean.FALSE);
        }
        if (!(orphaned = this.cleanCanonicalSemanticChildren(gmfView, viewChildren = this.getViewChildren(gmfView), semanticChildren = new ArrayList<SiriusNodeDescriptor>(SiriusDiagramUpdater.getSemanticChildren(gmfView)))).isEmpty()) {
            this.setRegionsContainerAsImpacted(gmfView, isRegionsContainer, isPartOfRegionsContainer);
        }
        this.deleteViews(orphaned);
        Set<View> createdViews = this.createViews(semanticChildren, gmfView.getType(), gmfView);
        if (!createdViews.isEmpty()) {
            this.setRegionsContainerAsImpacted(gmfView, isRegionsContainer, isPartOfRegionsContainer);
        }
        if (semanticView instanceof DNodeList || isPartOfRegionsContainer) {
            this.refreshSemanticChildrenOrdering(gmfView);
        }
        return createdViews;
    }

    private void setRegionsContainerAsImpacted(View gmfView, boolean isRegionsContainer, boolean isPartOfRegionsContainer) {
        Option<View> realRegionsContainer;
        if (isRegionsContainer) {
            this.regionsContainersToLayoutWithImpactStatus.put(gmfView, Boolean.TRUE);
        } else if (isPartOfRegionsContainer && (realRegionsContainer = new ViewQuery(gmfView).getAncestor(2002, 3008)).some()) {
            this.regionsContainersToLayoutWithImpactStatus.put((View)realRegionsContainer.get(), Boolean.TRUE);
        }
    }

    private void markCreatedViewsAsToLayout(Collection<View> createdViews) {
        for (View createdView : createdViews) {
            createdView.eAdapters().add((Object)SiriusLayoutDataManager.INSTANCE.getAdapterMarker());
        }
    }

    private void markCreatedViewsWithCenterLayout(View createdView) {
        createdView.eAdapters().add((Object)SiriusLayoutDataManager.INSTANCE.getCenterAdapterMarker());
    }

    private boolean refreshSemanticChildrenOrdering(View hostView) {
        boolean moveOccur = false;
        HashMap<EObject, View> semantic2ViewMap = new HashMap<EObject, View>();
        List<View> views = this.getViewChildren(hostView);
        ArrayList<SiriusNodeDescriptor> semanticChildren = new ArrayList<SiriusNodeDescriptor>(SiriusDiagramUpdater.getSemanticChildren(hostView));
        int i = 0;
        while (i < semanticChildren.size()) {
            SiriusNodeDescriptor viewpointNodeDescriptor = (SiriusNodeDescriptor)semanticChildren.get(i);
            EObject modelElement = viewpointNodeDescriptor.getModelElement();
            View view = null;
            if (semantic2ViewMap.containsKey(modelElement)) {
                view = (View)semantic2ViewMap.get(modelElement);
            } else {
                view = this.getView(views, modelElement);
                if (view != null) {
                    semantic2ViewMap.put(modelElement, view);
                }
            }
            if (view != null && hostView.getPersistedChildren().indexOf((Object)view) != i) {
                hostView.getPersistedChildren().move(i, (Object)view);
                moveOccur = true;
            }
            ++i;
        }
        return moveOccur;
    }

    private View getView(List<View> views, EObject modelElement) {
        for (View view : views) {
            if (!modelElement.equals(view.getElement())) continue;
            return view;
        }
        return null;
    }

    private List<View> getViewChildren(View current) {
        return new ArrayList<View>((Collection<View>)current.getChildren());
    }

    protected Set<View> createViews(List<SiriusNodeDescriptor> eObjects, String factoryHint, View host) {
        ArrayList<CreateViewRequest.ViewDescriptor> descriptors = new ArrayList<CreateViewRequest.ViewDescriptor>();
        for (SiriusNodeDescriptor nodeDescriptor : eObjects) {
            EObject element = nodeDescriptor.getModelElement();
            if (element == null) continue;
            CreateViewRequest.ViewDescriptor descriptor = this.getViewDescriptor(element, nodeDescriptor.getType());
            descriptors.add(descriptor);
        }
        LinkedHashSet createdViews = Sets.newLinkedHashSet();
        LinkedHashSet createdViewsToLayout = Sets.newLinkedHashSet();
        Diagram previousCreatedView = null;
        for (CreateViewRequest.ViewDescriptor viewDescriptor : descriptors) {
            Class viewKind = viewDescriptor.getViewKind();
            IAdaptable semanticAdapter = viewDescriptor.getElementAdapter();
            View containerView = host;
            String semanticHint = viewDescriptor.getSemanticHint();
            int index = viewDescriptor.getIndex();
            boolean persisted = viewDescriptor.isPersisted();
            PreferencesHint preferencesHint = viewDescriptor.getPreferencesHint();
            Diagram createdView = null;
            if (viewKind == Diagram.class) {
                createdView = this.viewpointViewProvider.createDiagram(semanticAdapter, semanticHint, preferencesHint);
            } else if (viewKind == Edge.class) {
                createdView = this.viewpointViewProvider.createEdge(semanticAdapter, containerView, semanticHint, index, persisted, preferencesHint);
            } else if (viewKind == Node.class) {
                createdView = this.viewpointViewProvider.createNode(semanticAdapter, containerView, semanticHint, index, persisted, preferencesHint);
            }
            if (createdView == null) continue;
            createdViews.add(createdView);
            if (!this.updateLocationAndSize((View)createdView, (View)previousCreatedView)) {
                createdViewsToLayout.add(createdView);
            } else {
                if (viewKind == Node.class) {
                    this.removeJustCreatedMarker((View)createdView);
                }
                previousCreatedView = createdView;
            }
            if (!(createdView instanceof Node)) continue;
            for (Object view : createdView.getPersistedChildren()) {
                if (!(view instanceof View) || !new ViewQuery((View)view).isForNameEditPartOnBorder()) continue;
                this.updateLocationAndSize((View)view, null);
            }
        }
        if (this.storeViews2Arrange) {
            this.markCreatedViewsAsToLayout(createdViewsToLayout);
        }
        return createdViews;
    }

    private void removeJustCreatedMarker(View createdView) {
        LinkedHashSet adapters = Sets.newLinkedHashSet((Iterable)createdView.eAdapters());
        Iterator iterator = adapters.iterator();
        ArrayList<Adapter> adaptersToRemove = new ArrayList<Adapter>();
        while (iterator.hasNext()) {
            Adapter adapter = (Adapter)iterator.next();
            if (!adapter.isAdapterForType(AbstractContainerViewFactory.class)) continue;
            adaptersToRemove.add(adapter);
        }
        for (Adapter adapterToRemove : adaptersToRemove) {
            createdView.eAdapters().remove((Object)adapterToRemove);
        }
    }

    private boolean updateLocationAndSize(View createdView, View previousCreatedView) {
        boolean updateLocationAndSize = false;
        EObject element = createdView.getElement();
        if (this.isBorderedNode(element) || new ViewQuery(createdView).isForNameEditPartOnBorder()) {
            updateLocationAndSize = this.updateAbstractDNode_ownedBorderedNodes_Bounds(createdView, previousCreatedView);
        } else if (this.isTopLevelNode(element)) {
            updateLocationAndSize = this.updateDDiagramChildBounds(createdView, previousCreatedView);
        } else if (this.isChildNodeButNotBorderedNodeOfContainer(element)) {
            updateLocationAndSize = this.updateDNodeContainerChildButNotBorderedNodeBounds(createdView, previousCreatedView);
        }
        return updateLocationAndSize;
    }

    private boolean updateDDiagramChildBounds(View createdView, View previousCreatedView) {
        Dimension size = null;
        Point location = null;
        boolean isAlreadylayouted = false;
        EObject element = createdView.getElement();
        org.eclipse.sirius.diagram.business.api.query.DNodeQuery dNodeQuery = null;
        if (element instanceof DNode) {
            DNode dNode = (DNode)element;
            dNodeQuery = new org.eclipse.sirius.diagram.business.api.query.DNodeQuery(dNode);
        }
        if (element instanceof DDiagramElement) {
            if (element instanceof AbstractDNode) {
                AbstractDNode abstractDNode = (AbstractDNode)element;
                LayoutData layoutData = SiriusLayoutDataManager.INSTANCE.getData(abstractDNode);
                if (layoutData == null) {
                    layoutData = SiriusLayoutDataManager.INSTANCE.getData(abstractDNode, true);
                }
                if (layoutData != null && layoutData.getSize() != null) {
                    if (dNodeQuery == null || dNodeQuery != null && dNodeQuery.allowsHorizontalResize() && dNodeQuery.allowsVerticalResize()) {
                        size = layoutData.getSize();
                    } else if (dNodeQuery != null && dNodeQuery.allowsHorizontalResize()) {
                        size = new Dimension(layoutData.getSize().width, this.getDefaultSize((AbstractDNode)((AbstractDNode)element)).height);
                    } else if (dNodeQuery != null && dNodeQuery.allowsVerticalResize()) {
                        size = new Dimension(this.getDefaultSize((AbstractDNode)((AbstractDNode)element)).width, layoutData.getSize().height);
                    }
                }
                if (layoutData != null && layoutData.getLocation() != null) {
                    location = layoutData.getLocation();
                }
            }
        } else {
            size = ViewSizeHint.getInstance().consumeSize();
        }
        if (size == null) {
            size = this.getDefaultSize((AbstractDNode)element);
        }
        if (createdView instanceof Node && ((Node)createdView).getLayoutConstraint() instanceof Bounds) {
            Bounds bounds = (Bounds)((Node)createdView).getLayoutConstraint();
            if (location == null && previousCreatedView instanceof Node && ((Node)previousCreatedView).getLayoutConstraint() instanceof Bounds) {
                if (previousCreatedView.eAdapters().contains((Object)SiriusLayoutDataManager.INSTANCE.getCenterAdapterMarker())) {
                    this.markCreatedViewsWithCenterLayout(createdView);
                } else {
                    Bounds previousBounds = (Bounds)((Node)previousCreatedView).getLayoutConstraint();
                    location = new Point(previousBounds.getX(), previousBounds.getY()).getTranslated(30, 30);
                }
            }
            if (location == null && SiriusLayoutDataManager.INSTANCE.getData().some()) {
                this.markCreatedViewsWithCenterLayout(createdView);
                isAlreadylayouted = true;
            }
            if (location != null) {
                bounds.setX(location.x);
                bounds.setY(location.y);
                isAlreadylayouted = true;
            }
            if (size != null) {
                if (size.width != -1) {
                    bounds.setWidth(size.width);
                }
                if (size.height != -1) {
                    bounds.setHeight(size.height);
                }
            }
        }
        return isAlreadylayouted;
    }

    private boolean updateAbstractDNode_ownedBorderedNodes_Bounds(View createdView, View previousCreatedView) {
        Node createdNode = (Node)createdView;
        AbstractDNode portNode = (AbstractDNode)createdView.getElement();
        Node parentNode = (Node)createdView.eContainer();
        LayoutData layoutData = SiriusLayoutDataManager.INSTANCE.getData(portNode);
        boolean laidOut = false;
        if (layoutData == null) {
            Location createdNodeBounds;
            Rectangle tempBounds;
            layoutData = SiriusLayoutDataManager.INSTANCE.getData(portNode, true);
            if (layoutData != null) {
                laidOut = true;
                Point location = layoutData.getLocation() != null ? layoutData.getLocation() : new Point(0, 0);
                Dimension size = null;
                size = layoutData.getSize() != null ? layoutData.getSize() : this.getDefaultSize(portNode);
                tempBounds = new Rectangle(location, size);
            } else {
                Dimension size = ViewSizeHint.getInstance().consumeSize();
                Point location = null;
                if (size == null) {
                    Option<Rectangle> optionalRect;
                    if (new ViewQuery(createdView).isForNameEditPart() && (optionalRect = GMFHelper.getAbsoluteBounds(createdView)).some()) {
                        size = ((Rectangle)optionalRect.get()).getSize();
                    }
                    if (size == null) {
                        size = this.getDefaultSize(portNode);
                    }
                }
                if (location == null) {
                    location = new Point(0, 0);
                }
                tempBounds = new Rectangle(location, size);
            }
            CanonicalDBorderItemLocator locator = new CanonicalDBorderItemLocator(parentNode, 29);
            if (new ViewQuery(createdView).isForNameEditPart()) {
                locator.setBorderItemOffset(IBorderItemOffsets.NO_OFFSET);
            } else if (new DDiagramElementQuery((DDiagramElement)portNode).isIndirectlyCollapsed()) {
                locator.setBorderItemOffset(IBorderItemOffsets.COLLAPSE_FILTER_OFFSET);
            } else {
                locator.setBorderItemOffset(IBorderItemOffsets.DEFAULT_OFFSET);
            }
            Figure dummyFigure = new Figure();
            Rectangle constraint = tempBounds.getCopy();
            locator.setConstraint(constraint);
            dummyFigure.setVisible(true);
            Rectangle rect = new Rectangle(constraint);
            Point parentAbsoluteLocation = GMFHelper.getAbsoluteLocation(parentNode);
            rect.translate(parentAbsoluteLocation.x, parentAbsoluteLocation.y);
            dummyFigure.setBounds(rect);
            Point realLocation = locator.getValidLocation(rect, createdNode, Lists.newArrayList((Object[])new Node[]{createdNode}));
            Dimension d = realLocation.getDifference(parentAbsoluteLocation);
            Point location = new Point(d.width, d.height);
            realLocation.setLocation(location);
            locator.relocate(createdNode);
            LayoutConstraint createdNodeLayoutConstraint = createdNode.getLayoutConstraint();
            if (createdNodeLayoutConstraint instanceof Location) {
                laidOut = true;
                createdNodeBounds = (Location)createdNodeLayoutConstraint;
                createdNodeBounds.setX(location.x);
                createdNodeBounds.setY(location.y);
            }
            if (createdNodeLayoutConstraint instanceof Size) {
                createdNodeBounds = (Size)createdNodeLayoutConstraint;
                ResizeKind resizeKind = ResizeKind.NSEW_LITERAL;
                if (portNode instanceof DNode) {
                    resizeKind = ((DNode)portNode).getResizeKind();
                }
                if (constraint.width != -1 && this.canResizeWidth(resizeKind)) {
                    createdNodeBounds.setWidth(constraint.width);
                }
                if (constraint.height != -1 && this.canResizeHeight(resizeKind)) {
                    createdNodeBounds.setHeight(constraint.height);
                }
            }
        } else {
            laidOut = true;
            Point location = layoutData.getLocation() != null ? layoutData.getLocation() : new Point(0, 0);
            Dimension size = null;
            size = layoutData.getSize() != null ? layoutData.getSize() : this.getDefaultSize(portNode);
            CanonicalDBorderItemLocator locator = new CanonicalDBorderItemLocator(parentNode, 29);
            if (portNode != null) {
                if (new DDiagramElementQuery((DDiagramElement)portNode).isIndirectlyCollapsed()) {
                    locator.setBorderItemOffset(IBorderItemOffsets.COLLAPSE_FILTER_OFFSET);
                } else {
                    locator.setBorderItemOffset(IBorderItemOffsets.DEFAULT_OFFSET);
                }
            } else {
                locator.setBorderItemOffset(IBorderItemOffsets.DEFAULT_OFFSET);
            }
            Point parentAbsoluteLocation = GMFHelper.getAbsoluteBounds(parentNode).getTopLeft();
            Point realLocation = locator.getValidLocation(new Rectangle(location.getTranslated(parentAbsoluteLocation), size), createdNode, Collections.singleton(createdNode));
            realLocation.translate(parentAbsoluteLocation.negate());
            Node node = (Node)createdView;
            Bounds bounds = (Bounds)node.getLayoutConstraint();
            bounds.setX(realLocation.x);
            bounds.setY(realLocation.y);
            if (size.width != -1) {
                bounds.setWidth(size.width);
            }
            if (size.height != -1) {
                bounds.setHeight(size.height);
            }
        }
        return laidOut;
    }

    private boolean updateDNodeContainerChildButNotBorderedNodeBounds(View createdView, View previousCreatedView) {
        EObject element = createdView.getElement();
        EObject parent = element.eContainer();
        boolean isAlreadylayouted = false;
        if (element instanceof AbstractDNode && parent instanceof DNodeContainer) {
            Dimension size = null;
            Point location = null;
            AbstractDNode abstractDNode = (AbstractDNode)element;
            LayoutData layoutData = SiriusLayoutDataManager.INSTANCE.getData(abstractDNode);
            if (layoutData == null) {
                layoutData = SiriusLayoutDataManager.INSTANCE.getData(abstractDNode, true);
            }
            if (layoutData != null) {
                location = layoutData.getLocation();
                size = layoutData.getSize();
                isAlreadylayouted = true;
            }
            if (size == null) {
                size = this.getDefaultSize(abstractDNode);
            }
            if (location == null) {
                if (previousCreatedView instanceof Node && ((Node)previousCreatedView).getLayoutConstraint() instanceof Bounds) {
                    if (previousCreatedView.eAdapters().contains((Object)SiriusLayoutDataManager.INSTANCE.getCenterAdapterMarker())) {
                        this.markCreatedViewsWithCenterLayout(createdView);
                    } else {
                        Bounds previousBounds = (Bounds)((Node)previousCreatedView).getLayoutConstraint();
                        location = new Point(previousBounds.getX(), previousBounds.getY()).getTranslated(30, 30);
                    }
                    isAlreadylayouted = true;
                } else if (layoutData == null && SiriusLayoutDataManager.INSTANCE.getData().some() && !new DNodeContainerExperimentalQuery((DNodeContainer)parent).isRegionContainer()) {
                    this.markCreatedViewsWithCenterLayout(createdView);
                    isAlreadylayouted = true;
                }
            }
            if (createdView instanceof Node) {
                Node createdNode = (Node)createdView;
                this.updateLocationConstraint(createdNode, size, location, abstractDNode);
            }
        }
        return isAlreadylayouted;
    }

    private void updateLocationConstraint(Node createdNode, Dimension size, Point location, AbstractDNode abstractDNode) {
        Bounds bounds = (Bounds)createdNode.getLayoutConstraint();
        if (location != null) {
            bounds.setX(location.x);
            bounds.setY(location.y);
        }
        ResizeKind resizeKind = ResizeKind.NSEW_LITERAL;
        if (abstractDNode instanceof DNode) {
            resizeKind = ((DNode)abstractDNode).getResizeKind();
        }
        if (size != null) {
            if (size.width != -1 && this.canResizeWidth(resizeKind)) {
                bounds.setWidth(size.width);
            }
            if (size.height != -1 && this.canResizeHeight(resizeKind)) {
                bounds.setHeight(size.height);
            }
        }
    }

    private boolean canResizeHeight(ResizeKind resizeKind) {
        return resizeKind.getValue() == 2 || resizeKind.getValue() == 1;
    }

    private boolean canResizeWidth(ResizeKind resizeKind) {
        return resizeKind.getValue() == 3 || resizeKind.getValue() == 1;
    }

    private Dimension getDefaultSize(AbstractDNode abstractDNode) {
        Dimension defaultSize = new Dimension(-1, -1);
        if (abstractDNode instanceof DNode) {
            defaultSize = new DNodeQuery((DNode)abstractDNode).getDefaultDimension();
        }
        return defaultSize;
    }

    protected CreateViewRequest getCreateViewRequest(List<? extends CreateViewRequest.ViewDescriptor> descriptors) {
        return new CreateViewRequest(descriptors);
    }

    protected boolean isBorderedNode(EObject element) {
        EObject parent;
        boolean result = false;
        if (element instanceof DNode && (parent = element.eContainer()) instanceof AbstractDNode) {
            AbstractDNode parentDNode = (AbstractDNode)parent;
            result = parentDNode.getOwnedBorderedNodes().contains((Object)element);
        }
        return result;
    }

    protected boolean isTopLevelNode(EObject element) {
        boolean isTopLevelNode = false;
        EObject container = element.eContainer();
        if (container instanceof DDiagram) {
            DDiagram dDiagram = (DDiagram)container;
            isTopLevelNode = dDiagram.getOwnedDiagramElements().contains((Object)element);
        }
        return isTopLevelNode;
    }

    private boolean isChildNodeButNotBorderedNodeOfContainer(EObject element) {
        boolean isChildNodeButNotBorderedNodeOfContainer = false;
        EObject container = element.eContainer();
        if (container instanceof DNodeContainer) {
            DNodeContainer dNodeContainer = (DNodeContainer)container;
            isChildNodeButNotBorderedNodeOfContainer = dNodeContainer.getOwnedDiagramElements().contains((Object)element);
        }
        return isChildNodeButNotBorderedNodeOfContainer;
    }

    protected CreateViewRequest.ViewDescriptor getViewDescriptor(EObject element, String factoryHint) {
        CanonicalElementAdapter elementAdapter = new CanonicalElementAdapter(element, factoryHint);
        CreateViewRequest.ViewDescriptor descriptor = this.getViewDescriptor((IAdaptable)elementAdapter, Node.class, factoryHint, -1);
        return descriptor;
    }

    protected CreateViewRequest.ViewDescriptor getViewDescriptor(IAdaptable elementAdapter, Class<?> viewKind, String hint, int index) {
        return new CreateViewRequest.ViewDescriptor(elementAdapter, viewKind, hint, index, true, DiagramUIPlugin.DIAGRAM_PREFERENCES_HINT);
    }

    private List<View> cleanCanonicalSemanticChildren(View currentView, Collection<View> viewChildren, Collection<SiriusNodeDescriptor> semanticChildren) {
        Iterator<View> viewChildrenIT = viewChildren.iterator();
        ArrayList<View> orphaned = new ArrayList<View>();
        HashMap<EObject, View> viewToSemanticMap = new HashMap<EObject, View>();
        HashMap<EObject, SiriusNodeDescriptor> semanticToObjectInMap = new HashMap<EObject, SiriusNodeDescriptor>();
        HashSet<EObject> realSemanticChilren = new HashSet<EObject>();
        for (SiriusNodeDescriptor object : semanticChildren) {
            realSemanticChilren.add(object.getModelElement());
            semanticToObjectInMap.put(object.getModelElement(), object);
        }
        while (viewChildrenIT.hasNext()) {
            View viewChild = viewChildrenIT.next();
            EObject semanticChild = viewChild.getElement();
            if (!new IsOrphanedSwitch(viewChild, realSemanticChilren, currentView).doSwitch(SiriusVisualIDRegistry.getVisualID(currentView)).booleanValue()) {
                semanticChildren.remove(semanticToObjectInMap.get(semanticChild));
                viewToSemanticMap.put(semanticChild, viewChild);
            } else {
                orphaned.add(viewChild);
            }
            View viewInMap = (View)viewToSemanticMap.get(semanticChild);
            if (viewInMap == null || viewChild.equals(viewInMap) || !viewInMap.isMutable()) continue;
            orphaned.remove(viewChild);
            orphaned.add(viewInMap);
            viewToSemanticMap.put(semanticChild, viewChild);
        }
        return orphaned;
    }

    protected boolean deleteViews(Collection<? extends View> views) {
        for (View view : views) {
            List<Edge> edgesToDelete = this.getIncomingOutgoingEdges(view);
            EcoreUtil.remove((EObject)view);
            for (Edge edge : edgesToDelete) {
                EcoreUtil.remove((EObject)edge);
            }
        }
        return !views.isEmpty();
    }

    private List<Edge> getIncomingOutgoingEdges(View view) {
        ArrayList edgesToDelete = Lists.newArrayList();
        Iterables.addAll((Collection)edgesToDelete, (Iterable)Iterables.filter((Iterable)view.getSourceEdges(), Edge.class));
        Iterables.addAll((Collection)edgesToDelete, (Iterable)Iterables.filter((Iterable)view.getTargetEdges(), Edge.class));
        for (View child : this.getViewChildren(view)) {
            edgesToDelete.addAll(this.getIncomingOutgoingEdges(child));
        }
        return edgesToDelete;
    }
}

