/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ui.business.api.session;

import com.google.common.collect.Maps;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.sirius.business.api.dialect.DialectManager;
import org.eclipse.sirius.business.api.query.RepresentationDescriptionQuery;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.common.ui.tools.api.util.EclipseUIUtil;
import org.eclipse.sirius.ui.business.api.dialect.DialectUIManager;
import org.eclipse.sirius.ui.tools.internal.dialogs.RepresentationsSelectionDialog;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.description.RepresentationDescription;
import org.eclipse.sirius.viewpoint.description.Viewpoint;
import org.eclipse.sirius.viewpoint.provider.Messages;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public final class SessionHelper {
    private SessionHelper() {
    }

    public static void openStartupRepresentations(Session session, IProgressMonitor monitor) {
        try {
            Collection<DRepresentation> selection;
            String projectName;
            monitor.beginTask(Messages.SessionHelper_startupRepresentationOpeningTask, 1);
            Collection<DRepresentation> startupCandidates = SessionHelper.findAllStartupCandidates(session);
            String origin = null;
            if (session.getSessionResource().getURI().segmentCount() > 1 && (projectName = session.getSessionResource().getURI().segment(1)) != null) {
                origin = MessageFormat.format(Messages.SessionHelper_origin, projectName);
            }
            if (!(selection = SessionHelper.selectRepresentationsToOpen(origin, startupCandidates)).isEmpty()) {
                monitor.subTask(Messages.SessionHelper_openStartupRepresentationsTask);
            }
            for (DRepresentation repr : selection) {
                DialectUIManager.INSTANCE.openEditor(session, repr, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            }
        }
        finally {
            monitor.done();
        }
    }

    public static Collection<DRepresentation> findAllStartupCandidates(Session session) {
        ArrayList<DRepresentation> candidates = new ArrayList<DRepresentation>();
        Collection selectedViewpoints = session.getSelectedViewpoints(false);
        if (!selectedViewpoints.isEmpty()) {
            HashMap alreadyCheckedDescriptions = Maps.newHashMap();
            Collection allRepresentations = DialectManager.INSTANCE.getAllRepresentations(session);
            for (DRepresentation repr : allRepresentations) {
                RepresentationDescription description = DialectManager.INSTANCE.getDescription(repr);
                if (description == null || !SessionHelper.checkStartupDescInSelectedVps(description, alreadyCheckedDescriptions, selectedViewpoints)) continue;
                candidates.add(repr);
            }
        }
        return candidates;
    }

    private static boolean checkStartupDescInSelectedVps(RepresentationDescription description, Map<RepresentationDescription, Boolean> checkedDescriptions, Collection<Viewpoint> selectedVps) {
        if (!checkedDescriptions.containsKey(description)) {
            boolean candidate = false;
            if (description.isShowOnStartup()) {
                Viewpoint parentViewpoint = new RepresentationDescriptionQuery(description).getParentViewpoint();
                candidate = parentViewpoint == null ? false : selectedVps.contains(parentViewpoint);
            }
            checkedDescriptions.put(description, candidate);
        }
        return checkedDescriptions.get(description);
    }

    public static Collection<DRepresentation> selectRepresentationsToOpen(final String representationsOrigin, final Collection<DRepresentation> candidates) {
        final ArrayList<DRepresentation> selection = new ArrayList<DRepresentation>();
        if (candidates.size() == 1) {
            selection.addAll(candidates);
        } else if (candidates.size() > 1) {
            EclipseUIUtil.displaySyncExec((Runnable)new Runnable(){

                @Override
                public void run() {
                    Shell shell = PlatformUI.getWorkbench().getDisplay().getActiveShell();
                    RepresentationsSelectionDialog dlg = new RepresentationsSelectionDialog(shell, candidates);
                    dlg.create();
                    dlg.setTitle(Messages.SessionHelper_selectionDialogTitle);
                    String message = Messages.SessionHelper_selectionDialogMessage;
                    if (representationsOrigin != null) {
                        message = MessageFormat.format(Messages.SessionHelper_selectionDialogMessageWithOrigin, representationsOrigin);
                    }
                    dlg.setMessage(message);
                    if (dlg.open() == 0) {
                        selection.addAll(dlg.getSelectedRepresentations());
                    }
                }
            });
        }
        return selection;
    }
}

