/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.mapping;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.mapping.ModelProvider;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.resources.mapping.ResourceMappingContext;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.team.core.mapping.ISynchronizationScope;
import org.eclipse.team.core.mapping.ISynchronizationScopeParticipant;
import org.eclipse.team.internal.ui.TeamUIPlugin;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PlatformUI;

public class ResourceModelScopeParticipant
implements ISynchronizationScopeParticipant,
IResourceChangeListener,
IPropertyChangeListener {
    private final ModelProvider provider;
    private final ISynchronizationScope scope;

    public ResourceModelScopeParticipant(ModelProvider provider, ISynchronizationScope scope) {
        this.provider = provider;
        this.scope = scope;
        if (this.hasWorkspaceMapping()) {
            ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this, 1);
        }
        if (this.hasWorkingSetMappings()) {
            PlatformUI.getWorkbench().getWorkingSetManager().addPropertyChangeListener((IPropertyChangeListener)this);
        }
    }

    private boolean hasWorkingSetMappings() {
        ResourceMapping[] mappings = this.scope.getMappings(this.provider.getDescriptor().getId());
        int i = 0;
        while (i < mappings.length) {
            ResourceMapping mapping = mappings[i];
            Object modelObject = mapping.getModelObject();
            if (modelObject instanceof IWorkingSet) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean hasWorkspaceMapping() {
        ResourceMapping[] mappings = this.scope.getMappings(this.provider.getDescriptor().getId());
        int i = 0;
        while (i < mappings.length) {
            ModelProvider provider;
            IResource resource;
            ResourceMapping mapping = mappings[i];
            Object modelObject = mapping.getModelObject();
            if (modelObject instanceof IResource ? (resource = (IResource)modelObject).getType() == 8 : modelObject instanceof ModelProvider && (provider = (ModelProvider)modelObject).getId().equals("org.eclipse.core.resources.modelProvider")) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public ResourceMapping[] handleContextChange(ISynchronizationScope scope, IResource[] resources, IProject[] projects) {
        HashSet result = new HashSet();
        int i = 0;
        while (i < projects.length) {
            IProject project = projects[i];
            this.collectMappings(project, result);
            ++i;
        }
        return result.toArray(new ResourceMapping[result.size()]);
    }

    /*
     * Unable to fully structure code
     */
    private void collectMappings(IProject project, Set result) {
        mappings = this.scope.getMappings(this.provider.getDescriptor().getId());
        i = 0;
        while (i < mappings.length) {
            mapping = mappings[i];
            refresh = false;
            modelObject = mapping.getModelObject();
            if (modelObject instanceof IWorkingSet) {
                set = (IWorkingSet)modelObject;
                elements = set.getElements();
                j = 0;
                while (j < elements.length) {
                    adaptable = elements[j];
                    m = (ResourceMapping)Adapters.adapt((Object)adaptable, ResourceMapping.class);
                    if (m != null) {
                        p = m.getProjects();
                        k = 0;
                        while (k < p.length) {
                            mp = p[k];
                            if (mp.equals((Object)project)) {
                                refresh = true;
                                break;
                            }
                            ++k;
                        }
                    }
                    if (!refresh) {
                        ++j;
                        continue;
                    }
                    break;
                }
            } else if (modelObject instanceof IResource) {
                resource = (IResource)modelObject;
                if (resource.getType() == 8) {
                    refresh = true;
                }
            } else if (modelObject instanceof ModelProvider) {
                mp = (ModelProvider)modelObject;
                try {
                    list = mp.getMappings((IResource)project, ResourceMappingContext.LOCAL_CONTEXT, null);
                    if (list.length <= 0) ** GOTO lbl44
                    refresh = true;
                }
                catch (CoreException e) {
                    TeamUIPlugin.log(e);
                }
            }
            if (refresh) {
                result.add(mapping);
            }
            ++i;
        }
    }

    public void dispose() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        if (PlatformUI.isWorkbenchRunning()) {
            PlatformUI.getWorkbench().getWorkingSetManager().removePropertyChangeListener((IPropertyChangeListener)this);
        }
    }

    public void resourceChanged(IResourceChangeEvent event) {
        HashSet result = new HashSet();
        IResourceDelta[] children = event.getDelta().getAffectedChildren();
        int i = 0;
        while (i < children.length) {
            IResourceDelta delta = children[i];
            IResource resource = delta.getResource();
            if (resource.getType() == 4 && ((delta.getKind() & 3) != 0 || (delta.getFlags() & 0x4000) != 0) && this.isInContext(resource)) {
                this.collectMappings((IProject)resource, result);
            }
            ++i;
        }
        if (!result.isEmpty()) {
            this.fireChange(result.toArray(new ResourceMapping[result.size()]));
        }
    }

    private boolean isInContext(IResource resource) {
        IProject[] projects = this.scope.getProjects();
        int i = 0;
        while (i < projects.length) {
            IProject project = projects[i];
            if (project.equals((Object)resource.getProject())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private void fireChange(ResourceMapping[] mappings) {
        this.scope.refresh(mappings);
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty() == "workingSetContentChange") {
            IWorkingSet newSet = (IWorkingSet)event.getNewValue();
            ResourceMapping[] mappings = this.scope.getMappings(this.provider.getDescriptor().getId());
            int i = 0;
            while (i < mappings.length) {
                ResourceMapping mapping = mappings[i];
                if (newSet == mapping.getModelObject()) {
                    this.fireChange(new ResourceMapping[]{mapping});
                }
                ++i;
            }
        } else {
            event.getProperty();
        }
    }
}

