/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.analysis.counters.ui;

import com.google.common.base.Splitter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.dialogs.TreePatternFilter;

public class CounterTreePatternFilter
extends TreePatternFilter {
    private final List<Pattern> fPatterns = new ArrayList<Pattern>();
    private final Map<String, Matcher> fMatchers = new HashMap<String, Matcher>();

    public void setPattern(String patternString) {
        this.fPatterns.clear();
        this.fMatchers.clear();
        super.setPattern(patternString);
        Iterable filters = Splitter.on((char)'/').split((CharSequence)patternString.replace('*', '.'));
        filters.forEach(filter -> {
            boolean bl = this.fPatterns.add(Pattern.compile(filter, 2));
        });
    }

    protected boolean isLeafMatch(Viewer viewer, Object element) {
        Object node = element;
        StructuredViewer structuredViewer = (StructuredViewer)viewer;
        ILabelProvider labelProvider = (ILabelProvider)structuredViewer.getLabelProvider();
        ListIterator<Pattern> iter = this.fPatterns.listIterator(this.fPatterns.size());
        while (iter.hasPrevious()) {
            String labelText = labelProvider.getText(node);
            if (!this.wordMatches(labelText, iter.previous())) {
                return false;
            }
            IContentProvider contentProvider = ((StructuredViewer)viewer).getContentProvider();
            node = ((ITreeContentProvider)contentProvider).getParent(node);
        }
        return true;
    }

    private boolean wordMatches(String text, Pattern pattern) {
        Matcher matcher;
        Matcher matcher2 = matcher = this.fMatchers.containsKey(text) ? this.fMatchers.get(text) : pattern.matcher(text);
        return text != null && matcher != null && matcher.find();
    }
}

