/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.lttng2.ust.core.analysis.memory;

import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.AbstractStateSystemAnalysisDataProvider;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.CommonStatusMessage;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.TmfCommonXAxisResponseFactory;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.filters.TimeQueryFilter;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.xy.ITmfCommonXAxisModel;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.xy.ITmfXYDataProvider;
import org.eclipse.tracecompass.internal.provisional.tmf.core.response.TmfModelResponse;
import org.eclipse.tracecompass.internal.tmf.core.model.YModel;
import org.eclipse.tracecompass.lttng2.ust.core.analysis.memory.Messages;
import org.eclipse.tracecompass.lttng2.ust.core.analysis.memory.UstMemoryAnalysisModule;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateSystemDisposedException;
import org.eclipse.tracecompass.statesystem.core.interval.ITmfStateInterval;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceUtils;

@NonNullByDefault
public class UstMemoryUsageDataProvider
extends AbstractStateSystemAnalysisDataProvider
implements ITmfXYDataProvider {
    private final UstMemoryAnalysisModule fModule;

    public static @Nullable UstMemoryUsageDataProvider create(ITmfTrace trace) {
        UstMemoryAnalysisModule module = (UstMemoryAnalysisModule)TmfTraceUtils.getAnalysisModuleOfClass((ITmfTrace)trace, UstMemoryAnalysisModule.class, (String)"org.eclipse.linuxtools.lttng2.ust.analysis.memory");
        if (module != null) {
            module.schedule();
            return new UstMemoryUsageDataProvider(trace, module);
        }
        return null;
    }

    private UstMemoryUsageDataProvider(ITmfTrace trace, UstMemoryAnalysisModule module) {
        super(trace);
        this.fModule = module;
    }

    public TmfModelResponse<ITmfCommonXAxisModel> fetchXY(TimeQueryFilter filter, @Nullable IProgressMonitor monitor) {
        TmfModelResponse res = this.verifyParameters(this.fModule, filter, monitor);
        if (res != null) {
            return res;
        }
        ITmfStateSystem ss = Objects.requireNonNull(this.fModule.getStateSystem(), "Statesystem should have been verified by verifyParameters");
        HashMap<Integer, double[]> tempModel = new HashMap<Integer, double[]>();
        List tidQuarks = ss.getSubAttributes(-1, false);
        HashMap<Integer, String> processName = new HashMap<Integer, String>();
        long[] xValues = filter.getTimesRequested();
        long currentEnd = ss.getCurrentEndTime();
        try {
            int i = 0;
            while (i < xValues.length) {
                if (monitor != null && monitor.isCanceled()) {
                    return TmfCommonXAxisResponseFactory.createCancelledResponse((String)CommonStatusMessage.TASK_CANCELLED);
                }
                long time = xValues[i];
                if (time >= ss.getStartTime() && time <= currentEnd) {
                    List fullState = ss.queryFullState(time);
                    Iterator iterator = tidQuarks.iterator();
                    while (iterator.hasNext()) {
                        double yvalue;
                        int quark = (Integer)iterator.next();
                        int memoryAttribute = ss.optQuarkRelative(quark, new String[]{"Memory"});
                        int procNameQuark = ss.optQuarkRelative(quark, new String[]{"Procname"});
                        if (memoryAttribute == -2 || procNameQuark == -2) continue;
                        String procnameValue = (String)((ITmfStateInterval)fullState.get(procNameQuark)).getValue();
                        if (procnameValue != null && !procnameValue.isEmpty()) {
                            processName.put(quark, procnameValue);
                        }
                        tempModel.putIfAbsent(quark, new double[xValues.length]);
                        double[] values = Objects.requireNonNull((double[])tempModel.get(quark));
                        Object val = ((ITmfStateInterval)fullState.get(memoryAttribute)).getValue();
                        values[i] = yvalue = (double)UstMemoryUsageDataProvider.extractValue(val);
                    }
                }
                ++i;
            }
        }
        catch (StateSystemDisposedException e) {
            return TmfCommonXAxisResponseFactory.createFailedResponse((String)e.getMessage());
        }
        ImmutableMap.Builder ySeries = ImmutableMap.builder();
        for (Map.Entry tempEntry : tempModel.entrySet()) {
            @Nullable String name = (String)processName.get(tempEntry.getKey());
            name = UstMemoryUsageDataProvider.beautifyName(name, ss, (Integer)tempEntry.getKey());
            ySeries.put((Object)name, (Object)new YModel(name, (double[])tempEntry.getValue()));
        }
        boolean complete = ss.waitUntilBuilt(0L) || filter.getEnd() <= currentEnd;
        return TmfCommonXAxisResponseFactory.create((String)Objects.requireNonNull(Messages.MemoryUsageDataProvider_Title), (long[])xValues, (Map)ySeries.build(), (boolean)complete);
    }

    private static String beautifyName(@Nullable String name, ITmfStateSystem ss, int quark) {
        if (name != null && !name.isEmpty()) {
            return String.valueOf(name) + " (" + ss.getAttributeName(quark) + ')';
        }
        return String.valueOf('(') + ss.getAttributeName(quark) + ')';
    }

    private static long extractValue(@Nullable Object val) {
        if (val instanceof Number) {
            return ((Number)val).longValue();
        }
        return 0L;
    }
}

