/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.lttng2.ust.ui.analysis.debuginfo;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.internal.lttng2.ust.ui.analysis.debuginfo.UstDebugInfoSymbolProviderPreferencePage;
import org.eclipse.tracecompass.lttng2.ust.core.analysis.debuginfo.BinaryCallsite;
import org.eclipse.tracecompass.lttng2.ust.core.analysis.debuginfo.FunctionLocation;
import org.eclipse.tracecompass.lttng2.ust.core.analysis.debuginfo.UstDebugInfoBinaryAspect;
import org.eclipse.tracecompass.lttng2.ust.core.analysis.debuginfo.UstDebugInfoFunctionAspect;
import org.eclipse.tracecompass.lttng2.ust.core.trace.LttngUstTrace;
import org.eclipse.tracecompass.tmf.core.symbols.DefaultSymbolProvider;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.ui.symbols.ISymbolProvider;
import org.eclipse.tracecompass.tmf.ui.symbols.ISymbolProviderPreferencePage;

public class UstDebugInfoSymbolProvider
extends DefaultSymbolProvider
implements ISymbolProvider {
    public UstDebugInfoSymbolProvider(LttngUstTrace trace) {
        super((ITmfTrace)trace);
    }

    void setConfiguredPathPrefix(LttngUstTrace.SymbolProviderConfig newConfig) {
        this.getTrace().setSymbolProviderConfig(newConfig);
    }

    public @NonNull LttngUstTrace getTrace() {
        return (LttngUstTrace)super.getTrace();
    }

    public @Nullable String getSymbolText(int pid, long timestamp, long address) {
        BinaryCallsite bc = UstDebugInfoBinaryAspect.getBinaryCallsite((LttngUstTrace)this.getTrace(), (int)pid, (long)timestamp, (long)address);
        if (bc == null) {
            return null;
        }
        FunctionLocation loc = UstDebugInfoFunctionAspect.getFunctionFromBinaryLocation((BinaryCallsite)bc);
        return loc == null ? null : loc.getFunctionName();
    }

    public @NonNull ISymbolProviderPreferencePage createPreferencePage() {
        return new UstDebugInfoSymbolProviderPreferencePage(this);
    }
}

