/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.viewers;

import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.tracecompass.tmf.core.component.ITmfComponent;
import org.eclipse.tracecompass.tmf.core.signal.TmfSelectionRangeUpdatedSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalHandler;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalThrottler;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceClosedSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceOpenedSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceRangeUpdatedSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceSelectedSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceUpdatedSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfWindowRangeUpdatedSignal;
import org.eclipse.tracecompass.tmf.core.timestamp.ITmfTimestamp;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimeRange;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimestamp;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceContext;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceManager;
import org.eclipse.tracecompass.tmf.ui.viewers.ITmfTimeProvider;
import org.eclipse.tracecompass.tmf.ui.viewers.TmfViewer;

public abstract class TmfTimeViewer
extends TmfViewer
implements ITmfTimeProvider {
    private long fStartTime;
    private long fEndTime;
    private long fWindowStartTime;
    private long fWindowEndTime;
    private long fSelectionBeginTime;
    private long fSelectionEndTime;
    private ITmfTrace fTrace;
    private final TmfSignalThrottler fTimeRangeSyncThrottle = new TmfSignalThrottler((ITmfComponent)this, 200L);

    public TmfTimeViewer() {
    }

    public TmfTimeViewer(Composite parent) {
        this(parent, "");
    }

    public TmfTimeViewer(Composite parent, String name) {
        this.init(parent, name);
    }

    protected void setStartTime(long startTime) {
        this.fStartTime = startTime;
    }

    protected void setEndTime(long endTime) {
        this.fEndTime = endTime;
    }

    protected void setWindowRange(long windowStartTime, long windowEndTime) {
        this.fWindowStartTime = windowStartTime;
        this.fWindowEndTime = windowEndTime;
    }

    protected void setSelectionRange(long selectionBeginTime, long selectionEndTime) {
        this.fSelectionBeginTime = selectionBeginTime;
        this.fSelectionEndTime = selectionEndTime;
    }

    protected void setTrace(ITmfTrace trace) {
        this.fTrace = trace;
    }

    protected ITmfTrace getTrace() {
        return this.fTrace;
    }

    @Override
    public long getStartTime() {
        return this.fStartTime;
    }

    @Override
    public long getEndTime() {
        return this.fEndTime;
    }

    @Override
    public long getWindowStartTime() {
        return this.fWindowStartTime;
    }

    @Override
    public long getWindowEndTime() {
        return this.fWindowEndTime;
    }

    @Override
    public long getWindowDuration() {
        return this.getWindowEndTime() - this.getWindowStartTime();
    }

    @Override
    public long getSelectionBeginTime() {
        return this.fSelectionBeginTime;
    }

    @Override
    public long getSelectionEndTime() {
        return this.fSelectionEndTime;
    }

    @Override
    public void updateSelectionRange(long currentBeginTime, long currentEndTime) {
        if (this.fTrace != null) {
            this.setSelectionRange(currentBeginTime, currentEndTime);
            ITmfTimestamp startTimestamp = TmfTimestamp.fromNanos((long)this.getSelectionBeginTime());
            ITmfTimestamp endTimestamp = TmfTimestamp.fromNanos((long)this.getSelectionEndTime());
            TmfSelectionRangeUpdatedSignal signal = new TmfSelectionRangeUpdatedSignal((Object)this, startTimestamp, endTimestamp);
            this.broadcast((TmfSignal)signal);
        }
    }

    @Override
    public void updateWindow(long windowStartTime, long windowEndTime) {
        this.setWindowRange(windowStartTime, windowEndTime);
        TmfTimeRange timeRange = new TmfTimeRange(TmfTimestamp.fromNanos((long)this.getWindowStartTime()), TmfTimestamp.fromNanos((long)this.getWindowEndTime()));
        TmfWindowRangeUpdatedSignal signal = new TmfWindowRangeUpdatedSignal((Object)this, timeRange);
        this.fTimeRangeSyncThrottle.queue((TmfSignal)signal);
    }

    public void loadTrace(ITmfTrace trace) {
        this.fTrace = trace;
        TmfTraceContext ctx = TmfTraceManager.getInstance().getCurrentTraceContext();
        long selectionStart = ctx.getSelectionRange().getStartTime().toNanos();
        long selectionEnd = ctx.getSelectionRange().getEndTime().toNanos();
        TmfTimeRange windowRange = ctx.getWindowRange();
        long windowStartTime = windowRange.getStartTime().toNanos();
        long windowEndTime = windowRange.getEndTime().toNanos();
        long startTime = this.fTrace.getStartTime().toNanos();
        long endTime = this.fTrace.getEndTime().toNanos();
        this.setSelectionRange(selectionStart, selectionEnd);
        this.setStartTime(startTime);
        this.setWindowRange(windowStartTime, windowEndTime);
        this.setEndTime(endTime);
    }

    public void reset() {
        this.setSelectionRange(0L, 0L);
        this.setStartTime(0L);
        this.setWindowRange(0L, 0L);
        this.setEndTime(0L);
        this.setTrace(null);
    }

    @TmfSignalHandler
    public void traceOpened(@Nullable TmfTraceOpenedSignal signal) {
        if (signal == null) {
            return;
        }
        this.fTrace = signal.getTrace();
        this.loadTrace(this.getTrace());
    }

    @TmfSignalHandler
    public void traceSelected(@Nullable TmfTraceSelectedSignal signal) {
        if (signal != null && this.fTrace != signal.getTrace()) {
            this.fTrace = signal.getTrace();
            this.loadTrace(this.getTrace());
        }
    }

    @TmfSignalHandler
    public void traceClosed(@Nullable TmfTraceClosedSignal signal) {
        if (signal == null || signal.getTrace() != this.fTrace) {
            return;
        }
        this.fTrace = null;
        this.reset();
    }

    @TmfSignalHandler
    public void selectionRangeUpdated(@Nullable TmfSelectionRangeUpdatedSignal signal) {
        if (signal != null && signal.getSource() != this && this.fTrace != null) {
            long selectedTime = signal.getBeginTime().toNanos();
            long selectedEndTime = signal.getEndTime().toNanos();
            this.setSelectionRange(selectedTime, selectedEndTime);
        }
    }

    @TmfSignalHandler
    public void windowRangeUpdated(@Nullable TmfWindowRangeUpdatedSignal signal) {
        if (signal != null && this.fTrace != null) {
            TmfTimeRange range = signal.getCurrentRange().getIntersection(this.fTrace.getTimeRange());
            if (range == null) {
                return;
            }
            if (signal.getSource() != this) {
                long windowStartTime = range.getStartTime().toNanos();
                long windowEndTime = range.getEndTime().toNanos();
                this.setWindowRange(windowStartTime, windowEndTime);
            }
        }
    }

    @TmfSignalHandler
    public void traceRangeUpdated(@Nullable TmfTraceRangeUpdatedSignal signal) {
        if (signal == null || signal.getTrace() != this.fTrace) {
            return;
        }
        TmfTimeRange fullRange = signal.getRange();
        long traceStartTime = fullRange.getStartTime().toNanos();
        long traceEndTime = fullRange.getEndTime().toNanos();
        this.setStartTime(traceStartTime);
        this.setEndTime(traceEndTime);
    }

    @TmfSignalHandler
    public void traceUpdated(@Nullable TmfTraceUpdatedSignal signal) {
        if (signal == null || signal.getTrace() != this.fTrace) {
            return;
        }
        TmfTimeRange fullRange = signal.getTrace().getTimeRange();
        long traceStartTime = fullRange.getStartTime().toNanos();
        long traceEndTime = fullRange.getEndTime().toNanos();
        this.setStartTime(traceStartTime);
        this.setEndTime(traceEndTime);
    }
}

