/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.progress;

import java.time.Duration;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.progress.GroupInfo;
import org.eclipse.ui.internal.progress.IJobProgressManagerListener;
import org.eclipse.ui.internal.progress.IProgressUpdateCollector;
import org.eclipse.ui.internal.progress.JobInfo;
import org.eclipse.ui.internal.progress.JobTreeElement;
import org.eclipse.ui.internal.progress.ProgressManager;
import org.eclipse.ui.internal.progress.Throttler;
import org.eclipse.ui.internal.util.PrefUtil;

class ProgressViewUpdater
implements IJobProgressManagerListener {
    private static ProgressViewUpdater singleton;
    private IProgressUpdateCollector[] collectors;
    UpdatesInfo currentInfo = new UpdatesInfo();
    boolean debug;
    Throttler throttledUpdate = new Throttler(PlatformUI.getWorkbench().getDisplay(), Duration.ofMillis(100L), this::update);

    static ProgressViewUpdater getSingleton() {
        if (singleton == null) {
            singleton = new ProgressViewUpdater();
        }
        return singleton;
    }

    static boolean hasSingleton() {
        return singleton != null;
    }

    static void clearSingleton() {
        if (singleton != null) {
            ProgressManager.getInstance().removeListener(singleton);
        }
        singleton = null;
    }

    private ProgressViewUpdater() {
        this.collectors = new IProgressUpdateCollector[0];
        ProgressManager.getInstance().addListener(this);
        this.debug = PrefUtil.getAPIPreferenceStore().getBoolean("SHOW_SYSTEM_JOBS");
    }

    void addCollector(IProgressUpdateCollector newCollector) {
        IProgressUpdateCollector[] newCollectors = new IProgressUpdateCollector[this.collectors.length + 1];
        System.arraycopy(this.collectors, 0, newCollectors, 0, this.collectors.length);
        newCollectors[this.collectors.length] = newCollector;
        this.collectors = newCollectors;
    }

    void removeCollector(IProgressUpdateCollector provider) {
        HashSet<IProgressUpdateCollector> newCollectors = new HashSet<IProgressUpdateCollector>();
        int i = 0;
        while (i < this.collectors.length) {
            if (!this.collectors[i].equals(provider)) {
                newCollectors.add(this.collectors[i]);
            }
            ++i;
        }
        IProgressUpdateCollector[] newArray = new IProgressUpdateCollector[newCollectors.size()];
        newCollectors.toArray(newArray);
        this.collectors = newArray;
        if (this.collectors.length == 0) {
            ProgressViewUpdater.clearSingleton();
        }
    }

    private void update() {
        if (this.collectors.length == 0) {
            return;
        }
        if (this.currentInfo.updateAll) {
            this.currentInfo.reset();
            IProgressUpdateCollector[] iProgressUpdateCollectorArray = this.collectors;
            int n = this.collectors.length;
            int n2 = 0;
            while (n2 < n) {
                IProgressUpdateCollector collector = iProgressUpdateCollectorArray[n2];
                collector.refresh();
                ++n2;
            }
        } else {
            this.currentInfo.processForUpdate();
            Object[] updateItems = this.currentInfo.refreshes.toArray();
            Object[] additionItems = this.currentInfo.additions.toArray();
            Object[] deletionItems = this.currentInfo.deletions.toArray();
            this.currentInfo.reset();
            IProgressUpdateCollector[] iProgressUpdateCollectorArray = this.collectors;
            int n = this.collectors.length;
            int n3 = 0;
            while (n3 < n) {
                IProgressUpdateCollector collector = iProgressUpdateCollectorArray[n3];
                if (updateItems.length > 0) {
                    collector.refresh(updateItems);
                }
                if (additionItems.length > 0) {
                    collector.add(additionItems);
                }
                if (deletionItems.length > 0) {
                    collector.remove(deletionItems);
                }
                ++n3;
            }
        }
    }

    UpdatesInfo getCurrentInfo() {
        return this.currentInfo;
    }

    public void refresh(JobInfo info) {
        this.currentInfo.refresh(info);
        GroupInfo group = info.getGroupInfo();
        if (group != null) {
            this.currentInfo.refresh(group);
        }
        this.throttledUpdate.throttledExec();
    }

    @Override
    public void refreshJobInfo(JobInfo info) {
        this.currentInfo.refresh(info);
        this.throttledUpdate.throttledExec();
    }

    @Override
    public void refreshGroup(GroupInfo info) {
        this.currentInfo.refresh(info);
        this.throttledUpdate.throttledExec();
    }

    @Override
    public void addGroup(GroupInfo info) {
        this.currentInfo.add(info);
        this.throttledUpdate.throttledExec();
    }

    @Override
    public void refreshAll() {
        this.currentInfo.updateAll = true;
        this.throttledUpdate.throttledExec();
    }

    @Override
    public void addJob(JobInfo info) {
        GroupInfo group = info.getGroupInfo();
        if (group == null) {
            this.currentInfo.add(info);
        } else {
            this.currentInfo.refresh(group);
        }
        this.throttledUpdate.throttledExec();
    }

    @Override
    public void removeJob(JobInfo info) {
        GroupInfo group = info.getGroupInfo();
        if (group == null) {
            this.currentInfo.remove(info);
        } else {
            this.currentInfo.refresh(group);
        }
        this.throttledUpdate.throttledExec();
    }

    @Override
    public void removeGroup(GroupInfo group) {
        this.currentInfo.remove(group);
        this.throttledUpdate.throttledExec();
    }

    @Override
    public boolean showsDebug() {
        return this.debug;
    }

    class UpdatesInfo {
        Collection additions = new HashSet();
        Collection deletions = new HashSet();
        Collection refreshes = new HashSet();
        boolean updateAll = false;

        private UpdatesInfo() {
        }

        void add(JobTreeElement addition) {
            this.additions.add(addition);
        }

        void remove(JobTreeElement removal) {
            this.deletions.add(removal);
        }

        void refresh(JobTreeElement refresh) {
            this.refreshes.add(refresh);
        }

        void reset() {
            this.additions.clear();
            this.deletions.clear();
            this.refreshes.clear();
            this.updateAll = false;
        }

        void processForUpdate() {
            HashSet<JobTreeElement> staleAdditions = new HashSet<JobTreeElement>();
            for (JobTreeElement treeElement : this.additions) {
                if (treeElement.isActive() || !this.deletions.contains(treeElement)) continue;
                staleAdditions.add(treeElement);
            }
            this.additions.removeAll(staleAdditions);
            HashSet<JobTreeElement> obsoleteRefresh = new HashSet<JobTreeElement>();
            for (JobTreeElement treeElement : this.refreshes) {
                Object parent;
                if (this.deletions.contains(treeElement) || this.additions.contains(treeElement)) {
                    obsoleteRefresh.add(treeElement);
                }
                if ((parent = treeElement.getParent()) != null && (this.deletions.contains(parent) || this.additions.contains(parent))) {
                    obsoleteRefresh.add(treeElement);
                }
                if (treeElement.isActive()) continue;
                obsoleteRefresh.add(treeElement);
                this.deletions.add(treeElement);
            }
            this.refreshes.removeAll(obsoleteRefresh);
        }
    }
}

